# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PluginPPI
                                 A QGIS plugin
 Pixel Purity Index algorithm
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-02-06
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Gustavo Ferreira
        email                : gustavoohs@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import necessary libraries
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.PyQt.QtWidgets import QApplication
from qgis.core import *
import sys, os
from osgeo import ogr, gdal
import numpy as np
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .PPI_dialog import PluginPPIDialog
import os.path

class PluginPPI:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PluginPPI_{}.qm'.format(locale))

        # Load translation file if it exists
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Pixel Purity Index')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
    def update_progress(self, value):
        self.dlg.progressBar.setValue(value)
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PluginPPI', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/PPI/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'PPI'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Pixel Purity Index'),
                action)
            self.iface.removeToolBarIcon(action)

    def load_input(self):
      # Clears the combo box and populates it with raster layer names
      self.dlg.comboBox.clear()
      list_layers = [layer for layer in QgsProject.instance().mapLayers().values()]
      list_rasters = []
      for i in list_layers:
          if i.type() == QgsMapLayer.RasterLayer:
              list_rasters.append(i.name())
      self.dlg.comboBox.addItems(list_rasters)

    def open_file(self):
        # Open file dialog to select an image file
        lyr = str(QFileDialog.getOpenFileName(caption="Image", filter="Images (*.tif)")[0])
        
        if (lyr != ""):
            # Add the selected raster layer to QGIS and load input layers
            self.iface.addRasterLayer(lyr, str.split(os.path.basename(lyr),".") [0],"gdal")
            self.load_input()


    def get_layer1(self):
        """Get the selected layer in the ComboBox"""
        layer = None
        lyr_name = self.dlg.comboBox.currentText()
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == lyr_name:
                layer = lyr
        return layer
        

    def save_result(self):
        """Opens the dialog window to define the name and location of the generated layer."""
        save = str(QFileDialog.getSaveFileName(caption="Save result.",filter="GTiff (*.tif)")[0])
        self.dlg.lineEdit.setText(save)

    def variables(self):
        """Set variables for the run function"""
        self.layer1 = self.get_layer1()
        self.out = self.dlg.lineEdit.text()

    def ppi_function(self, arr, iter_value=10000, threshold_value=0):
        # Perform Pixel Purity Index (PPI) algorithm
       shape = arr.shape
       arr = arr.reshape(-1, arr.shape[-1])
       nbands = arr.shape[-1]

       counts = np.zeros(arr.shape[0], dtype=np.uint32)

       for i in range(int(iter_value)):
           r = np.random.rand(nbands) - 0.5
           r /= np.sqrt(np.sum(r * r))
           s = arr.dot(r)
           imin, imax = np.argmin(s), np.argmax(s)
           if threshold_value == 0:
               counts[imin] += 1
               counts[imax] += 1
           else:
               counts[(s >= s[imax] - threshold_value) | (s <= s[imin] + threshold_value)] += 1

       return counts.reshape(shape[:2])

    def run(self):
        if self.first_start == True:
            self.first_start = False
            self.dlg = PluginPPIDialog()

        self.dlg.show()
        self.load_input()
        self.dlg.toolButton.clicked.connect(self.open_file)
        self.dlg.toolButton_2.clicked.connect(self.save_result)
        self.dlg.button_box.accepted.disconnect()
        self.dlg.button_box.accepted.connect(self.run)
    
        self.dlg.progressBar.setValue(0)
        result = self.dlg.exec_()

        if result:
            self.variables()
            ds1 = gdal.Open(str(self.layer1.source()))
            src = ds1.ReadAsArray().swapaxes(0,2).swapaxes(0,1)

            iter_value = self.dlg.spinBox.value()
            threshold_value = self.dlg.doubleSpinBox.value()

            # Configure a barra de progresso
            self.dlg.progressBar.setRange(0, iter_value)
            self.dlg.progressBar.setValue(0)

            for i in range(iter_value):
                # Atualize a barra de progresso a cada iteração
                self.update_progress(i + 1)
                QApplication.processEvents()  # Garante que a GUI seja atualizada

                # Execute ppi_function
                result = self.ppi_function(src, iter_value=iter_value, threshold_value=threshold_value)

            driver = gdal.GetDriverByName("GTiff")
            out = driver.Create(self.out, src.shape[1], src.shape[0], 1, gdal.GDT_UInt32)

            out.SetGeoTransform(ds1.GetGeoTransform())
            out.SetProjection(ds1.GetProjection())
            out.GetRasterBand(1).WriteArray(result)
            out.FlushCache()
            out = None

            self.iface.addRasterLayer(self.out)
