# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OsmAnd bridge
                                 A QGIS plugin
 Import tracks, favourites, itinerary and AV notes from OsmAnd
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-04-10
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Sylvain Théry - UMR 5281 ART-Dev
        email                : sylvain.thery@cnrs.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import datetime as dt
from PyQt5.QtWidgets import QTableWidgetItem
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
import glob
from qgis.core import QgsMessageLog, Qgis

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'OsmAnd_bridge_import_dialog.ui'), resource_suffix='')

class OsmAndBridgeImportDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """
        Constructor
        :param parent: None
        :type parent: None
        """

        super(OsmAndBridgeImportDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.init_widget()
        self.plugin_name = 'OsmAnd bridge'

    def init_widget(self) -> None:
        """
        Init dialog GUI
        :return: None
        :rtype: None
        """
        #
        self.tW_tracks.setColumnCount(3)
        columns = [self.tr("Name"), self.tr("Size"), self.tr("Last Modified")]
        self.tW_tracks.setHorizontalHeaderLabels(columns)
        self.tW_tracks.setSortingEnabled(True)
        self.tW_tracks.setRowCount(0)
        self.tW_tracks.setSizeAdjustPolicy(QtWidgets.QAbstractScrollArea.AdjustToContents)
        self.tW_tracks.selectionModel().selectionChanged.connect(self.enable_ok_button)

        self.QgsFW_osmand_root_path.fileChanged.connect(self.osmand_root_path_changed)
        self.QgsFW_dest_path.fileChanged.connect(self.destination_changed)
        for cBB in [self.cB_favourites, self.cB_itinerary, self.cB_AVnotes]:
            cBB.setEnabled(False)
            cBB.setChecked(False)
            cBB.stateChanged.connect(self.enable_ok_button)
        self.buttonBox.button(QtWidgets.QDialogButtonBox.Ok).setEnabled(False)
        self.clearPB.clicked.connect(self.clear_selection)

    def clear_selection(self):
        self.tW_tracks.clearSelection()
        self.enable_ok_button()

    def destination_changed(self):
        """
        Called when destination text area content change
        :return: None
        :rtype: None
        """

        if not os.path.exists(os.path.dirname(self.QgsFW_dest_path.filePath())):
            QgsMessageLog.logMessage(self.tr('not valid output file path.'), self.plugin_name, level=Qgis.Critical)
        self.enable_ok_button()


    def osmand_root_path_changed(self) -> None:
        """
        Called when destination text area content change
        :return: None
        :rtype: None
        """

        if not os.path.isdir(self.QgsFW_osmand_root_path.filePath()):
            QgsMessageLog.logMessage(self.tr('not valid OsmAnd file path.'), self.plugin_name, level=Qgis.Critical)
            self.init_widget()
        else:
            # tracks table
            try:
                if not os.path.isdir(f'{self.QgsFW_osmand_root_path.filePath()}/tracks/rec/'):
                    QgsMessageLog.logMessage(self.tr('no valid OsmAnd tracks path.'), self.plugin_name,
                                             level=Qgis.Critical)
                    self.tW_tracks.setRowCount(0)
                else:
                    pattern = f'{self.QgsFW_osmand_root_path.filePath()}/tracks/rec/*.gpx'
                    if len(glob.glob(pattern)) >= 0:
                        self.get_gpx_file_informations(pattern)
                        self.tW_tracks.setEnabled(True)
                        self.tW_tracks.resizeColumnsToContents()
                    else:
                        self.tW_tracks.setRowCount(0)
            except:
                QgsMessageLog.logMessage(self.tr('no gpx file to import.'), self.plugin_name, level=Qgis.Critical)


            # checkbox favorites
            try:
                with open(f'{self.QgsFW_osmand_root_path.filePath()}/favourites.gpx'):
                    QgsMessageLog.logMessage(self.tr('found ./favourites.gpx.'), self.plugin_name, level=Qgis.Info)
                    self.cB_favourites.setEnabled(True)
                    self.cB_favourites.setChecked(True)

            except IOError:
                QgsMessageLog.logMessage(self.tr('./favourites.gpx not found.'), self.plugin_name, level=Qgis.Warning)
                self.cB_favourites.setEnabled(False)
                self.cB_favourites.setChecked(False)


            # checkbox itinerary
            try:
                with open(f'{self.QgsFW_osmand_root_path.filePath()}/itinerary.gpx'):
                    QgsMessageLog.logMessage(self.tr('found ./itinerary.gpx.'), self.plugin_name, level=Qgis.Info)
                    self.cB_itinerary.setEnabled(True)
                    self.cB_itinerary.setChecked(True)

            except IOError:
                QgsMessageLog.logMessage(self.tr('./favourites.gpx not found.'), self.plugin_name, level=Qgis.Warning)
                self.cB_itinerary.setEnabled(False)
                self.cB_itinerary.setChecked(False)

            # checkbox AVnotes
            try:
                if not os.path.isdir(f'{self.QgsFW_osmand_root_path.filePath()}/avnotes/'):
                    QgsMessageLog.logMessage(self.tr('no valid OsmAnd avnotes path.'), self.plugin_name,
                                             level=Qgis.Critical)
                    self.cB_AVnotes.setEnabled(False)
                    self.cB_AVnotes.setChecked(False)
                else:
                    if len(glob.glob(f'{self.QgsFW_osmand_root_path.filePath()}/avnotes/*.3gp)')) + \
                            len(glob.glob(f'{self.QgsFW_osmand_root_path.filePath()}/avnotes/*.jpg')) + \
                            len(glob.glob(f'{self.QgsFW_osmand_root_path.filePath()}/avnotes/*.mp4')) > 0:
                        self.cB_AVnotes.setEnabled(True)
                        self.cB_AVnotes.setChecked(True)

            except:
                QgsMessageLog.logMessage(self.tr('no avnote file to import.'), self.plugin_name, level=Qgis.Critical)

        self.enable_ok_button()


    def get_gpx_file_informations(self, pattern: str) -> None:
        """
        List files according to pattern and send info the function that feed dialog table
        :param pattern: a file pattern whit directory (eg. '/home/sylvain/test/*.gpx)
        :type pattern: string
        :return: None
        :rtype: None
        """
        # listFiles = os.listdir(path)
        for f in glob.glob(pattern):
            p = os.path.join(pattern, f)
            st = os.stat(p)
            # to do convert list into individual items
            self.add_gpx_file_table_row([os.path.basename(f), self.human_readable_filesize(os.path.getsize(p)),
                                         str(dt.datetime.fromtimestamp(st.st_mtime))])

    def add_gpx_file_table_row(self, row_data) -> None:
        """
        Add files details to the dialog's table widget
        :param row_data: list of gpx file details
        :type row_data: list of strings
        :return: None
        :rtype: None
        """
        row = self.tW_tracks.rowCount()
        self.tW_tracks.setRowCount(row + 1)
        col = 0
        for item in row_data:
            cell = QTableWidgetItem(str(item))
            self.tW_tracks.setItem(row, col, cell)
            col += 1

    def human_readable_filesize(self, bytes: int, units=[' bytes', ' KB', ' MB', ' GB', ' TB', ' PB', ' EB']) -> str:
        """
        Return a human readable string representation of bytes based on a recursive call of itself
        Taken from https://stackoverflow.com/questions/1094841/get-human-readable-version-of-file-size/43750422
        :param bytes: size of a file in bytes
        :type bytes: int
        :param units: human readable file size units
        :type units: list of string
        :return: return a human readable string representation of bytes
        :rtype: str
        """

        return str(bytes) + units[0] if bytes < 1024 else self.human_readable_filesize(bytes >> 10, units[1:])

    def enable_ok_button(self):
        """
        Manage OK button. Make it only enable when params are OK.
        :return: None
        :rtype: None
        """
        flag = False
        try:

            if os.path.isdir(os.path.dirname(self.QgsFW_osmand_root_path.filePath())):
                if os.path.isdir(self.QgsFW_dest_path.filePath()):
                    if self.cB_AVnotes.isChecked() or self.cB_favourites.isChecked() or self.cB_itinerary.isChecked() \
                            or len(set(index.row() for index in self.tW_tracks.selectedIndexes()))>0:
                        flag=True

        except:
            pass
        self.buttonBox.button(QtWidgets.QDialogButtonBox.Ok).setEnabled(flag)




