# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OsmAnd bridge
                                 A QGIS plugin
 Import tracks, favourites, itinerary and AV notes from OsmAnd
 Generated by Plugin Builder: https://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-04-10
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Sylvain Théry - UMR 5281 ART-Dev
        email                : sylvain.thery@cnrs.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis._core import QgsFields, QgsVectorFileWriter, QgsCoordinateReferenceSystem, QgsCoordinateTransformContext


def create_empty_gpkg_layer(gpkg_path: str, layer_name: str, geometry: int,
                            crs: str, schema: QgsFields, append: bool = False
                            ) -> None:
    """
    Create a empty layer into a gpkg file. The gpkg is created if needed, and can be overwritten if it already exists
    Taken from :
    https://gis.stackexchange.com/questions/417916/creating-empty-layers-in-a-geopackage-using-pyqgis
    Thanks to Germán Carrillo https://gis.stackexchange.com/users/4972/germ%c3%a1n-carrillo

    :param gpkg_path: geopackage file
    :type gpkg_path: str

    :param layer_name: layer to be created
    :type layer_name: str

    :param geometry: Geometry Type. Can be none.
    :type geometry: QgsWkbType

    :param crs: CRS of the geometry. Can be empty
    :type crs: str

    :param schema: Attribute table structure
    :type schema: QgsFields()

    :param append: What to do when gpkg file exists (create or overwrite layer)
    :type append: bool

    :return: None
    :rtype: None
    """
    options = QgsVectorFileWriter.SaveVectorOptions()
    options.driverName = "GPKG"
    options.layerName = layer_name
    if append:
        options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer

    writer = QgsVectorFileWriter.create(
        gpkg_path,
        schema,
        geometry,
        QgsCoordinateReferenceSystem(crs),
        QgsCoordinateTransformContext(),
        options)
    del writer