# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OsmAnd bridge
                                 A QGIS plugin
 Import tracks, favourites, itinerary and AV notes from OsmAnd
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-04-10
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Sylvain Théry - UMR 5281 ART-Dev
        email                : sylvain.thery@cnrs.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import glob
import math
import os
import shutil

import qgis

from qgis.core import QgsVectorLayer, QgsProject, QgsVectorFileWriter, QgsField, QgsFeature, QgsGeometry, \
    QgsPointXY, QgsSvgMarkerSymbolLayer, QgsAction
from qgis.PyQt.QtCore import QVariant


import pathlib



def import_avnotes(self: object, source_path: str) -> bool:
    """

    :type self: object
    :param self:
    :param source_path:
    :type source_path:
    :return:
    :rtype:
    """


    extension_list = [['3gp', 'audio'], ['mp4', 'video'], ['mp3', 'audio'], ['jpg', 'picture'], ['tif', 'picture']]
    file_to_import = []

    # First we check for AV files and make list of elt to import
    for ext in extension_list:
        for file in glob.glob(f'{self.dlg_import.QgsFW_osmand_root_path.filePath()}/avnotes/*.{ext[0]}'):
            file_to_import.append([file, ext[1]])


    # define new gpkg layers
    attributes_list = [QgsField('full_path', QVariant.String),
                       QgsField('relative_path', QVariant.String),
                       QgsField('filename', QVariant.String),
                       QgsField('type', QVariant.String),
                       QgsField('x', QVariant.Double),
                       QgsField('y', QVariant.Double)]
    # audio
    a_uri = f"{self.dest_gpkg}|layername=audio"
    a_layer = QgsVectorLayer("Point", self.tr('Audio notes'), "memory")
    a_pr = a_layer.dataProvider()
    a_pr.addAttributes(attributes_list)
    a_layer.updateFields()

    # video
    v_uri = f"{self.dest_gpkg}|layername=video"
    v_layer = QgsVectorLayer("Point", self.tr('Video notes'), 'memory')
    v_pr = v_layer.dataProvider()
    v_pr.addAttributes(attributes_list)
    v_layer.updateFields()

    # pictures
    p_uri = f"{self.dest_gpkg}|layername=picture"
    p_layer = QgsVectorLayer("Point", self.tr('Picture notes'), 'memory')
    p_pr = p_layer.dataProvider()
    p_pr.addAttributes(attributes_list)
    p_layer.updateFields()

    QgsProject.instance().addMapLayer(a_layer)
    QgsProject.instance().addMapLayer(v_layer)
    QgsProject.instance().addMapLayer(p_layer)


    for elt in file_to_import:
        file = elt[0]
        filename = os.path.basename(file)
        full_path = f'{self.dlg_import.QgsFW_dest_path.filePath()}/avnotes/{filename}'
        rel_path = f'./avnotes/{filename}'
        shutil.copy(file, full_path)
        y, x, z = decode_short_code(pathlib.Path(file).stem)

        f = QgsFeature()
        f.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(x, y)))
        f.setAttributes([full_path, rel_path, filename, elt[1], x, y])
        if elt[1] == 'audio':
            pr = a_pr
            layer = a_layer
        elif elt[1] == 'video':
            pr = v_pr
            layer = v_layer
        elif elt[1] == 'picture':
            pr = p_pr
            layer = p_layer
        pr.addFeature(f)
    # update layer extent and final extent of the mapCanvas
    # move layer to group
    for layer in [[v_layer, v_uri], [p_layer, p_uri], [a_layer, a_uri]]:
        if layer[0].featureCount() > 0:
            options = QgsVectorFileWriter.SaveVectorOptions()
            options.layerName = layer[1].split('layername=')[1] # quick and dirty to get gpkg layername
            options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer
            context = QgsProject.instance().transformContext()
            QgsVectorFileWriter.writeAsVectorFormatV2(layer[0], self.dest_gpkg, context, options)
            new_sublayer = QgsVectorLayer(layer[1], layer[0].name(), 'ogr')
            QgsProject.instance().addMapLayer(new_sublayer)
            new_sublayer.updateExtents(True)
            self.extent.combineExtentWith(new_sublayer.extent())
            move_to_group(new_sublayer, self.tr('Audiovisual notes'))
            f'{os.path.dirname(__file__)}/svg_markers/Speaker_Icon.svg'
            if options.layerName =='audio':
                symbol = QgsSvgMarkerSymbolLayer(f'{os.path.dirname(__file__)}/svg_markers/Speaker_Icon.svg')
                # new_sublayer.setMapTipTemplate('<img src="file://[% "full_path" %]"/>')
            elif options.layerName =='video':
                symbol = QgsSvgMarkerSymbolLayer(f'{os.path.dirname(__file__)}/svg_markers/Video_Camera_-_The_Noun_Project.svg')
                # new_sublayer.setMapTipTemplate('<video controls width=\'250\'><source src=\'[% "full_path" %]\' type=\'video/mp4\{></video>')
            elif options.layerName =='picture':
                symbol = QgsSvgMarkerSymbolLayer(f'{os.path.dirname(__file__)}/svg_markers/Font_Awesome_5_solid_camera.svg')
                new_sublayer.setMapTipTemplate('<img src=\'file://[% "full_path" %]\'/>')
            symbol.setSize(6)

            new_sublayer.renderer().symbol().changeSymbolLayer(0, symbol)
            new_sublayer.triggerRepaint()
            self.iface.layerTreeView().refreshLayerSymbology(new_sublayer.id())

            # add action to open linked document
            action = QgsAction(QgsAction.OpenUrl, self.tr('Open file'), '[% "full_path" %]')
            my_scopes = {'Field', 'Canvas', 'Form', 'Field', 'Layer', 'Feature'}
            action.setActionScopes(my_scopes)
            actionManager = new_sublayer.actions()
            actionManager.addAction(action)
            for scope in my_scopes:
                    actionManager.setDefaultAction(scope, action.id())



            # symbol.setSize(6)
            # new_sublayer.renderer().symbol().changeSymbolLayer(0, symbol)
            # new_sublayer.triggerRepaint()
            # self.iface.layerTreeView().refreshLayerSymbology(new_sublayer.id())
        QgsProject.instance().removeMapLayer(layer[0])



def import_gpx_track_file(self: object, filename: str) -> bool:
    """
    Iterate thru gpx file layers. if not empty, add layer to corresponding group
    
    :param self: Class instance
    :type self: QgsInterface
    :param filename: full gpx file path
    :type filename: str
    :return: result of the operation
    :rtype: bool
    """
    try:
        prefix = pathlib.Path(filename).stem
        # list of type of items that can be found in gpx files and their translations for group naming
        names = [["waypoints", self.tr("Waypoints")], ["routes", self.tr("Routes")], ["tracks", self.tr("Tracks")],
                 ["route_points", self.tr("Route points")], ["track_points", self.tr("Track points")]]

        for name in names:
            # prepare gpx layer
            uri = f"{filename}|layername={name[0]}"
            sublayer = QgsVectorLayer(uri, name[0], 'ogr')
            if sublayer.featureCount() > 0:
                # load gpx layer
                QgsProject.instance().addMapLayer(sublayer)
                # set options to export it to gpkg
                options = QgsVectorFileWriter.SaveVectorOptions()
                options.layerName = f"{prefix}_{sublayer.name()}"
                options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer
                context = QgsProject.instance().transformContext()
                # do export
                QgsVectorFileWriter.writeAsVectorFormatV2(sublayer, self.dest_gpkg, context, options)
                # remove source layer
                QgsProject.instance().removeMapLayer(sublayer)
                # load new gpkg layer
                uri = f"{self.dest_gpkg}|layername={options.layerName}"
                new_sublayer = QgsVectorLayer(uri, options.layerName, 'ogr')
                QgsProject.instance().addMapLayer(new_sublayer)
                # update layer extent and final extent of the mapCanvas
                new_sublayer.updateExtents(True)
                self.extent.combineExtentWith(new_sublayer.extent())

                # put into a group layer
                if prefix == 'favourites':
                    move_to_group(new_sublayer, self.tr('Favourites'))
                elif prefix == 'itinerary':
                    move_to_group(new_sublayer, self.tr('Itinerary'))
                else:
                    move_to_group(new_sublayer, name[1])
        return True

    except Exception as e:
        return False


def move_to_group(thing, group, pos=0, expanded=False) -> tuple:
    """
    Move a layer tree node into a layer tree group.
    Moving destroys the original thing and creates a copy. It is the
    copy which is returned.

    Taken from: https://gis.stackexchange.com/a/415161
    Thanks Lorem-Ipsum https://gis.stackexchange.com/users/190371/lorem-ipsum

    :param thing: Thing to move.  Can be a tree node (i.e. a layer or a group) or a map layer, the object or the string name/id.
    :type thing: group name (str), layer id (str), qgis.core.QgsMapLayer, qgis.core.QgsLayerTreeNode

    :param group: Group to move the thing to. If group does not already exist, it will be created.
    :type group: group name (str) or qgis.core.QgsLayerTreeGroup

    :param pos: Position to insert into group. Default is 0.
    :type pos: int
    :param expanded: Collapse or expand the thing moved. Default is False.
    :type expanded: bool

    :return: the moved thing and the group moved to.
    :rtype: tuple
    """

    tree = qgis.core.QgsProject.instance().layerTreeRoot()

    # thing
    if isinstance(thing, str):
        try:  # group name
            node_object = tree.findGroup(thing)
        except:  # layer id
            node_object = tree.findLayer(thing)
    elif isinstance(thing, qgis.core.QgsMapLayer):
        node_object = tree.findLayer(thing)
    elif isinstance(thing, qgis.core.QgsLayerTreeNode):
        node_object = thing  # tree layer or group

    # group
    if isinstance(group, qgis.core.QgsLayerTreeGroup):
        group_name = group.name()
    else:  # group is str
        group_name = group

    group_object = tree.findGroup(group_name)

    if not group_object:
        group_object = tree.addGroup(group_name)

    # do the move
    node_object_clone = node_object.clone()
    node_object_clone.setExpanded(expanded)
    group_object.insertChildNode(pos, node_object_clone)

    parent = node_object.parent()
    parent.removeChildNode(node_object)

    return node_object_clone, group_object


def decode_short_code(shortcode: str) -> list:
    """
    From a shortcode string, returns a list whith XY coordinates and zoom level
    Inspired by http://www.salesianer.de/util/shortcode.js
    Thanks H. v. Hatzfeld http://www.salesianer.de/hatzfeld/

    :param shortcode: a string which represents a pair of geographical coordinates and a zoom level
    :type shortcode:
    :return: Y coordinates, X coordinates, zoom level
    :rtype: real, real, int
    """

    char_array = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_~"
    i = 0
    x = 0
    y = 0
    z = -8
    for i in range(len(shortcode)):
        digit = char_array.find(shortcode[i])
        if digit == -1:
            break
        x <<= 3
        y <<= 3

        for j in range(2, -1, -1):
            # x |= ((digit & (1 << (j+j+1))) == 0 ? 0 : (1 << j))
            if (digit & (1 << (j + j + 1))) == 0:
                x |= 0
            else:
                x |= (1 << j)
            # y |= ((digit & (1 << (j + j))) == 0 ? 0: (1 << j));
            if (digit & (1 << (j + j))) == 0:
                y |= 0
            else:
                y |= (1 << j)
        z += 3;
    x = x * math.pow(2, 2 - 3 * i) * 90 - 180
    y = y * math.pow(2, 2 - 3 * i) * 45 - 90

    if i < len(shortcode) and char_array.find(shortcode[i]) == "-":
        z -= 2
        if i + 1 < len(shortcode) and char_array.find(shortcode[i + 1]) == "-":
            z += 1

    return [y, x, z]
