# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OpenTripPlannerPlugin
                                 A QGIS plugin
 This plugin makes OpenTripPlanner functionalities accessible in QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-10-21
        git sha              : $Format:%H$
        copyright            : (C) 2019 - Today by Mario Königbauer
        email                : mkoenigb@gmx.de
        repository           : https://github.com/mkoenigb/OpenTripPlannerPlugin
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QObject, QThread, pyqtSignal
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from PyQt5.QtNetwork import  QNetworkAccessManager, QNetworkRequest
from PyQt5.QtCore import *
from qgis.core import *
from qgis.utils import *


# Initialize Qt resources from file resources.py
from .resources import *
from .otp_plugin_worker_routes import *
from .otp_plugin_worker_isochrones import *
# Import the code for the dialog
from .otp_plugin_dialog import OpenTripPlannerPluginDialog
from osgeo import ogr
from datetime import *
import os
import urllib
import zipfile
import json

MESSAGE_CATEGORY = 'OpenTripPlanner PlugIn'

class OpenTripPlannerPluginGeneralFunctions(object):
    
    def __init__(self, dialog, iface):
        #print('init general functions')
        self.dlg = dialog
        self.iface = iface
        
    # https://docs.qgis.org/testing/en/docs/pyqgis_developer_cookbook/settings.html and https://gis.stackexchange.com/questions/114527/qgis-plugin-with-save-settings-dialog
    def store_general_variables(self):
        s = QgsSettings()
        
        # Server URL
        self.serverurl = self.dlg.GeneralSettings_ServerURL.toPlainText() # read from textbox
        s.setValue("otp_plugin/GeneralSettings_ServerURL", self.serverurl) # store as variable via QgsSettings
        
        # Custom TEMP-Folder
        self.customtempfolder = self.dlg.GeneralSettings_CustomTempFolder.toPlainText()
        s.setValue("otp_plugin/GeneralSettings_CustomTempFolder", self.customtempfolder)
        self.customtempfolder_use = int(self.dlg.GeneralSettings_CustomTempFolder_Use.isChecked())
        s.setValue("otp_plugin/GeneralSettings_CustomTempFolder_Use", self.customtempfolder_use)
        
        # Proxy-Settings
        self.proxy_use = int(self.dlg.GeneralSettings_Proxy_Use.isChecked())
        s.setValue("otp_plugin/GeneralSettings_Proxy_Use", self.proxy_use)
        
        # Timeout
        self.timeout_setting = float(self.dlg.GeneralSettings_Timeout.value())
        s.setValue("otp_plugin/GeneralSettings_Timeout", self.timeout_setting)
        
        # Communicate with user
        self.iface.messageBar().pushMessage("Success", "General settings stored! ServerURL: " + self.serverurl, MESSAGE_CATEGORY, level=Qgis.Success, duration=3)
        QgsMessageLog.logMessage("General settings stored! ServerURL: " + self.serverurl,MESSAGE_CATEGORY,Qgis.Info)
        
    def read_general_variables(self):
        s = QgsSettings()
        
        # Server URL
        self.serverurl = s.value("otp_plugin/GeneralSettings_ServerURL", "") # read from variable via QgsSettings
        if isinstance(self.serverurl, str): self.dlg.GeneralSettings_ServerURL.setText(self.serverurl) # set textbox text to variable from QgsSettings
        
        # Custom TEMP-Folder
        self.customtempfolder = s.value("otp_plugin/GeneralSettings_CustomTempFolder", "")
        if isinstance(self.customtempfolder, str): self.dlg.GeneralSettings_CustomTempFolder.setText(self.customtempfolder)        
        self.customtempfolder_use = int(s.value("otp_plugin/GeneralSettings_CustomTempFolder_Use", 0))
        self.dlg.GeneralSettings_CustomTempFolder_Use.setChecked(self.customtempfolder_use)
        if self.customtempfolder_use == 0:
            self.otp_plugin_location = os.path.realpath(os.path.join(os.getcwd(), os.path.dirname(__file__))) #Read path of this plugin
            self.tmp_save_location = os.path.join(self.otp_plugin_location, 'temp_files') + os.sep  #Concat path of this plugin to save location of temporary shapefiles
        else:
            self.tmp_save_location = self.customtempfolder
        
        # Proxy-Settings
        self.proxy_use = int(s.value("otp_plugin/GeneralSettings_Proxy_Use", 0))
        self.dlg.GeneralSettings_Proxy_Use.setChecked(self.proxy_use)
        self.read_proxy_settings()
        
        # Timeout
        self.timeout_setting = float(s.value("otp_plugin/GeneralSettings_Timeout", 10.00))
        self.dlg.GeneralSettings_Timeout.setValue(self.timeout_setting)
           
    def restore_general_variables(self):
        s = QgsSettings()
        
        # Server URL
        self.serverurl = 'http://localhost:8080/otp/routers/default/'
        if isinstance(self.serverurl, str): self.dlg.GeneralSettings_ServerURL.setText(self.serverurl) # set textbox text to variable from QgsSettings
        
        # Custom TEMP-Folder
        self.customtempfolder = ""
        if isinstance(self.customtempfolder, str): self.dlg.GeneralSettings_CustomTempFolder.setText(self.customtempfolder)   
        self.customtempfolder_use = int(0)
        self.dlg.GeneralSettings_CustomTempFolder_Use.setChecked(self.customtempfolder_use)     
        
        # Proxy-Settings
        self.proxy_use = int(0)
        self.dlg.GeneralSettings_Proxy_Use.setChecked(self.proxy_use)
        
        # Timeout
        self.timeout_setting = float(10.00)
        self.dlg.GeneralSettings_Timeout.setValue(self.timeout_setting)
        
        # Communicate with user
        self.iface.messageBar().pushMessage("Success", "Default general settings restored!", MESSAGE_CATEGORY, level=Qgis.Success, duration=3)
        QgsMessageLog.logMessage("Default general settings restored!",MESSAGE_CATEGORY,Qgis.Info)
        self.store_general_variables()
        
    def store_route_variables(self):
        s = QgsSettings()
        
        # Walk Speed
        self.routes_walkspeed_use_setting = int(self.dlg.Routes_WalkSpeed_Use.isChecked())
        s.setValue("otp_plugin/Routes_WalkSpeed_Use", self.routes_walkspeed_use_setting)
        self.routes_walkspeed_setting = float(self.dlg.Routes_WalkSpeed.value())
        s.setValue("otp_plugin/Routes_WalkSpeed", self.routes_walkspeed_setting)
        # Test for Override Buttons - doesnt work
        #self.Routes_Routes_WalkSpeed_Override_Use_setting = int(self.dlg.Routes_WalkSpeed_Override.isActive())
        #s.setValue("otp_plugin/Routes_WalkSpeed_Override_Use", self.Routes_WalkSpeed_Override_Use_setting)
        #self.Routes_Routes_WalkSpeed_Override_setting = self.dlg.Routes_WalkSpeed_Override.toProperty()
        #s.setValue("otp_plugin/Routes_WalkSpeed_Override", self.Routes_WalkSpeed_Override_setting)
        
        # Bike Speed
        self.routes_bikespeed_use_setting = int(self.dlg.Routes_BikeSpeed_Use.isChecked())
        s.setValue("otp_plugin/Routes_BikeSpeed_Use", self.routes_bikespeed_use_setting)
        self.routes_bikespeed_setting = float(self.dlg.Routes_BikeSpeed.value())
        s.setValue("otp_plugin/Routes_BikeSpeed", self.routes_bikespeed_setting)
        
        # Date
        self.routes_date_use_setting = int(self.dlg.Routes_Date_Use.isChecked())
        s.setValue("otp_plugin/Routes_Date_Use", self.routes_date_use_setting)
        self.routes_date_setting = self.dlg.Routes_Date.date()
        s.setValue("otp_plugin/Routes_Date", self.routes_date_setting)
        
        # Time
        self.routes_time_use_setting = int(self.dlg.Routes_Time_Use.isChecked())
        s.setValue("otp_plugin/Routes_Time_Use", self.routes_time_use_setting)
        self.routes_time_setting = self.dlg.Routes_Time.time()
        s.setValue("otp_plugin/Routes_Time", self.routes_time_setting)
        
        # ArriveBy
        self.routes_arriveby_use_setting = int(self.dlg.Routes_ArriveBy_Use.isChecked())
        s.setValue("otp_plugin/Routes_ArriveBy_Use", self.routes_arriveby_use_setting)
        self.routes_arriveby_setting = int(self.dlg.Routes_ArriveBy.isChecked())
        s.setValue("otp_plugin/Routes_ArriveBy", self.routes_arriveby_setting)
        
        # Wheelchair
        self.routes_wheelchair_use_setting = int(self.dlg.Routes_Wheelchair_Use.isChecked())
        s.setValue("otp_plugin/Routes_Wheelchair_Use", self.routes_wheelchair_use_setting)
        self.routes_wheelchair_setting = int(self.dlg.Routes_Wheelchair.isChecked())
        s.setValue("otp_plugin/Routes_Wheelchair", self.routes_wheelchair_setting)
        
        # Wait Reluctance
        self.routes_waitreluctance_use_setting = int(self.dlg.Routes_WaitReluctance_Use.isChecked())
        s.setValue("otp_plugin/Routes_WaitReluctance_Use", self.routes_waitreluctance_use_setting)
        self.routes_waitreluctance_setting = float(self.dlg.Routes_WaitReluctance.value())
        s.setValue("otp_plugin/Routes_WaitReluctance", self.routes_waitreluctance_setting)
        
        # Max Transfers
        self.routes_maxtransfers_use_setting = int(self.dlg.Routes_MaxTransfers_Use.isChecked())
        s.setValue("otp_plugin/Routes_MaxTransfers_Use", self.routes_maxtransfers_use_setting)
        self.routes_maxtransfers_setting = int(self.dlg.Routes_MaxTransfers.value())
        s.setValue("otp_plugin/Routes_MaxTransfers", self.routes_maxtransfers_setting)
        
        # Max Walkdistance
        self.routes_maxwalkdistance_use_setting = int(self.dlg.Routes_MaxWalkDistance_Use.isChecked())
        s.setValue("otp_plugin/Routes_MaxWalkDistance_Use", self.routes_maxwalkdistance_use_setting)
        self.routes_maxwalkdistance_setting = int(self.dlg.Routes_MaxWalkDistance.value())
        s.setValue("otp_plugin/Routes_MaxWalkDistance", self.routes_maxwalkdistance_setting)
        
        # Max Offroaddistance
        self.routes_maxoffroaddistance_use_setting = int(self.dlg.Routes_MaxOffroadDistance_Use.isChecked())
        s.setValue("otp_plugin/Routes_MaxOffroadDistance_Use", self.routes_maxoffroaddistance_use_setting)
        self.routes_maxoffroaddistance_setting = int(self.dlg.Routes_MaxOffroadDistance.value())
        s.setValue("otp_plugin/Routes_MaxOffroadDistance", self.routes_maxoffroaddistance_setting)
        
        # Iterinaries
        self.routes_iterinaries_use_setting = int(self.dlg.Routes_Iterinaries_Use.isChecked())
        s.setValue("otp_plugin/Routes_Iterinaries_Use", self.routes_iterinaries_use_setting)
        self.routes_iterinaries_setting = int(self.dlg.Routes_Iterinaries.value())
        s.setValue("otp_plugin/Routes_Iterinaries", self.routes_iterinaries_setting)        
        
        # Optimize
        self.routes_optimize_use_setting = int(self.dlg.Routes_Optimize_Use.isChecked())
        s.setValue("otp_plugin/Routes_Optimize_Use", self.routes_optimize_use_setting)
        self.routes_optimize_setting = str(self.dlg.Routes_Optimize.currentText())
        s.setValue("otp_plugin/Routes_Optimize", self.routes_optimize_setting)

        # Mode
        self.routes_transportationmode_setting = self.dlg.Routes_TransportationMode.toPlainText()
        s.setValue("otp_plugin/Routes_TransportationMode", self.routes_transportationmode_setting)
        
        # Additional Parameters
        self.routes_additionalparameters_setting = self.dlg.Routes_AdditionalParameters.toPlainText()
        s.setValue("otp_plugin/Routes_AdditionalParameters", self.routes_additionalparameters_setting)
        
        # Matrixmatching
        self.routes_onlymatching_setting = int(self.dlg.Routes_OnlyMatching.isChecked())
        s.setValue("otp_plugin/Routes_OnlyMatching", self.routes_onlymatching_setting)
        
        self.iface.messageBar().pushMessage("Success", "Route settings stored!", MESSAGE_CATEGORY, level=Qgis.Success, duration=3) 
        QgsMessageLog.logMessage("Route settings stored!",MESSAGE_CATEGORY,Qgis.Info)
        
    def read_route_variables(self):
        s = QgsSettings()
        
        # Walk Speed
        self.routes_walkspeed_use_setting = int(s.value("otp_plugin/Routes_WalkSpeed_Use", 0))
        self.dlg.Routes_WalkSpeed_Use.setChecked(self.routes_walkspeed_use_setting)
        self.routes_walkspeed_setting = float(s.value("otp_plugin/Routes_WalkSpeed", 4.828032))
        self.dlg.Routes_WalkSpeed.setValue(self.routes_walkspeed_setting)
        # Test for Override Buttons - doesnt work
        #self.Routes_WalkSpeed_Override_Use_setting = int(s.value("otp_plugin/Routes_WalkSpeed_Override_Use", 1))
        #self.dlg.Routes_WalkSpeed_Override.setActive(self.Routes_WalkSpeed_Override_Use_setting)
        #self.Routes_WalkSpeed_Override_setting = s.value("otp_plugin/Routes_WalkSpeed_Override", 4.828032)
        #self.dlg.Routes_WalkSpeed_Override.setExpressionString(self.Routes_WalkSpeed_Override_setting)
              
        # Bike Speed
        self.routes_bikespeed_use_setting = int(s.value("otp_plugin/Routes_BikeSpeed_Use", 0))
        self.dlg.Routes_BikeSpeed_Use.setChecked(self.routes_bikespeed_use_setting)
        self.routes_bikespeed_setting = float(s.value("otp_plugin/Routes_BikeSpeed", 17.7))
        self.dlg.Routes_BikeSpeed.setValue(self.routes_bikespeed_setting)
        
        # Date
        self.routes_date_use_setting = int(s.value("otp_plugin/Routes_Date_Use", 1))
        self.dlg.Routes_Date_Use.setChecked(self.routes_date_use_setting)
        self.routes_date_setting = s.value("otp_plugin/Routes_Date", QtCore.QDateTime.currentDateTime())
        # I guess nobody understands this date 'stuff'....
        try:
            self.dlg.Routes_Date.setDateTime(self.routes_date_setting) # Standard value
        except:
            self.dlg.Routes_Date.setDate(self.routes_date_setting) # Stored value
        
        # Time
        self.routes_time_use_setting = int(s.value("otp_plugin/Routes_Time_Use", 1))
        self.dlg.Routes_Time_Use.setChecked(self.routes_time_use_setting)
        self.routes_time_setting = s.value("otp_plugin/Routes_Time", QTime.fromString('14:00:00'))
        self.dlg.Routes_Time.setTime(self.routes_time_setting)
        
        # Arrive By
        self.routes_arriveby_use_setting = int(s.value("otp_plugin/Routes_ArriveBy_Use", 0))
        self.dlg.Routes_ArriveBy_Use.setChecked(self.routes_arriveby_use_setting)
        self.routes_arriveby_setting = int(s.value("otp_plugin/Routes_ArriveBy", 0))
        self.dlg.Routes_ArriveBy.setChecked(self.routes_arriveby_setting)
        
        # Wheelchair
        self.routes_wheelchair_use_setting = int(s.value("otp_plugin/Routes_Wheelchair_Use", 0))
        self.dlg.Routes_Wheelchair_Use.setChecked(self.routes_wheelchair_use_setting)
        self.routes_wheelchair_setting = int(s.value("otp_plugin/Routes_Wheelchair", 0))
        self.dlg.Routes_Wheelchair.setChecked(self.routes_wheelchair_setting)
        
        # Wait Reluctance
        self.routes_waitreluctance_use_setting = int(s.value("otp_plugin/Routes_WaitReluctance_Use", 0))
        self.dlg.Routes_WaitReluctance_Use.setChecked(self.routes_waitreluctance_use_setting)
        self.routes_waitreluctance_setting = float(s.value("otp_plugin/Routes_WaitReluctance", 0.95))
        self.dlg.Routes_WaitReluctance.setValue(self.routes_waitreluctance_setting)
        
        # Max Transfers
        self.routes_maxtransfers_use_setting = int(s.value("otp_plugin/Routes_MaxTransfers_Use", 0))
        self.dlg.Routes_MaxTransfers_Use.setChecked(self.routes_maxtransfers_use_setting)
        self.routes_maxtransfers_setting = int(s.value("otp_plugin/Routes_MaxTransfers", 5))
        self.dlg.Routes_MaxTransfers.setValue(self.routes_maxtransfers_setting)
        
        # Max WalkDistance
        self.routes_maxwalkdistance_use_setting = int(s.value("otp_plugin/Routes_MaxWalkDistance_Use", 0))
        self.dlg.Routes_MaxWalkDistance_Use.setChecked(self.routes_maxwalkdistance_use_setting)
        self.routes_maxwalkdistance_setting = int(s.value("otp_plugin/Routes_MaxWalkDistance", 1000))
        self.dlg.Routes_MaxWalkDistance.setValue(self.routes_maxwalkdistance_setting)
        
        # Max OffRoadDistance
        self.routes_maxoffroaddistance_use_setting = int(s.value("otp_plugin/Routes_MaxOffroadDistance_Use", 0))
        self.dlg.Routes_MaxOffroadDistance_Use.setChecked(self.routes_maxoffroaddistance_use_setting)
        self.routes_maxoffroaddistance_setting = int(s.value("otp_plugin/Routes_MaxOffroadDistance", 150))
        self.dlg.Routes_MaxOffroadDistance.setValue(self.routes_maxoffroaddistance_setting)
        
        # Iterinaries
        self.routes_iterinaries_use_setting = int(s.value("otp_plugin/Routes_Iterinaries_Use", 1))
        self.dlg.Routes_Iterinaries_Use.setChecked(self.routes_iterinaries_use_setting)
        self.routes_iterinaries_setting = int(s.value("otp_plugin/Routes_Iterinaries", 1))
        self.dlg.Routes_Iterinaries.setValue(self.routes_iterinaries_setting)        
        
        # Optimize
        self.routes_optimize_use_setting = int(s.value("otp_plugin/Routes_Optimize_Use", 0))
        self.dlg.Routes_Optimize_Use.setChecked(self.routes_optimize_use_setting)
        self.routes_optimize_setting = str(s.value("otp_plugin/Routes_Optimize", 'QUICK'))
        self.dlg.Routes_Optimize.setCurrentText(self.routes_optimize_setting)
        
        # Mode
        self.routes_transportationmode = s.value("otp_plugin/Routes_TransportationMode", "WALK,TRANSIT")
        if isinstance(self.routes_transportationmode, str): self.dlg.Routes_TransportationMode.setText(self.routes_transportationmode)
        
        # Additional Parameters
        self.routes_additionalparameters = s.value("otp_plugin/Routes_AdditionalParameters", "")
        if isinstance(self.routes_additionalparameters, str): self.dlg.Routes_AdditionalParameters.setText(self.routes_additionalparameters)
        
        # Matrixmatching
        self.routes_onlymatching_setting = int(s.value("otp_plugin/Routes_OnlyMatching", 1))
        self.dlg.Routes_OnlyMatching.setChecked(self.routes_onlymatching_setting)
        
        #self.iface.messageBar().pushMessage("Success", "Function read_route_variables running!", level=Qgis.Success, duration=3)

    def restore_route_variables(self):
        s = QgsSettings()
        #DefaultSettings
        # Walk Speed
        self.routes_walkspeed_use_setting = int(0)
        self.dlg.Routes_WalkSpeed_Use.setChecked(self.routes_walkspeed_use_setting)
        self.routes_walkspeed_setting = float(4.828032)
        self.dlg.Routes_WalkSpeed.setValue(self.routes_walkspeed_setting)
        
        # Bike Speed
        self.routes_bikespeed_use_setting = int(0)
        self.dlg.Routes_BikeSpeed_Use.setChecked(self.routes_bikespeed_use_setting)
        self.routes_bikespeed_setting = float(17.7)
        self.dlg.Routes_BikeSpeed.setValue(self.routes_bikespeed_setting)
        
        # Date #####
        self.routes_date_use_setting = int(1)
        self.dlg.Routes_Date_Use.setChecked(self.routes_date_use_setting)
        self.routes_date_setting = QDateTime(QtCore.QDateTime.currentDateTime())
        self.dlg.Routes_Date.setDateTime(self.routes_date_setting)
        
        # Time
        self.routes_time_use_setting = int(1)
        self.dlg.Routes_Time_Use.setChecked(self.routes_time_use_setting)
        self.routes_time_setting = QTime.fromString('14:00:00')
        self.dlg.Routes_Time.setTime(self.routes_time_setting)
        
        # Arrive By
        self.routes_arriveby_use_setting = int(0)
        self.dlg.Routes_ArriveBy_Use.setChecked(self.routes_arriveby_use_setting)
        self.routes_arriveby_setting = int(0)
        self.dlg.Routes_ArriveBy.setChecked(self.routes_arriveby_setting)
        
        # Wheelchair
        self.routes_wheelchair_use_setting = int(0)
        self.dlg.Routes_Wheelchair_Use.setChecked(self.routes_wheelchair_use_setting)
        self.routes_wheelchair_setting = int(0)
        self.dlg.Routes_Wheelchair.setChecked(self.routes_wheelchair_setting)
        
        # Wait Reluctance
        self.routes_waitreluctance_use_setting = int(0)
        self.dlg.Routes_WaitReluctance_Use.setChecked(self.routes_waitreluctance_use_setting)
        self.routes_waitreluctance_setting = float(0.95)
        self.dlg.Routes_WaitReluctance.setValue(self.routes_waitreluctance_setting)
        
        # Max Transfers
        self.routes_maxtransfers_use_setting = int(0)
        self.dlg.Routes_MaxTransfers_Use.setChecked(self.routes_maxtransfers_use_setting)
        self.routes_maxtransfers_setting = int(5)
        self.dlg.Routes_MaxTransfers.setValue(self.routes_maxtransfers_setting)
        
        # Max WalkDistance
        self.routes_maxwalkdistance_use_setting = int(0)
        self.dlg.Routes_MaxWalkDistance_Use.setChecked(self.routes_maxwalkdistance_use_setting)
        self.routes_maxwalkdistance_setting = int(1000)
        self.dlg.Routes_MaxWalkDistance.setValue(self.routes_maxwalkdistance_setting)
        
        # Max OffRoadDistance
        self.routes_maxoffroaddistance_use_setting = int(0)
        self.dlg.Routes_MaxOffroadDistance_Use.setChecked(self.routes_maxoffroaddistance_use_setting)
        self.routes_maxoffroaddistance_setting = int(150)
        self.dlg.Routes_MaxOffroadDistance.setValue(self.routes_maxoffroaddistance_setting)
        
        # Iterinaries
        self.routes_iterinaries_use_setting = int(1)
        self.dlg.Routes_Iterinaries_Use.setChecked(self.routes_iterinaries_use_setting)
        self.routes_iterinaries_setting = int(1)
        self.dlg.Routes_Iterinaries.setValue(self.routes_iterinaries_setting)        
        
        # Optimize
        self.routes_optimize_use_setting = int(0)
        self.dlg.Routes_Optimize_Use.setChecked(self.routes_optimize_use_setting)
        self.routes_optimize_setting = 'QUICK'
        self.dlg.Routes_Optimize.setCurrentText(self.routes_optimize_setting)        
        
        # Mode
        self.routes_transportationmode = ""
        if isinstance(self.routes_transportationmode, str): self.dlg.Routes_TransportationMode.setText(self.routes_transportationmode)
        
        # Additional Parameters
        self.routes_additionalparameters = ""
        if isinstance(self.routes_additionalparameters, str): self.dlg.Routes_AdditionalParameters.setText(self.routes_additionalparameters)
        
        # Matrixmatching
        self.routes_onlymatching_setting = int(0)
        self.dlg.Routes_OnlyMatching.setChecked(self.routes_onlymatching_setting)        
        
        self.iface.messageBar().pushMessage("Success", "Default route settings restored!", MESSAGE_CATEGORY, level=Qgis.Success, duration=3)
        QgsMessageLog.logMessage("Default route settings restored!",MESSAGE_CATEGORY,Qgis.Info)
        self.store_route_variables()
        
    def store_isochrone_variables(self):
        s = QgsSettings()
        
        # Walk Speed
        self.isochrones_walkspeed_use_setting = int(self.dlg.Isochrones_WalkSpeed_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_WalkSpeed_Use", self.isochrones_walkspeed_use_setting)
        self.isochrones_walkspeed_setting = float(self.dlg.Isochrones_WalkSpeed.value())
        s.setValue("otp_plugin/Isochrones_WalkSpeed", self.isochrones_walkspeed_setting)
        
        # Bike Speed
        self.isochrones_bikespeed_use_setting = int(self.dlg.Isochrones_BikeSpeed_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_BikeSpeed_Use", self.isochrones_bikespeed_use_setting)
        self.isochrones_bikespeed_setting = float(self.dlg.Isochrones_BikeSpeed.value())
        s.setValue("otp_plugin/Isochrones_BikeSpeed", self.isochrones_bikespeed_setting)
        
        # Date
        self.isochrones_date_use_setting = int(self.dlg.Isochrones_Date_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_Date_Use", self.isochrones_date_use_setting)
        self.isochrones_date_setting = self.dlg.Isochrones_Date.date()
        s.setValue("otp_plugin/Isochrones_Date", self.isochrones_date_setting)
        
        # Time
        self.isochrones_time_use_setting = int(self.dlg.Isochrones_Time_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_Time_Use", self.isochrones_time_use_setting)
        self.isochrones_time_setting = self.dlg.Isochrones_Time.time()
        s.setValue("otp_plugin/Isochrones_Time", self.isochrones_time_setting)
        
        # ArriveBy
        self.isochrones_arriveby_use_setting = int(self.dlg.Isochrones_ArriveBy_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_ArriveBy_Use", self.isochrones_arriveby_use_setting)
        self.isochrones_arriveby_setting = int(self.dlg.Isochrones_ArriveBy.isChecked())
        s.setValue("otp_plugin/Isochrones_ArriveBy", self.isochrones_arriveby_setting)
        
        # Wheelchair
        self.isochrones_wheelchair_use_setting = int(self.dlg.Isochrones_Wheelchair_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_Wheelchair_Use", self.isochrones_wheelchair_use_setting)
        self.isochrones_wheelchair_setting = int(self.dlg.Isochrones_Wheelchair.isChecked())
        s.setValue("otp_plugin/Isochrones_Wheelchair", self.isochrones_wheelchair_setting)
        
        # Wait Reluctance
        self.isochrones_waitreluctance_use_setting = int(self.dlg.Isochrones_WaitReluctance_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_WaitReluctance_Use", self.isochrones_waitreluctance_use_setting)
        self.isochrones_waitreluctance_setting = float(self.dlg.Isochrones_WaitReluctance.value())
        s.setValue("otp_plugin/Isochrones_WaitReluctance", self.isochrones_waitreluctance_setting)
        
        # Max Transfers
        self.isochrones_maxtransfers_use_setting = int(self.dlg.Isochrones_MaxTransfers_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_MaxTransfers_Use", self.isochrones_maxtransfers_use_setting)
        self.isochrones_maxtransfers_setting = int(self.dlg.Isochrones_MaxTransfers.value())
        s.setValue("otp_plugin/Isochrones_MaxTransfers", self.isochrones_maxtransfers_setting)
        
        # Max Walkdistance
        self.isochrones_maxwalkdistance_use_setting = int(self.dlg.Isochrones_MaxWalkDistance_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_MaxWalkDistance_Use", self.isochrones_maxwalkdistance_use_setting)
        self.isochrones_maxwalkdistance_setting = int(self.dlg.Isochrones_MaxWalkDistance.value())
        s.setValue("otp_plugin/Isochrones_MaxWalkDistance", self.isochrones_maxwalkdistance_setting)
        
        # Max Offroaddistance
        self.isochrones_maxoffroaddistance_use_setting = int(self.dlg.Isochrones_MaxOffroadDistance_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_MaxOffroadDistance_Use", self.isochrones_maxoffroaddistance_use_setting)
        self.isochrones_maxoffroaddistance_setting = int(self.dlg.Isochrones_MaxOffroadDistance.value())
        s.setValue("otp_plugin/Isochrones_MaxOffroadDistance", self.isochrones_maxoffroaddistance_setting)
        
        # Precision Meters
        self.isochrones_precisionmeters_use_setting = int(self.dlg.Isochrones_PrecisionMeters_Use.isChecked())
        s.setValue("otp_plugin/Isochrones_PrecisionMeters_Use", self.isochrones_precisionmeters_use_setting)
        self.isochrones_precisionmeters_setting = int(self.dlg.Isochrones_PrecisionMeters.value())
        s.setValue("otp_plugin/Isochrones_PrecisionMeters", self.isochrones_precisionmeters_setting)
        
        # Cutoff Secs
        self.isochrones_interval_setting = self.dlg.Isochrones_Interval.toPlainText()
        s.setValue("otp_plugin/Isochrones_Interval", self.isochrones_interval_setting)
        
        # Mode
        self.isochrones_transportationmode_setting = self.dlg.Isochrones_TransportationMode.toPlainText()
        s.setValue("otp_plugin/Isochrones_TransportationMode", self.isochrones_transportationmode_setting)
        
        # Additional Parameters
        self.isochrones_additionalparameters_setting = self.dlg.Isochrones_AdditionalParameters.toPlainText()
        s.setValue("otp_plugin/Isochrones_AdditionalParameters", self.isochrones_additionalparameters_setting)
        
        self.iface.messageBar().pushMessage("Success", "Isochrone settings stored!", MESSAGE_CATEGORY, level=Qgis.Success, duration=3) 
        QgsMessageLog.logMessage("Isochrone settings stored!",MESSAGE_CATEGORY,Qgis.Info)
        
    def read_isochrone_variables(self):
        s = QgsSettings()
        
        # Walk Speed
        self.isochrones_walkspeed_use_setting = int(s.value("otp_plugin/Isochrones_WalkSpeed_Use", 0))
        self.dlg.Isochrones_WalkSpeed_Use.setChecked(self.isochrones_walkspeed_use_setting)
        self.isochrones_walkspeed_setting = float(s.value("otp_plugin/Isochrones_WalkSpeed", 4.828032))
        self.dlg.Isochrones_WalkSpeed.setValue(self.isochrones_walkspeed_setting)
        
        # Bike Speed
        self.isochrones_bikespeed_use_setting = int(s.value("otp_plugin/Isochrones_BikeSpeed_Use", 0))
        self.dlg.Isochrones_BikeSpeed_Use.setChecked(self.isochrones_bikespeed_use_setting)
        self.isochrones_bikespeed_setting = float(s.value("otp_plugin/Isochrones_BikeSpeed", 17.7))
        self.dlg.Isochrones_BikeSpeed.setValue(self.isochrones_bikespeed_setting)
        
        # Date
        self.isochrones_date_use_setting = int(s.value("otp_plugin/Isochrones_Date_Use", 1))
        self.dlg.Isochrones_Date_Use.setChecked(self.isochrones_date_use_setting)
        self.isochrones_date_setting = s.value("otp_plugin/Isochrones_Date", QtCore.QDateTime.currentDateTime())
        # I guess nobody understands this date 'stuff'....
        try:
            self.dlg.Isochrones_Date.setDateTime(self.isochrones_date_setting) # Standard value
        except:
            self.dlg.Isochrones_Date.setDate(self.isochrones_date_setting) # Stored value
        
        # Time
        self.isochrones_time_use_setting = int(s.value("otp_plugin/Isochrones_Time_Use", 1))
        self.dlg.Isochrones_Time_Use.setChecked(self.isochrones_time_use_setting)
        self.isochrones_time_setting = s.value("otp_plugin/Isochrones_Time", QTime.fromString('14:00:00'))
        self.dlg.Isochrones_Time.setTime(self.isochrones_time_setting)
        
        # Arrive By
        self.isochrones_arriveby_use_setting = int(s.value("otp_plugin/Isochrones_ArriveBy_Use", 0))
        self.dlg.Isochrones_ArriveBy_Use.setChecked(self.isochrones_arriveby_use_setting)
        self.isochrones_arriveby_setting = int(s.value("otp_plugin/Isochrones_ArriveBy", 0))
        self.dlg.Isochrones_ArriveBy.setChecked(self.isochrones_arriveby_setting)
        
        # Wheelchair
        self.isochrones_wheelchair_use_setting = int(s.value("otp_plugin/Isochrones_Wheelchair_Use", 0))
        self.dlg.Isochrones_Wheelchair_Use.setChecked(self.isochrones_wheelchair_use_setting)
        self.isochrones_wheelchair_setting = int(s.value("otp_plugin/Isochrones_Wheelchair", 0))
        self.dlg.Isochrones_Wheelchair.setChecked(self.isochrones_wheelchair_setting)
        
        # Wait Reluctance
        self.isochrones_waitreluctance_use_setting = int(s.value("otp_plugin/Isochrones_WaitReluctance_Use", 0))
        self.dlg.Isochrones_WaitReluctance_Use.setChecked(self.isochrones_waitreluctance_use_setting)
        self.isochrones_waitreluctance_setting = float(s.value("otp_plugin/Isochrones_WaitReluctance", 0.95))
        self.dlg.Isochrones_WaitReluctance.setValue(self.isochrones_waitreluctance_setting)
        
        # Max Transfers
        self.isochrones_maxtransfers_use_setting = int(s.value("otp_plugin/Isochrones_MaxTransfers_Use", 0))
        self.dlg.Isochrones_MaxTransfers_Use.setChecked(self.isochrones_maxtransfers_use_setting)
        self.isochrones_maxtransfers_setting = int(s.value("otp_plugin/Isochrones_MaxTransfers", 5))
        self.dlg.Isochrones_MaxTransfers.setValue(self.isochrones_maxtransfers_setting)
        
        # Max WalkDistance
        self.isochrones_maxwalkdistance_use_setting = int(s.value("otp_plugin/Isochrones_MaxWalkDistance_Use", 0))
        self.dlg.Isochrones_MaxWalkDistance_Use.setChecked(self.isochrones_maxwalkdistance_use_setting)
        self.isochrones_maxwalkdistance_setting = int(s.value("otp_plugin/Isochrones_MaxWalkDistance", 1000))
        self.dlg.Isochrones_MaxWalkDistance.setValue(self.isochrones_maxwalkdistance_setting)
        
        # Max OffRoadDistance
        self.isochrones_maxoffroaddistance_use_setting = int(s.value("otp_plugin/Isochrones_MaxOffroadDistance_Use", 0))
        self.dlg.Isochrones_MaxOffroadDistance_Use.setChecked(self.isochrones_maxoffroaddistance_use_setting)
        self.isochrones_maxoffroaddistance_setting = int(s.value("otp_plugin/Isochrones_MaxOffroadDistance", 150))
        self.dlg.Isochrones_MaxOffroadDistance.setValue(self.isochrones_maxoffroaddistance_setting)
        
        # Precision Meters
        self.isochrones_precisionmeters_use_setting = int(s.value("otp_plugin/Isochrones_PrecisionMeters_Use", 0))
        self.dlg.Isochrones_PrecisionMeters_Use.setChecked(self.isochrones_precisionmeters_use_setting)
        self.isochrones_precisionmeters_setting = int(s.value("otp_plugin/Isochrones_PrecisionMeters", 200))
        self.dlg.Isochrones_PrecisionMeters.setValue(self.isochrones_precisionmeters_setting)
        
        # Cutoff Sec
        self.isochrones_interval = s.value("otp_plugin/Isochrones_Interval", "60,120,180,240,300")
        if isinstance(self.isochrones_interval, str): self.dlg.Isochrones_Interval.setText(self.isochrones_interval)
        
        # Mode
        self.isochrones_transportationmode = s.value("otp_plugin/Isochrones_TransportationMode", "WALK,TRANSIT")
        if isinstance(self.isochrones_transportationmode, str): self.dlg.Isochrones_TransportationMode.setText(self.isochrones_transportationmode)
        
        # Additional Parameters
        self.isochrones_additionalparameters = s.value("otp_plugin/Isochrones_AdditionalParameters", "")
        if isinstance(self.isochrones_additionalparameters, str): self.dlg.Isochrones_AdditionalParameters.setText(self.isochrones_additionalparameters)
        
        #self.iface.messageBar().pushMessage("Success", "Function read_isochrone_variables running!", level=Qgis.Success, duration=3)

    def restore_isochrone_variables(self):
        s = QgsSettings()
        #DefaultSettings
        # Walk Speed
        self.isochrones_walkspeed_use_setting = int(0)
        self.dlg.Isochrones_WalkSpeed_Use.setChecked(self.isochrones_walkspeed_use_setting)
        self.isochrones_walkspeed_setting = float(4.828032)
        self.dlg.Isochrones_WalkSpeed.setValue(self.isochrones_walkspeed_setting)
        
        # Bike Speed
        self.isochrones_bikespeed_use_setting = int(0)
        self.dlg.Isochrones_BikeSpeed_Use.setChecked(self.isochrones_bikespeed_use_setting)
        self.isochrones_bikespeed_setting = float(17.7)
        self.dlg.Isochrones_BikeSpeed.setValue(self.isochrones_bikespeed_setting)
        
        # Date #####
        self.isochrones_date_use_setting = int(1)
        self.dlg.Isochrones_Date_Use.setChecked(self.isochrones_date_use_setting)
        self.isochrones_date_setting = QDateTime(QtCore.QDateTime.currentDateTime())
        self.dlg.Isochrones_Date.setDateTime(self.isochrones_date_setting)
        
        # Time
        self.isochrones_time_use_setting = int(1)
        self.dlg.Isochrones_Time_Use.setChecked(self.isochrones_time_use_setting)
        self.isochrones_time_setting = QTime.fromString('14:00:00')
        self.dlg.Isochrones_Time.setTime(self.isochrones_time_setting)
        
        # Arrive By
        self.isochrones_arriveby_use_setting = int(0)
        self.dlg.Isochrones_ArriveBy_Use.setChecked(self.isochrones_arriveby_use_setting)
        self.isochrones_arriveby_setting = int(0)
        self.dlg.Isochrones_ArriveBy.setChecked(self.isochrones_arriveby_setting)
        
        # Wheelchair
        self.isochrones_wheelchair_use_setting = int(0)
        self.dlg.Isochrones_Wheelchair_Use.setChecked(self.isochrones_wheelchair_use_setting)
        self.isochrones_wheelchair_setting = int(0)
        self.dlg.Isochrones_Wheelchair.setChecked(self.isochrones_wheelchair_setting)
        
        # Wait Reluctance
        self.isochrones_waitreluctance_use_setting = int(0)
        self.dlg.Isochrones_WaitReluctance_Use.setChecked(self.isochrones_waitreluctance_use_setting)
        self.isochrones_waitreluctance_setting = float(0.95)
        self.dlg.Isochrones_WaitReluctance.setValue(self.isochrones_waitreluctance_setting)
        
        # Max Transfers
        self.isochrones_maxtransfers_use_setting = int(0)
        self.dlg.Isochrones_MaxTransfers_Use.setChecked(self.isochrones_maxtransfers_use_setting)
        self.isochrones_maxtransfers_setting = int(5)
        self.dlg.Isochrones_MaxTransfers.setValue(self.isochrones_maxtransfers_setting)
        
        # Max WalkDistance
        self.isochrones_maxwalkdistance_use_setting = int(0)
        self.dlg.Isochrones_MaxWalkDistance_Use.setChecked(self.isochrones_maxwalkdistance_use_setting)
        self.isochrones_maxwalkdistance_setting = int(1000)
        self.dlg.Isochrones_MaxWalkDistance.setValue(self.isochrones_maxwalkdistance_setting)
        
        # Max OffRoadDistance
        self.isochrones_maxoffroaddistance_use_setting = int(0)
        self.dlg.Isochrones_MaxOffroadDistance_Use.setChecked(self.isochrones_maxoffroaddistance_use_setting)
        self.isochrones_maxoffroaddistance_setting = int(150)
        self.dlg.Isochrones_MaxOffroadDistance.setValue(self.isochrones_maxoffroaddistance_setting)
        
        # Precision Meters
        self.isochrones_precisionmeters_use_setting = int(0)
        self.dlg.Isochrones_PrecisionMeters_Use.setChecked(self.isochrones_precisionmeters_use_setting)
        self.isochrones_precisionmeters_setting = int(200)
        self.dlg.Isochrones_PrecisionMeters.setValue(self.isochrones_precisionmeters_setting)
        
        # Cutoff Sec
        self.isochrones_interval = ""
        if isinstance(self.isochrones_interval, str): self.dlg.Isochrones_Interval.setText(self.isochrones_interval)
        
        # Mode
        self.isochrones_transportationmode = ""
        if isinstance(self.isochrones_transportationmode, str): self.dlg.Isochrones_TransportationMode.setText(self.isochrones_transportationmode)
        
        # Additional Parameters
        self.isochrones_additionalparameters = ""
        if isinstance(self.isochrones_additionalparameters, str): self.dlg.Isochrones_AdditionalParameters.setText(self.isochrones_additionalparameters)
        
        self.iface.messageBar().pushMessage("Success", "Default isochrone settings restored!", MESSAGE_CATEGORY, level=Qgis.Success, duration=3)
        QgsMessageLog.logMessage("Default isochrone settings restored!",MESSAGE_CATEGORY,Qgis.Info)
        self.store_isochrone_variables()
        
        
    def check_server_status(self):
        # Proxy not working properly.... maybe I'll implement this someday...
        #self.read_proxy_settings()
        #proxy_support = urllib.request.ProxyHandler(self.proxyhandledict)
        #opener = urllib.request.build_opener(proxy_support)
        #urllib.request.install_opener(opener)
        servercheckrequest = urllib.request.Request(str(self.dlg.GeneralSettings_ServerURL.toPlainText()))
        try:
            urllib.request.urlopen(servercheckrequest, timeout=float(self.dlg.GeneralSettings_Timeout.value()))
            self.dlg.GeneralSettings_ServerStatusResult.setText("Server is Online :)")
            self.dlg.GeneralSettings_ServerStatusResult.setStyleSheet("background-color: green; color: white ")
        except urllib.error.URLError as urlerror:
            self.dlg.GeneralSettings_ServerStatusResult.setText("Error: " + str(urlerror.reason))
            self.dlg.GeneralSettings_ServerStatusResult.setStyleSheet("background-color: red; color: white ")
        except urllib.error.HTTPError as httperror:
            self.dlg.GeneralSettings_ServerStatusResult.setText("Error: " + str(httperror.code))
            self.dlg.GeneralSettings_ServerStatusResult.setStyleSheet("background-color: red; color: white ")
        
    def read_proxy_settings(self):
        pass
        """
        # not working properly.... maybe I'll implement this someday... feel free to make a pull request ;)
        # https://gis.stackexchange.com/questions/372294/sending-requests-including-headers-via-pyqgis-by-using-qgis-proxysettings
        s = QSettings()
        self.proxyEnabled = s.value("proxy/proxyEnabled", "")
        self.proxyType = s.value("proxy/proxyType", "" )
        self.proxyHost = s.value("proxy/proxyHost", "" )
        self.proxyPort = s.value("proxy/proxyPort", "" )
        self.proxyUser = s.value("proxy/proxyUser", "" )
        self.proxyPassword = s.value("proxy/proxyPassword", "" )
        
        self.proxyConcat = self.proxyUser + ':' + self.proxyPassword + '@' + self.proxyHost + ':' + self.proxyPort
        
        try:
            if self.proxyEnabled is True:
                self.proxyhandledict = {'http':self.proxyConcat}
            else:
                self.proxyhandledict = {}
        except:
            self.proxyhandledict = {}
        """
            
    def isochrones_maplayerselection(self): # Outsourcing layerselection to this function to avoid repeading the same code everywhere (Reference: https://gis.stackexchange.com/a/225659/107424)
        self.dlg.Isochrones_SelectInputLayer.setFilters(QgsMapLayerProxyModel.PointLayer) # Filter out all layers except Point layers
        self.isochrones_selectedlayer = self.dlg.Isochrones_SelectInputLayer.currentLayer() # Using the currently selected layer in QgsMapLayerComboBox as selectedLayer
        if not self.isochrones_selectedlayer: # cancel if no pointlayer available
            return
        self.isochrones_inputlayer_fieldnames = [field.name() for field in self.isochrones_selectedlayer.fields()] # Receive Isochrones_Inputlayer_Fieldnames from selected layer
        
        # Setting up QgsOverrideButtons (Reference: https://gis.stackexchange.com/a/350993/107424). Has to be done here, so they get updated when the layer selection has changed...
        #WalkSpeed
        self.dlg.Isochrones_WalkSpeed_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_WalkSpeed_Override.init(0, QgsProperty(), QgsPropertyDefinition("walkSpeed", "Walk Speed in km/h", QgsPropertyDefinition.DoublePositive), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #BikeSpeed
        self.dlg.Isochrones_BikeSpeed_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_BikeSpeed_Override.init(0, QgsProperty(), QgsPropertyDefinition("bikeSpeed", "Bike Speed in km/h", QgsPropertyDefinition.DoublePositive), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #Date
        self.dlg.Isochrones_Date_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_Date_Override.init(0, QgsProperty(), QgsPropertyDefinition("Date", "Date in YYYY-MM-DD", QgsPropertyDefinition.String), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #Time
        self.dlg.Isochrones_Time_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_Time_Override.init(0, QgsProperty(), QgsPropertyDefinition("Time", "Time in HH:MM:SS", QgsPropertyDefinition.String), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #ArriveBy
        self.dlg.Isochrones_ArriveBy_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_ArriveBy_Override.init(0, QgsProperty(), QgsPropertyDefinition("ArriveBy", "ArriveBy as Boolean", QgsPropertyDefinition.Boolean), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #Wheelchair
        self.dlg.Isochrones_Wheelchair_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_Wheelchair_Override.init(0, QgsProperty(), QgsPropertyDefinition("Wheelchair", "Wheelchair as Boolean", QgsPropertyDefinition.Boolean), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #WaitReluctance
        self.dlg.Isochrones_WaitReluctance_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_WaitReluctance_Override.init(0, QgsProperty(), QgsPropertyDefinition("WaitReluctance", "Wait Reluctance Factor as Double", QgsPropertyDefinition.Double), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #MaxTransfers
        self.dlg.Isochrones_MaxTransfers_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_MaxTransfers_Override.init(0, QgsProperty(), QgsPropertyDefinition("MaxTransfers", "Maximum Transfers as Integer", QgsPropertyDefinition.IntegerPositive), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #MaxWalkDistance
        self.dlg.Isochrones_MaxWalkDistance_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_MaxWalkDistance_Override.init(0, QgsProperty(), QgsPropertyDefinition("MaxWalkDistance", "Maximum Walk Distance in Meters", QgsPropertyDefinition.IntegerPositive), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #MaxOffroadDistance
        self.dlg.Isochrones_MaxOffroadDistance_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_MaxOffroadDistance_Override.init(0, QgsProperty(), QgsPropertyDefinition("MaxOffroadDistance", "Maximum Offroad Distance in Meters", QgsPropertyDefinition.IntegerPositive), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #PrecisionMeters
        self.dlg.Isochrones_PrecisionMeters_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_PrecisionMeters_Override.init(0, QgsProperty(), QgsPropertyDefinition("PrecisionMeters", "Level of Detail in Meters", QgsPropertyDefinition.IntegerPositiveGreaterZero), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #Interval
        self.dlg.Isochrones_Interval_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_Interval_Override.init(0, QgsProperty(), QgsPropertyDefinition("Interval", "Isochrones Interval in Seconds as String using Integer Values separated by Comma", QgsPropertyDefinition.String), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #TransportationMode
        self.dlg.Isochrones_TransportationMode_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_TransportationMode_Override.init(0, QgsProperty(), QgsPropertyDefinition("TransportationMode", "TransportationMode as String separated by Comma", QgsPropertyDefinition.String), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #AdditionalParameters
        self.dlg.Isochrones_AdditionalParameters_Override.registerExpressionContextGenerator(self.isochrones_selectedlayer) # will allow the use of global, project, and layer variables.
        self.dlg.Isochrones_AdditionalParameters_Override.init(0, QgsProperty(), QgsPropertyDefinition("AdditionalParameters", "Additional Parameters as String", QgsPropertyDefinition.String), self.isochrones_selectedlayer, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition

        
    def routes_maplayerselection(self): # Outsourcing layerselection to this function to avoid repeading the same code everywhere (Reference: https://gis.stackexchange.com/a/225659/107424)
        self.dlg.Routes_SelectInputLayer_Source.setFilters(QgsMapLayerProxyModel.PointLayer) # Filter out all layers except Point layers
        self.routes_selectedlayer_source = self.dlg.Routes_SelectInputLayer_Source.currentLayer() # Using the currently selected layer in QgsMapLayerComboBox as selectedLayer
        self.dlg.Routes_SelectInputLayer_Target.setFilters(QgsMapLayerProxyModel.PointLayer) # Filter out all layers except Point layers
        self.routes_selectedlayer_target = self.dlg.Routes_SelectInputLayer_Target.currentLayer() # Using the currently selected layer in QgsMapLayerComboBox as selectedLayer
        if not self.routes_selectedlayer_source or not self.routes_selectedlayer_target: # cancel if no pointlayer available
            return
        self.routes_inputlayer_source_fieldnames = [field.name() for field in self.routes_selectedlayer_source.fields()] # Receive Inputlayer_Fieldnames from selected layer
        self.routes_inputlayer_target_fieldnames = [field.name() for field in self.routes_selectedlayer_target.fields()] # Receive Inputlayer_Fieldnames from selected layer
        self.routes_uidfield_source = self.dlg.Routes_SelectInputField_Source.setLayer(self.routes_selectedlayer_source) # Reference fieldselection to layer
        self.routes_uidfield_target = self.dlg.Routes_SelectInputField_Target.setLayer(self.routes_selectedlayer_target) # Reference fieldselection to layer
        try: # setup default selected fields
            if self.dlg.Routes_SelectInputField_Source.currentField() == '': # Only default if no field is selected
                if self.routes_selectedlayer_source.fields().indexFromName('id') == -1: # if no id field, use the first field
                    self.dlg.Routes_SelectInputField_Source.setCurrentIndex(0)
                else: # if id field, use it as default
                    self.dlg.Routes_SelectInputField_Source.setField('id')
                # same for targetlayer
            if self.dlg.Routes_SelectInputField_Target.currentField() == '': # Only default if no field is selected
                if self.routes_selectedlayer_target.fields().indexFromName('id') == -1:
                    self.dlg.Routes_SelectInputField_Target.setCurrentIndex(0)
                else:
                    self.dlg.Routes_SelectInputField_Target.setField('id')
        except: # if layer has no field, throw error
            self.iface.messageBar().pushMessage("Error", " Layer does not have any fields!", MESSAGE_CATEGORY, level=Qgis.Critical, duration=3)
            QgsMessageLog.logMessage("Layer does not have any fields!",MESSAGE_CATEGORY,Qgis.Warning)
            
        if self.dlg.Routes_DataDefinedLayer_Source.isChecked() == True:
            ddomaster = self.routes_selectedlayer_source
        elif self.dlg.Routes_DataDefinedLayer_Target.isChecked() == True:
            ddomaster = self.routes_selectedlayer_target
        else:
            ddomaster = self.routes_selectedlayer_source

        # Setting up QgsOverrideButtons (Reference: https://gis.stackexchange.com/a/350993/107424). Has to be done here, so they get updated when the layer selection has changed...
        # Use Sourcelayer as Master
        #WalkSpeed
        self.dlg.Routes_WalkSpeed_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_WalkSpeed_Override.init(0, QgsProperty(), QgsPropertyDefinition("walkSpeed", "Walk Speed in km/h", QgsPropertyDefinition.DoublePositive), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #BikeSpeed
        self.dlg.Routes_BikeSpeed_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_BikeSpeed_Override.init(0, QgsProperty(), QgsPropertyDefinition("bikeSpeed", "Bike Speed in km/h", QgsPropertyDefinition.DoublePositive), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #Date
        self.dlg.Routes_Date_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_Date_Override.init(0, QgsProperty(), QgsPropertyDefinition("Date", "Date in YYYY-MM-DD", QgsPropertyDefinition.String), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #Time
        self.dlg.Routes_Time_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_Time_Override.init(0, QgsProperty(), QgsPropertyDefinition("Time", "Time in HH:MM:SS", QgsPropertyDefinition.String), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #ArriveBy
        self.dlg.Routes_ArriveBy_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_ArriveBy_Override.init(0, QgsProperty(), QgsPropertyDefinition("ArriveBy", "ArriveBy as Boolean", QgsPropertyDefinition.Boolean), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #Wheelchair
        self.dlg.Routes_Wheelchair_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_Wheelchair_Override.init(0, QgsProperty(), QgsPropertyDefinition("Wheelchair", "Wheelchair as Boolean", QgsPropertyDefinition.Boolean), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #WaitReluctance
        self.dlg.Routes_WaitReluctance_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_WaitReluctance_Override.init(0, QgsProperty(), QgsPropertyDefinition("WaitReluctance", "Wait Reluctance Factor as Double", QgsPropertyDefinition.Double), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #MaxTransfers
        self.dlg.Routes_MaxTransfers_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_MaxTransfers_Override.init(0, QgsProperty(), QgsPropertyDefinition("MaxTransfers", "Maximum Transfers as Integer", QgsPropertyDefinition.IntegerPositive), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #MaxWalkDistance
        self.dlg.Routes_MaxWalkDistance_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_MaxWalkDistance_Override.init(0, QgsProperty(), QgsPropertyDefinition("MaxWalkDistance", "Maximum Walk Distance in Meters", QgsPropertyDefinition.IntegerPositive), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #MaxOffroadDistance
        self.dlg.Routes_MaxOffroadDistance_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_MaxOffroadDistance_Override.init(0, QgsProperty(), QgsPropertyDefinition("MaxOffroadDistance", "Maximum Offroad Distance in Meters", QgsPropertyDefinition.IntegerPositive), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #Iterinaries
        self.dlg.Routes_Iterinaries_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_Iterinaries_Override.init(0, QgsProperty(), QgsPropertyDefinition("numIterinaries", "Number of Iterinaries", QgsPropertyDefinition.IntegerPositiveGreaterZero), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #Optimize
        self.dlg.Routes_Optimize_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_Optimize_Override.init(0, QgsProperty(), QgsPropertyDefinition("Optimize", "Optimizationmode as String", QgsPropertyDefinition.String), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #TransportationMode
        self.dlg.Routes_TransportationMode_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_TransportationMode_Override.init(0, QgsProperty(), QgsPropertyDefinition("TransportationMode", "TransportationMode as String separated by Comma", QgsPropertyDefinition.String), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
        #AdditionalParameters
        self.dlg.Routes_AdditionalParameters_Override.registerExpressionContextGenerator(ddomaster) # will allow the use of global, project, and layer variables.
        self.dlg.Routes_AdditionalParameters_Override.init(0, QgsProperty(), QgsPropertyDefinition("AdditionalParameters", "Additional Parameters as String", QgsPropertyDefinition.String), ddomaster, False) # Need to tell the button which kind of property it expects. This is done by calling the init function of the button. This function expects a QgsPropertyDefinition
    
    # Disable/Enable GUI elements to prevent them from beeing used while worker threads are running and accidentially changing settings during progress
    def disableIsochronesGui(self):
        exceptionlist = ['Isochrones_ProgressBar','Isochrones_Cancel']
        for widget in self.dlg.tab_run_isochrones.children():
            if not widget.objectName() in exceptionlist:
                widget.setEnabled(False)
    def disableRoutesGui(self):
        exceptionlist = ['Routes_ProgressBar','Routes_Cancel']
        for widget in self.dlg.tab_run_routes.children():
            if not widget.objectName() in exceptionlist:
                widget.setEnabled(False)
    def disableGeneralSettingsGui(self):
        exceptionlist = ['GeneralSettings_Proxy_Use']
        for widget in self.dlg.tab_settings_general.children():
            if not widget.objectName() in exceptionlist:
                widget.setEnabled(False)
    def enableIsochronesGui(self):
        exceptionlist = []
        for widget in self.dlg.tab_run_isochrones.children():
            if not widget.objectName() in exceptionlist:
                widget.setEnabled(True)
    def enableRoutesGui(self):
        exceptionlist = []
        for widget in self.dlg.tab_run_routes.children():
            if not widget.objectName() in exceptionlist:
                widget.setEnabled(True)
    def enableGeneralSettingsGui(self):
        exceptionlist = ['GeneralSettings_Proxy_Use']
        for widget in self.dlg.tab_settings_general.children():
            if not widget.objectName() in exceptionlist:
                widget.setEnabled(True)
