# -*- coding: utf-8 -*-
"""
/***************************************************************************
 OpenTripPlannerPlugin
                                 A QGIS plugin
 This plugin makes OpenTripPlanner functionalities accessible in QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-10-21
        git sha              : $Format:%H$
        copyright            : (C) 2019 - Today by Mario Königbauer
        email                : mkoenigb@gmx.de
        repository           : https://github.com/mkoenigb/OpenTripPlannerPlugin
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QObject, QThread, pyqtSignal
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from PyQt5.QtNetwork import  QNetworkAccessManager, QNetworkRequest
from PyQt5.QtCore import *
from qgis.core import *
from qgis.utils import *


# Initialize Qt resources from file resources.py
from .resources import *
from .otp_plugin_general_functions import *
# Import the code for the dialog
from .otp_plugin_dialog import OpenTripPlannerPluginDialog
from osgeo import ogr
from datetime import *
import processing
import os
import urllib
import zipfile
import json
import math

MESSAGE_CATEGORY = 'OpenTripPlanner PlugIn'

class OpenTripPlannerPluginAggregatedIsochronesWorker(QThread):
    aggregated_isochrones_finished = pyqtSignal(object, int, str, str)
    aggregated_isochrones_progress = pyqtSignal(int, str)

    def __init__(self, dialog, iface, otpgf, resultlayer):
        super(QThread, self).__init__()
        self.dlg = dialog
        self.gf = otpgf
        self.iface = iface
        self.stopaggregated_isochronesworker = False
        self.aggregated_isochrones_memorylayer_vl = resultlayer
        self.aggregated_isochrones_state = 0
        self.gf.read_general_variables()
        #self.gf.read_isochrone_variables()
    
    def stop(self):
        self.stopaggregated_isochronesworker = True

        
    def run(self):        
        # clear and initialize vars and stuff
        self.aggregated_isochrones_state = 1
        aggregated_isochrone_url = None
        #aggregated_isochrone_error = None
        #aggregated_isochrone_errors = []
        statusinformation = ''
        #tmp_aggregated_isochrones_error = None
        #tmp_aggregated_isochrones_errors = []
        unique_errors = []
        r = None
        inputlayer_outfeat = None
        debug_info = None
        aggregated_isochrone_uid_counter = 0
        aggregated_isochrone_id_counter = 0
        aggregated_isochrones_memorylayer_vl = self.aggregated_isochrones_memorylayer_vl
        
        QgsMessageLog.logMessage("",MESSAGE_CATEGORY,Qgis.Info)
        QgsMessageLog.logMessage("",MESSAGE_CATEGORY,Qgis.Info)
        QgsMessageLog.logMessage("##### Aggregated-Isochrones job starting @ " + str(datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f")) + " #####",MESSAGE_CATEGORY,Qgis.Info)
        QgsMessageLog.logMessage("",MESSAGE_CATEGORY,Qgis.Info)
        aggregated_isochrones_starttime = datetime.now()
        
        # Preparing Progressbar
        progressbar_featurecount = self.gf.aggregated_isochrones_selectedlayer.featureCount()
        progressbar_percent = 1 # Use 1 on start to show users that something is running if the first one takes a while
        progressbar_counter = 0
        statusinformation = "Aggregated-Isochrones job starting @ " + str(datetime.now().strftime("%Y-%m-%d %H:%M:%S"))
        self.aggregated_isochrones_progress.emit(int(progressbar_percent),str(statusinformation))
            
        # Setting up Override Button context
        ctx = QgsExpressionContext(QgsExpressionContextUtils.globalProjectLayerScopes(self.gf.aggregated_isochrones_selectedlayer)) #This context will be able to evaluate global, project, and layer variables
        
        
        # Create the Output-Vectorlayer
        with edit(aggregated_isochrones_memorylayer_vl):
            aggregated_isochrones_memorylayer_pr = aggregated_isochrones_memorylayer_vl.dataProvider()
            for field in self.gf.aggregated_isochrones_selectedlayer.fields():          
                #aggregated_isochrones_memorylayer_pr.addAttributes([QgsField('Source_' + str(field.name()), field.type())]) # Old fieldname + Source_ as prefix. Keep original field type <-- to add prefix dont forget to add it for the new_feat later as well
                aggregated_isochrones_memorylayer_pr.addAttributes([QgsField(field.name(), field.type())]) # copy fields from input to output
            new_generic_fields = [
                                  QgsField("AggIsochrone_UID", QVariant.Int), # Unique ID per feature of result layer
                                  QgsField("AggIsochrone_ID", QVariant.Int), # ID of input feature
                                  #QgsField("AggIsochrone_SID", QVariant.Int), # SubID of input feature (iteration)
                                  QgsField("AggIsochrone_Error", QVariant.String), # On Input-Feature-Base
                                  QgsField("AggIsochrone_URL", QVariant.String), # Base URL without &date= and without &time=
                                  QgsField("AggIsochrone_From", QVariant.String), # From Datetime
                                  QgsField("AggIsochrone_To", QVariant.String), # To Datetime
                                  QgsField("AggIsochrone_ReqIntervalSec", QVariant.Int), # Request-Interval in Seconds
                                  QgsField("AggIsochrone_ReqDates", QVariant.String), # Requested Dates
                                  QgsField("AggIsochrone_ReqTimes", QVariant.String), # Requested Times
                                  QgsField("AggIsochrone_TotalRequests",QVariant.Int) # Only for Raw and Dissolve
                                  ]
            if self.dlg.AggregatedIsochrones_MaxDissolve_Use.isChecked():
                new_generic_mode_fields = [QgsField("AggIsochrone_time",QVariant.Int)]
            elif self.dlg.AggregatedIsochrones_AllUnion_Use.isChecked():
                # returns fields: time_count, time_unique, time_min, time_max, time_range, time_sum, time_mean, time_median, time_stddev, time_minority, time_majority, time_q1, time_q3, time_iqr
                new_generic_mode_fields = [
                                           QgsField("AggIsochrone_time_count",QVariant.Int),
                                           QgsField("AggIsochrone_time_unique",QVariant.Int),
                                           QgsField("AggIsochrone_time_min",QVariant.Double),
                                           QgsField("AggIsochrone_time_max",QVariant.Double),
                                           QgsField("AggIsochrone_time_range",QVariant.Double),
                                           QgsField("AggIsochrone_time_sum",QVariant.Double),
                                           QgsField("AggIsochrone_time_mean",QVariant.Double),
                                           QgsField("AggIsochrone_time_median",QVariant.Double),
                                           QgsField("AggIsochrone_time_stddev",QVariant.Double),
                                           QgsField("AggIsochrone_time_minority",QVariant.Double),
                                           QgsField("AggIsochrone_time_majority",QVariant.Double),
                                           QgsField("AggIsochrone_time_q1",QVariant.Double),
                                           QgsField("AggIsochrone_time_q3",QVariant.Double),
                                           QgsField("AggIsochrone_time_iqr",QVariant.Double)
                                          ]
            elif self.dlg.AggregatedIsochrones_NoAggRaw_Use.isChecked():
                new_generic_mode_fields = [QgsField("AggIsochrone_time",QVariant.Int),QgsField("AggIsochrone_reqdt",QVariant.String)]
            else:
                new_generic_mode_fields = [QgsField("AggIsochrone_time",QVariant.Int)]
            
            aggregated_isochrones_memorylayer_pr.addAttributes(new_generic_fields)
            aggregated_isochrones_memorylayer_pr.addAttributes(new_generic_mode_fields)
            inputlayer_numberoffields = self.gf.aggregated_isochrones_selectedlayer.fields().count() # count number of fields in inputlayer
            
            # Savelocation
            tmp_save_location = self.gf.tmp_save_location
    
            # General Settings
            serverurl = self.gf.serverurl #'https://api.digitransit.fi/routing/v1/routers/hsl/' #self.dlg.GeneralSettings_ServerURL.toPlainText()        
     
            # Preparing Transformation to WGS 84
            sourcecrs = QgsCoordinateReferenceSystem(self.gf.aggregated_isochrones_selectedlayer.crs().authid()) # Read CRS of input layer
            destcrs = QgsCoordinateReferenceSystem("EPSG:4326") # and set destination CRS to WGS 84 (OTP can only understand EPSG:4326) 
            tr = QgsCoordinateTransform(sourcecrs, destcrs, QgsProject.instance()) # Setting up transformation
            

            
            if progressbar_featurecount == 0:
                self.aggregated_isochrones_state = 3
                QgsMessageLog.logMessage("Warning! No Isochrones to create. Inputlayer is empty.",MESSAGE_CATEGORY,Qgis.Warning)
                statusinformation = ('No Isochrones to create. Inputlayer is empty. Cancelling execution.')
                self.aggregated_isochrones_progress.emit(int(progressbar_percent),str(statusinformation))
                
            for inputlayer_iteration, inputlayer_feature in enumerate(self.gf.aggregated_isochrones_selectedlayer.getFeatures()):
                if self.stopaggregated_isochronesworker == True: # if cancel button has been clicked this var has been set to True to break the loop so the thread can be quit
                    self.aggregated_isochrones_state = 2
                    break
                
                # Initial Variables
                # Empty the error vars
                isochrone_error = None
                isochrone_errors = []
                isochrone_unique_errors = []
                
                progressbar_counter = progressbar_counter + 1
                statusinformation = ('Processing Feature ID: ' + str(inputlayer_feature.id()) + ' (#' + str(inputlayer_iteration+1) + ' of ' + str(progressbar_featurecount) + ' total features)')
                self.aggregated_isochrones_progress.emit(int(progressbar_percent),str(statusinformation))
                
                # Override Button Feature
                ctx.setFeature(inputlayer_feature) #Setting context to current feature
                
                # Feature Geometry
                geom = inputlayer_feature.geometry() # fetch geometry of current feature
                geom.transform(tr) # Transform geometry to WGS 84 (We prepared this outside the loop)
                pointgeom = geom.asPoint() #Read Point geometry
                x = round(pointgeom.x(),8) #Read X-Value
                y = round(pointgeom.y(),8) #Read Y-Value
                QgsMessageLog.logMessage("Feature ID: " + str(inputlayer_feature.id()),MESSAGE_CATEGORY,Qgis.Info)
                QgsMessageLog.logMessage("PointX: " + str(x) + " | PointY: " + str(y),MESSAGE_CATEGORY,Qgis.Info)
                
                
                #Check where to gather attributes from: GUI or Layer? 
                #WalkSpeed
                if self.dlg.AggregatedIsochrones_WalkSpeed_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_WalkSpeed_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_walkspeed_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_WalkSpeed_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_walkspeed_value = self.dlg.AggregatedIsochrones_WalkSpeed.value() # Receiving Value from GUI: QDoubleSpinBox
                    if aggregated_isochrones_walkspeed_value is not None: # Check if received value is NULL
                        aggregated_isochrones_walkspeed_ms = float(aggregated_isochrones_walkspeed_value) * 0.27777777777778 # Convert float and km/h to m/s
                        aggregated_isochrones_walkspeed_urlstring = '&walkSpeed=' + str(round(aggregated_isochrones_walkspeed_ms,6)) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_walkspeed_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_walkspeed_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
     
                #BikeSpeed
                if self.dlg.AggregatedIsochrones_BikeSpeed_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_BikeSpeed_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_bikespeed_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_BikeSpeed_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_bikespeed_value = self.dlg.AggregatedIsochrones_BikeSpeed.value() # Receiving Value from GUI: QDoubleSpinBox
                    if aggregated_isochrones_bikespeed_value is not None: # Check if received value is NULL
                        aggregated_isochrones_bikespeed_ms = float(aggregated_isochrones_bikespeed_value) * 0.27777777777778 # Convert float and km/h to m/s
                        aggregated_isochrones_bikespeed_urlstring = '&bikeSpeed=' + str(round(aggregated_isochrones_bikespeed_ms,6)) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_bikespeed_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_bikespeed_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
                    
                #Wait at Beginning
                if self.dlg.AggregatedIsochrones_WaitAtBeginning_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_WaitAtBeginning_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_waitatbeginning_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_WaitAtBeginning_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_waitatbeginning_value = self.dlg.AggregatedIsochrones_WaitAtBeginning.value() # Receiving Value from GUI: QDoubleSpinBox
                    if aggregated_isochrones_waitatbeginning_value is not None: # Check if received value is NULL
                        aggregated_isochrones_waitatbeginning_float = round(float(aggregated_isochrones_waitatbeginning_value),2)
                        aggregated_isochrones_waitatbeginning_urlstring = '&waitAtBeginningFactor=' + str(aggregated_isochrones_waitatbeginning_float) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_waitatbeginning_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_waitatbeginning_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
                
                #Clamp initial Wait
                if self.dlg.AggregatedIsochrones_ClampInitialWait_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_ClampInitialWait_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_clampinitialwait_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_ClampInitialWait_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_clampinitialwait_value = self.dlg.AggregatedIsochrones_ClampInitialWait.value() # Receiving Value from GUI: QDoubleSpinBox
                    if aggregated_isochrones_clampinitialwait_value is not None: # Check if received value is NULL
                        aggregated_isochrones_clampinitialwait_float = round(float(aggregated_isochrones_clampinitialwait_value),2)
                        aggregated_isochrones_clampinitialwait_urlstring = '&clampInitialWait=' + str(aggregated_isochrones_clampinitialwait_float) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_clampinitialwait_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_clampinitialwait_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
                    
                #ArriveBy
                if self.dlg.AggregatedIsochrones_ArriveBy_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_ArriveBy_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_arriveby_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_ArriveBy_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_arriveby_value = self.dlg.AggregatedIsochrones_ArriveBy.isChecked() # Receiving Value from GUI: QCheckBox
                    if aggregated_isochrones_arriveby_value is not None: # Check if received value is NULL
                        aggregated_isochrones_arriveby_urlstring = '&arriveBy=' + str(aggregated_isochrones_arriveby_value) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_arriveby_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_arriveby_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
                    
                #Wheelchair
                if self.dlg.AggregatedIsochrones_Wheelchair_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_Wheelchair_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_wheelchair_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_Wheelchair_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_wheelchair_value = self.dlg.AggregatedIsochrones_Wheelchair.isChecked() # Receiving Value from GUI: QCheckBox
                    if aggregated_isochrones_wheelchair_value is not None: # Check if received value is NULL
                        aggregated_isochrones_wheelchair_urlstring = '&wheelchair=' + str(aggregated_isochrones_wheelchair_value) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_wheelchair_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_wheelchair_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
                    
                #WaitReluctance
                if self.dlg.AggregatedIsochrones_WaitReluctance_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_WaitReluctance_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_waitreluctance_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_WaitReluctance_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_waitreluctance_value = self.dlg.AggregatedIsochrones_WaitReluctance.value() # Receiving Value from GUI: QDoubleSpinBox
                    if aggregated_isochrones_waitreluctance_value is not None: # Check if received value is NULL
                        aggregated_isochrones_waitreluctance_float = round(float(aggregated_isochrones_waitreluctance_value),2)
                        aggregated_isochrones_waitreluctance_urlstring = '&waitReluctance=' + str(aggregated_isochrones_waitreluctance_float) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_waitreluctance_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_waitreluctance_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
                    
                #MaxTransfers
                if self.dlg.AggregatedIsochrones_MaxTransfers_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_MaxTransfers_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_maxtransfers_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_MaxTransfers_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_maxtransfers_value = self.dlg.AggregatedIsochrones_MaxTransfers.value() # Receiving Value from GUI: QSpinBox
                    if aggregated_isochrones_maxtransfers_value is not None: # Check if received value is NULL
                        aggregated_isochrones_maxtransfers_urlstring = '&maxTransfers=' + str(aggregated_isochrones_maxtransfers_value) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_maxtransfers_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_maxtransfers_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
                 
                #MaxWalkDistance
                if self.dlg.AggregatedIsochrones_MaxWalkDistance_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_MaxWalkDistance_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_maxwalkdistance_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_MaxWalkDistance_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_maxwalkdistance_value = self.dlg.AggregatedIsochrones_MaxWalkDistance.value() # Receiving Value from GUI: QSpinBox
                    if aggregated_isochrones_maxwalkdistance_value is not None: # Check if received value is NULL
                        aggregated_isochrones_maxwalkdistance_urlstring = '&maxWalkDistance=' + str(aggregated_isochrones_maxwalkdistance_value) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_maxwalkdistance_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_maxwalkdistance_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
                 
                #MaxOffroadDistance
                if self.dlg.AggregatedIsochrones_MaxOffroadDistance_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_MaxOffroadDistance_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_maxoffroaddistance_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_MaxOffroadDistance_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_maxoffroaddistance_value = self.dlg.AggregatedIsochrones_MaxOffroadDistance.value() # Receiving Value from GUI: QSpinBox
                    if aggregated_isochrones_maxoffroaddistance_value is not None: # Check if received value is NULL
                        aggregated_isochrones_maxoffroaddistance_urlstring = '&offRoadDistanceMeters=' + str(aggregated_isochrones_maxoffroaddistance_value) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_maxoffroaddistance_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_maxoffroaddistance_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)
                 
                #PrecisionMeters
                if self.dlg.AggregatedIsochrones_PrecisionMeters_Use.isChecked() == True: # Check if option shall be used                
                    if self.dlg.AggregatedIsochrones_PrecisionMeters_Override.isActive() == True: # Check if override button shall be used
                        aggregated_isochrones_precisionmeters_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_PrecisionMeters_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                    else:
                        aggregated_isochrones_precisionmeters_value = self.dlg.AggregatedIsochrones_PrecisionMeters.value() # Receiving Value from GUI: QSpinBox
                    if aggregated_isochrones_precisionmeters_value is not None: # Check if received value is NULL
                        aggregated_isochrones_precisionmeters_urlstring = '&precisionMeters=' + str(aggregated_isochrones_precisionmeters_value) # Concatenate to URL string if option is used and value is not NULL
                    else:
                        aggregated_isochrones_precisionmeters_urlstring = '' # Leave URL string empty if value is NULL (Empty, not NULL!!)
                else:
                    aggregated_isochrones_precisionmeters_urlstring = '' # Leave URL string empty if option is not used (Empty, not NULL!!)                   
    
                #Isochrones Interval
                if self.dlg.AggregatedIsochrones_Interval_Override.isActive() == True:
                    aggregated_isochrones_interval_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_Interval_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                else:
                    aggregated_isochrones_interval_value = self.dlg.AggregatedIsochrones_Interval.toPlainText() #Receiving Value from GUI: QTextEdit
                if not aggregated_isochrones_interval_value: # Check if it is NULL
                    aggregated_isochrones_interval_value = '300,600,900' # Make sure cutoffSec is not empty because it is a must have parameter   
                aggregated_isochrones_interval_value = aggregated_isochrones_interval_value.replace(" ", "")  # Remove whitespaces in case user entered them              
                interval_list = list(aggregated_isochrones_interval_value.split(",")) # Split given Integers (as string) separated by comma into a list
                interval_list_new = []
                for entry in interval_list:
                    if entry.lower().endswith('m'):
                        entry = str(int(entry.lower().replace('m',''))*60)
                    elif entry.lower().endswith('h'):
                        entry = str(int(entry.lower().replace('h',''))*3600)
                    interval_list_new.append(entry)
                aggregated_isochrones_interval_urlstring = "&cutoffSec=".join(interval_list_new) #Join the list to a string and add leading "&cutoffSec=" to each Integer. The first item of the list will get no leading "&cutoffSec=", we will add this later
    
                #Transportation Mode
                if self.dlg.AggregatedIsochrones_TransportationMode_Override.isActive() == True:
                    aggregated_isochrones_transportationmode_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_TransportationMode_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                else:
                    aggregated_isochrones_transportationmode_value = self.dlg.AggregatedIsochrones_TransportationMode.toPlainText() #Receiving Value from GUI: QTextEdit
                if not aggregated_isochrones_transportationmode_value: # Check if it is NULL
                    aggregated_isochrones_transportationmode_value = 'WALK,TRANSIT' # Make sure Mode is not empty because it is a must have parameter
                aggregated_isochrones_transportationmode_urlstring = "&mode=" + aggregated_isochrones_transportationmode_value.upper() # Make sure Mode is given as uppercase to prevent possible server errors (not sure how otp handels this exactly)
                
                #Additional Parameters
                if self.dlg.AggregatedIsochrones_AdditionalParameters_Override.isActive() == True:
                    aggregated_isochrones_additionalparameters_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_AdditionalParameters_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                else:
                    aggregated_isochrones_additionalparameters_value = self.dlg.AggregatedIsochrones_AdditionalParameters.toPlainText() #Receiving Value from GUI: QTextEdit
                if aggregated_isochrones_additionalparameters_value is not None: # If Additional Parameters are filled, use it
                    aggregated_isochrones_additionalparameters_urlstring = str(aggregated_isochrones_additionalparameters_value) # Create the string
                else: # If Additional Parameters are not filled, do not use it
                    aggregated_isochrones_additionalparameters_urlstring = '' # Create the string (Empty, because it is not used, not NULL!!)
                    
                ##################################
                
                #From DateTime
                if self.dlg.AggregatedIsochrones_FromDateTime_Override.isActive() == True: # Check if override button shall be used
                    aggregated_isochrones_fromdatetime_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_FromDateTime_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                else:
                    aggregated_isochrones_fromdatetime_value = self.dlg.AggregatedIsochrones_FromDateTime.dateTime().toString("yyyy-MM-dd HH:mm:ss") # Receiving Value from GUI: QDateTime
                aggregated_isochrones_fromdatetime_value = datetime.strptime(aggregated_isochrones_fromdatetime_value, '%Y-%m-%d %H:%M:%S')
                    
                #To DateTime
                if self.dlg.AggregatedIsochrones_ToDateTime_Override.isActive() == True: # Check if override button shall be used
                    aggregated_isochrones_todatetime_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_ToDateTime_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                else:
                    aggregated_isochrones_todatetime_value = self.dlg.AggregatedIsochrones_ToDateTime.dateTime().toString("yyyy-MM-dd HH:mm:ss") # Receiving Value from GUI: QDateTime
                aggregated_isochrones_todatetime_value = datetime.strptime(aggregated_isochrones_todatetime_value, '%Y-%m-%d %H:%M:%S')
                
                #RequestInterval             
                if self.dlg.AggregatedIsochrones_RequestInterval_Override.isActive() == True: # Check if override button shall be used
                    aggregated_isochrones_requestinterval_value, irrelevantsuccessstorage = self.dlg.AggregatedIsochrones_RequestInterval_Override.toProperty().value(ctx) #Receiving Value from Layer or GUI: DataDefinedOverride (Reference: https://gis.stackexchange.com/a/350279/107424 and https://gis.stackexchange.com/a/350993/107424)
                else:
                    aggregated_isochrones_requestinterval_value = self.dlg.AggregatedIsochrones_RequestInterval.value() # Receiving Value from GUI: QSpinBox
                
                
                #Cancel execution if....:
                if (not aggregated_isochrones_requestinterval_value or aggregated_isochrones_requestinterval_value < 1 or aggregated_isochrones_todatetime_value < aggregated_isochrones_fromdatetime_value):
                    self.aggregated_isochrones_state = 4
                    QgsMessageLog.logMessage("Warning! There is something wrong with your DateTime-Settings, check them and try again.",MESSAGE_CATEGORY,Qgis.Warning)
                    break
                
                # Iterating over the datetimes
                intervalseconds = (aggregated_isochrones_todatetime_value - aggregated_isochrones_fromdatetime_value).seconds
                required_iterations = math.ceil(intervalseconds / aggregated_isochrones_requestinterval_value) 
                intervaliteration = 0
                isochrones_times = []
                isochrones_dates = []
                tmp_aggregated_isochrones_vl = QgsVectorLayer("MultiPolygon?crs=epsg:4326", "TmpAggregatedIsochrones", "memory")
                tmp_aggregated_isochrones_pr = tmp_aggregated_isochrones_vl.dataProvider()
                with edit(tmp_aggregated_isochrones_vl):
                    tmp_aggregated_isochrones_pr.addAttributes([QgsField("time",QVariant.Int)])
                    if self.dlg.AggregatedIsochrones_NoAggRaw_Use.isChecked():
                        tmp_aggregated_isochrones_pr.addAttributes([QgsField("reqdt",QVariant.String)])
                    tmp_aggregated_isochrones_vl.updateFields()
                
                    for currentsecond in range(0,intervalseconds,aggregated_isochrones_requestinterval_value):
                        intervaliteration += 1
                        if self.stopaggregated_isochronesworker == True: # if cancel button has been clicked this var has been set to True to break the loop so the thread can be quit
                            self.aggregated_isochrones_state = 2
                            break
                    
                        aggregated_isochrones_currentdatetime_value = (aggregated_isochrones_fromdatetime_value + timedelta(seconds = currentsecond))
                        aggregated_isochrones_currentdatetime_string = aggregated_isochrones_currentdatetime_value.strftime("%Y-%m-%d %H:%M:%S")
                        aggregated_isochrones_currentdate_string = aggregated_isochrones_currentdatetime_value.strftime("%Y-%m-%d")
                        aggregated_isochrones_currenttime_string = aggregated_isochrones_currentdatetime_value.strftime("%H:%M:%S")
                        aggregated_isochrones_currentdate_urlstring = '&date=' + str(aggregated_isochrones_currentdate_string)
                        aggregated_isochrones_currenttime_urlstring = '&time=' + str(aggregated_isochrones_currenttime_string)
                        isochrones_dates.append(aggregated_isochrones_currentdate_string)
                        isochrones_times.append(aggregated_isochrones_currenttime_string)
                        
                        statusinformation = ('Processing Feature ID: ' + str(inputlayer_feature.id()) + ' (#' + str(inputlayer_iteration+1) + ' of ' + str(progressbar_featurecount) + ' total features)\n'
                                            + 'Processing iteration '  + str(intervaliteration) + ' of ' + str(required_iterations) + ' total iterations. Requesting Isochrone for DateTime: ' + str(aggregated_isochrones_currentdatetime_string))
                        self.aggregated_isochrones_progress.emit(int(progressbar_percent),str(statusinformation))
                        
                        #Working example: https://api.digitransit.fi/routing/v1/routers/hsl/isochrone?fromPlace=60.169,24.938&mode=WALK,TRANSIT&date=2019-11-01&time=08:00:00&maxWalkDistance=500&cutoffSec=1800&cutoffSec=3600
                        #Concat URL and convert to string
                        inputfeature_base_url_without_datetime = (str(serverurl) + "isochrone?algorithm=accSampling" + # base url without datetime to store in attribute table
                                        "&fromPlace=" + str(y) + "," + str(x) + # c
                                        aggregated_isochrones_transportationmode_urlstring + #
                                        aggregated_isochrones_walkspeed_urlstring + #
                                        aggregated_isochrones_bikespeed_urlstring + #
                                        aggregated_isochrones_waitatbeginning_urlstring + #
                                        aggregated_isochrones_clampinitialwait_urlstring + #
                                        aggregated_isochrones_arriveby_urlstring + #
                                        aggregated_isochrones_wheelchair_urlstring + #
                                        aggregated_isochrones_waitreluctance_urlstring + #
                                        aggregated_isochrones_maxtransfers_urlstring + #
                                        aggregated_isochrones_maxwalkdistance_urlstring + #
                                        aggregated_isochrones_maxoffroaddistance_urlstring + #
                                        aggregated_isochrones_precisionmeters_urlstring + #
                                        aggregated_isochrones_additionalparameters_urlstring + #
                                        "&cutoffSec=" + str(aggregated_isochrones_interval_urlstring) #
                                        )
                        isochrone_url = (str(serverurl) + "isochrone?algorithm=accSampling" + # Add Isochrones request and algorithm to server url
                                        "&fromPlace=" + str(y) + "," + str(x) + # concatenate x and y coordinates as string
                                        aggregated_isochrones_transportationmode_urlstring + #
                                        aggregated_isochrones_walkspeed_urlstring + #
                                        aggregated_isochrones_bikespeed_urlstring + #
                                        aggregated_isochrones_waitatbeginning_urlstring + #
                                        aggregated_isochrones_clampinitialwait_urlstring + #
                                        aggregated_isochrones_currentdate_urlstring + #
                                        aggregated_isochrones_currenttime_urlstring + #
                                        aggregated_isochrones_arriveby_urlstring + #
                                        aggregated_isochrones_wheelchair_urlstring + #
                                        aggregated_isochrones_waitreluctance_urlstring + #
                                        aggregated_isochrones_maxtransfers_urlstring + #
                                        aggregated_isochrones_maxwalkdistance_urlstring + #
                                        aggregated_isochrones_maxoffroaddistance_urlstring + #
                                        aggregated_isochrones_precisionmeters_urlstring + #
                                        aggregated_isochrones_additionalparameters_urlstring + # Additional Parameters entered as OTP-Readable string -> User responsibility
                                        "&cutoffSec=" + str(aggregated_isochrones_interval_urlstring) # Interval-Integers are taken as comma separated string, then split into list and then joined to string with leading "&cutoffSec=". The first interval therefore has no leading "&cutoffSec=" thats why we add it here
                                        )
                        QgsMessageLog.logMessage('Intervaliteration: ' + str(intervaliteration) + " of " + str(required_iterations) + ' total iterations. Requesting Isochrone for DateTime: ' + str(aggregated_isochrones_currentdatetime_string) + '\nwith URL: ' + str(isochrone_url),MESSAGE_CATEGORY,Qgis.Info)
                        debug_info = "Feature ID: " + str(inputlayer_feature.id()) + ' at iteration: ' + str(intervaliteration) + ' with URL: ' + str(isochrone_url) + '\n'
                        
                        #request and download file
                        isochrone_responseLayer = None
                        try:
                            isochrone_headers = {"accept":"application/x-zip-compressed"}
                            isochrone_request = urllib.request.Request(isochrone_url, headers=isochrone_headers)
                            isochrone_response = urllib.request.urlopen(isochrone_request, timeout=self.gf.timeout_setting)
                            # Sending request to server. Using shapefiles to avoid invalid geometries on high level of detail + geojson throwback seems to be limited to 4 decimals.
                        #save file
                            try:
                                with open(tmp_save_location + 'isochrones.zip', 'wb') as f: # Write shapefile to temp location
                                    f.write(isochrone_response.read())
                                    #f.write(r.content) # write zip content
                        #unzip file
                                try:
                                    with zipfile.ZipFile(tmp_save_location + 'isochrones.zip', 'r') as zip_ref:
                                        zip_ref.extractall(tmp_save_location) 
                        #load file
                                    try:
                                        isochrone_responseLayer = QgsVectorLayer(tmp_save_location + "null.shp", "null", "ogr") # load just downloaded file as vector layer
                                        isochrone_responseLayer.updateExtents()
                                    except Exception as e:
                                        isochrone_error = f'Error: loading response failed (Exception {str(e)})'
                                        isochrone_errors.append(isochrone_error)
                                except Exception as e:
                                    isochrone_error = f'Error: response file not valid (Exception {str(e)})'
                                    isochrone_errors.append(isochrone_error)
                            except Exception as e:
                                isochrone_error = f'Error: writing response to harddrive failed (Exception {str(e)})'
                                isochrone_errors.append(isochrone_error)
                        except Exception as e:
                            isochrone_error = f'Error: request failed (Exception {str(e)})' 
                            isochrone_errors.append(isochrone_error)

                        # Check Validity of Responselayer
                        try:
                            if not isochrone_responseLayer:
                                isochrone_error = 'Error: response layer does not exist'
                                isochrone_errors.append(isochrone_error)
                            elif (not isochrone_responseLayer.isValid()) or (isochrone_responseLayer.extent().yMaximum() == 0.0) or (isochrone_responseLayer.extent().xMaximum() == 0.0) or (isochrone_responseLayer.extent().yMinimum() == 0.0) or (isochrone_responseLayer.extent().xMinimum() == 0.0):
                                isochrone_error = 'Error: response layer is not valid'
                                isochrone_errors.append(isochrone_error)
                        except Exception as e:
                            isochrone_error = f'Error: response layer is not valid (Exception {str(e)})'
                            isochrone_errors.append(isochrone_error)
                        
                        # Cancel this isochrone on errors
                        if isochrone_errors:
                            continue
                        
                        statusinformation = ('Processing Feature ID: ' + str(inputlayer_feature.id()) + ' (#' + str(inputlayer_iteration+1) + ' of ' + str(progressbar_featurecount) + ' total features)\n'
                                            + 'Processing iteration '  + str(intervaliteration) + ' of ' + str(required_iterations) + ' total iterations. Postprocessing response isochrone.')
                        self.aggregated_isochrones_progress.emit(int(progressbar_percent),str(statusinformation))
                        
                        if self.dlg.AggregatedIsochrones_NoAggRaw_Use.isChecked():
                            isochrone_responseLayer.dataProvider().addAttributes([QgsField("reqdt",QVariant.String)])
                            isochrone_responseLayer.updateFields()
                            with edit(isochrone_responseLayer):
                                for feat in isochrone_responseLayer.getFeatures():
                                    feat['reqdt'] = str(aggregated_isochrones_currentdate_string + ' ' + aggregated_isochrones_currenttime_string)
                                    isochrone_responseLayer.updateFeature(feat)
                        
                        # Process the response
                        if self.dlg.AggregatedIsochrones_AllUnion_Use.isChecked():
                            isochrone_responseLayer = self.union_processing_per_datetime_response(isochrone_responseLayer)
                            
                        #iterate trough response
                        try:
                            for isochrone_feature in isochrone_responseLayer.getFeatures():
                                tmp_aggregated_isochrones_pr.addFeature(isochrone_feature) # copy features of responselayer including geometry and attributes
                            tmp_aggregated_isochrones_vl.updateFields()
                            tmp_aggregated_isochrones_vl.updateExtents()
                        except:
                            isochrone_error = f'Error: could not copy response to temporary result'
                            isochrone_errors.append(isochrone_error)
                        
                                                
                    # END OF TIME ITERATION    
                
                    statusinformation = ('Processing Feature ID: ' + str(inputlayer_feature.id()) + ' (#' + str(inputlayer_iteration+1) + ' of ' + str(progressbar_featurecount) + ' total features)\n'
                                            + 'Postprocessing received isochrones for all requested datetimes.')
                    self.aggregated_isochrones_progress.emit(int(progressbar_percent),str(statusinformation)) 
                    
                    
                    if self.dlg.AggregatedIsochrones_MaxDissolve_Use.isChecked(): # Dissolve
                        # returns fields: time 
                        # returns n features: n intervals
                        #try:
                        tmp_aggregated_isochrones_vl = self.dissolve_processing_per_inputfeature(tmp_aggregated_isochrones_vl)
                        #except Exception as e:
                        #    isochrone_error = f'Postprocessing failed (Exception {e})'
                        #    isochrone_errors.append(isochrone_error)
                    elif self.dlg.AggregatedIsochrones_AllUnion_Use.isChecked(): # Union
                        # returns fields: time, time_count, time_unique, time_min, time_max, time_range, time_sum, time_mean, time_median, time_stddev, time_minority, time_majority, time_q1, time_q3, time_iqr
                        # returns n features: n 
                        #try:
                        tmp_aggregated_isochrones_vl = self.union_processing_per_inputfeature(tmp_aggregated_isochrones_vl)
                        #except Exception as e:
                        #    isochrone_error = f'Postprocessing failed (Exception {e})'
                        #    isochrone_errors.append(isochrone_error)
                    elif self.dlg.AggregatedIsochrones_NoAggRaw_Use.isChecked(): # Raw
                        # returns fields: time, reqdt
                        # returns n features: n intervals * n iterations
                        pass
                    else:
                        # returns fields: time
                        # returns n features: n intervals * n iterations
                        pass
                    
                    
                # END OF EDIT tmp_aggregated_isochrones_vl LAYER
                
                
                # Check Validity
                fatal_isochrone_error = False
                try:
                    if not tmp_aggregated_isochrones_vl:
                        isochrone_error = 'Error: aggregated layer does not exist'
                        isochrone_errors.append(isochrone_error)
                        fatal_isochrone_error = True
                    if (not tmp_aggregated_isochrones_vl.isValid()) or (tmp_aggregated_isochrones_vl.extent().yMaximum() == 0.0) or (tmp_aggregated_isochrones_vl.extent().xMaximum() == 0.0) or (tmp_aggregated_isochrones_vl.extent().yMinimum() == 0.0) or (tmp_aggregated_isochrones_vl.extent().xMinimum() == 0.0):
                        isochrone_error = 'Error: aggregated layer is not valid'
                        isochrone_errors.append(isochrone_error)
                        fatal_isochrone_error = True
                    if tmp_aggregated_isochrones_vl.featureCount() == 0:
                        isochrone_error = 'Error: aggregated layer is empty'
                        isochrone_errors.append(isochrone_error)
                        fatal_isochrone_error = True
                except Exception as e:
                    isochrone_error = f'Error: aggregated layer is not valid (Exception {str(e)})'
                    isochrone_errors.append(isochrone_error)
                    fatal_isochrone_error = True
                    
                # Postprocess Fieldnames:
                with edit(tmp_aggregated_isochrones_vl):
                    for field in tmp_aggregated_isochrones_vl.fields():
                        idx = tmp_aggregated_isochrones_vl.fields().indexFromName(field.name())
                        tmp_aggregated_isochrones_vl.renameAttribute(idx, 'AggIsochrone_' + str(field.name()))
                    tmp_aggregated_isochrones_vl.updateFields()
                    tmp_aggregated_isochrones_vl.updateExtents()  
                    
                # Create a dummy feature on error
                if isochrone_errors:
                    if fatal_isochrone_error == True:
                        isochrone_error = ('Error: Could not receive a single valid response for Feature ID ' + str(inputlayer_feature.id()))
                        isochrone_errors.append(isochrone_error)
                        tmp_aggregated_isochrones_vl = QgsVectorLayer("MultiPolygon?crs=epsg:4326", "TmpAggregatedIsochrones", "memory")
                        tmp_aggregated_isochrones_pr = tmp_aggregated_isochrones_vl.dataProvider()
                        with edit(tmp_aggregated_isochrones_vl):
                            error_feature = QgsFeature()
                            error_feature.setGeometry(QgsGeometry.fromWkt("Polygon ((-0.1 -0.1, -0.1 0.1, 0.1 0.1, 0.1 -0.1, -0.1 -0.1))"))
                            tmp_aggregated_isochrones_pr.addAttributes(new_generic_mode_fields)
                            tmp_aggregated_isochrones_pr.addFeature(error_feature)
                        tmp_aggregated_isochrones_vl.updateExtents()
                    isochrone_unique_errors = set(isochrone_errors)
                    isochrone_unique_errors = list(isochrone_unique_errors)
                    unique_errors.extend(isochrone_unique_errors)
                    QgsMessageLog.logMessage('Isochrone Errors: ' + str("; ".join(isochrone_unique_errors)),MESSAGE_CATEGORY,Qgis.Warning)
                    
                #self.aggregated_isochrones_finished.emit(tmp_aggregated_isochrones_vl, 99, str('bla'), str('blubb'))
                    
                # Append Fields on first iteration depending on the chosen mode to output
                if inputlayer_iteration == 0:
                   for field in tmp_aggregated_isochrones_vl.fields():
                        aggregated_isochrones_memorylayer_pr.addAttributes([QgsField(str(field.name()), field.type())])
                   aggregated_isochrones_memorylayer_vl.updateFields()
                    
                #iterate trough isochrones
                aggregated_isochrone_id_counter = aggregated_isochrone_id_counter + 1
                unique_isochrones_dates = set(isochrones_dates)
                unique_isochrones_dates = list(unique_isochrones_dates)
                unique_isochrones_dates.sort()
                unique_isochrones_times = set(isochrones_times)
                unique_isochrones_times = list(unique_isochrones_times)
                unique_isochrones_times.sort()
                
                for aggregated_isochrone_feature in tmp_aggregated_isochrones_vl.getFeatures():
                    aggregated_isochrone_uid_counter = aggregated_isochrone_uid_counter + 1
                    new_fields = QgsFields()
                    for field in self.gf.aggregated_isochrones_selectedlayer.fields(): # if prefix should be used add it here as well
                        new_fields.append(field)
                    for field in new_generic_fields:
                        new_fields.append(field)
                    for field in new_generic_mode_fields:
                        new_fields.append(field)
                    new_feat = QgsFeature(new_fields)
                    new_attrs = {}
                    for i in range(0, inputlayer_numberoffields):              
                        new_attrs[i] = inputlayer_feature[i]
                    new_attrs[inputlayer_numberoffields + 0] = aggregated_isochrone_uid_counter # inputlayer_numberoffields comes from fields().count() which is not zero based but our dictionary is, thats why +0
                    new_attrs[inputlayer_numberoffields + 1] = aggregated_isochrone_id_counter
                    new_attrs[inputlayer_numberoffields + 2] = str("; ".join(isochrone_unique_errors)) if isochrone_errors else None
                    new_attrs[inputlayer_numberoffields + 3] = inputfeature_base_url_without_datetime
                    new_attrs[inputlayer_numberoffields + 4] = str(aggregated_isochrones_fromdatetime_value)
                    new_attrs[inputlayer_numberoffields + 5] = str(aggregated_isochrones_todatetime_value)
                    new_attrs[inputlayer_numberoffields + 6] = aggregated_isochrones_requestinterval_value
                    new_attrs[inputlayer_numberoffields + 7] = str(";".join(unique_isochrones_dates))
                    new_attrs[inputlayer_numberoffields + 8] = str(";".join(unique_isochrones_times))
                    new_attrs[inputlayer_numberoffields + 9] = int(required_iterations)
                    for i in range(0, tmp_aggregated_isochrones_vl.fields().count()):
                        new_attrs[inputlayer_numberoffields + 10 + i] = aggregated_isochrone_feature[i]
                    for idx, attr in new_attrs.items():
                        new_feat.setAttribute(idx, attr)
                    new_feat.setGeometry(aggregated_isochrone_feature.geometry())
                    aggregated_isochrones_memorylayer_vl.addFeature(new_feat)
                    aggregated_isochrones_memorylayer_vl.updateFeature(new_feat)

                aggregated_isochrones_memorylayer_vl.updateFields()
                aggregated_isochrones_memorylayer_vl.updateExtents()
                
                # Update Progressbar
                progressbar_percent = progressbar_counter / float(progressbar_featurecount) * 100
                statusinformation = ('Feature ID: ' + str(inputlayer_feature.id()) + ' done with ' + str(len(isochrone_unique_errors)) if isochrone_errors else str(0) + ' errors')
                self.aggregated_isochrones_progress.emit(int(progressbar_percent),str(statusinformation))
                
                QgsMessageLog.logMessage("",MESSAGE_CATEGORY,Qgis.Info)
                QgsMessageLog.logMessage("-----",MESSAGE_CATEGORY,Qgis.Info)
                QgsMessageLog.logMessage("",MESSAGE_CATEGORY,Qgis.Info)
                
            #END OF INPUTLAYER FEATURE LOOP
            
            # Isochrones Memory VectorLayer
            aggregated_isochrones_memorylayer_vl.updateFields()
            aggregated_isochrones_memorylayer_vl.updateExtents()
            
        # END OF EDIT aggregated_isochrones_memorylayer_vl LAYER

        unique_errors = set(unique_errors)
        unique_errors = list(unique_errors)
        unique_errors_string = '; '.join(unique_errors)
        aggregated_isochrones_endtime = datetime.now()
        aggregated_isochrones_runtime = aggregated_isochrones_endtime - aggregated_isochrones_starttime
        if self.stopaggregated_isochronesworker == True:
            QgsMessageLog.logMessage("##### Aggregated-Isochrones job canceled by user after " + str(aggregated_isochrones_runtime) + " @ " + str(datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f")) + " #####",MESSAGE_CATEGORY,Qgis.Info)
            statusinformation = ('Aggregated Isochrones Job Canceled after ' + str(aggregated_isochrones_runtime) + ' with ' + str(len(unique_errors)) + ' errors' + '\nErrors occured: ' + '; '.join(unique_errors))
        else:
            QgsMessageLog.logMessage("##### Aggregated-Isochrones job done in " + str(aggregated_isochrones_runtime) + " @ " + str(datetime.now().strftime("%Y-%m-%d %H:%M:%S.%f")) + " #####",MESSAGE_CATEGORY,Qgis.Info)
            statusinformation = ('Aggregated Isochrones Job Done after ' + str(aggregated_isochrones_runtime) + ' with ' + str(len(unique_errors)) + ' errors' + '\nErrors occured: ' + '; '.join(unique_errors))
        
        QgsMessageLog.logMessage("",MESSAGE_CATEGORY,Qgis.Info)
        
        self.aggregated_isochrones_progress.emit(int(progressbar_percent),str(statusinformation))
        self.aggregated_isochrones_finished.emit(aggregated_isochrones_memorylayer_vl, self.aggregated_isochrones_state, str(unique_errors_string), str(aggregated_isochrones_runtime))
        
    def dissolve_processing_per_inputfeature(self, vectorlayer):
        # dissolve
        dissolve_params = {'FIELD':['time'], 
                           'INPUT': vectorlayer, 
                           'OUTPUT':'TEMPORARY_OUTPUT'
                          }
        vectorlayer = processing.run("native:dissolve", dissolve_params)
        vectorlayer = vectorlayer['OUTPUT']
        
        return vectorlayer

    def union_processing_per_inputfeature(self, vectorlayer):
        # multipart to singlepart
        multiparttosinglepart_params = {'INPUT' : vectorlayer, 
                                        'OUTPUT' : 'TEMPORARY_OUTPUT'
                                       }
        vectorlayer = processing.run('native:multiparttosingleparts',multiparttosinglepart_params)
        vectorlayer = vectorlayer['OUTPUT']

        # v.clean
        vclean_params = {'-b' : False, 
                         '-c' : False, 
                         'GRASS_MIN_AREA_PARAMETER' : 0.0001, 
                         'GRASS_OUTPUT_TYPE_PARAMETER' : 0, 
                         'GRASS_REGION_PARAMETER' : None, 
                         'GRASS_SNAP_TOLERANCE_PARAMETER' : -1, 
                         'GRASS_VECTOR_DSCO' : '', 
                         'GRASS_VECTOR_EXPORT_NOCAT' : False, 
                         'GRASS_VECTOR_LCO' : '', 
                         'error' : 'TEMPORARY_OUTPUT', 
                         'input' : vectorlayer, 
                         'output' : 'TEMPORARY_OUTPUT', 
                         'threshold' : '', 
                         'tool' : [0], 
                         'type' : [0,1,2,3,4,5,6] 
                        }
        vectorlayer = processing.run('grass7:v.clean',vclean_params)
        vectorlayer = vectorlayer['output']
        
        # fix geometries
        fixgeometries_params = {'INPUT' : vectorlayer, 
                                 'OUTPUT' : 'TEMPORARY_OUTPUT' 
                                }
        vectorlayer = processing.run('native:fixgeometries',fixgeometries_params)
        vectorlayer = vectorlayer['OUTPUT']

        # union
        union_params = {'INPUT' : vectorlayer, 
                        'OUTPUT' : 'TEMPORARY_OUTPUT', 
                        'OVERLAY' : None, 
                        'OVERLAY_FIELDS_PREFIX' : ''
                       }
        vectorlayer_union = processing.run('native:union',union_params)
        vectorlayer_union = vectorlayer_union['OUTPUT']

        # delete duplicate geometries
        deleteduplicategometries_params = {'INPUT' : vectorlayer_union, 
                                           'OUTPUT' : 'TEMPORARY_OUTPUT' 
                                          }
        try:
            vectorlayer_dupldelete = processing.run('native:deleteduplicategeometries',deleteduplicategometries_params)
        except:
            vectorlayer_dupldelete = processing.run('qgis:deleteduplicategeometries',deleteduplicategometries_params)
        vectorlayer_dupldelete = vectorlayer_dupldelete['OUTPUT']

        # join by location summary
        joinbylocationsummary_params = {'DISCARD_NONMATCHING' : False, 
                                        'INPUT' : vectorlayer_dupldelete, 
                                        'JOIN' : vectorlayer_union, 
                                        'JOIN_FIELDS' : ['time'],
                                        'OUTPUT' : 'TEMPORARY_OUTPUT', 
                                        'PREDICATE' : [2],
                                        'SUMMARIES' : []
                                       }
        vectorlayer = processing.run('qgis:joinbylocationsummary',joinbylocationsummary_params)
        vectorlayer = vectorlayer['OUTPUT']
        
        # delete all fields except time*
        fieldstodelete = []
        for i, field in enumerate(vectorlayer.fields()):
            if 'time_' not in field.name():
                fieldstodelete.append(i)
        vectorlayer.dataProvider().deleteAttributes(fieldstodelete)
        vectorlayer.updateFields()
        
        return vectorlayer
        
    def union_processing_per_datetime_response(self, vectorlayer):
        #QgsMessageLog.logMessage('featurecount start processing: ' + str(vectorlayer.featureCount()),MESSAGE_CATEGORY,Qgis.Info)
        # v.clean <- should work without it for each response
        """
        vclean_params = {'-b' : False, 
                         '-c' : False, 
                         'GRASS_MIN_AREA_PARAMETER' : 0.0001, 
                         'GRASS_OUTPUT_TYPE_PARAMETER' : 0,
                         'GRASS_REGION_PARAMETER' : None, 
                         'GRASS_SNAP_TOLERANCE_PARAMETER' : -1, 
                         'GRASS_VECTOR_DSCO' : '', 
                         'GRASS_VECTOR_EXPORT_NOCAT' : False, 
                         'GRASS_VECTOR_LCO' : '', 
                         'error' : 'TEMPORARY_OUTPUT', 
                         'input' : vectorlayer, 
                         'output' : 'TEMPORARY_OUTPUT', 
                         'threshold' : '', 
                         'tool' : [0], 
                         'type' : [0,1,2,3,4,5,6] 
                        }
        vectorlayer = processing.run('grass7:v.clean',vclean_params)
        vectorlayer = vectorlayer['output']
        """
        # fix geometries
        fixgeometries_params = {'INPUT' : vectorlayer, 
                                'OUTPUT' : 'TEMPORARY_OUTPUT' 
                               }
        vectorlayer = processing.run('native:fixgeometries',fixgeometries_params)
        vectorlayer = vectorlayer['OUTPUT']
        
        # union
        union_params = {'INPUT' : vectorlayer, 
                        'OUTPUT' : 'TEMPORARY_OUTPUT', 
                        'OVERLAY' : None, 
                        'OVERLAY_FIELDS_PREFIX' : '' 
                       }
        vectorlayer = processing.run('native:union',union_params)
        vectorlayer = vectorlayer['OUTPUT']
        
        # join by location summary
        joinsummary_params = {'DISCARD_NONMATCHING' : False, 
                              'INPUT' : vectorlayer, 
                              'JOIN' : vectorlayer, 
                              'JOIN_FIELDS' : ['time'], 
                              'OUTPUT' : 'TEMPORARY_OUTPUT', 
                              'PREDICATE' : [2], 
                              'SUMMARIES' : [2] 
                             }
        vectorlayer = processing.run('qgis:joinbylocationsummary',joinsummary_params)
        vectorlayer = vectorlayer['OUTPUT']
        
        # delete duplicate geometries
        deleteduplicategometries_params = {'INPUT' : vectorlayer, 
                                           'OUTPUT' : 'TEMPORARY_OUTPUT' 
                                          }
        try:
            vectorlayer_dupldelete = processing.run('native:deleteduplicategeometries',deleteduplicategometries_params)
        except:
            vectorlayer_dupldelete = processing.run('qgis:deleteduplicategeometries',deleteduplicategometries_params)
        vectorlayer = vectorlayer_dupldelete['OUTPUT']
        
        #QgsMessageLog.logMessage('featurecount end processing: ' + str(vectorlayer.featureCount()),MESSAGE_CATEGORY,Qgis.Info)
        
        # copy time_min to time and delete all fields except time
        with edit(vectorlayer):
            for timefeat in vectorlayer.getFeatures():
                try:
                    timefeat['time'] = int(timefeat['time_min'])
                except:
                    timefeat['time'] =  0
                vectorlayer.updateFeature(timefeat)
        fieldstodelete = []
        for i, field in enumerate(vectorlayer.fields()):
            if not field.name() == 'time':
                fieldstodelete.append(i)
        vectorlayer.dataProvider().deleteAttributes(fieldstodelete)
        vectorlayer.updateFields()
        
        return vectorlayer
