# -*- coding: utf-8 -*-

"""
/***************************************************************************
 OpenTopographyDEMDownloader
                                 A QGIS plugin
 This plugin downloads DEM from OpenTopography.org
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-27
        copyright            : (C) 2022 by Kyaw Naing Win
        email                : kyawnaingwinknw@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Kyaw Naing Win'
__date__ = '2022-01-27'
__copyright__ = '(C) 2022 by Kyaw Naing Win'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect
import processing

from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .OpenTopography_DEMDownloader_provider import OpenTopographyDEMDownloaderProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class OpenTopographyDEMDownloaderPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = OpenTopographyDEMDownloaderProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()
        
        icon = os.path.join(os.path.join(cmd_folder, 'icon.png'))
        self.action = QAction(
              QIcon(icon),
              u"OpenTopography DEM Downloader", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addPluginToRasterMenu(u"&OpenTopography DEM", self.action)
        self.iface.addToolBarIcon(self.action)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        self.iface.removePluginRasterMenu(u"&OpenTopography DEM", self.action)
        self.iface.removeToolBarIcon(self.action)
        
    def run(self):        
        processing.execAlgorithmDialog("OTDEMDownloader:OpenTopography DEM Downloader")
