# -*- coding: utf-8 -*-

'''
/***************************************************************************
 Offline-MapMatching
                                 A QGIS plugin
 desciption of the plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-08-08
        copyright            : (C) 2018 by Christoph Jung
        email                : jagodki.cj@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
'''

__author__ = 'Christoph Jung'
__date__ = '2018-08-08'
__copyright__ = '(C) 2018 by Christoph Jung'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'
from PyQt5.QtCore import QCoreApplication, QUrl
from PyQt5.QtGui import QIcon
from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterField,
                       QgsProcessingParameterString,
                       QgsProcessingParameterNumber,
                       QgsCoordinateReferenceSystem,
                       QgsProject,
                       QgsProcessingParameterFeatureSink,
                       QgsWkbTypes)
import processing
import time, os.path


class ClipNetworkAlgorithm(QgsProcessingAlgorithm):
    '''
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    '''

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    NETWORK = 'NETWORK'
    TRAJECTORY = 'TRAJECTORY'
    ORDER_FIELD = 'ORDER_FIELD'
    BUFFER_RADIUS = 'BUFFER_RADIUS'
    OUTPUT = 'OUTPUT'

    def initAlgorithm(self, config):
        '''
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        '''
        
        self.addParameter(
            QgsProcessingParameterVectorLayer(
                self.NETWORK,
                self.tr('Network layer'),
                [QgsProcessing.TypeVectorLine]
            )
        )
        
        self.addParameter(
            QgsProcessingParameterVectorLayer(
                self.TRAJECTORY,
                self.tr('Trajectory layer'),
                [QgsProcessing.TypeVectorPoint]
            )
        )
        
        self.addParameter(
            QgsProcessingParameterField(
                self.ORDER_FIELD,
                self.tr('Order Trajectory by'),
                parentLayerParameterName=self.TRAJECTORY,
                type=QgsProcessingParameterField.Any
            )
        )
        
        self.addParameter(
            QgsProcessingParameterNumber(
                self.BUFFER_RADIUS,
                self.tr('Buffer radius around the Trajectory'),
                type=QgsProcessingParameterNumber.Double,
                defaultValue=0,
                minValue=0.0
            )
        )
        
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Clipped Network')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        '''
        Here is where the processing itself takes place.
        '''
        start_time = time.time()
        
        #extract all parameters
        network_layer = self.parameterAsVectorLayer(
            parameters,
            self.NETWORK,
            context
        )
        
        trajectory_layer = self.parameterAsVectorLayer(
            parameters,
            self.TRAJECTORY,
            context
        )
        
        trajectory_order_field = self.parameterAsString(
            parameters,
            self.ORDER_FIELD,
            context
        )
        
        buffer = self.parameterAsDouble(
            parameters,
            self.BUFFER_RADIUS,
            context
        )
        
        (sink, dest_id) = self.parameterAsSink(
            parameters,
            self.OUTPUT,
            context,
            network_layer.fields(),
            QgsWkbTypes.LineString,
            network_layer.crs()
        )
        
        #init the progressbar
        max_count = 4
        counter = 0
        feedback.setProgress(int((counter / max_count) * max_count))
        
        #trajectory to path
        points_to_path = processing.run("qgis:pointstopath", {
            'INPUT':trajectory_layer,
            'ORDER_FIELD':trajectory_order_field,
            'GROUP_FIELD':None,
            'DATE_FORMAT':'',
            'OUTPUT':'memory:path'
        })
        counter += 1
        feedback.setProgress(int((counter / max_count) * max_count))
        if feedback.isCanceled():
            return {'canceled °o°': str(round(time.time() - start_time, 2))}
        
        #buffer path
        buffer = processing.run("native:buffer", {
            'INPUT':points_to_path['OUTPUT'],
            'DISTANCE':buffer,
            'SEGMENTS':5,
            'END_CAP_STYLE':0,
            'JOIN_STYLE':0,
            'MITER_LIMIT':2,
            'DISSOLVE':False,
            'OUTPUT':'memory:buffer'})
        counter += 1
        feedback.setProgress(int((counter / max_count) * max_count))
        feedback.pushInfo('created buffer successfully')
        if feedback.isCanceled():
            return {'canceled °o°': str(round(time.time() - start_time, 2))}
        
        #clip network
        clipped_network = processing.run("native:clip", {
            'INPUT':network_layer,
            'OVERLAY':buffer['OUTPUT'],
            'OUTPUT':'memory:clip'})
        counter += 1
        feedback.setProgress(int((counter / max_count) * max_count))
        feedback.pushInfo('clipped buffer successfully')
        if feedback.isCanceled():
            return {'canceled °o°': str(round(time.time() - start_time, 2))}
        
        #multipart to single part
        single_part_network = processing.run("native:multiparttosingleparts", {
            'INPUT':clipped_network['OUTPUT'],
            'OUTPUT':'memory:omm_clipped_network'})
        counter += 1
        feedback.setProgress(int((counter / max_count) * max_count))
        feedback.pushInfo('created single parts successfully')
        if feedback.isCanceled():
            return {'canceled °o°': str(round(time.time() - start_time, 2))}
        
        #add the result to the QGIS project
        sink.addFeatures(single_part_network['OUTPUT'].getFeatures())
        
        return {'OUTPUT': dest_id}

    def name(self):
        '''
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        '''
        return 'clip_network'
    
    def helpUrl(self):
        '''
        Returns the URL for the help document, if a help document does exist.
        '''
        dir = os.path.dirname(__file__)
        file = os.path.abspath(os.path.join(dir, '..', 'help_docs', 'help.html'))
        if not os.path.exists(file):
            return ''
        return QUrl.fromLocalFile(file).toString(QUrl.FullyEncoded)

    def shortHelpString(self):
        '''Returns the text for the help widget, if a help document does exist.'''
        dir = os.path.dirname(__file__)
        file = os.path.abspath(os.path.join(dir, '..', 'help_docs', 'help_processing_clipping_network.html'))
        if not os.path.exists(file):
            return ''
        with open(file) as helpf:
            help=helpf.read()
        return help
    
    def displayName(self):
        '''
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        '''
        return self.tr('Clip Network')

    def group(self):
        '''
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        '''
        return self.tr(self.groupId())
    
    def groupId(self):
        '''
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        '''
        return 'Preprocessing'
    
    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return ClipNetworkAlgorithm()

    def icon(self):
        return QIcon(':/plugins/offline_map_matching/icons/clipping_icon.png')
