# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Ntrip
                                 A QGIS plugin
 Carrega casters
                              -------------------
        begin                : 2014-09-19
        git sha              : $Format:%H$
        copyright            : (C) 2014 by Felipe Ferrari
        email                : ferrari@dsg.eb.mil.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import httplib, exceptions, string
from PyQt4.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt4.QtGui import QAction, QIcon, QMessageBox
from qgis.core import QgsVectorLayer, QgsMapLayerRegistry, QgsFeature, QgsGeometry, QgsPoint
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from NTRIP_dialog import NtripDialog
import os.path


class Ntrip:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Ntrip_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = NtripDialog()

 
    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(
            QIcon(":/plugins/Ntrip/icon.png"),
            u"NTRIP MountPoints", self.iface.mainWindow())
        # connect the action to the run method
        self.action.triggered.connect(self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu(u"NTRIP", self.action)        

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"NTRIP", self.action)
        self.iface.removeToolBarIcon(self.action)

    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result==1:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            end = self.dlg.enderecoLine.text()
            end = string.lower(end)
            if end.startswith('http://'):
                end = end[7:]
            if end.startswith('www.'):
                end = end[4:]
            if end.endswith('/'):
                end = end[:-1]
            print end
            end = end + ":"
            porta = self.dlg.portaLine.text()
            if len(porta) == 0:
                porta='2101'
            end = end + porta
            conn = httplib.HTTPConnection(end)
            try:
                conn.request("GET", "")
                r1 = conn.getresponse()
                linhas = r1.read().splitlines()
                vlayer = QgsVectorLayer("Point?crs=epsg:4326&field=id:integer&field=name:string(20)&index=yes", "MountPoints",  "memory")
                pr = vlayer.dataProvider()
            except exceptions.Exception:
                linhas = []
            
            i=0
            if len(linhas) > 0 and linhas[0].startswith('SOURCETABLE 200 OK'):
                for linha in linhas:
                    campos = str.split(linha,';')
                    if campos[0].startswith('STR'):
                        i+=1
                        nome = campos[1]
                        y = float(campos[9])
                        x = float(campos[10])
                        fet = QgsFeature()
                        fet.setGeometry( QgsGeometry.fromPoint(QgsPoint(x,y)) )
                        fet.setAttributes([i, nome])
                        pr.addFeatures([fet])
                QgsMapLayerRegistry.instance().addMapLayer(vlayer)
            else:
                QMessageBox.information(None, "Erro", u'O endereço não se trata de um Caster.')
            conn.close()
