#########################################################################################
####################################  Show logging messages #############################
#########################################################################################
from qgis.PyQt.QtGui import QStandardItem, QStandardItemModel
from qgis.PyQt.QtWidgets import QAbstractItemView
from qgis.PyQt.QtCore import Qt
from qgis.core import QgsMessageLog
from .constants import PLUGIN_NAME
import time


class LoggingManager:
    """
    Class to manage logging manages generated by this plugin code
    """
    def __init__(self, dlg):

        assert dlg is not None, "LoggingManager: dlg is None"

        self.dlg = dlg

        self.logModel = QStandardItemModel()
        self.dlg.logView.setModel(self.logModel)
        self.dlg.logView.setEditTriggers(QAbstractItemView.EditTrigger.NoEditTriggers)
        
        self.logModel.appendRow([QStandardItem("Start logging")])

        self.logModel.setHeaderData(0, Qt.Orientation.Horizontal, "Log bericht")
        self.logModel.horizontalHeaderItem(0).setTextAlignment(Qt.AlignmentFlag.AlignLeft)
        self.dlg.logView.horizontalHeader().setStretchLastSection(True)
        
    def start_time(self):
        self.tic = time.perf_counter()

    def stop_time(self):
        toc = time.perf_counter()
        self.log(f"Rendering finished in {toc - self.tic:0.4f} seconds.", 0)

    def log(self, text, lvl=1):
        if not isinstance(text, str):
            text = str(text)
        
        log = QStandardItem(text)
        log.setToolTip(text)
        QgsMessageLog.logMessage(text, PLUGIN_NAME, lvl)
        return self.logModel.appendRow([log])