/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import shaded.org.hsqldb.map.BitMap;

public final class ServerAcl {
    static final byte[] ALL_SET_4BYTES = new byte[]{-1, -1, -1, -1};
    static final byte[] ALL_SET_16BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private PrintWriter pw = null;
    private List<AclEntry> aclEntries;
    private static AclEntry PROHIBIT_ALL_IPV4;
    private static AclEntry PROHIBIT_ALL_IPV6;
    private File aclFile;
    private long lastLoadTime = 0L;

    public static String dottedNotation(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(byArray[i] & 0xFF);
        }
        return stringBuilder.toString();
    }

    public static String colonNotation(byte[] byArray) {
        if (byArray.length / 2 * 2 != byArray.length) {
            throw new RuntimeException("At this time .colonNotation only handles even byte quantities");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; i += 2) {
            if (i > 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(Integer.toHexString((byArray[i] & 0xFF) * 256 + (byArray[i + 1] & 0xFF)));
        }
        return stringBuilder.toString();
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.aclEntries.size(); ++i) {
            if (i > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Entry " + (i + 1) + ": " + this.aclEntries.get(i));
        }
        return stringBuilder.toString();
    }

    public boolean permitAccess(String string) {
        try {
            return this.permitAccess(InetAddress.getByName(string).getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            this.println("'" + string + "' denied because failed to resolve to an addr");
            return false;
        }
    }

    public boolean permitAccess(byte[] byArray) {
        this.ensureAclsUptodate();
        for (int i = 0; i < this.aclEntries.size(); ++i) {
            if (!this.aclEntries.get(i).matches(byArray)) continue;
            AclEntry aclEntry = this.aclEntries.get(i);
            this.println("Addr '" + ServerAcl.dottedNotation(byArray) + "' matched rule #" + (i + 1) + ":  " + aclEntry);
            return aclEntry.allow;
        }
        throw new RuntimeException("No rule matches address '" + ServerAcl.dottedNotation(byArray) + "'");
    }

    private void println(String string) {
        if (this.pw == null) {
            return;
        }
        this.pw.println(string);
        this.pw.flush();
    }

    public ServerAcl(File file) throws IOException, AclFormatException {
        this.aclFile = file;
        this.aclEntries = this.load();
    }

    synchronized void ensureAclsUptodate() {
        if (this.lastLoadTime > this.aclFile.lastModified()) {
            return;
        }
        try {
            this.aclEntries = this.load();
            this.println("ACLs reloaded from file");
        }
        catch (Exception exception) {
            this.println("Failed to reload ACL file.  Retaining old ACLs.  " + exception);
        }
    }

    /*
     * Exception decompiling
     */
    List<AclEntry> load() throws IOException, AclFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] stringArray) throws AclFormatException, IOException {
        String string;
        if (stringArray.length > 1) {
            throw new RuntimeException("Try: java -cp path/to/hsqldb.jar " + ServerAcl.class.getName() + " --help");
        }
        if (stringArray.length > 0 && stringArray[0].equals("--help")) {
            System.err.println("SYNTAX: java -cp path/to/hsqldb.jar " + ServerAcl.class.getName() + " [filepath.txt]");
            System.err.println("ACL file path defaults to 'acl.txt' in the current directory.");
            System.exit(0);
        }
        ServerAcl serverAcl = new ServerAcl(new File(stringArray.length == 0 ? "acl.txt" : stringArray[0]));
        serverAcl.setPrintWriter(new PrintWriter(System.out));
        System.out.println(serverAcl.toString());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter hostnames or IP addresses to be tested (one per line).");
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty()) continue;
            System.out.println(Boolean.toString(serverAcl.permitAccess(string)));
        }
    }

    static {
        try {
            PROHIBIT_ALL_IPV4 = new AclEntry(InetAddress.getByName("0.0.0.0").getAddress(), 0, false);
            PROHIBIT_ALL_IPV6 = new AclEntry(InetAddress.getByName("::").getAddress(), 0, false);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Unexpected problem in static initializer", unknownHostException);
        }
        catch (AclFormatException aclFormatException) {
            throw new RuntimeException("Unexpected problem in static initializer", aclFormatException);
        }
    }

    private static final class InternalException
    extends Exception {
        private InternalException() {
        }
    }

    private static final class AclEntry {
        private byte[] value;
        private byte[] mask;
        private int bitBlockSize;
        public boolean allow;

        public AclEntry(byte[] byArray, int n, boolean bl) throws AclFormatException {
            byte[] byArray2 = null;
            switch (byArray.length) {
                case 4: {
                    byArray2 = ALL_SET_4BYTES;
                    break;
                }
                case 16: {
                    byArray2 = ALL_SET_16BYTES;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only 4 and 16 bytes supported, not " + byArray.length);
                }
            }
            if (n > byArray.length * 8) {
                throw new IllegalArgumentException("Specified " + n + " significant bits, but value only has " + byArray.length * 8 + " bits");
            }
            this.bitBlockSize = n;
            this.value = byArray;
            this.mask = BitMap.leftShift(byArray2, byArray.length * 8 - n);
            if (this.mask.length != byArray.length) {
                throw new RuntimeException("Basic program assertion failed.  Generated mask length " + this.mask.length + " (bytes) does not match given value length " + byArray.length + " (bytes).");
            }
            this.allow = bl;
            this.validateMask();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Addrs ").append((String)(this.value.length == 16 ? "[" + ServerAcl.colonNotation(this.value) + "]" : ServerAcl.dottedNotation(this.value))).append("/" + this.bitBlockSize + " " + (this.allow ? "ALLOW" : "DENY"));
            return stringBuilder.toString();
        }

        public boolean matches(byte[] byArray) {
            if (this.value.length != byArray.length) {
                return false;
            }
            return !BitMap.hasAnyBitSet(BitMap.xor(this.value, BitMap.and(byArray, this.mask)));
        }

        public void validateMask() throws AclFormatException {
            if (BitMap.hasAnyBitSet(BitMap.and(this.value, BitMap.not(this.mask)))) {
                throw new AclFormatException("The base address '" + ServerAcl.dottedNotation(this.value) + "' is too specific for block-size-spec /" + this.bitBlockSize);
            }
        }
    }

    public static final class AclFormatException
    extends Exception {
        public AclFormatException(String string) {
            super(string);
        }
    }
}

