/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.rights;

import shaded.org.hsqldb.Database;
import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.Routine;
import shaded.org.hsqldb.Schema;
import shaded.org.hsqldb.SchemaObject;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.HsqlArrayList;
import shaded.org.hsqldb.lib.List;
import shaded.org.hsqldb.lib.OrderedHashMap;
import shaded.org.hsqldb.result.Result;
import shaded.org.hsqldb.rights.Grantee;
import shaded.org.hsqldb.rights.GranteeManager;
import shaded.org.hsqldb.rights.User;

public final class UserManager {
    private OrderedHashMap<String, User> userList;
    private GranteeManager granteeManager;
    Routine pwCheckFunction;
    Routine extAuthenticationFunction;

    public UserManager(Database database) {
        this.granteeManager = database.getGranteeManager();
        this.userList = new OrderedHashMap();
    }

    public User createUser(Session session, HsqlNameManager.HsqlName hsqlName, String string, boolean bl) {
        User user = this.granteeManager.addUser(hsqlName);
        if (session == null) {
            user.setPassword(string, bl);
        } else {
            try {
                this.setPassword(session, user, string, bl);
            }
            catch (HsqlException hsqlException) {
                this.granteeManager.removeNewUser(hsqlName);
                throw hsqlException;
            }
        }
        this.userList.add(hsqlName.name, user);
        return user;
    }

    public void setPassword(Session session, User user, String string, boolean bl) {
        if (!bl && !this.checkComplexity(session, string)) {
            throw Error.error(391);
        }
        user.setPassword(string, bl);
    }

    public boolean checkComplexity(Session session, String string) {
        if (session == null || this.pwCheckFunction == null) {
            return true;
        }
        Result result = this.pwCheckFunction.invoke(session, new Object[]{string}, null, true);
        Boolean bl = (Boolean)result.getValueObject();
        return bl != null && bl != false;
    }

    public void dropUser(String string) {
        boolean bl = GranteeManager.isReserved(string);
        if (bl) {
            throw Error.error(4002, string);
        }
        boolean bl2 = this.granteeManager.removeGrantee(string);
        if (!bl2) {
            throw Error.error(4001, string);
        }
        User user = this.userList.remove(string);
        if (user == null) {
            throw Error.error(4001, string);
        }
    }

    public void createFirstUser(String string, String string2) {
        boolean bl = true;
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
            bl = false;
        }
        HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.nameManager.newHsqlName(string, bl, 11);
        User user = this.createUser(null, hsqlName, string2, false);
        user.isLocalOnly = true;
        this.granteeManager.grant(hsqlName.name, "DBA", this.granteeManager.getDBARole());
    }

    public User getUser(String string, String string2) {
        SchemaObject schemaObject;
        int n;
        User user;
        boolean bl;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        boolean bl2 = bl = (user = (User)this.userList.get((Object)string)) != null && user.isLocalOnly;
        if (this.extAuthenticationFunction == null || bl) {
            user = this.get(string);
            user.checkPassword(string2);
            return user;
        }
        Result result = this.extAuthenticationFunction.invokeJavaMethodDirect(new String[]{this.granteeManager.database.getNameString(), string, string2});
        if (result.isError()) {
            throw Error.error(4001, result.getMainString());
        }
        Object[] objectArray = (Object[])result.getValueObject();
        if (user == null) {
            HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.nameManager.newHsqlName(string, true, 11);
            user = this.createUser(null, hsqlName, "", false);
            user.isExternalOnly = true;
        }
        if (objectArray == null) {
            user.updateAllRights();
            return user;
        }
        user.clearPrivileges();
        for (n = 0; n < objectArray.length; ++n) {
            try {
                schemaObject = this.granteeManager.getRole((String)objectArray[n]);
                user.grant((Grantee)schemaObject);
                continue;
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
        user.updateAllRights();
        for (n = 0; n < objectArray.length; ++n) {
            schemaObject = this.granteeManager.database.schemaManager.findSchema((String)objectArray[n]);
            if (schemaObject == null) continue;
            user.setInitialSchema(((Schema)schemaObject).getName());
            break;
        }
        return user;
    }

    public OrderedHashMap<String, User> getUsers() {
        return this.userList;
    }

    public boolean exists(String string) {
        return this.userList.get((Object)string) != null;
    }

    public User get(String string) {
        User user = (User)this.userList.get((Object)string);
        if (user == null) {
            throw Error.error(4001, string);
        }
        return user;
    }

    public HsqlArrayList<User> listVisibleUsers(Session session) {
        HsqlArrayList<User> hsqlArrayList = new HsqlArrayList<User>();
        boolean bl = session.isAdmin();
        String string = session.getUsername();
        if (this.userList == null || this.userList.isEmpty()) {
            return hsqlArrayList;
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = this.userList.get(i);
            if (user == null) continue;
            String string2 = user.getName().getNameString();
            if (bl) {
                hsqlArrayList.add(user);
                continue;
            }
            if (!string.equals(string2)) continue;
            hsqlArrayList.add(user);
        }
        return hsqlArrayList;
    }

    public User getSysUser() {
        return GranteeManager.systemAuthorisation;
    }

    public synchronized void removeSchemaReference(HsqlNameManager.HsqlName hsqlName) {
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = this.userList.get(i);
            HsqlNameManager.HsqlName hsqlName2 = user.getInitialSchema();
            if (hsqlName2 == null || !hsqlName.equals(hsqlName2)) continue;
            user.setInitialSchema(null);
        }
    }

    public void setPasswordCheckFunction(Routine routine) {
        this.pwCheckFunction = routine;
    }

    public void setExtAuthenticationFunction(Routine routine) {
        this.extAuthenticationFunction = routine;
    }

    public List<String> getInitialSchemaSQLArray() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>(this.userList.size());
        for (int i = 0; i < this.userList.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName;
            User user = this.userList.get(i);
            if (user.isSystem || (hsqlName = user.getInitialSchema()) == null) continue;
            hsqlArrayList.add(user.getInitialSchemaSQL());
        }
        return hsqlArrayList;
    }

    public List<String> getAuthenticationSQLArray() {
        StringBuilder stringBuilder;
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        if (this.pwCheckFunction != null) {
            stringBuilder = new StringBuilder(64);
            stringBuilder.append("SET").append(' ').append("DATABASE").append(' ').append("PASSWORD").append(' ').append("CHECK").append(' ').append("FUNCTION").append(' ').append(this.pwCheckFunction.getSQLBodyDefinition());
            hsqlArrayList.add(stringBuilder.toString());
        }
        if (this.extAuthenticationFunction != null) {
            stringBuilder = new StringBuilder(64);
            stringBuilder.append("SET").append(' ').append("DATABASE").append(' ').append("AUTHENTICATION").append(' ').append("FUNCTION").append(' ').append(this.extAuthenticationFunction.getSQLBodyDefinition());
            hsqlArrayList.add(stringBuilder.toString());
        }
        return hsqlArrayList;
    }
}

