/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.persist;

import shaded.org.hsqldb.Row;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.index.Index;
import shaded.org.hsqldb.navigator.RowIterator;
import shaded.org.hsqldb.navigator.RowSetNavigatorClient;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.persist.RowInsertInterface;
import shaded.org.hsqldb.types.DateTimeType;
import shaded.org.hsqldb.types.TimestampData;
import shaded.org.hsqldb.types.Type;

public class RowInsertVersioning
implements RowInsertInterface {
    final Session session;
    final RowInsertInterface.ErrorLogger callback;
    final int mode;
    RowSetNavigatorClient rowSet = new RowSetNavigatorClient(64);
    Table table = null;
    PersistentStore store;
    Index index = null;

    public RowInsertVersioning(Session session, RowInsertInterface.ErrorLogger errorLogger, int n) {
        this.session = session;
        this.callback = errorLogger;
        this.mode = n;
    }

    @Override
    public void finishTable() {
        this.applyChangeSet();
    }

    @Override
    public void close() {
        this.callback.close();
    }

    @Override
    public long getErrorLineNumber() {
        return 0L;
    }

    @Override
    public void insert(Table table, PersistentStore persistentStore, Object[] objectArray) {
        if (this.table != table) {
            this.resetTable(table, persistentStore);
        }
        if (this.isSameRowSet(objectArray)) {
            this.rowSet.add(objectArray);
        } else {
            this.applyChangeSet();
            this.rowSet.add(objectArray);
        }
    }

    @Override
    public void setStartLineNumber(long l) {
    }

    boolean isSameRowSet(Object[] objectArray) {
        if (this.rowSet.isEmpty()) {
            return true;
        }
        return this.index.compareRow(this.session, objectArray, this.rowSet.getData(0)) == 0;
    }

    void applyChangeSet() {
        Object[] objectArray;
        if (this.rowSet.getSize() == 0) {
            return;
        }
        int n = 0;
        RowIterator rowIterator = this.index.findFirstRow(this.session, this.store, this.rowSet.getData(0));
        boolean bl = false;
        Row row = null;
        while (rowIterator.next() && this.isSameRowSet(rowIterator.getCurrent())) {
            row = rowIterator.getCurrentRow();
            TimestampData timestampData = row.getSystemStartVersion();
            int n2 = this.compareColumn(timestampData, objectArray = this.rowSet.getData(n), this.table.getSystemPeriodStartIndex());
            if (n2 < 0) {
                timestampData = row.getSystemEndVersion();
                n2 = this.compareColumn(timestampData, objectArray, this.table.getSystemPeriodStartIndex());
                if (n2 <= 0) continue;
                bl = true;
                break;
            }
            if (n2 > 0) {
                bl = true;
                break;
            }
            timestampData = row.getSystemEndVersion();
            n2 = this.compareColumn(timestampData, objectArray, this.table.getSystemPeriodEndIndex());
            if (n2 == 0) {
                ++n;
                continue;
            }
            if (timestampData.getSeconds() != DateTimeType.epochLimitSeconds) continue;
            rowIterator.removeCurrent();
            break;
        }
        if (bl) {
            for (int i = n; i < this.rowSet.getSize(); ++i) {
                objectArray = this.rowSet.getData(i);
                Row row2 = new Row(this.table, objectArray);
                this.callback.writeRow(0L, row2);
            }
        } else {
            for (int i = n; i < this.rowSet.getSize(); ++i) {
                objectArray = this.rowSet.getData(i);
                this.table.insertFromScript(this.session, this.store, objectArray);
            }
        }
        this.rowSet.clear();
    }

    void resetTable(Table table, PersistentStore persistentStore) {
        this.table = table;
        this.store = persistentStore;
        this.index = table.getPrimaryIndex();
    }

    int compareColumn(TimestampData timestampData, Object[] objectArray, int n) {
        return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.compare(this.session, timestampData, objectArray[n]);
    }
}

