/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.persist;

import shaded.org.hsqldb.lib.LongLookup;
import shaded.org.hsqldb.persist.CachedObjectBase;
import shaded.org.hsqldb.rowio.RowInputInterface;
import shaded.org.hsqldb.rowio.RowOutputInterface;

public class IntArrayCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 4;
    int[] values;

    public IntArrayCachedObject(int n) {
        this.values = new int[n];
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        this.position = rowInputInterface.getFilePosition();
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            this.values[i] = rowInputInterface.readInt();
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.values.length;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.values.length * 4;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.write(rowOutputInterface, null);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        int n = this.values.length;
        rowOutputInterface.setStorageSize(this.storageSize);
        for (int i = 0; i < n; ++i) {
            rowOutputInterface.writeInt(this.values[i]);
        }
        rowOutputInterface.writeEnd();
    }

    public int getNonZeroSize() {
        int n;
        for (n = 0; n < this.values.length && this.values[n] != 0; ++n) {
        }
        return n;
    }

    public void setValue(int n, int n2) {
        this.values[n] = n2;
        this.hasChanged = true;
    }

    public void setIntArray(int[] nArray) {
        this.values = nArray;
        this.hasChanged = true;
    }

    public int getValue(int n) {
        return this.values[n];
    }

    public int[] getIntArray() {
        return this.values;
    }
}

