/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.navigator;

import shaded.org.hsqldb.HsqlException;
import shaded.org.hsqldb.QueryExpression;
import shaded.org.hsqldb.QuerySpecification;
import shaded.org.hsqldb.Row;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.SortAndSlice;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.TableBase;
import shaded.org.hsqldb.lib.ArrayUtil;
import shaded.org.hsqldb.navigator.RowIterator;
import shaded.org.hsqldb.navigator.RowSetNavigatorData;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.result.ResultMetaData;
import shaded.org.hsqldb.rowio.RowInputInterface;
import shaded.org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorDataTable
extends RowSetNavigatorData {
    public TableBase table;
    public PersistentStore store;
    RowIterator iterator;
    int iteratorPos = -1;
    Object[] tempRowData;

    public RowSetNavigatorDataTable(Session session, QuerySpecification querySpecification) {
        super(session, querySpecification.sortAndSlice);
        this.rangePosition = querySpecification.resultRangePosition;
        this.visibleColumnCount = querySpecification.indexLimitVisible;
        this.table = querySpecification.resultTable.duplicate();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, !querySpecification.isAggregated);
        this.isAggregate = querySpecification.isAggregated;
        this.isSimpleAggregate = querySpecification.isAggregated && !querySpecification.isGrouped;
        this.reindexTable = querySpecification.isGrouped;
        this.mainIndex = querySpecification.mainIndex;
        this.fullIndex = querySpecification.fullIndex;
        this.orderIndex = querySpecification.orderIndex;
        this.groupIndex = querySpecification.groupIndex;
        this.idIndex = querySpecification.idIndex;
        this.rowNumIndex = querySpecification.rowNumIndex;
        this.tempRowData = new Object[1];
    }

    public RowSetNavigatorDataTable(Session session, QuerySpecification querySpecification, RowSetNavigatorData rowSetNavigatorData) {
        this(session, querySpecification);
        rowSetNavigatorData.reset();
        while (rowSetNavigatorData.next()) {
            this.add(rowSetNavigatorData.getCurrent());
        }
    }

    public RowSetNavigatorDataTable(Session session, QueryExpression queryExpression) {
        super(session, queryExpression.sortAndSlice);
        this.table = queryExpression.resultTable.duplicate();
        this.visibleColumnCount = this.table.getColumnCount();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, true);
        this.mainIndex = queryExpression.mainIndex;
        this.fullIndex = queryExpression.fullIndex;
    }

    public RowSetNavigatorDataTable(Session session, Table table) {
        super(session, SortAndSlice.noSort);
        this.table = table;
        this.visibleColumnCount = table.getColumnCount();
        this.mainIndex = table.getPrimaryIndex();
        this.fullIndex = table.getFullIndex(session);
        this.store = table.getRowStore(session);
        this.size = (int)this.store.elementCount();
        this.reset();
    }

    @Override
    public void sortFull() {
        if (this.reindexTable) {
            this.store.indexRows((Session)this.session);
        }
        this.mainIndex = this.fullIndex;
        this.reset();
    }

    @Override
    public void sortOrder() {
        if (this.orderIndex != null) {
            if (this.reindexTable) {
                this.store.indexRows((Session)this.session);
            }
            this.mainIndex = this.orderIndex;
            this.reset();
        }
    }

    @Override
    public void sortOrderUnion(SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            this.reset();
        }
    }

    @Override
    public void add(Object[] objectArray) {
        try {
            Object object;
            if (this.table.getDataColumnCount() > objectArray.length) {
                object = this.table.getEmptyRowData();
                ArrayUtil.copyArray(objectArray, object, objectArray.length);
                objectArray = object;
            }
            object = (Row)this.store.getNewCachedObject((Session)this.session, objectArray, false);
            this.store.indexRow((Session)this.session, (Row)object);
            ++this.size;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    void addAdjusted(Object[] objectArray, int[] nArray) {
        try {
            if (nArray == null) {
                objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.visibleColumnCount);
            } else {
                Object[] objectArray2 = new Object[this.visibleColumnCount];
                ArrayUtil.projectRow(objectArray, nArray, objectArray2);
                objectArray = objectArray2;
            }
            this.add(objectArray);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public void updateData(long l, Object[] objectArray) {
        this.tempRowData[0] = l;
        RowIterator rowIterator = this.idIndex.findFirstRow((Session)this.session, this.store, this.tempRowData, this.idIndex.getDefaultColumnMap());
        if (rowIterator.next()) {
            rowIterator.removeCurrent();
            rowIterator.release();
            --this.size;
            this.add(objectArray);
        }
        this.resetIterator();
    }

    @Override
    public void updateData(Object[] objectArray, Object[] objectArray2) {
        if (this.isSimpleAggregate) {
            return;
        }
        RowIterator rowIterator = this.groupIndex.findFirstRow((Session)this.session, this.store, objectArray);
        if (rowIterator.next()) {
            rowIterator.removeCurrent();
            rowIterator.release();
            --this.size;
            this.add(objectArray2);
        }
    }

    @Override
    public boolean absolute(int n) {
        if (n < 0) {
            n += this.size;
        }
        if (n < 0) {
            this.beforeFirst();
            return false;
        }
        if (n >= this.size) {
            this.afterLast();
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        this.currentPos = n;
        return true;
    }

    private boolean toCurrentRow() {
        if (this.rowNumIndex == this.mainIndex) {
            this.tempRowData[0] = (long)this.currentPos;
            this.iterator = this.rowNumIndex.findFirstRow((Session)this.session, this.store, this.tempRowData, this.rowNumIndex.getDefaultColumnMap());
            this.iterator.next();
            this.iteratorPos = this.currentPos;
        } else {
            if (this.iteratorPos > this.currentPos) {
                this.resetIterator();
            }
            while (this.iteratorPos < this.currentPos) {
                this.iterator.next();
                ++this.iteratorPos;
            }
        }
        return true;
    }

    @Override
    public Object[] getCurrent() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        if (this.currentPos != this.iteratorPos) {
            this.toCurrentRow();
        }
        return this.iterator.getCurrent();
    }

    @Override
    public Row getCurrentRow() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        if (this.currentPos != this.iteratorPos) {
            this.toCurrentRow();
        }
        return this.iterator.getCurrentRow();
    }

    @Override
    public boolean next() {
        return super.next();
    }

    @Override
    public void removeCurrent() {
        Row row = this.getCurrentRow();
        if (row != null) {
            this.iterator.removeCurrent();
            this.iterator.next();
            --this.currentPos;
            --this.size;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.resetIterator();
    }

    void resetIterator() {
        if (this.iterator != null) {
            this.iterator.release();
        }
        this.iterator = this.mainIndex.firstRow((Session)this.session, this.store, null, 0, null);
        this.iteratorPos = -1;
    }

    @Override
    public void release() {
        if (this.isClosed) {
            return;
        }
        this.iterator.release();
        this.store.release();
        this.isClosed = true;
    }

    @Override
    public void clear() {
        this.store.removeAll();
        this.size = 0;
        this.reset();
    }

    @Override
    public boolean isMemory() {
        return this.store.isMemory();
    }

    @Override
    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) {
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) {
        this.reset();
        rowOutputInterface.writeLong(this.id);
        rowOutputInterface.writeInt(this.size);
        rowOutputInterface.writeInt(0);
        rowOutputInterface.writeInt(this.size);
        while (this.next()) {
            Object[] objectArray = this.getCurrent();
            rowOutputInterface.writeData(resultMetaData.getExtendedColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
        this.reset();
    }

    @Override
    public Object[] getData(long l) {
        this.tempRowData[0] = l;
        RowIterator rowIterator = this.idIndex.findFirstRow((Session)this.session, this.store, this.tempRowData, this.idIndex.getDefaultColumnMap());
        rowIterator.next();
        return rowIterator.getCurrent();
    }

    public void copy(RowSetNavigatorData rowSetNavigatorData, int[] nArray) {
        while (rowSetNavigatorData.next()) {
            Object[] objectArray = rowSetNavigatorData.getCurrent();
            this.addAdjusted(objectArray, nArray);
        }
    }

    @Override
    public void union(RowSetNavigatorData rowSetNavigatorData) {
        int n = this.table.getColumnTypes().length;
        this.removeDuplicates();
        rowSetNavigatorData.reset();
        while (rowSetNavigatorData.next()) {
            Object[] objectArray = rowSetNavigatorData.getCurrent();
            RowIterator rowIterator = this.findFirstRow(objectArray);
            if (!rowIterator.next()) {
                objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, n);
                this.add(objectArray);
            }
            rowIterator.release();
        }
        this.reset();
    }

    @Override
    public void intersect(RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates();
        rowSetNavigatorData.sortFull();
        while (this.next()) {
            Object[] objectArray = this.getCurrent();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (bl) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public void intersectAll(RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = null;
        Object var4_3 = null;
        Object[] objectArray2 = null;
        this.sortFull();
        rowSetNavigatorData.sortFull();
        RowIterator rowIterator = RowIterator.emptyRowIterator;
        while (this.next()) {
            boolean bl;
            Object[] objectArray3 = this.getCurrent();
            boolean bl2 = bl = objectArray == null || this.fullIndex.compareRowNonUnique((Session)this.session, objectArray3, objectArray, this.fullIndex.getColumnCount()) != 0;
            if (bl) {
                objectArray = objectArray3;
                rowIterator = rowSetNavigatorData.findFirstRow(objectArray3);
            }
            if (rowIterator.next() && this.fullIndex.compareRowNonUnique((Session)this.session, objectArray3, objectArray2 = rowIterator.getCurrent(), this.fullIndex.getColumnCount()) == 0) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public void except(RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates();
        rowSetNavigatorData.sortFull();
        while (this.next()) {
            Object[] objectArray = this.getCurrent();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (!bl) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public void exceptNoDedup(RowSetNavigatorData rowSetNavigatorData) {
        rowSetNavigatorData.sortFull();
        this.reset();
        while (this.next()) {
            Object[] objectArray = this.getCurrent();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (!bl) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public void exceptAll(RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        this.sortFull();
        rowSetNavigatorData.sortFull();
        RowIterator rowIterator = RowIterator.emptyRowIterator;
        while (this.next()) {
            boolean bl;
            Object[] objectArray3 = this.getCurrent();
            boolean bl2 = bl = objectArray == null || this.fullIndex.compareRowNonUnique((Session)this.session, objectArray3, objectArray, this.fullIndex.getColumnCount()) != 0;
            if (bl) {
                objectArray = objectArray3;
                rowIterator = rowSetNavigatorData.findFirstRow(objectArray3);
            }
            if (!rowIterator.next() || this.fullIndex.compareRowNonUnique((Session)this.session, objectArray3, objectArray2 = rowIterator.getCurrent(), this.fullIndex.getColumnCount()) != 0) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    public boolean hasUniqueNotNullRows() {
        this.sortFull();
        Object[] objectArray = null;
        while (this.next()) {
            Object[] objectArray2 = this.getCurrent();
            if (this.hasNull(objectArray2)) continue;
            if (objectArray != null && this.fullIndex.compareRow((Session)this.session, objectArray, objectArray2) == 0) {
                return false;
            }
            objectArray = objectArray2;
        }
        return true;
    }

    @Override
    public void removeDuplicates() {
        this.sortFull();
        Object[] objectArray = null;
        while (this.next()) {
            Object[] objectArray2 = this.getCurrent();
            if (objectArray != null && this.fullIndex.compareRow((Session)this.session, objectArray, objectArray2) == 0) {
                this.removeCurrent();
                continue;
            }
            objectArray = objectArray2;
        }
        this.reset();
    }

    @Override
    public void trim(int n, int n2) {
        int n3;
        if (this.size == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        if (n != 0) {
            this.reset();
            for (n3 = 0; n3 < n; ++n3) {
                this.next();
                this.removeCurrent();
            }
        }
        if (n2 == 0 || n2 >= this.size) {
            return;
        }
        this.reset();
        for (n3 = 0; n3 < n2; ++n3) {
            this.next();
        }
        while (this.next()) {
            this.removeCurrent();
        }
        this.reset();
    }

    @Override
    boolean hasNull(Object[] objectArray) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (objectArray[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getGroupData(Object[] objectArray) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = objectArray;
                return null;
            }
            return this.simpleAggregateData;
        }
        RowIterator rowIterator = this.groupIndex.findFirstRow((Session)this.session, this.store, objectArray);
        if (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            if (this.isAggregate) {
                row.setChanged(true);
            }
            return row.getData();
        }
        return null;
    }

    @Override
    boolean containsRow(Object[] objectArray) {
        RowIterator rowIterator = this.mainIndex.findFirstRow((Session)this.session, this.store, objectArray);
        boolean bl = rowIterator.next();
        rowIterator.release();
        return bl;
    }

    @Override
    RowIterator findFirstRow(Object[] objectArray) {
        return this.mainIndex.findFirstRow((Session)this.session, this.store, objectArray);
    }
}

