/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.map;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import shaded.org.hsqldb.lib.ArrayCounter;
import shaded.org.hsqldb.lib.ArrayUtil;
import shaded.org.hsqldb.lib.ObjectComparator;
import shaded.org.hsqldb.lib.PrimitiveIterator;
import shaded.org.hsqldb.map.HashIndex;

public class BaseHashMap {
    protected boolean isIntKey;
    protected boolean isLongKey;
    protected boolean isObjectKey;
    protected boolean isNoValue;
    protected boolean isIntValue;
    protected boolean isLongValue;
    protected boolean isObjectValue;
    protected boolean isMultiValue;
    protected boolean isList;
    protected boolean isAccessCount;
    protected boolean isLastAccessCount;
    protected HashIndex hashIndex;
    protected int[] intKeyTable;
    protected Object[] objectKeyTable;
    protected long[] longKeyTable;
    protected int[] intValueTable;
    protected Object[] objectValueTable;
    protected long[] longValueTable;
    protected int accessMin;
    protected AtomicInteger accessCount;
    protected int[] accessTable;
    protected Object[] objectValueTable2;
    protected Object[] objectValueTable3;
    protected final float loadFactor;
    protected final int initialCapacity;
    protected int threshold;
    protected int maxCapacity;
    protected int purgePolicy = 0;
    protected boolean minimizeOnEmpty;
    protected ObjectComparator comparator = ObjectComparator.defaultComparator;
    protected boolean hasZeroKey;
    protected int zeroKeyIndex = -1;
    protected int zeroOrNullValueCount;
    protected static final int noKeyOrValue = 0;
    protected static final int intKeyOrValue = 1;
    protected static final int longKeyOrValue = 2;
    protected static final int objectKeyOrValue = 3;
    protected static final int NO_PURGE = 0;
    protected static final int PURGE_ALL = 1;
    protected static final int PURGE_HALF = 2;
    public static final int ACCESS_MAX = 0x7FEFFFFF;
    public static final Object[] emptyObjectArray = new Object[0];

    protected BaseHashMap(int n, int n2, int n3, boolean bl) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        n = n < 4 ? 4 : (int)ArrayUtil.getBinaryNormalisedCeiling(n);
        this.loadFactor = 1.0f;
        this.initialCapacity = n;
        this.threshold = n;
        int n4 = (int)((float)n * this.loadFactor);
        if (n4 < 4) {
            n4 = 4;
        }
        this.hashIndex = new HashIndex(n4, n, true);
        int n5 = this.threshold;
        if (n2 == 1) {
            this.isIntKey = true;
            this.intKeyTable = new int[n5];
        } else if (n2 == 3) {
            this.isObjectKey = true;
            this.objectKeyTable = new Object[n5];
        } else {
            this.isLongKey = true;
            this.longKeyTable = new long[n5];
        }
        if (n3 == 1) {
            this.isIntValue = true;
            this.intValueTable = new int[n5];
        } else if (n3 == 3) {
            this.isObjectValue = true;
            this.objectValueTable = new Object[n5];
        } else if (n3 == 2) {
            this.isLongValue = true;
            this.longValueTable = new long[n5];
        } else {
            this.isNoValue = true;
        }
        this.isLastAccessCount = bl;
        if (bl) {
            this.accessTable = new int[n5];
            this.accessCount = new AtomicInteger();
        }
    }

    protected int getLookup(Object object) {
        Object object2;
        int n = this.comparator.hashCode(object);
        int n2 = this.hashIndex.getLookup(n);
        while (n2 >= 0 && !this.comparator.equals(object, object2 = this.objectKeyTable[n2])) {
            n2 = this.hashIndex.getNextLookup(n2);
        }
        return n2;
    }

    protected int getLookup(Object object, int n) {
        Object object2;
        int n2 = this.hashIndex.getLookup(n);
        while (n2 >= 0 && !this.comparator.equals(object, object2 = this.objectKeyTable[n2])) {
            n2 = this.hashIndex.getNextLookup(n2);
        }
        return n2;
    }

    protected int getLookup(int n) {
        int n2;
        int n3 = (int)((long)n >>> 32 ^ (long)n);
        int n4 = this.hashIndex.getLookup(n3);
        while (n4 >= 0 && n != (n2 = this.intKeyTable[n4])) {
            n4 = this.hashIndex.getNextLookup(n4);
        }
        return n4;
    }

    protected int getLookup(long l) {
        long l2;
        int n = (int)(l >>> 32 ^ l);
        int n2 = this.hashIndex.getLookup(n);
        while (n2 >= 0 && l != (l2 = this.longKeyTable[n2])) {
            n2 = this.hashIndex.getNextLookup(n2);
        }
        return n2;
    }

    protected int getObjectLookup(long l) {
        long l2;
        int n = (int)(l >>> 32 ^ l);
        int n2 = this.hashIndex.getLookup(n);
        while (n2 >= 0 && (l2 = this.comparator.longKey(this.objectKeyTable[n2])) != l) {
            n2 = this.hashIndex.getNextLookup(n2);
        }
        return n2;
    }

    protected PrimitiveIterator getMultiValuesIterator(Object object) {
        int n = this.getLookup(object);
        ValueCollectionIterator valueCollectionIterator = new ValueCollectionIterator(object, n);
        return valueCollectionIterator;
    }

    protected int multiValueElementCount(Object object) {
        int n = this.getLookup(object);
        if (n == -1) {
            return 0;
        }
        int n2 = 1;
        while ((n = this.hashIndex.getNextLookup(n)) != -1 && this.objectKeyTable[n].equals(object)) {
            ++n2;
        }
        return n2;
    }

    protected int multiValueKeyCount() {
        int n = 0;
        int n2 = -1;
        Object object = null;
        int n3 = 0;
        while (n3 < this.hashIndex.hashTable.length) {
            if (this.hashIndex.hashTable[n3] < 0) {
                ++n3;
                continue;
            }
            if ((n2 = n2 < 0 ? this.hashIndex.hashTable[n3] : this.hashIndex.getNextLookup(n2)) < 0) {
                ++n3;
                continue;
            }
            if (this.comparator.equals(object, this.objectKeyTable[n2])) continue;
            object = this.objectKeyTable[n2];
            ++n;
        }
        return n;
    }

    protected Object addOrUpdate(long l, long l2, Object object, Object object2) {
        int n;
        if (this.isObjectKey) {
            if (object == null) {
                return null;
            }
            n = this.comparator.hashCode(object);
        } else {
            n = (int)(l >>> 32 ^ l);
        }
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        Object object3 = null;
        boolean bl = false;
        while (n3 >= 0) {
            if (this.isObjectKey) {
                bl = this.comparator.equals(this.objectKeyTable[n3], object);
            } else if (this.isIntKey) {
                bl = l == (long)this.intKeyTable[n3];
            } else if (this.isLongKey) {
                boolean bl2 = bl = l == this.longKeyTable[n3];
            }
            if (bl) break;
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (bl) {
            if (this.isNoValue) {
                return Boolean.FALSE;
            }
            if (this.isObjectValue) {
                object3 = this.objectValueTable[n3];
                this.objectValueTable[n3] = object2;
                if (object2 == null) {
                    if (object3 != null) {
                        ++this.zeroOrNullValueCount;
                    }
                } else if (object3 == null) {
                    --this.zeroOrNullValueCount;
                }
            } else if (this.isIntValue) {
                int n5 = this.intValueTable[n3];
                object3 = n5;
                this.intValueTable[n3] = (int)l2;
                if (l2 == 0L) {
                    if (n5 != 0) {
                        ++this.zeroOrNullValueCount;
                    }
                } else if (n5 == 0) {
                    --this.zeroOrNullValueCount;
                }
            } else if (this.isLongValue) {
                long l3 = this.longValueTable[n3];
                object3 = l3;
                this.longValueTable[n3] = l2;
                if (l2 == 0L) {
                    if (l3 != 0L) {
                        ++this.zeroOrNullValueCount;
                    }
                } else if (l3 == 0L) {
                    --this.zeroOrNullValueCount;
                }
            }
            if (this.isLastAccessCount) {
                this.accessTable[n3] = this.accessCount.incrementAndGet();
            } else if (this.isAccessCount) {
                int n6 = n3;
                this.accessTable[n6] = this.accessTable[n6] + 1;
            }
            return object3;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrUpdate(l, l2, object, object2);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        if (this.isObjectKey) {
            this.objectKeyTable[n3] = object;
        } else if (this.isIntKey) {
            this.intKeyTable[n3] = (int)l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[n3] = l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        }
        if (this.isNoValue) {
            return Boolean.TRUE;
        }
        if (this.isObjectValue) {
            this.objectValueTable[n3] = object2;
            if (object2 == null) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isIntValue) {
            this.intValueTable[n3] = (int)l2;
            if (l2 == 0L) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isLongValue) {
            this.longValueTable[n3] = l2;
            if (l2 == 0L) {
                ++this.zeroOrNullValueCount;
            }
        }
        if (this.isLastAccessCount) {
            this.accessTable[n3] = this.accessCount.incrementAndGet();
        } else if (this.isAccessCount) {
            this.accessTable[n3] = 1;
        }
        return object3;
    }

    protected Object remove(long l, long l2, Object object, Object object2, boolean bl, boolean bl2) {
        int n;
        int n2;
        if (this.isObjectKey) {
            if (object == null) {
                return null;
            }
            n2 = this.comparator.hashCode(object);
        } else {
            n2 = (int)(l >>> 32 ^ l);
        }
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        Object object3 = null;
        while (n4 >= 0) {
            n = 0;
            if (this.isObjectKey) {
                n = this.comparator.equals(this.objectKeyTable[n4], object);
            } else if (this.isIntKey) {
                n = l == (long)this.intKeyTable[n4] ? 1 : 0;
            } else if (this.isLongKey) {
                int n6 = n = l == this.longKeyTable[n4] ? 1 : 0;
            }
            if (n != 0) {
                if (!bl) break;
                if (this.isObjectValue) {
                    n = ObjectComparator.defaultComparator.equals(this.objectValueTable[n4], object2) ? 1 : 0;
                } else if (this.isIntValue) {
                    n = (long)this.intValueTable[n4] == l2 ? 1 : 0;
                } else if (this.isLongKey) {
                    int n7 = n = this.longValueTable[n4] == l2 ? 1 : 0;
                }
                if (n != 0) break;
                return null;
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (n4 < 0) {
            if (this.isNoValue) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (this.isObjectKey) {
            this.objectKeyTable[n4] = null;
        } else {
            if (l == 0L) {
                this.hasZeroKey = false;
                this.zeroKeyIndex = -1;
            }
            if (this.isIntKey) {
                this.intKeyTable[n4] = 0;
            } else {
                this.longKeyTable[n4] = 0L;
            }
        }
        if (this.isNoValue) {
            object3 = Boolean.TRUE;
        } else if (this.isObjectValue) {
            object3 = this.objectValueTable[n4];
            this.objectValueTable[n4] = null;
            if (object3 == null) {
                --this.zeroOrNullValueCount;
            }
        } else if (this.isIntValue) {
            n = this.intValueTable[n4];
            object3 = n;
            this.intValueTable[n4] = 0;
            if (n == 0) {
                --this.zeroOrNullValueCount;
            }
        } else if (this.isLongValue) {
            long l3 = this.longValueTable[n4];
            object3 = l3;
            this.longValueTable[n4] = 0L;
            if (l3 == 0L) {
                --this.zeroOrNullValueCount;
            }
        }
        this.hashIndex.unlinkNode(n3, n5, n4);
        if (this.accessTable != null) {
            this.accessTable[n4] = 0;
        }
        if (this.isList && bl2) {
            this.removeRow(n4);
        }
        if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
            this.rehash(this.initialCapacity);
        }
        return object3;
    }

    protected boolean addMultiVal(long l, long l2, Object object, Object object2) {
        int n;
        if (this.isObjectKey) {
            if (object == null) {
                return false;
            }
            n = this.comparator.hashCode(object);
        } else {
            n = (int)(l >>> 32 ^ l);
        }
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        while (n3 >= 0) {
            if (this.isObjectKey) {
                bl = this.comparator.equals(this.objectKeyTable[n3], object);
            } else if (this.isIntKey) {
                bl = l == (long)this.intKeyTable[n3];
            } else if (this.isLongKey) {
                boolean bl2 = bl = l == this.longKeyTable[n3];
            }
            if (!bl) {
                if (n5 >= 0) break;
            } else {
                n5 = n3;
                if (this.isObjectValue) {
                    bl = ObjectComparator.defaultComparator.equals(this.objectValueTable[n3], object2);
                } else if (this.isIntValue) {
                    bl = l2 == (long)this.intValueTable[n3];
                } else if (this.isLongValue) {
                    boolean bl3 = bl = l2 == this.longValueTable[n3];
                }
                if (bl) {
                    return false;
                }
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addMultiVal(l, l2, object, object2);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        if (this.isObjectKey) {
            this.objectKeyTable[n3] = object;
        } else if (this.isIntKey) {
            this.intKeyTable[n3] = (int)l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[n3] = l;
            if (l == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n3;
            }
        }
        if (this.isObjectValue) {
            this.objectValueTable[n3] = object2;
            if (object2 == null) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isIntValue) {
            this.intValueTable[n3] = (int)l2;
            if (l2 == 0L) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isLongValue) {
            this.longValueTable[n3] = l2;
            if (l2 == 0L) {
                ++this.zeroOrNullValueCount;
            }
        }
        if (this.isLastAccessCount) {
            this.accessTable[n3] = this.accessCount.incrementAndGet();
        } else if (this.isAccessCount) {
            this.accessTable[n3] = 1;
        }
        return true;
    }

    protected Object removeMultiVal(long l, long l2, Object object, Object object2, boolean bl) {
        if (object == null) {
            return null;
        }
        int n = this.comparator.hashCode(object);
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        int n5 = -1;
        Object object3 = null;
        while (n3 >= 0) {
            if (this.isObjectKey) {
                boolean bl2 = this.comparator.equals(this.objectKeyTable[n3], object);
                if (!bl2) {
                    if (n5 >= 0) break;
                } else {
                    n5 = n3;
                    if (bl) {
                        bl2 = ObjectComparator.defaultComparator.equals(this.objectValueTable[n3], object2);
                        if (bl2) {
                            this.objectKeyTable[n3] = null;
                            object3 = this.objectValueTable[n3];
                            this.objectValueTable[n3] = null;
                            if (object3 == null) {
                                --this.zeroOrNullValueCount;
                            }
                            this.hashIndex.unlinkNode(n2, n4, n3);
                            return object3;
                        }
                    } else {
                        this.objectKeyTable[n3] = null;
                        object3 = this.objectValueTable[n3];
                        this.objectValueTable[n3] = null;
                        if (object3 == null) {
                            --this.zeroOrNullValueCount;
                        }
                        if (n4 > n3) {
                            // empty if block
                        }
                        this.hashIndex.unlinkNode(n2, n4, n3);
                        if (n4 < 0) {
                            n3 = this.hashIndex.hashTable[n2];
                            if (n3 < 0) {
                                break;
                            }
                        } else {
                            n3 = n4;
                        }
                    }
                }
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return object3;
    }

    protected Object removeObject(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        int n = this.comparator.hashCode(object);
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        Object object2 = null;
        while (n3 >= 0) {
            if (this.comparator.equals(this.objectKeyTable[n3], object)) {
                object2 = this.objectKeyTable[n3];
                this.objectKeyTable[n3] = null;
                if (this.accessTable != null) {
                    this.accessTable[n3] = 0;
                }
                this.hashIndex.unlinkNode(n2, n4, n3);
                if (this.isObjectValue) {
                    object2 = this.objectValueTable[n3];
                    this.objectValueTable[n3] = null;
                }
                if (bl) {
                    this.removeRow(n3);
                }
                return object2;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return object2;
    }

    protected Object addOrRemoveObject(long l, Object object, boolean bl) {
        int n = (int)(l >>> 32 ^ l);
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.getLookup(n);
        int n4 = -1;
        Object object2 = null;
        while (n3 >= 0) {
            if (this.comparator.longKey(this.objectKeyTable[n3]) == l) {
                object2 = this.objectKeyTable[n3];
                break;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (n3 >= 0) {
            if (bl) {
                this.objectKeyTable[n3] = null;
                this.hashIndex.unlinkNode(n2, n4, n3);
                if (this.accessTable != null) {
                    this.accessTable[n3] = 0;
                }
                if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
                    this.rehash(this.initialCapacity);
                }
            } else {
                this.objectKeyTable[n3] = object;
                if (this.isLastAccessCount) {
                    this.accessTable[n3] = this.accessCount.incrementAndGet();
                } else if (this.isAccessCount) {
                    int n5 = n3;
                    this.accessTable[n5] = this.accessTable[n5] + 1;
                }
            }
            return object2;
        }
        if (bl) {
            return null;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemoveObject(l, object, bl);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        this.objectKeyTable[n3] = object;
        if (this.isLastAccessCount) {
            this.accessTable[n3] = this.accessCount.incrementAndGet();
        } else if (this.isAccessCount) {
            this.accessTable[n3] = 1;
        }
        return object2;
    }

    protected boolean reset() {
        if (this.maxCapacity == 0 || this.maxCapacity > this.threshold) {
            this.rehash(this.hashIndex.linkTable.length * 2);
            return true;
        }
        switch (this.purgePolicy) {
            case 1: {
                this.clear();
                return true;
            }
            case 2: {
                this.clearToHalf();
                return true;
            }
        }
        return false;
    }

    protected void rehash(int n) {
        int n2 = this.hashIndex.newNodePointer;
        boolean bl = this.hasZeroKey;
        int n3 = this.zeroKeyIndex;
        if (n < this.hashIndex.elementCount) {
            return;
        }
        this.hashIndex.reset(n, n);
        this.hasZeroKey = false;
        this.zeroKeyIndex = -1;
        this.zeroOrNullValueCount = 0;
        this.threshold = n;
        int n4 = -1;
        while ((n4 = this.nextLookup(n4, n2, bl, n3)) < n2) {
            long l = 0L;
            long l2 = 0L;
            Object object = null;
            Object object2 = null;
            if (this.isObjectKey) {
                object = this.objectKeyTable[n4];
            } else {
                l = this.isIntKey ? (long)this.intKeyTable[n4] : this.longKeyTable[n4];
            }
            if (this.isObjectValue) {
                object2 = this.objectValueTable[n4];
            } else if (this.isIntValue) {
                l2 = this.intValueTable[n4];
            } else if (this.isLongValue) {
                l2 = this.longValueTable[n4];
            }
            if (this.isMultiValue) {
                this.addMultiVal(l, l2, object, object2);
            } else {
                this.addOrUpdate(l, l2, object, object2);
            }
            if (this.accessTable == null) continue;
            this.accessTable[this.hashIndex.elementCount - 1] = this.accessTable[n4];
        }
        this.resizeElementArrays(this.hashIndex.newNodePointer, n);
    }

    private void resizeElementArrays(int n, int n2) {
        Object[] objectArray;
        int n3;
        int n4 = n3 = n2 > n ? n : n2;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            this.intKeyTable = new int[n2];
            System.arraycopy(objectArray, 0, this.intKeyTable, 0, n3);
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            this.intValueTable = new int[n2];
            System.arraycopy(objectArray, 0, this.intValueTable, 0, n3);
        }
        if (this.isLongKey) {
            objectArray = this.longKeyTable;
            this.longKeyTable = new long[n2];
            System.arraycopy(objectArray, 0, this.longKeyTable, 0, n3);
        }
        if (this.isLongValue) {
            objectArray = this.longValueTable;
            this.longValueTable = new long[n2];
            System.arraycopy(objectArray, 0, this.longValueTable, 0, n3);
        }
        if (this.objectKeyTable != null) {
            objectArray = this.objectKeyTable;
            this.objectKeyTable = new Object[n2];
            System.arraycopy(objectArray, 0, this.objectKeyTable, 0, n3);
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            this.objectValueTable = new Object[n2];
            System.arraycopy(objectArray, 0, this.objectValueTable, 0, n3);
        }
        if (this.objectValueTable2 != null) {
            objectArray = this.objectValueTable2;
            this.objectValueTable2 = new Object[n2];
            System.arraycopy(objectArray, 0, this.objectValueTable2, 0, n3);
        }
        if (this.objectValueTable3 != null) {
            objectArray = this.objectValueTable3;
            this.objectValueTable3 = new Object[n2];
            System.arraycopy(objectArray, 0, this.objectValueTable3, 0, n3);
        }
        if (this.accessTable != null) {
            objectArray = this.accessTable;
            this.accessTable = new int[n2];
            System.arraycopy(objectArray, 0, this.accessTable, 0, n3);
        }
    }

    private void clearElementArrays(int n, int n2) {
        if (this.intKeyTable != null) {
            Arrays.fill(this.intKeyTable, n, n2, 0);
        } else if (this.longKeyTable != null) {
            Arrays.fill(this.longKeyTable, n, n2, 0L);
        }
        if (this.objectKeyTable != null) {
            Arrays.fill(this.objectKeyTable, n, n2, null);
        }
        if (this.intValueTable != null) {
            Arrays.fill(this.intValueTable, n, n2, 0);
        } else if (this.longValueTable != null) {
            Arrays.fill(this.longValueTable, n, n2, 0L);
        } else if (this.objectValueTable != null) {
            Arrays.fill(this.objectValueTable, n, n2, null);
        }
        if (this.objectValueTable2 != null) {
            Arrays.fill(this.objectValueTable2, n, n2, null);
        }
        if (this.objectValueTable3 != null) {
            Arrays.fill(this.objectValueTable3, n, n2, null);
        }
        if (this.accessTable != null) {
            Arrays.fill(this.accessTable, n, n2, 0);
        }
    }

    void removeFromElementArrays(int n, int n2) {
        Object[] objectArray;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2 - 1);
            this.intKeyTable[n - 1] = 0;
        } else if (this.isLongKey) {
            objectArray = this.longKeyTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2 - 1);
            this.longKeyTable[n - 1] = 0L;
        }
        if (this.objectKeyTable != null) {
            objectArray = this.objectKeyTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2 - 1);
            this.objectKeyTable[n - 1] = null;
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2 - 1);
            this.intValueTable[n - 1] = 0;
        } else if (this.isLongValue) {
            objectArray = this.longValueTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2 - 1);
            this.longValueTable[n - 1] = 0L;
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2 - 1);
            this.objectValueTable[n - 1] = null;
        }
        if (this.objectValueTable2 != null) {
            objectArray = this.objectValueTable2;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2 - 1);
            this.objectValueTable2[n - 1] = null;
        }
        if (this.objectValueTable3 != null) {
            objectArray = this.objectValueTable3;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2 - 1);
            this.objectValueTable3[n - 1] = null;
        }
        if (this.accessTable != null) {
            objectArray = this.accessTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n - n2 - 1);
            this.accessTable[n - 1] = 0;
        }
    }

    void insertIntoElementArrays(int n, int n2) {
        Object[] objectArray;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
            this.intKeyTable[n2] = 0;
        } else if (this.isLongKey) {
            objectArray = this.longKeyTable;
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
            this.longKeyTable[n2] = 0L;
        }
        if (this.objectKeyTable != null) {
            objectArray = this.objectKeyTable;
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
            this.objectKeyTable[n2] = null;
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
            this.intValueTable[n2] = 0;
        } else if (this.isLongValue) {
            objectArray = this.longValueTable;
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
            this.longValueTable[n2] = 0L;
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
            this.objectValueTable[n2] = null;
        }
        if (this.objectValueTable2 != null) {
            objectArray = this.objectValueTable2;
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
            this.objectValueTable2[n2] = null;
        }
        if (this.objectValueTable3 != null) {
            objectArray = this.objectValueTable3;
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
            this.objectValueTable3[n2] = null;
        }
        if (this.accessTable != null) {
            objectArray = this.accessTable;
            System.arraycopy(objectArray, n2, objectArray, n2 + 1, n - n2);
            this.accessTable[n2] = 0;
        }
    }

    int nextLookup(int n, int n2, boolean bl, int n3) {
        ++n;
        while (n < n2) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n] != null) {
                    return n;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n] != 0) {
                    return n;
                }
                if (bl && n == n3) {
                    return n;
                }
            } else {
                if (this.longKeyTable[n] != 0L) {
                    return n;
                }
                if (bl && n == n3) {
                    return n;
                }
            }
            ++n;
        }
        return n;
    }

    protected int nextLookup(int n) {
        ++n;
        while (n < this.hashIndex.newNodePointer) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n] != null) {
                    return n;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n] != 0) {
                    return n;
                }
                if (this.hasZeroKey && n == this.zeroKeyIndex) {
                    return n;
                }
            } else {
                if (this.longKeyTable[n] != 0L) {
                    return n;
                }
                if (this.hasZeroKey && n == this.zeroKeyIndex) {
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    protected void removeRow(int n) {
        int n2 = this.hashIndex.newNodePointer;
        if (n2 == 0) {
            return;
        }
        this.hashIndex.removeEmptyNode(n);
        this.removeFromElementArrays(n2, n);
    }

    protected void insertRow(int n) {
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
        }
        if (n == this.hashIndex.elementCount) {
            return;
        }
        int n2 = this.hashIndex.newNodePointer;
        if (n2 == 0) {
            return;
        }
        this.insertIntoElementArrays(n2, n);
        this.hashIndex.insertEmptyNode(n);
    }

    public void clear() {
        if (this.hashIndex.modified) {
            if (this.accessCount != null) {
                this.accessCount.set(0);
            }
            this.accessMin = 0;
            this.hasZeroKey = false;
            this.zeroKeyIndex = -1;
            this.zeroOrNullValueCount = 0;
            this.clearElementArrays(0, this.hashIndex.newNodePointer);
            this.hashIndex.clear();
            if (this.minimizeOnEmpty) {
                this.rehash(this.initialCapacity);
            }
        }
    }

    protected int getAccessCountCeiling(int n, int n2) {
        return ArrayCounter.rank(this.accessTable, this.hashIndex.newNodePointer, n, this.accessMin, this.accessCount.get(), n2);
    }

    protected void setAccessCountFloor(int n) {
        this.accessMin = n;
    }

    private void clearToHalf() {
        int n = this.threshold >> 1;
        int n2 = this.threshold >> 8;
        if (n2 < 64) {
            n2 = 64;
        }
        int n3 = this.hashIndex.newNodePointer;
        int n4 = this.getAccessCountCeiling(n, n2);
        for (int i = 0; i < n3; ++i) {
            Object object = this.objectKeyTable[i];
            if (object == null || this.accessTable[i] >= n4) continue;
            this.removeObject(object, false);
        }
        this.accessMin = n4;
        if (this.hashIndex.elementCount > this.threshold - n2) {
            this.clear();
        }
    }

    protected void resetAccessCount() {
        int n = this.accessCount.get();
        if (n > 0 && n < 0x7FEFFFFF) {
            return;
        }
        int n2 = this.hashIndex.getNewNodePointer();
        n = 0;
        this.accessMin = Integer.MAX_VALUE;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.accessTable[i];
            if (n3 == 0) continue;
            this.accessTable[i] = n3 = (n3 >>> 2) + 1;
            if (n3 > n) {
                n = n3;
                continue;
            }
            if (n3 >= this.accessMin) continue;
            this.accessMin = n3;
        }
        if (this.accessMin > n) {
            this.accessMin = n;
        }
        this.accessCount.set(n);
    }

    protected int capacity() {
        return this.hashIndex.linkTable.length;
    }

    public int size() {
        return this.hashIndex.elementCount;
    }

    public boolean isEmpty() {
        return this.hashIndex.elementCount == 0;
    }

    protected final boolean containsObjectKey(Object object) {
        if (object == null) {
            return false;
        }
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int n = this.getLookup(object, this.comparator.hashCode(object));
        return n != -1;
    }

    protected final boolean containsIntKey(int n) {
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int n2 = this.getLookup(n);
        return n2 != -1;
    }

    protected final boolean containsLongKey(long l) {
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int n = this.getLookup(l);
        return n != -1;
    }

    protected boolean containsValue(Object object) {
        int n;
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        if (object == null) {
            for (n = 0; n < this.hashIndex.newNodePointer; ++n) {
                if (this.objectValueTable[n] != null) continue;
                if (this.isObjectKey) {
                    if (this.objectKeyTable[n] == null) continue;
                    return true;
                }
                if (this.isIntKey) {
                    if (this.intKeyTable[n] != 0) {
                        return true;
                    }
                    if (!this.hasZeroKey || n != this.zeroKeyIndex) continue;
                    return true;
                }
                if (this.longKeyTable[n] != 0L) {
                    return true;
                }
                if (!this.hasZeroKey || n != this.zeroKeyIndex) continue;
                return true;
            }
        } else {
            while (n < this.hashIndex.newNodePointer) {
                if (object.equals(this.objectValueTable[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected boolean containsValue(int n) {
        if (n == 0) {
            return this.zeroOrNullValueCount > 0;
        }
        for (int i = 0; i < this.hashIndex.newNodePointer; ++i) {
            if (this.intValueTable[i] != n) continue;
            return true;
        }
        return false;
    }

    protected boolean containsValue(long l) {
        if (l == 0L) {
            return this.zeroOrNullValueCount > 0;
        }
        for (int i = 0; i < this.hashIndex.newNodePointer; ++i) {
            if (this.longValueTable[i] != l) continue;
            return true;
        }
        return false;
    }

    protected Object[] toArray(boolean bl) {
        Object[] objectArray = new Object[this.size()];
        return this.toArray(objectArray, bl);
    }

    protected <T> T[] multiValueKeysToArray(T[] objectArray) {
        int n = this.multiValueKeyCount();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        MultiValueKeyIterator multiValueKeyIterator = new MultiValueKeyIterator();
        int n2 = 0;
        while (multiValueKeyIterator.hasNext()) {
            objectArray[n2] = multiValueKeyIterator.next();
            ++n2;
        }
        return objectArray;
    }

    protected <T> T[] toArray(T[] objectArray, boolean bl) {
        if (objectArray.length < this.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
        }
        int n = this.hashIndex.getNewNodePointer();
        int n2 = 0;
        Object[] objectArray2 = bl ? this.objectKeyTable : this.objectValueTable;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray2[i];
            if (object == null) continue;
            objectArray[n2++] = object;
        }
        return objectArray;
    }

    protected int[] toIntArray(int[] nArray, boolean bl) {
        if (nArray.length < this.size()) {
            nArray = new int[this.size()];
        }
        BaseHashIterator baseHashIterator = new BaseHashIterator(bl);
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            nArray[i] = n = baseHashIterator.nextInt();
        }
        return nArray;
    }

    protected long[] toLongArray(long[] lArray, boolean bl) {
        if (lArray.length < this.size()) {
            lArray = new long[this.size()];
        }
        BaseHashIterator baseHashIterator = new BaseHashIterator(bl);
        for (int i = 0; i < lArray.length; ++i) {
            long l;
            lArray[i] = l = (long)baseHashIterator.nextInt();
        }
        return lArray;
    }

    public BaseHashMap clone() {
        BaseHashMap baseHashMap = null;
        try {
            baseHashMap = (BaseHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        baseHashMap.hashIndex = this.hashIndex.clone();
        if (this.intKeyTable != null) {
            baseHashMap.intKeyTable = (int[])this.intKeyTable.clone();
        }
        if (this.objectKeyTable != null) {
            baseHashMap.objectKeyTable = (Object[])this.objectKeyTable.clone();
        }
        if (this.longKeyTable != null) {
            baseHashMap.longKeyTable = (long[])this.longKeyTable.clone();
        }
        if (this.intValueTable != null) {
            baseHashMap.intValueTable = (int[])this.intValueTable.clone();
        }
        if (this.objectValueTable != null) {
            baseHashMap.objectValueTable = (Object[])this.objectValueTable.clone();
        }
        if (this.longValueTable != null) {
            baseHashMap.longValueTable = (long[])this.longValueTable.clone();
        }
        if (this.accessTable != null) {
            baseHashMap.accessTable = (int[])this.accessTable.clone();
        }
        if (this.objectValueTable2 != null) {
            baseHashMap.objectValueTable2 = (Object[])this.objectValueTable2.clone();
        }
        if (this.objectValueTable3 != null) {
            baseHashMap.objectValueTable3 = (Object[])this.objectValueTable3.clone();
        }
        return baseHashMap;
    }

    BaseHashMap duplicate() {
        return null;
    }

    protected class BaseHashIterator
    implements PrimitiveIterator {
        protected boolean keys;
        protected int lookup = -1;
        protected int counter;
        protected boolean removed;

        public BaseHashIterator() {
        }

        public BaseHashIterator(boolean bl) {
            this.keys = bl;
            if (!bl && BaseHashMap.this.isNoValue) {
                throw new RuntimeException("Hash Iterator");
            }
        }

        public void reset() {
            this.lookup = -1;
            this.counter = 0;
            this.removed = false;
        }

        @Override
        public boolean hasNext() {
            return this.counter < BaseHashMap.this.hashIndex.elementCount;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.keys) {
                if (BaseHashMap.this.isIntKey) {
                    return this.nextInt();
                }
                if (BaseHashMap.this.isLongKey) {
                    return this.nextLong();
                }
            } else {
                if (BaseHashMap.this.isIntValue) {
                    return this.nextInt();
                }
                if (BaseHashMap.this.isLongValue) {
                    return this.nextLong();
                }
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.objectKeyTable[this.lookup];
                }
                return BaseHashMap.this.objectValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isIntKey || !this.keys && !BaseHashMap.this.isIntValue) {
                throw new UnsupportedOperationException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.intKeyTable[this.lookup];
                }
                return BaseHashMap.this.intValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isLongKey || !this.keys && !BaseHashMap.this.isLongValue) {
                throw new UnsupportedOperationException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                return this.keys ? BaseHashMap.this.longKeyTable[this.lookup] : BaseHashMap.this.longValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            if (this.removed) {
                throw new NoSuchElementException("Hash Iterator");
            }
            --this.counter;
            this.removed = true;
            if (BaseHashMap.this.isObjectKey) {
                if (BaseHashMap.this.isMultiValue) {
                    BaseHashMap.this.removeMultiVal(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], BaseHashMap.this.objectValueTable[this.lookup], true);
                } else {
                    BaseHashMap.this.remove(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], null, false, true);
                }
            } else if (BaseHashMap.this.isIntKey) {
                BaseHashMap.this.remove(BaseHashMap.this.intKeyTable[this.lookup], 0L, null, null, false, true);
            } else {
                BaseHashMap.this.remove(BaseHashMap.this.longKeyTable[this.lookup], 0L, null, null, false, true);
            }
            if (BaseHashMap.this.isList) {
                --this.lookup;
            }
        }

        public int getAccessCount() {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            return BaseHashMap.this.accessTable[this.lookup];
        }

        public void setAccessCount(int n) {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            BaseHashMap.this.accessTable[this.lookup] = n;
        }

        public int getLookup() {
            return this.lookup;
        }
    }

    protected class MultiValueKeyIterator
    implements PrimitiveIterator {
        int index = 0;
        int lookup = -1;
        boolean removed;
        Object oldKey;

        public MultiValueKeyIterator() {
            if (BaseHashMap.this.hashIndex.elementCount > 0) {
                this.toNextLookup();
            }
        }

        private void toNextLookup() {
            while (this.index < BaseHashMap.this.hashIndex.hashTable.length) {
                if (BaseHashMap.this.hashIndex.hashTable[this.index] < 0) {
                    ++this.index;
                    continue;
                }
                this.lookup = this.lookup < 0 ? BaseHashMap.this.hashIndex.hashTable[this.index] : BaseHashMap.this.hashIndex.getNextLookup(this.lookup);
                if (this.lookup < 0) {
                    ++this.index;
                    continue;
                }
                if (BaseHashMap.this.comparator.equals(this.oldKey, BaseHashMap.this.objectKeyTable[this.lookup])) continue;
            }
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.lookup < 0) {
                throw new NoSuchElementException("Hash Iterator");
            }
            Object object = BaseHashMap.this.objectKeyTable[this.lookup];
            this.toNextLookup();
            this.oldKey = object;
            return object;
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            BaseHashMap.this.removeMultiVal(0L, 0L, this.oldKey, null, false);
            this.oldKey = null;
        }
    }

    protected class ValueCollectionIterator
    implements PrimitiveIterator {
        int lookup = -1;
        Object key;

        ValueCollectionIterator(Object object, int n) {
            this.key = object;
            this.lookup = n;
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            Object object;
            if (this.lookup == -1) {
                throw new NoSuchElementException();
            }
            Object object2 = BaseHashMap.this.objectValueTable[this.lookup];
            this.lookup = BaseHashMap.this.hashIndex.getNextLookup(this.lookup);
            if (this.lookup != -1 && !BaseHashMap.this.comparator.equals(object = BaseHashMap.this.objectKeyTable[this.lookup], this.key)) {
                this.lookup = -1;
            }
            return object2;
        }
    }
}

