/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import shaded.org.hsqldb.lib.IntKeyHashMap;
import shaded.org.hsqldb.lib.Map;

public class OrderedIntKeyHashMap<V>
extends IntKeyHashMap<V>
implements Map<Integer, V> {
    public OrderedIntKeyHashMap() {
        this(8);
    }

    public OrderedIntKeyHashMap(int n) throws IllegalArgumentException {
        super(n);
        this.isList = true;
    }

    public int getKeyAt(int n, int n2) {
        if (n >= 0 && n < this.size()) {
            return this.intKeyTable[n];
        }
        return n2;
    }

    public Object getValueAt(int n) {
        this.checkRange(n);
        return this.objectValueTable[n];
    }

    public Object setValueAt(int n, Object object) {
        this.checkRange(n);
        Object object2 = this.objectValueTable[n];
        this.objectValueTable[n] = object;
        return object2;
    }

    public boolean set(int n, int n2, V v) throws IndexOutOfBoundsException {
        this.checkRange(n);
        if (this.keySet().contains(n2) && this.getIndex(n2) != n) {
            return false;
        }
        super.remove(this.intKeyTable[n], 0L, null, null, false, false);
        this.put(n2, v);
        return true;
    }

    public boolean insert(int n, int n2, V v) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.getLookup(n2);
        if (n3 >= 0) {
            return false;
        }
        if (n < this.size()) {
            super.insertRow(n);
        }
        super.put(n2, v);
        return true;
    }

    public boolean setKeyAt(int n, int n2) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object = this.objectValueTable[n];
        return this.set(n, n2, object);
    }

    public int getIndex(int n) {
        return this.getLookup(n);
    }

    @Override
    public V remove(int n) {
        return (V)super.remove(n, 0L, null, null, false, true);
    }

    public void removeEntry(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        int n2 = this.intKeyTable[n];
        super.remove(n2, 0L, null, null, false, true);
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

