/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import shaded.org.hsqldb.lib.IntHashSet;

public class OrderedIntHashSet
extends IntHashSet {
    public OrderedIntHashSet() {
        this(8);
    }

    public OrderedIntHashSet(int n) throws IllegalArgumentException {
        super(n);
        this.isList = true;
    }

    public OrderedIntHashSet(int[] nArray) {
        super(nArray.length);
        this.isList = true;
        this.addAll(nArray);
    }

    public OrderedIntHashSet(int[] nArray, int[] nArray2) {
        super(nArray.length + nArray2.length);
        this.isList = true;
        this.addAll(nArray);
        this.addAll(nArray2);
    }

    public OrderedIntHashSet(int[] nArray, int[] nArray2, int[] nArray3) {
        super(nArray.length + nArray2.length + nArray3.length);
        this.isList = true;
        this.addAll(nArray);
        this.addAll(nArray2);
        this.addAll(nArray3);
    }

    public boolean insert(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(n2)) {
            return false;
        }
        if (n < this.size()) {
            super.insertRow(n);
        }
        return this.add(n2);
    }

    @Override
    public boolean remove(int n) {
        return (Boolean)super.remove(n, 0L, null, null, false, true);
    }

    public void removeEntry(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        int n2 = this.intKeyTable[n];
        super.remove(n2, 0L, null, null, false, true);
    }

    public int get(int n) {
        this.checkRange(n);
        return this.intKeyTable[n];
    }

    public int getIndex(int n) {
        return this.getLookup(n);
    }

    public int getOrderedStartMatchCount(int[] nArray) {
        int n;
        for (n = 0; n < nArray.length && n < this.size() && this.get(n) == nArray[n]; ++n) {
        }
        return n;
    }

    public boolean addAll(OrderedIntHashSet orderedIntHashSet) {
        int n = this.size();
        int n2 = orderedIntHashSet.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = orderedIntHashSet.get(i);
            this.add(n3);
        }
        return n != this.size();
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

