/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Arrays;
import shaded.org.hsqldb.lib.IntValueHashMap;

public final class ArrayUtil {
    public static final int CLASS_CODE_BYTE = 66;
    public static final int CLASS_CODE_CHAR = 67;
    public static final int CLASS_CODE_DOUBLE = 68;
    public static final int CLASS_CODE_FLOAT = 70;
    public static final int CLASS_CODE_INT = 73;
    public static final int CLASS_CODE_LONG = 74;
    public static final int CLASS_CODE_OBJECT = 76;
    public static final int CLASS_CODE_SHORT = 83;
    public static final int CLASS_CODE_BOOLEAN = 90;
    private static final IntValueHashMap<Class> classCodeMap = new IntValueHashMap(16);

    static int getClassCode(Class clazz) {
        if (!clazz.isPrimitive()) {
            return 76;
        }
        return classCodeMap.get((Object)clazz, -1);
    }

    public static void clearArray(int n, Object object, int n2, int n3) {
        switch (n) {
            case 66: {
                byte[] byArray = (byte[])object;
                Arrays.fill(byArray, n2, n3, (byte)0);
                break;
            }
            case 67: {
                char[] cArray = (char[])object;
                Arrays.fill(cArray, n2, n3, '\u0000');
                break;
            }
            case 83: {
                short[] sArray = (short[])object;
                Arrays.fill(sArray, n2, n3, (short)0);
                break;
            }
            case 73: {
                int[] nArray = (int[])object;
                Arrays.fill(nArray, n2, n3, 0);
                break;
            }
            case 74: {
                long[] lArray = (long[])object;
                Arrays.fill(lArray, n2, n3, 0L);
                break;
            }
            case 70: {
                float[] fArray = (float[])object;
                Arrays.fill(fArray, n2, n3, 0.0f);
                break;
            }
            case 68: {
                double[] dArray = (double[])object;
                Arrays.fill(dArray, n2, n3, 0.0);
                break;
            }
            case 90: {
                boolean[] blArray = (boolean[])object;
                Arrays.fill(blArray, n2, n3, false);
                break;
            }
            default: {
                Object[] objectArray = (Object[])object;
                Arrays.fill(objectArray, n2, n3, null);
                break;
            }
        }
    }

    public static void adjustArray(int n, Object object, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (n3 >= n2 || n4 == 0) {
            return;
        }
        int n8 = n2 + n4;
        if (n4 >= 0) {
            n7 = n3;
            n6 = n3 + n4;
            n5 = n2 - n3;
        } else {
            n7 = n3 - n4;
            n6 = n3;
            n5 = n2 - n3 + n4;
        }
        if (n5 > 0) {
            System.arraycopy(object, n7, object, n6, n5);
        }
        if (n4 < 0) {
            ArrayUtil.clearArray(n, object, n8, n2);
        }
    }

    public static void sortArray(int[] nArray) {
        boolean bl;
        do {
            bl = false;
            for (int i = 0; i < nArray.length - 1; ++i) {
                if (nArray[i] <= nArray[i + 1]) continue;
                int n = nArray[i + 1];
                nArray[i + 1] = nArray[i];
                nArray[i] = n;
                bl = true;
            }
        } while (bl);
    }

    public static int find(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == object) {
                return i;
            }
            if (object == null || !object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static int find(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int find(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != n2) continue;
            return i;
        }
        return -1;
    }

    public static int find(short[] sArray, int n) {
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int find(short[] sArray, int n, int n2, int n3) {
        for (int i = n2; i < n2 + n3; ++i) {
            if (sArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int find(char[] cArray, int n) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int findNot(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            return i;
        }
        return -1;
    }

    public static boolean areEqualSets(int[] nArray, int[] nArray2) {
        return nArray.length == nArray2.length && ArrayUtil.haveEqualSets(nArray, nArray2, nArray.length);
    }

    public static boolean haveEqualSets(int[] nArray, int[] nArray2, int n) {
        if (n > nArray.length || n > nArray2.length) {
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            for (int j = 0; j < n; ++j) {
                if (nArray2[j] == n2) continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(int[] nArray, int[] nArray2, int n) {
        if (n > nArray.length || n > nArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(Object[] objectArray, Object[] objectArray2, int n) {
        if (n > objectArray.length || n > objectArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == objectArray2[i] || objectArray[i] != null && objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean haveCommonElement(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length > nArray2.length) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                if (n != nArray2[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] commonElements(int[] nArray, int[] nArray2) {
        int[] nArray3 = null;
        int n = ArrayUtil.countCommonElements(nArray, nArray2);
        if (n > 0) {
            nArray3 = new int[n];
            int n2 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray[i] != nArray2[j]) continue;
                    nArray3[n2++] = nArray[i];
                }
            }
        }
        return nArray3;
    }

    public static int countCommonElements(int[] nArray, int[] nArray2) {
        int n = 0;
        if (nArray.length > nArray2.length) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        block0: for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != nArray2[j]) continue;
                ++n;
                continue block0;
            }
        }
        return n;
    }

    public static int countCommonElements(Object[] objectArray, int n, Object[] objectArray2) {
        int n2 = 0;
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < objectArray2.length; ++j) {
                if (objectArray[i] != objectArray2[j]) continue;
                ++n2;
                continue block0;
            }
        }
        return n2;
    }

    public static int countSameElements(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        int n3 = byArray.length - n;
        if (n3 > byArray2.length) {
            n3 = byArray2.length;
        }
        for (int i = 0; i < n3 && byArray[i + n] == byArray2[i]; ++i) {
            ++n2;
        }
        return n2;
    }

    public static int countSameElements(char[] cArray, int n, char[] cArray2) {
        int n2 = 0;
        int n3 = cArray.length - n;
        if (n3 > cArray2.length) {
            n3 = cArray2.length;
        }
        for (int i = 0; i < n3 && cArray[i + n] == cArray2[i]; ++i) {
            ++n2;
        }
        return n2;
    }

    public static int countSameElements(int[] nArray, int n, int[] nArray2) {
        int n2 = 0;
        int n3 = nArray.length - n;
        if (n3 > nArray2.length) {
            n3 = nArray2.length;
        }
        for (int i = 0; i < n3 && nArray[i + n] == nArray2[i]; ++i) {
            ++n2;
        }
        return n2;
    }

    public static int countSmallerElements(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            ++n2;
        }
        return n2;
    }

    public static int countSmallerEqualElements(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > n) continue;
            ++n2;
        }
        return n2;
    }

    public static int[] union(int[] nArray, int[] nArray2) {
        int n = ArrayUtil.countCommonElements(nArray, nArray2);
        if (n == nArray2.length) {
            return nArray;
        }
        if (n == nArray.length) {
            return nArray2;
        }
        int n2 = nArray.length + nArray2.length - n;
        int[] nArray3 = Arrays.copyOf(nArray, n2);
        int n3 = nArray.length;
        block0: for (int i = 0; i < nArray2.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray2[i] == nArray[j]) continue block0;
            }
            nArray3[n3++] = nArray2[i];
        }
        return nArray3;
    }

    public static int[] concat(int[] nArray, int[] nArray2) {
        int n = nArray.length + nArray2.length;
        int[] nArray3 = Arrays.copyOf(nArray, n);
        int n2 = nArray.length;
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[n2++] = nArray2[i];
        }
        return nArray3;
    }

    public static int find(byte[] byArray, int n, int n2, byte[] byArray2) {
        n2 = n2 - byArray2.length + 1;
        byte by = byArray2[0];
        for (int i = n; i < n2; ++i) {
            if (byArray[i] != by) continue;
            if (byArray2.length == 1) {
                return i;
            }
            if (!ArrayUtil.containsAt(byArray, i, byArray2)) continue;
            return i;
        }
        return -1;
    }

    public static int findNotIn(byte[] byArray, int n, int n2, byte[] byArray2) {
        block0: for (int i = n; i < n2; ++i) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i] == byArray2[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int findIn(byte[] byArray, int n, int n2, byte[] byArray2) {
        for (int i = n; i < n2; ++i) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i] != byArray2[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int find(byte[] byArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] != n3 && byArray[i] != n4) continue;
            return i;
        }
        return -1;
    }

    public static int[] booleanArrayToIntIndexes(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public static void intIndexesToBooleanArray(int[] nArray, boolean[] blArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= blArray.length) continue;
            blArray[nArray[i]] = true;
        }
    }

    public static int countStartIntIndexesInBooleanArray(int[] nArray, boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < nArray.length && blArray[nArray[i]]; ++i) {
            ++n;
        }
        return n;
    }

    public static void orBooleanArray(boolean[] blArray, boolean[] blArray2) {
        for (int i = 0; i < blArray2.length; ++i) {
            int n = i;
            blArray2[n] = blArray2[n] | blArray[i];
        }
    }

    public static boolean areAllIntIndexesAsBooleanArray(int[] nArray, boolean[] blArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (blArray[nArray[i]]) continue;
            return false;
        }
        return nArray.length == ArrayUtil.countTrueElements(blArray);
    }

    public static boolean areAllIntIndexesInBooleanArray(int[] nArray, boolean[] blArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (blArray[nArray[i]]) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyIntIndexInBooleanArray(int[] nArray, boolean[] blArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (!blArray[nArray[i]]) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllTrueElements(boolean[] blArray, boolean[] blArray2) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray2[i] || blArray[i]) continue;
            return false;
        }
        return true;
    }

    public static int countTrueElements(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    public static boolean hasNull(Object[] objectArray, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray[nArray[i]] != null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAllNull(Object[] objectArray, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray[nArray[i]] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAt(byte[] byArray, int n, byte[] byArray2) {
        return ArrayUtil.countSameElements(byArray, n, byArray2) == byArray2.length;
    }

    public static int countStartElementsAt(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        block0: for (int i = n; i < byArray.length; ++i) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i] != byArray2[j]) continue;
                ++n2;
                continue block0;
            }
        }
        return n2;
    }

    public static boolean containsAt(char[] cArray, int n, char[] cArray2) {
        return ArrayUtil.countSameElements(cArray, n, cArray2) == cArray2.length;
    }

    public static int countNonStartElementsAt(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        block0: for (int i = n; i < byArray.length; ++i) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i] == byArray2[j]) break block0;
            }
            ++n2;
        }
        return n2;
    }

    public static int copyBytes(long l, byte[] byArray, int n, int n2, long l2, byte[] byArray2, int n3) {
        if (n >= byArray.length) {
            return 0;
        }
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        if (n3 > byArray2.length) {
            n3 = byArray2.length;
        }
        if (l + (long)n >= l2 + (long)n3 || l + (long)n + (long)n2 <= l2) {
            return 0;
        }
        long l3 = l2 - l;
        long l4 = 0L;
        int n4 = n + n2;
        if (l3 >= 0L) {
            if (l3 < (long)n) {
                l3 = n;
            }
        } else {
            l4 = -l3 + (long)n;
            l3 = n;
        }
        if ((long)(n2 = n4 - (int)l3) > (long)n3 - l4) {
            n2 = n3 - (int)l4;
        }
        System.arraycopy(byArray, (int)l3, byArray2, (int)l4, n2);
        return n2;
    }

    public static byte[] copyBytes(byte[] byArray, byte[] byArray2, int n) {
        if (byArray.length + n > byArray2.length) {
            byte[] byArray3 = new byte[byArray.length + n];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            byArray2 = byArray3;
        }
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        return byArray2;
    }

    public static void copyArray(Object object, Object object2, int n) {
        System.arraycopy(object, 0, object2, 0, n);
    }

    public static void copyMoveSegment(Object object, Object object2, int n, int n2, int n3, int n4) {
        boolean bl = n2 < n4;
        int n5 = bl ? n2 : n4;
        System.arraycopy(object, 0, object2, 0, n5);
        n5 = bl ? n - n4 - n3 : n - n2 - n3;
        int n6 = bl ? n4 + n3 : n2 + n3;
        System.arraycopy(object, n6, object2, n6, n5);
        System.arraycopy(object, n2, object2, n4, n3);
        n5 = Math.abs(n2 - n4);
        n6 = bl ? n2 + n3 : n4;
        int n7 = bl ? n2 : n4 + n3;
        System.arraycopy(object, n6, object2, n7, n5);
    }

    public static int[] arraySlice(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        return nArray2;
    }

    public static void fillArray(char[] cArray, int n, char c) {
        int n2 = cArray.length;
        while (--n2 >= n) {
            cArray[n2] = c;
        }
    }

    public static void fillArray(byte[] byArray, int n, byte by) {
        int n2 = byArray.length;
        while (--n2 >= n) {
            byArray[n2] = by;
        }
    }

    public static void fillArray(Object[] objectArray, Object object) {
        int n = objectArray.length;
        while (--n >= 0) {
            objectArray[n] = object;
        }
    }

    public static void fillArray(int[] nArray, int n) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray[n2] = n;
        }
    }

    public static void fillArray(double[] dArray, double d) {
        int n = dArray.length;
        while (--n >= 0) {
            dArray[n] = d;
        }
    }

    public static void fillArray(boolean[] blArray, boolean bl) {
        int n = blArray.length;
        while (--n >= 0) {
            blArray[n] = bl;
        }
    }

    public static Object duplicateArray(Object object) {
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    public static Object resizeArrayIfDifferent(Object object, int n) {
        int n2 = Array.getLength(object);
        if (n2 == n) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        if (n2 < n) {
            n = n2;
        }
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    public static Object resizeArray(Object object, int n) {
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        int n2 = Array.getLength(object);
        if (n2 < n) {
            n = n2;
        }
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    public static <T> T[] toAdjustedArray(T[] TArray, T t) {
        int n = TArray.length;
        T[] TArray2 = Arrays.copyOf(TArray, n + 1);
        TArray2[n] = t;
        return TArray2;
    }

    public static Object toAdjustedArray(Object object, Object object2, int n, int n2) {
        int n3 = Array.getLength(object) + n2;
        Object object3 = Array.newInstance(object.getClass().getComponentType(), n3);
        ArrayUtil.copyAdjustArray(object, object3, object2, n, n2);
        return object3;
    }

    public static int[] except(int[] nArray, int[] nArray2) {
        int n = nArray.length - ArrayUtil.countCommonElements(nArray, nArray2);
        if (n == nArray.length) {
            return nArray;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (ArrayUtil.find(nArray2, nArray[i]) >= 0) continue;
            nArray3[n2++] = nArray[i];
        }
        return nArray3;
    }

    public static void copyAdjustArray(Object object, Object object2, Object object3, int n, int n2) {
        int n3 = Array.getLength(object);
        if (n < 0) {
            System.arraycopy(object, 0, object2, 0, n3);
            return;
        }
        System.arraycopy(object, 0, object2, 0, n);
        if (n2 == 0) {
            int n4 = n3 - n - 1;
            Array.set(object2, n, object3);
            if (n4 > 0) {
                System.arraycopy(object, n + 1, object2, n + 1, n4);
            }
        } else if (n2 < 0) {
            int n5 = n3 - n - 1;
            if (n5 > 0) {
                System.arraycopy(object, n + 1, object2, n, n5);
            }
        } else {
            int n6 = n3 - n;
            Array.set(object2, n, object3);
            if (n6 > 0) {
                System.arraycopy(object, n, object2, n + 1, n6);
            }
        }
    }

    public static void copyAdjustArray(Object[] objectArray, Object[] objectArray2, int[] nArray, int n) {
        if (n == 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; n2 < objectArray.length && i < objectArray2.length; ++n2, ++i) {
            if (n3 < nArray.length) {
                int n4 = nArray[n3];
                if (n > 0) {
                    if (n4 == i) {
                        ++i;
                        ++n3;
                    }
                } else if (n4 == n2) {
                    ++n2;
                    ++n3;
                }
            }
            objectArray2[i] = objectArray[n2];
        }
    }

    public static int[] toAdjustedColumnArray(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return null;
        }
        if (n < 0) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > n) {
                nArray2[n3] = nArray[i] + n2;
                ++n3;
                continue;
            }
            if (nArray[i] == n) {
                if (n2 < 0) continue;
                nArray2[n3] = nArray[i] + n2;
                ++n3;
                continue;
            }
            nArray2[n3] = nArray[i];
            ++n3;
        }
        if (nArray.length != n3) {
            int[] nArray3 = new int[n3];
            ArrayUtil.copyArray(nArray2, nArray3, n3);
            return nArray3;
        }
        return nArray2;
    }

    public static int[] toAdjustedColumnArray(int[] nArray, int[] nArray2, int n) {
        if (nArray == null) {
            return null;
        }
        int[] nArray3 = new int[nArray.length];
        if (n == 0) {
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        } else if (n < 0) {
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = ArrayUtil.countSmallerElements(nArray2, nArray[i]);
                nArray3[i] = nArray[i] - n2;
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = ArrayUtil.countSmallerEqualElements(nArray2, nArray[i]);
                nArray3[i] = nArray[i] + n3;
            }
        }
        return nArray3;
    }

    public static void projectRow(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) continue;
            objectArray2[i] = objectArray[nArray[i]];
        }
    }

    public static void projectRow(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] < 0) continue;
            nArray3[i] = nArray[nArray2[i]];
        }
    }

    public static void projectRowReverse(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) continue;
            objectArray[nArray[i]] = objectArray2[i];
        }
    }

    public static void projectMap(int[] nArray, int[] nArray2, int[] nArray3) {
        block0: for (int i = 0; i < nArray2.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray2[i] != nArray[j]) continue;
                nArray3[i] = j;
                continue block0;
            }
        }
    }

    public static void reorderMaps(int[] nArray, int[] nArray2, int[] nArray3) {
        block0: for (int i = 0; i < nArray.length; ++i) {
            for (int j = i; j < nArray2.length; ++j) {
                if (nArray[i] != nArray2[j]) continue;
                int n = nArray2[i];
                nArray2[i] = nArray2[j];
                nArray2[j] = n;
                n = nArray3[i];
                nArray3[i] = nArray3[j];
                nArray3[j] = n;
                continue block0;
            }
        }
    }

    public static void fillSequence(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
    }

    public static char[] byteArrayToChars(byte[] byArray) {
        return ArrayUtil.byteArrayToChars(byArray, byArray.length);
    }

    public static char[] byteArrayToChars(byte[] byArray, int n) {
        char[] cArray = new char[n / 2];
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)((byArray[n2] << 8) + (byArray[n2 + 1] & 0xFF));
            n2 += 2;
        }
        return cArray;
    }

    public static byte[] charArrayToBytes(char[] cArray) {
        return ArrayUtil.charArrayToBytes(cArray, cArray.length);
    }

    public static byte[] charArrayToBytes(char[] cArray, int n) {
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            byArray[n2] = (byte)(c >> 8);
            byArray[n2 + 1] = (byte)c;
            n2 += 2;
        }
        return byArray;
    }

    public static boolean isInSortedArray(char c, char[] cArray) {
        if (cArray.length == 0 || c < cArray[0] || c > cArray[cArray.length - 1]) {
            return false;
        }
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            int n3 = n + n2 >>> 1;
            if (c < cArray[n3]) {
                n2 = n3;
                continue;
            }
            if (c > cArray[n3]) {
                n = n3 + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public static boolean containsAll(Object[] objectArray, Object[] objectArray2) {
        block0: for (int i = 0; i < objectArray2.length; ++i) {
            for (int j = 0; j < objectArray.length; ++j) {
                if (objectArray2[i] == objectArray[j] || objectArray2[i].equals(objectArray[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean containsAny(Object[] objectArray, Object[] objectArray2) {
        for (int i = 0; i < objectArray2.length; ++i) {
            for (int j = 0; j < objectArray.length; ++j) {
                if (objectArray2[i] != objectArray[j] && !objectArray2[i].equals(objectArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(int[] nArray, int[] nArray2) {
        block0: for (int i = 0; i < nArray2.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray2[i] == nArray[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean containsAllAtStart(int[] nArray, int[] nArray2) {
        if (nArray2.length > nArray.length) {
            return false;
        }
        block0: for (int i = 0; i < nArray.length; ++i) {
            if (i == nArray2.length) {
                return true;
            }
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] == nArray2[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    public static byte[] toByteArray(long l, long l2) {
        byte[] byArray = new byte[16];
        int n = 0;
        while (n < 16) {
            int n2 = n == 0 ? (int)(l >>> 32) : (n == 4 ? (int)l : (n == 8 ? (int)(l2 >>> 32) : (int)l2));
            byArray[n++] = (byte)(n2 >>> 24);
            byArray[n++] = (byte)(n2 >>> 16);
            byArray[n++] = (byte)(n2 >>> 8);
            byArray[n++] = (byte)n2;
        }
        return byArray;
    }

    public static long byteSequenceToLong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            long l2 = byArray[n + i] & 0xFF;
            l += l2 << (7 - i) * 8;
        }
        return l;
    }

    public static int compare(byte[] byArray, byte[] byArray2) {
        return ArrayUtil.compare(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public static int compare(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n2;
        if (n5 > n4) {
            n5 = n4;
        }
        for (int i = 0; i < n5; ++i) {
            if (byArray[n + i] == byArray2[n3 + i]) continue;
            return (byArray[n + i] & 0xFF) > (byArray2[n3 + i] & 0xFF) ? 1 : -1;
        }
        if (n2 == n4) {
            return 0;
        }
        return n2 < n4 ? -1 : 1;
    }

    public static long getBinaryMultipleCeiling(long l, long l2) {
        long l3 = l & -l2;
        if (l3 != l) {
            l3 += l2;
        }
        return l3;
    }

    public static long getBinaryNormalisedCeiling(long l, int n) {
        long l2 = -1L << n;
        long l3 = l & l2;
        if (l3 != l) {
            l3 += 1L << n;
        }
        return l3;
    }

    public static long getBinaryNormalisedCeiling(long l) {
        long l2;
        for (l2 = 2L; l2 < l; l2 <<= 1) {
        }
        return l2;
    }

    public static boolean isTwoPower(int n, int n2) {
        for (int i = 0; i <= n2; ++i) {
            if ((n & 1) != 0) {
                return n == 1;
            }
            n >>= 1;
        }
        return false;
    }

    public static int getTwoPowerFloor(int n) {
        int n2 = ArrayUtil.getTwoPowerScale(n);
        if (n2 == 0) {
            return 0;
        }
        return 1 << n2;
    }

    public static int getTwoPowerScale(int n) {
        int n2 = 0;
        if (n == 0) {
            return 0;
        }
        for (int i = 0; i < 32; ++i) {
            if ((n & 1) != 0) {
                n2 = i;
            }
            n >>= 1;
        }
        return n2;
    }

    public static int cdiv(int n, int n2) {
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        return n3;
    }

    public static long cdiv(long l, long l2) {
        long l3 = l / l2;
        if (l % l2 != 0L) {
            ++l3;
        }
        return l3;
    }

    static {
        classCodeMap.put(Byte.TYPE, 66);
        classCodeMap.put(Character.TYPE, 83);
        classCodeMap.put(Short.TYPE, 83);
        classCodeMap.put(Integer.TYPE, 73);
        classCodeMap.put(Long.TYPE, 74);
        classCodeMap.put(Float.TYPE, 70);
        classCodeMap.put(Double.TYPE, 68);
        classCodeMap.put(Boolean.TYPE, 90);
        classCodeMap.put(Object.class, 76);
    }
}

