/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverAction;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import shaded.org.hsqldb.DatabaseURL;
import shaded.org.hsqldb.jdbc.JDBCConnection;
import shaded.org.hsqldb.jdbc.JDBCUtil;
import shaded.org.hsqldb.persist.HsqlProperties;

public class JDBCDriver
implements Driver {
    static final String conn_loginTimeout = "loginTimeout";
    public static final JDBCDriver driverInstance = new JDBCDriver();
    public final ThreadLocal<JDBCConnection> threadConnection = new ThreadLocal();

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        if (string.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length())) {
            JDBCConnection jDBCConnection = this.threadConnection.get();
            return jDBCConnection;
        }
        return JDBCDriver.getConnection(string, properties);
    }

    public static Connection getConnection(String string, Properties properties) throws SQLException {
        final HsqlProperties hsqlProperties = DatabaseURL.parseURL(string, true, false);
        if (hsqlProperties == null) {
            throw JDBCUtil.invalidArgument();
        }
        if (hsqlProperties.isEmpty()) {
            return null;
        }
        long l = 0L;
        if (properties != null) {
            l = HsqlProperties.getIntegerProperty(properties, conn_loginTimeout, 0);
        }
        hsqlProperties.addProperties(properties);
        if (l == 0L) {
            l = DriverManager.getLoginTimeout();
        }
        if (l == 0L) {
            return new JDBCConnection(hsqlProperties);
        }
        String string2 = hsqlProperties.getProperty("connection_type");
        if (DatabaseURL.isInProcessDatabaseType(string2)) {
            return new JDBCConnection(hsqlProperties);
        }
        final JDBCConnection[] jDBCConnectionArray = new JDBCConnection[1];
        final SQLException[] sQLExceptionArray = new SQLException[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    jDBCConnectionArray[0] = new JDBCConnection(hsqlProperties);
                }
                catch (SQLException sQLException) {
                    sQLExceptionArray[0] = sQLException;
                }
            }
        };
        thread.start();
        try {
            thread.join(1000L * l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (sQLExceptionArray[0] != null) {
            throw sQLExceptionArray[0];
        }
        if (jDBCConnectionArray[0] != null) {
            return jDBCConnectionArray[0];
        }
        throw JDBCUtil.sqlException(1351);
    }

    @Override
    public boolean acceptsURL(String string) {
        if (string == null) {
            return false;
        }
        if (string.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length())) {
            return true;
        }
        return string.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length());
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        if (!this.acceptsURL(string)) {
            return new DriverPropertyInfo[0];
        }
        String[] stringArray = new String[]{"true", "false"};
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[6];
        if (properties == null) {
            properties = new Properties();
        }
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("user", null);
        driverPropertyInfo.value = properties.getProperty("user");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", null);
        driverPropertyInfo.value = properties.getProperty("password");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("get_column_name", null);
        driverPropertyInfo.value = properties.getProperty("get_column_name", "true");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("ifexists", null);
        driverPropertyInfo.value = properties.getProperty("ifexists", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[3] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("default_schema", null);
        driverPropertyInfo.value = properties.getProperty("default_schema", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("shutdown", null);
        driverPropertyInfo.value = properties.getProperty("shutdown", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[5] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 7;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)JDBCUtil.notSupported();
    }

    static {
        try {
            DriverManager.registerDriver(driverInstance, new EmptyDiverAction());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class EmptyDiverAction
    implements DriverAction {
        private EmptyDiverAction() {
        }

        @Override
        public void deregister() {
        }
    }
}

