/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import shaded.org.hsqldb.jdbc.JDBCCommonDataSource;
import shaded.org.hsqldb.jdbc.JDBCDriver;
import shaded.org.hsqldb.jdbc.JDBCUtil;

public class JDBCDataSource
extends JDBCCommonDataSource
implements DataSource,
Serializable,
Referenceable,
Wrapper {
    @Override
    public Connection getConnection() throws SQLException {
        if (this.url == null) {
            throw JDBCUtil.nullArgument("url");
        }
        if (this.connectionProps == null) {
            if (this.user == null) {
                throw JDBCUtil.invalidArgument("user");
            }
            if (this.password == null) {
                throw JDBCUtil.invalidArgument("password");
            }
            return this.getConnection(this.user, this.password);
        }
        return this.getConnection(this.url, this.connectionProps);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        if (string == null) {
            throw JDBCUtil.invalidArgument("user");
        }
        if (string2 == null) {
            throw JDBCUtil.invalidArgument("password");
        }
        Properties properties = new Properties();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        properties.setProperty("loginTimeout", Integer.toString(this.loginTimeout));
        return this.getConnection(this.url, properties);
    }

    private Connection getConnection(String object, Properties properties) throws SQLException {
        if (!((String)object).startsWith("jdbc:hsqldb:")) {
            object = "jdbc:hsqldb:" + (String)object;
        }
        return JDBCDriver.getConnection((String)object, properties);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public Reference getReference() throws NamingException {
        String string = "shaded.org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("database", this.getDatabase()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.password));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return reference;
    }
}

