/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.ColumnSchema;
import shaded.org.hsqldb.Database;
import shaded.org.hsqldb.Expression;
import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.ParserDQL;
import shaded.org.hsqldb.QueryExpression;
import shaded.org.hsqldb.QuerySpecification;
import shaded.org.hsqldb.Row;
import shaded.org.hsqldb.Scanner;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.TableUtil;
import shaded.org.hsqldb.View;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.ArrayUtil;
import shaded.org.hsqldb.lib.OrderedHashMap;
import shaded.org.hsqldb.navigator.RowIterator;
import shaded.org.hsqldb.navigator.RowSetNavigatorData;
import shaded.org.hsqldb.navigator.RowSetNavigatorDataTable;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.result.Result;
import shaded.org.hsqldb.types.Type;

public class TableDerived
extends Table {
    public static final TableDerived[] emptyArray = new TableDerived[0];
    QueryExpression queryExpression;
    Expression dataExpression;
    boolean uniqueRows;
    boolean uniquePredicate;
    String sql;
    View view;
    int depth;
    boolean canRecompile = false;

    public TableDerived(Database database, HsqlNameManager.HsqlName hsqlName, int n) {
        super(database, hsqlName, n);
        switch (n) {
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName hsqlName, int n, HsqlNameManager.HsqlName[] hsqlNameArray, Type[] typeArray) {
        this(database, hsqlName, n);
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            ColumnSchema columnSchema = new ColumnSchema(hsqlNameArray[i], typeArray[i]);
            this.columnList.add(columnSchema.getName().name, columnSchema);
        }
        this.columnCount = hsqlNameArray.length;
        this.createPrimaryKey(null, null, false);
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName hsqlName, int n, Type[] typeArray, OrderedHashMap<String, ColumnSchema> orderedHashMap, int[] nArray) {
        this(database, hsqlName, n);
        this.colTypes = typeArray;
        this.columnList = orderedHashMap;
        this.columnCount = orderedHashMap.size();
        this.createPrimaryKey(null, nArray, true);
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName hsqlName, int n, QueryExpression queryExpression, Expression expression, int n2, int n3) {
        super(database, hsqlName, n);
        switch (n) {
            case 2: 
            case 8: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
        this.queryExpression = queryExpression;
        this.dataExpression = expression;
        this.depth = n3;
        switch (n2) {
            case 55: {
                queryExpression.setSingleRow();
                break;
            }
            case 54: {
                if (queryExpression != null) {
                    queryExpression.setFullOrder();
                }
                this.uniqueRows = true;
                break;
            }
            case 66: {
                queryExpression.setFullOrder();
                this.uniquePredicate = true;
                break;
            }
            case 68: {
                queryExpression.setFullOrder();
                break;
            }
        }
        if (expression != null) {
            expression.table = this;
        }
    }

    public TableDerived newDerivedTable(Session session, ParserDQL.CompileContext compileContext) {
        TableDerived tableDerived = this;
        if (this.isRecompiled()) {
            ParserDQL parserDQL = new ParserDQL(session, new Scanner(), compileContext);
            parserDQL.compileContext.setCurrentSubquery(this.tableName);
            parserDQL.reset(session, this.sql);
            parserDQL.read();
            tableDerived = parserDQL.XreadSubqueryTableBody(this.tableName, 23);
            tableDerived.queryExpression.resolve(session, parserDQL.compileContext.getOuterRanges(), null);
            tableDerived.columnList = this.columnList;
            tableDerived.columnCount = this.columnList.size();
            tableDerived.triggerList = this.triggerList;
            tableDerived.triggerLists = this.triggerLists;
            tableDerived.view = this.view;
            tableDerived.createPrimaryKey();
        }
        return tableDerived;
    }

    @Override
    public long getId() {
        return 0L;
    }

    @Override
    public boolean isQueryBased() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        if (this.view != null && this.view.isTriggerInsertable) {
            return false;
        }
        return this.queryExpression != null && this.queryExpression.isInsertable();
    }

    @Override
    public boolean isUpdatable() {
        if (this.view != null && this.view.isTriggerUpdatable) {
            return false;
        }
        return this.queryExpression != null && this.queryExpression.isUpdatable();
    }

    @Override
    public int[] getUpdatableColumns() {
        if (this.queryExpression != null) {
            return this.queryExpression.getBaseTableColumnMap();
        }
        return this.defaultColumnMap;
    }

    @Override
    public boolean isTriggerInsertable() {
        if (this.view != null) {
            return this.view.isTriggerInsertable;
        }
        return false;
    }

    @Override
    public boolean isTriggerUpdatable() {
        if (this.view != null) {
            return this.view.isTriggerUpdatable;
        }
        return false;
    }

    @Override
    public boolean isTriggerDeletable() {
        if (this.view != null) {
            return this.view.isTriggerDeletable;
        }
        return false;
    }

    @Override
    public Table getBaseTable() {
        return this.queryExpression == null ? this : this.queryExpression.getBaseTable();
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.queryExpression == null ? null : this.queryExpression.getBaseTableColumnMap();
    }

    @Override
    public QueryExpression getQueryExpression() {
        return this.queryExpression;
    }

    @Override
    public Expression getDataExpression() {
        return this.dataExpression;
    }

    @Override
    public void prepareTable(Session session) {
        if (this.columnCount > 0) {
            return;
        }
        if (this.dataExpression != null && this.columnCount == 0) {
            TableUtil.addAutoColumns(this, this.dataExpression.nodeDataTypes);
            this.setTableIndexesForSubquery(session);
        }
        if (this.queryExpression != null) {
            this.columnList = this.queryExpression.getColumns();
            this.columnCount = this.queryExpression.getColumnCount();
            this.setTableIndexesForSubquery(session);
        }
    }

    public void prepareTable(Session session, HsqlNameManager.HsqlName[] hsqlNameArray) {
        this.prepareTable(session);
        if (hsqlNameArray != null) {
            if (hsqlNameArray.length != this.columnList.size()) {
                throw Error.error(5593);
            }
            OrderedHashMap<String, ColumnSchema> orderedHashMap = new OrderedHashMap<String, ColumnSchema>();
            for (int i = 0; i < this.columnCount; ++i) {
                ColumnSchema columnSchema = (ColumnSchema)this.columnList.get(i);
                columnSchema.setName(hsqlNameArray[i]);
                orderedHashMap.add(hsqlNameArray[i].name, columnSchema);
            }
            this.columnList = orderedHashMap;
        }
    }

    private void setTableIndexesForSubquery(Session session) {
        int[] nArray = null;
        boolean bl = false;
        if (this.queryExpression != null && this.queryExpression.fullIndex != null) {
            bl = true;
        }
        if (bl || this.uniqueRows || this.uniquePredicate) {
            nArray = new int[this.getColumnCount()];
            ArrayUtil.fillSequence(nArray);
        }
        int[] nArray2 = (int[])(this.uniqueRows ? nArray : null);
        this.createPrimaryKey(null, nArray2, false);
        if (this.uniqueRows) {
            this.fullIndex = this.getPrimaryIndex();
        } else if (this.uniquePredicate || bl) {
            this.fullIndex = this.createIndexForColumns(session, nArray);
        }
    }

    void setCorrelated() {
        if (this.dataExpression != null) {
            this.dataExpression.isCorrelated = true;
        }
        if (this.queryExpression != null) {
            this.queryExpression.isCorrelated = true;
        }
    }

    boolean isCorrelated() {
        if (this.dataExpression != null) {
            return this.dataExpression.isCorrelated;
        }
        if (this.queryExpression != null) {
            return this.queryExpression.isCorrelated;
        }
        return false;
    }

    boolean hasUniqueNotNullRows(Session session) {
        return this.getNavigator(session).hasUniqueNotNullRows();
    }

    void resetToView() {
        this.queryExpression = this.view.getQueryExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void materialise(Session session) {
        session.sessionContext.pushStatementState();
        try {
            if (this.dataExpression != null) {
                PersistentStore persistentStore = session.sessionData.getSubqueryRowStore(this);
                this.dataExpression.insertValuesIntoSubqueryTable(session, persistentStore);
                return;
            }
            if (this.queryExpression == null) {
                return;
            }
            Result result = this.queryExpression.getResult(session, 0);
            if (this.uniqueRows) {
                RowSetNavigatorData rowSetNavigatorData = (RowSetNavigatorData)result.getNavigator();
                rowSetNavigatorData.removeDuplicates();
            }
            PersistentStore persistentStore = session.sessionData.getSubqueryRowStore(this);
            this.insertResult(session, persistentStore, result);
            result.getNavigator().release();
        }
        finally {
            session.sessionContext.popStatementState();
        }
    }

    @Override
    public void materialiseCorrelated(Session session) {
        if (this.isCorrelated()) {
            this.materialise(session);
        }
    }

    public boolean isRecompiled() {
        if (this.canRecompile && this.queryExpression instanceof QuerySpecification) {
            QuerySpecification querySpecification = (QuerySpecification)this.queryExpression;
            return !querySpecification.isAggregated && !querySpecification.isGrouped && !querySpecification.isOrderSensitive;
        }
        return false;
    }

    public Object[] getValues(Session session) {
        RowIterator rowIterator = this.rowIterator(session);
        if (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            if (rowIterator.next()) {
                throw Error.error(3201);
            }
            return row.getData();
        }
        return new Object[this.getColumnCount()];
    }

    public Object getValue(Session session) {
        Object[] objectArray = this.getValues(session);
        return objectArray[0];
    }

    public RowSetNavigatorData getNavigator(Session session) {
        RowSetNavigatorDataTable rowSetNavigatorDataTable = new RowSetNavigatorDataTable(session, this);
        return rowSetNavigatorDataTable;
    }

    public void setSQL(String string) {
        this.sql = string;
    }
}

