/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.ParserDQL;
import shaded.org.hsqldb.QueryExpression;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.StatementDMQL;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.OrderedHashSet;
import shaded.org.hsqldb.result.Result;
import shaded.org.hsqldb.result.ResultMetaData;

public class StatementQuery
extends StatementDMQL {
    public static final StatementQuery[] emptyArray = new StatementQuery[0];

    StatementQuery(Session session, QueryExpression queryExpression, ParserDQL.CompileContext compileContext) {
        super(44, 2003, session.getCurrentSchemaHsqlName());
        this.statementReturnType = 2;
        this.queryExpression = queryExpression;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        Result result = this.queryExpression.getResult(session, session.getMaxRows());
        result.setStatement(this);
        return result;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 44: 
            case 70: {
                return this.queryExpression.getMetaData();
            }
        }
        throw Error.runtimeError(201, "StatementQuery.getResultMetaData()");
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        int n;
        this.queryExpression.getBaseTableNames(orderedHashSet);
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll((HsqlNameManager.HsqlName[])this.routines[n].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        if (this.queryExpression.isUpdatable) {
            this.queryExpression.getBaseTableNames(orderedHashSet);
        }
    }

    @Override
    public int getResultProperties() {
        return this.queryExpression.isUpdatable ? 8 : 0;
    }

    public void setCursorName(HsqlNameManager.HsqlName hsqlName) {
        this.cursorName = hsqlName;
    }

    public HsqlNameManager.HsqlName getCursorName() {
        return this.cursorName;
    }
}

