/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.RowAction;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.Table;
import shaded.org.hsqldb.TableBase;
import shaded.org.hsqldb.lib.LongLookup;
import shaded.org.hsqldb.persist.CachedObject;
import shaded.org.hsqldb.persist.PersistentStore;
import shaded.org.hsqldb.rowio.RowInputInterface;
import shaded.org.hsqldb.rowio.RowOutputInterface;
import shaded.org.hsqldb.types.DateTimeType;
import shaded.org.hsqldb.types.TimestampData;

public class Row
implements CachedObject {
    long position;
    Object[] rowData;
    public volatile RowAction rowAction;
    protected TableBase table;

    public RowAction getAction() {
        return this.rowAction;
    }

    public Row(TableBase tableBase, Object[] objectArray) {
        this.table = tableBase;
        this.rowData = objectArray;
    }

    public Object getField(int n) {
        return this.rowData[n];
    }

    public Object[] getData() {
        return this.rowData;
    }

    public Object[] getDataCopy() {
        Object[] objectArray = new Object[this.rowData.length];
        Object[] objectArray2 = this.getData();
        System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        return objectArray;
    }

    boolean isDeleted(Session session, PersistentStore persistentStore) {
        Row row = (Row)persistentStore.get((CachedObject)this, false);
        if (row == null) {
            return true;
        }
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            return false;
        }
        return !rowAction.canRead(session, 0, null);
    }

    public TimestampData getSystemStartVersion() {
        if (this.table.isSystemVersioned) {
            TimestampData timestampData = (TimestampData)this.getField(((Table)this.table).systemPeriodStartColumn);
            return timestampData;
        }
        return DateTimeType.epochTimestamp;
    }

    public TimestampData getSystemEndVersion() {
        if (this.table.isSystemVersioned) {
            TimestampData timestampData = (TimestampData)this.getField(((Table)this.table).systemPeriodEndColumn);
            return timestampData;
        }
        return DateTimeType.epochLimitTimestamp;
    }

    public boolean isCurrentSystemVersion() {
        if (this.table.isSystemVersioned) {
            TimestampData timestampData = (TimestampData)this.getField(((Table)this.table).systemPeriodEndColumn);
            return DateTimeType.epochLimitSeconds == timestampData.getSeconds();
        }
        return true;
    }

    @Override
    public void setStorageSize(int n) {
    }

    @Override
    public int getStorageSize() {
        return 0;
    }

    @Override
    public final boolean isInvariable() {
        return false;
    }

    @Override
    public final boolean isBlock() {
        return false;
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public void updateAccessCount(int n) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public long getPos() {
        return this.position;
    }

    public long getId() {
        return (this.table.getId() << 40) + this.position;
    }

    @Override
    public void setPos(long l) {
        this.position = l;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void setChanged(boolean bl) {
    }

    @Override
    public boolean isKeepInMemory() {
        return true;
    }

    @Override
    public boolean keepInMemory(boolean bl) {
        return true;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public void setInMemory(boolean bl) {
    }

    public void delete(PersistentStore persistentStore) {
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return 0;
    }

    public TableBase getTable() {
        return this.table;
    }

    @Override
    public int getDefaultCapacity() {
        return 0;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Row) {
            return ((Row)object).table == this.table && ((Row)object).position == this.position;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.position;
    }
}

