/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.SchemaObject;
import shaded.org.hsqldb.lib.OrderedHashSet;
import shaded.org.hsqldb.rights.Grantee;

public class ReferenceObject
implements SchemaObject {
    HsqlNameManager.HsqlName name;
    HsqlNameManager.HsqlName target;

    public ReferenceObject(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        this.name = hsqlName;
        this.target = hsqlName2;
    }

    @Override
    public int getType() {
        return 29;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet<HsqlNameManager.HsqlName> getReferences() {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
        orderedHashSet.add(this.target);
        return orderedHashSet;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("CREATE").append(' ').append("SYNONYM").append(' ').append(this.name.getSchemaQualifiedStatementName()).append(' ').append("FOR").append(' ').append(this.target.getSchemaQualifiedStatementName());
        return stringBuilder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public HsqlNameManager.HsqlName getTarget() {
        return this.target;
    }
}

