/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import shaded.io.github.spannm.jackcess.Table;
import shaded.io.github.spannm.jackcess.impl.ColumnImpl;
import shaded.io.github.spannm.jackcess.util.ColumnMatcher;
import shaded.io.github.spannm.jackcess.util.SimpleColumnMatcher;

public class CaseInsensitiveColumnMatcher
implements ColumnMatcher {
    public static final CaseInsensitiveColumnMatcher INSTANCE = new CaseInsensitiveColumnMatcher();

    @Override
    public boolean matches(Table table, String columnName, Object value1, Object value2) {
        if (!table.getColumn(columnName).getType().isTextual()) {
            return SimpleColumnMatcher.INSTANCE.matches(table, columnName, value1, value2);
        }
        try {
            CharSequence cs1 = ColumnImpl.toCharSequence(value1);
            CharSequence cs2 = ColumnImpl.toCharSequence(value2);
            return cs1 == cs2 || cs1 != null && cs2 != null && cs1.toString().equalsIgnoreCase(cs2.toString());
        }
        catch (IOException _ex) {
            throw new UncheckedIOException("Could not read column " + columnName + " value", _ex);
        }
    }
}

