/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.query;

import java.util.List;
import shaded.io.github.spannm.jackcess.impl.query.QueryFormat;
import shaded.io.github.spannm.jackcess.impl.query.QueryImpl;
import shaded.io.github.spannm.jackcess.query.Query;
import shaded.io.github.spannm.jackcess.query.UnionQuery;

public class UnionQueryImpl
extends QueryImpl
implements UnionQuery {
    public UnionQueryImpl(String name, List<QueryImpl.Row> rows, int objectId, int objectFlag) {
        super(name, rows, objectId, objectFlag, Query.Type.UNION);
    }

    @Override
    public String getUnionType() {
        return this.hasFlag(2) ? "" : "ALL";
    }

    @Override
    public String getUnionString1() {
        return this.getUnionString("X7YZ_____1");
    }

    @Override
    public String getUnionString2() {
        return this.getUnionString("X7YZ_____2");
    }

    @Override
    public List<String> getOrderings() {
        return super.getOrderings();
    }

    private String getUnionString(String id) {
        for (QueryImpl.Row row : this.getTableRows()) {
            if (!id.equals(row._name2)) continue;
            return UnionQueryImpl.cleanUnionString(row._expression);
        }
        throw new IllegalStateException("Could not find union query with id " + id);
    }

    @Override
    protected void toSQLString(StringBuilder builder) {
        builder.append(this.getUnionString1()).append(QueryFormat.NEWLINE).append("UNION ");
        String unionType = this.getUnionType();
        if (!"".equals(unionType)) {
            builder.append(unionType).append(' ');
        }
        builder.append(this.getUnionString2());
        List<String> orderings = this.getOrderings();
        if (!orderings.isEmpty()) {
            builder.append(QueryFormat.NEWLINE).append("ORDER BY ").append(orderings);
        }
    }

    private static String cleanUnionString(String str) {
        return str.trim().replaceAll("[\r\n]+", QueryFormat.NEWLINE);
    }
}

