/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import shaded.io.github.spannm.jackcess.expr.EvalException;
import shaded.io.github.spannm.jackcess.expr.LocaleContext;
import shaded.io.github.spannm.jackcess.expr.Value;
import shaded.io.github.spannm.jackcess.impl.expr.BaseValue;
import shaded.io.github.spannm.jackcess.impl.expr.DefaultDateFunctions;
import shaded.io.github.spannm.jackcess.impl.expr.ValueSupport;
import shaded.io.github.spannm.jackcess.util.StringUtil;

public class StringValue
extends BaseValue {
    private static final Object NOT_A_NUMBER = new Object();
    private final String val;
    private Object num;

    public StringValue(String _val) {
        this.val = _val;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.STRING;
    }

    @Override
    public Object get() {
        return this.val;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return true;
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return this.val;
    }

    @Override
    public Integer getAsLongInt(LocaleContext ctx) {
        return this.roundToLongInt(ctx);
    }

    @Override
    public Double getAsDouble(LocaleContext ctx) {
        return this.getNumber(ctx).doubleValue();
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return this.getNumber(ctx);
    }

    @Override
    public Value getAsDateTimeValue(LocaleContext ctx) {
        Value dateValue = DefaultDateFunctions.stringToDateValue(ctx, this.val);
        if (dateValue == null) {
            try {
                dateValue = DefaultDateFunctions.numberToDateValue(this.getNumber(ctx).doubleValue());
            }
            catch (EvalException evalException) {
                // empty catch block
            }
            if (dateValue == null) {
                throw this.invalidConversion(Value.Type.DATE_TIME);
            }
        }
        return dateValue;
    }

    protected BigDecimal getNumber(LocaleContext ctx) {
        if (this.num instanceof BigDecimal) {
            return (BigDecimal)this.num;
        }
        if (this.num == null) {
            try {
                String tmpVal = this.val.trim();
                if (!tmpVal.isEmpty()) {
                    if (tmpVal.charAt(0) != '&') {
                        tmpVal = StringValue.toCanonicalNumberFormat(ctx, tmpVal);
                        this.num = ValueSupport.normalize(new BigDecimal(tmpVal));
                        return (BigDecimal)this.num;
                    }
                    if (ValueSupport.HEX_PAT.matcher(tmpVal).matches()) {
                        return this.parseIntegerString(tmpVal, 16);
                    }
                    if (ValueSupport.OCTAL_PAT.matcher(tmpVal).matches()) {
                        return this.parseIntegerString(tmpVal, 8);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.num = NOT_A_NUMBER;
        }
        throw this.invalidConversion(Value.Type.DOUBLE);
    }

    private BigDecimal parseIntegerString(String tmpVal, int radix) {
        this.num = new BigDecimal(ValueSupport.parseIntegerString(tmpVal, radix));
        return (BigDecimal)this.num;
    }

    private static String toCanonicalNumberFormat(LocaleContext ctx, String tmpVal) {
        DecimalFormatSymbols syms = ctx.getNumericConfig().getDecimalFormatSymbols();
        char groupSepChar = syms.getGroupingSeparator();
        tmpVal = StringUtil.remove(tmpVal, String.valueOf(groupSepChar));
        char decSepChar = syms.getDecimalSeparator();
        if (decSepChar != '.' && tmpVal.indexOf(decSepChar) >= 0) {
            tmpVal = tmpVal.replace(decSepChar, '.');
        }
        return tmpVal;
    }
}

