/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class RandomContext {
    private Source defRnd;
    private Map<Integer, Source> rnds;
    private float lastVal = 0.01953125f;

    public float getRandom(Integer _seed) {
        Source rnd;
        if (_seed == null) {
            if (this.defRnd == null) {
                this.defRnd = new SimpleSource(RandomContext.createRandom(System.currentTimeMillis()));
            }
            return this.defRnd.get();
        }
        if (this.rnds == null) {
            this.rnds = new HashMap<Integer, Source>();
        }
        if ((rnd = this.rnds.get(_seed)) == null) {
            int seedInt = _seed;
            rnd = seedInt > 0 ? new SimpleSource(RandomContext.createRandom(seedInt)) : (seedInt < 0 ? new ResetSource(RandomContext.createRandom(seedInt)) : new LastValSource());
            this.rnds.put(_seed, rnd);
        }
        return rnd.get();
    }

    private float withLast(float _lastVal) {
        this.lastVal = _lastVal;
        return _lastVal;
    }

    private void reset() {
        if (this.rnds != null) {
            this.rnds.clear();
        }
    }

    private static Random createRandom(long seed) {
        return new Random(seed);
    }

    private abstract class Source {
        private Source() {
        }

        public float get() {
            return RandomContext.this.withLast(this.getImpl());
        }

        protected abstract float getImpl();
    }

    private class SimpleSource
    extends Source {
        private final Random mrnd;

        private SimpleSource(Random _rnd) {
            this.mrnd = _rnd;
        }

        @Override
        protected float getImpl() {
            return this.mrnd.nextFloat();
        }
    }

    private class ResetSource
    extends Source {
        private final float mval;

        private ResetSource(Random _rnd) {
            this.mval = _rnd.nextFloat();
        }

        @Override
        protected float getImpl() {
            RandomContext.this.reset();
            return this.mval;
        }
    }

    private class LastValSource
    extends Source {
        private LastValSource() {
        }

        @Override
        protected float getImpl() {
            return RandomContext.this.lastVal;
        }
    }
}

