/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.math.BigDecimal;
import shaded.io.github.spannm.jackcess.expr.LocaleContext;
import shaded.io.github.spannm.jackcess.expr.Value;
import shaded.io.github.spannm.jackcess.impl.expr.BaseNumericValue;

public class LongValue
extends BaseNumericValue {
    private final Integer val;

    public LongValue(Integer _val) {
        this.val = _val;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.LONG;
    }

    @Override
    public Object get() {
        return this.val;
    }

    @Override
    protected Number getNumber() {
        return this.val;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return this.val.longValue() != 0L;
    }

    @Override
    public Integer getAsLongInt(LocaleContext ctx) {
        return this.val;
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return BigDecimal.valueOf(this.val.intValue());
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return this.val.toString();
    }
}

