/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.util.Arrays;
import shaded.io.github.spannm.jackcess.expr.EvalContext;
import shaded.io.github.spannm.jackcess.expr.EvalException;
import shaded.io.github.spannm.jackcess.expr.Function;
import shaded.io.github.spannm.jackcess.expr.LocaleContext;
import shaded.io.github.spannm.jackcess.expr.Value;

public class FunctionSupport {
    private static final char NON_VAR_SUFFIX = '$';

    private FunctionSupport() {
    }

    public static boolean getOptionalBooleanParam(LocaleContext ctx, Value[] params, int idx) {
        return params.length > idx && params[idx].getAsBoolean(ctx);
    }

    public static double getOptionalDoubleParam(EvalContext ctx, Value[] params, int idx, double defValue) {
        return params.length > idx ? params[idx].getAsDouble(ctx) : defValue;
    }

    public static int getOptionalIntParam(LocaleContext ctx, Value[] params, int idx, int defValue) {
        return FunctionSupport.getOptionalIntParam(ctx, params, idx, defValue, defValue);
    }

    public static int getOptionalIntParam(LocaleContext ctx, Value[] params, int idx, int defValue, int useDefValue) {
        int val = defValue;
        if (params.length > idx && (val = params[idx].getAsLongInt(ctx).intValue()) == useDefValue) {
            val = defValue;
        }
        return val;
    }

    public static class StringFuncWrapper
    implements Function {
        private final String mname;
        private final Function mdelegate;

        public StringFuncWrapper(Function _delegate) {
            this.mdelegate = _delegate;
            this.mname = this.mdelegate.getName() + "$";
        }

        @Override
        public String getName() {
            return this.mname;
        }

        @Override
        public boolean isPure() {
            return this.mdelegate.isPure();
        }

        @Override
        public Value eval(EvalContext ctx, Value ... params) {
            Value result = this.mdelegate.eval(ctx, params);
            if (result.isNull()) {
                result.getAsString(ctx);
            }
            return result;
        }

        public String toString() {
            return this.getName() + "()";
        }
    }

    public static abstract class FuncVar
    extends BaseFunction {
        protected FuncVar(String name) {
            super(name, 0, Integer.MAX_VALUE);
        }

        protected FuncVar(String name, int minParams, int maxParams) {
            super(name, minParams, maxParams);
        }

        @Override
        public final Value eval(EvalContext ctx, Value ... params) {
            try {
                this.validateNumParams(params);
                return this.evalVar(ctx, params);
            }
            catch (Exception _ex) {
                throw this.invalidFunctionCall(_ex, params);
            }
        }

        protected abstract Value evalVar(EvalContext var1, Value[] var2);
    }

    public static abstract class Func3
    extends BaseFunction {
        protected Func3(String name) {
            super(name, 3, 3);
        }

        @Override
        public final Value eval(EvalContext ctx, Value ... params) {
            try {
                this.validateNumParams(params);
                return this.eval3(ctx, params[0], params[1], params[2]);
            }
            catch (Exception _ex) {
                throw this.invalidFunctionCall(_ex, params);
            }
        }

        protected abstract Value eval3(EvalContext var1, Value var2, Value var3, Value var4);
    }

    public static abstract class Func2
    extends BaseFunction {
        protected Func2(String name) {
            super(name, 2, 2);
        }

        @Override
        public final Value eval(EvalContext ctx, Value ... params) {
            try {
                this.validateNumParams(params);
                return this.eval2(ctx, params[0], params[1]);
            }
            catch (Exception _ex) {
                throw this.invalidFunctionCall(_ex, params);
            }
        }

        protected abstract Value eval2(EvalContext var1, Value var2, Value var3);
    }

    public static abstract class Func1NullIsNull
    extends BaseFunction {
        protected Func1NullIsNull(String name) {
            super(name, 1, 1);
        }

        @Override
        public final Value eval(EvalContext ctx, Value ... params) {
            try {
                this.validateNumParams(params);
                Value param1 = params[0];
                if (param1.isNull()) {
                    return param1;
                }
                return this.eval1(ctx, param1);
            }
            catch (Exception _ex) {
                throw this.invalidFunctionCall(_ex, params);
            }
        }

        protected abstract Value eval1(EvalContext var1, Value var2);
    }

    public static abstract class Func1
    extends BaseFunction {
        protected Func1(String name) {
            super(name, 1, 1);
        }

        @Override
        public final Value eval(EvalContext ctx, Value ... params) {
            try {
                this.validateNumParams(params);
                return this.eval1(ctx, params[0]);
            }
            catch (Exception _ex) {
                throw this.invalidFunctionCall(_ex, params);
            }
        }

        protected abstract Value eval1(EvalContext var1, Value var2);
    }

    public static abstract class Func0
    extends BaseFunction {
        protected Func0(String name) {
            super(name, 0, 0);
        }

        @Override
        public boolean isPure() {
            return false;
        }

        @Override
        public final Value eval(EvalContext ctx, Value ... params) {
            try {
                this.validateNumParams(params);
                return this.eval0(ctx);
            }
            catch (Exception _ex) {
                throw this.invalidFunctionCall(_ex, params);
            }
        }

        protected abstract Value eval0(EvalContext var1);
    }

    public static abstract class BaseFunction
    implements Function {
        private final String _name;
        private final int _minParams;
        private final int _maxParams;

        protected BaseFunction(String name, int minParams, int maxParams) {
            this._name = name;
            this._minParams = minParams;
            this._maxParams = maxParams;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public boolean isPure() {
            return true;
        }

        protected void validateNumParams(Value[] params) {
            int num = params.length;
            if (num < this._minParams || num > this._maxParams) {
                String range = this._minParams == this._maxParams ? "" + this._minParams : this._minParams + " to " + this._maxParams;
                throw new EvalException("Invalid number of parameters " + num + " passed, expected " + range);
            }
        }

        protected EvalException invalidFunctionCall(Throwable t, Value[] params) {
            String paramStr = Arrays.toString(params);
            String msg = "Invalid function call {" + this._name + "(" + paramStr.substring(1, paramStr.length() - 1) + ")}";
            return new EvalException(msg, t);
        }

        public String toString() {
            return this.getName() + "()";
        }
    }
}

