/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.math.BigDecimal;
import shaded.io.github.spannm.jackcess.expr.EvalContext;
import shaded.io.github.spannm.jackcess.expr.EvalException;
import shaded.io.github.spannm.jackcess.expr.Function;
import shaded.io.github.spannm.jackcess.expr.Value;
import shaded.io.github.spannm.jackcess.impl.expr.DefaultFunctions;
import shaded.io.github.spannm.jackcess.impl.expr.FunctionSupport;
import shaded.io.github.spannm.jackcess.impl.expr.NumberFormatter;
import shaded.io.github.spannm.jackcess.impl.expr.ValueSupport;

public class DefaultNumberFunctions {
    public static final Function ABS = DefaultFunctions.registerFunc(new FunctionSupport.Func1NullIsNull("Abs"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            Value.Type mathType = param1.getType();
            switch (mathType) {
                case DATE: 
                case TIME: 
                case DATE_TIME: {
                    double result = Math.abs(param1.getAsDouble(ctx));
                    return ValueSupport.toDateValueIfPossible(mathType, result);
                }
                case LONG: {
                    return ValueSupport.toValue(Math.abs(param1.getAsLongInt(ctx)));
                }
                case DOUBLE: {
                    return ValueSupport.toValue(Math.abs(param1.getAsDouble(ctx)));
                }
                case STRING: 
                case BIG_DEC: {
                    return ValueSupport.toValue(param1.getAsBigDecimal(ctx).abs(NumberFormatter.DEC_MATH_CONTEXT));
                }
            }
            throw new EvalException("Unexpected type " + String.valueOf((Object)mathType));
        }
    });
    public static final Function ATAN = DefaultFunctions.registerFunc(new FunctionSupport.Func1("Atan"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            return ValueSupport.toValue(Math.atan(param1.getAsDouble(ctx)));
        }
    });
    public static final Function COS = DefaultFunctions.registerFunc(new FunctionSupport.Func1("Cos"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            return ValueSupport.toValue(Math.cos(param1.getAsDouble(ctx)));
        }
    });
    public static final Function EXP = DefaultFunctions.registerFunc(new FunctionSupport.Func1("Exp"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            return ValueSupport.toValue(Math.exp(param1.getAsDouble(ctx)));
        }
    });
    public static final Function FIX = DefaultFunctions.registerFunc(new FunctionSupport.Func1NullIsNull("Fix"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            if (param1.getType().isIntegral()) {
                return param1;
            }
            return ValueSupport.toValue(param1.getAsDouble(ctx).intValue());
        }
    });
    public static final Function INT = DefaultFunctions.registerFunc(new FunctionSupport.Func1NullIsNull("Int"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            if (param1.getType().isIntegral()) {
                return param1;
            }
            return ValueSupport.toValue((int)Math.floor(param1.getAsDouble(ctx)));
        }
    });
    public static final Function LOG = DefaultFunctions.registerFunc(new FunctionSupport.Func1("Log"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            return ValueSupport.toValue(Math.log(param1.getAsDouble(ctx)));
        }
    });
    public static final Function RND = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("Rnd", 0, 1){

        @Override
        public boolean isPure() {
            return false;
        }

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            Integer seed = params.length > 0 ? params[0].getAsLongInt(ctx) : null;
            return ValueSupport.toValue(ctx.getRandom(seed));
        }
    });
    public static final Function ROUND = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("Round", 1, 2){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            Value param1 = params[0];
            if (param1.isNull()) {
                return ValueSupport.NULL_VAL;
            }
            if (param1.getType().isIntegral()) {
                return param1;
            }
            int scale = 0;
            if (params.length > 1) {
                scale = params[1].getAsLongInt(ctx);
            }
            BigDecimal bd = param1.getAsBigDecimal(ctx).setScale(scale, NumberFormatter.ROUND_MODE);
            return ValueSupport.toValue(bd);
        }
    });
    public static final Function SGN = DefaultFunctions.registerFunc(new FunctionSupport.Func1NullIsNull("Sgn"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            int val = 0;
            val = param1.getType().isIntegral() ? param1.getAsLongInt(ctx).intValue() : param1.getAsBigDecimal(ctx).signum();
            return val > 0 ? ValueSupport.ONE_VAL : (val < 0 ? ValueSupport.NEG_ONE_VAL : ValueSupport.ZERO_VAL);
        }
    });
    public static final Function SQR = DefaultFunctions.registerFunc(new FunctionSupport.Func1("Sqr"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            double dv = param1.getAsDouble(ctx);
            if (dv < 0.0) {
                throw new EvalException("Invalid value '" + dv + "'");
            }
            return ValueSupport.toValue(Math.sqrt(dv));
        }
    });
    public static final Function SIN = DefaultFunctions.registerFunc(new FunctionSupport.Func1("Sin"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            return ValueSupport.toValue(Math.sin(param1.getAsDouble(ctx)));
        }
    });
    public static final Function TAN = DefaultFunctions.registerFunc(new FunctionSupport.Func1("Tan"){

        @Override
        protected Value eval1(EvalContext ctx, Value param1) {
            return ValueSupport.toValue(Math.tan(param1.getAsDouble(ctx)));
        }
    });

    DefaultNumberFunctions() {
    }
}

