/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import java.math.BigDecimal;
import shaded.io.github.spannm.jackcess.expr.LocaleContext;
import shaded.io.github.spannm.jackcess.expr.Value;
import shaded.io.github.spannm.jackcess.impl.expr.BaseNumericValue;

public class BigDecimalValue
extends BaseNumericValue {
    private final BigDecimal val;

    public BigDecimalValue(BigDecimal _val) {
        this.val = _val;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.BIG_DEC;
    }

    @Override
    public Object get() {
        return this.val;
    }

    @Override
    protected Number getNumber() {
        return this.val;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return (long)this.val.compareTo(BigDecimal.ZERO) != 0L;
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return ctx.getNumericConfig().format(this.val);
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return this.val;
    }
}

