/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.complex;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import shaded.io.github.spannm.jackcess.Column;
import shaded.io.github.spannm.jackcess.Database;
import shaded.io.github.spannm.jackcess.DateTimeType;
import shaded.io.github.spannm.jackcess.Row;
import shaded.io.github.spannm.jackcess.complex.Attachment;
import shaded.io.github.spannm.jackcess.complex.AttachmentColumnInfo;
import shaded.io.github.spannm.jackcess.complex.ComplexColumnInfo;
import shaded.io.github.spannm.jackcess.complex.ComplexDataType;
import shaded.io.github.spannm.jackcess.complex.ComplexValue;
import shaded.io.github.spannm.jackcess.complex.ComplexValueForeignKey;
import shaded.io.github.spannm.jackcess.complex.MultiValueColumnInfo;
import shaded.io.github.spannm.jackcess.complex.SingleValue;
import shaded.io.github.spannm.jackcess.complex.UnsupportedColumnInfo;
import shaded.io.github.spannm.jackcess.complex.UnsupportedValue;
import shaded.io.github.spannm.jackcess.complex.Version;
import shaded.io.github.spannm.jackcess.complex.VersionHistoryColumnInfo;
import shaded.io.github.spannm.jackcess.impl.complex.AttachmentColumnInfoImpl;
import shaded.io.github.spannm.jackcess.impl.complex.MultiValueColumnInfoImpl;
import shaded.io.github.spannm.jackcess.impl.complex.UnsupportedColumnInfoImpl;
import shaded.io.github.spannm.jackcess.impl.complex.VersionHistoryColumnInfoImpl;

public class ComplexValueForeignKeyImpl
extends ComplexValueForeignKey {
    private static final long serialVersionUID = 20110805L;
    private final transient Column mcolumn;
    private final int mvalue;
    private transient List<? extends ComplexValue> mvalues;

    public ComplexValueForeignKeyImpl(Column column, int value) {
        this.mcolumn = column;
        this.mvalue = value;
    }

    @Override
    public int get() {
        return this.mvalue;
    }

    @Override
    public Column getColumn() {
        return this.mcolumn;
    }

    @Override
    public ComplexDataType getComplexType() {
        return this.getComplexInfo().getType();
    }

    protected ComplexColumnInfo<? extends ComplexValue> getComplexInfo() {
        return this.mcolumn.getComplexInfo();
    }

    protected VersionHistoryColumnInfo getVersionInfo() {
        return (VersionHistoryColumnInfo)this.getComplexInfo();
    }

    protected AttachmentColumnInfo getAttachmentInfo() {
        return (AttachmentColumnInfo)this.getComplexInfo();
    }

    protected MultiValueColumnInfo getMultiValueInfo() {
        return (MultiValueColumnInfo)this.getComplexInfo();
    }

    protected UnsupportedColumnInfo getUnsupportedInfo() {
        return (UnsupportedColumnInfo)this.getComplexInfo();
    }

    @Override
    public int countValues() throws IOException {
        return this.getComplexInfo().countValues(this.get());
    }

    public List<Row> getRawValues() throws IOException {
        return this.getComplexInfo().getRawValues(this.get());
    }

    @Override
    public List<? extends ComplexValue> getValues() throws IOException {
        if (this.mvalues == null) {
            this.mvalues = this.getComplexInfo().getValues(this);
        }
        return this.mvalues;
    }

    @Override
    public List<Version> getVersions() throws IOException {
        if (this.getComplexType() != ComplexDataType.VERSION_HISTORY) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    @Override
    public List<Attachment> getAttachments() throws IOException {
        if (this.getComplexType() != ComplexDataType.ATTACHMENT) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    @Override
    public List<SingleValue> getMultiValues() throws IOException {
        if (this.getComplexType() != ComplexDataType.MULTI_VALUE) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    @Override
    public List<UnsupportedValue> getUnsupportedValues() throws IOException {
        if (this.getComplexType() != ComplexDataType.UNSUPPORTED) {
            throw new UnsupportedOperationException();
        }
        return this.getValues();
    }

    @Override
    public void reset() {
        this.mvalues = null;
    }

    @Override
    public Version addVersion(String value) throws IOException {
        return this.addVersionImpl(value, this.now());
    }

    @Override
    public Version addVersion(String value, Date modifiedDate) throws IOException {
        return this.addVersionImpl(value, modifiedDate);
    }

    @Override
    public Version addVersion(String value, LocalDateTime modifiedDate) throws IOException {
        return this.addVersionImpl(value, modifiedDate);
    }

    private Version addVersionImpl(String value, Object modifiedDate) throws IOException {
        this.reset();
        Version v = VersionHistoryColumnInfoImpl.newVersion(this, value, modifiedDate);
        this.getVersionInfo().addValue(v);
        return v;
    }

    @Override
    public Attachment addAttachment(byte[] data) throws IOException {
        return this.addAttachmentImpl(null, null, null, data, null, null);
    }

    @Override
    public Attachment addAttachment(String url, String name, String type, byte[] data, Date timeStamp, Integer flags) throws IOException {
        return this.addAttachmentImpl(url, name, type, data, timeStamp, flags);
    }

    @Override
    public Attachment addAttachment(String url, String name, String type, byte[] data, LocalDateTime timeStamp, Integer flags) throws IOException {
        return this.addAttachmentImpl(url, name, type, data, timeStamp, flags);
    }

    private Attachment addAttachmentImpl(String url, String name, String type, byte[] data, Object timeStamp, Integer flags) throws IOException {
        this.reset();
        Attachment a = AttachmentColumnInfoImpl.newAttachment(this, url, name, type, data, timeStamp, flags);
        this.getAttachmentInfo().addValue(a);
        return a;
    }

    @Override
    public Attachment addEncodedAttachment(byte[] encodedData) throws IOException {
        return this.addEncodedAttachmentImpl(null, null, null, encodedData, null, null);
    }

    @Override
    public Attachment addEncodedAttachment(String url, String name, String type, byte[] encodedData, Date timeStamp, Integer flags) throws IOException {
        return this.addEncodedAttachmentImpl(url, name, type, encodedData, timeStamp, flags);
    }

    @Override
    public Attachment addEncodedAttachment(String url, String name, String type, byte[] encodedData, LocalDateTime timeStamp, Integer flags) throws IOException {
        return this.addEncodedAttachmentImpl(url, name, type, encodedData, timeStamp, flags);
    }

    private Attachment addEncodedAttachmentImpl(String url, String name, String type, byte[] encodedData, Object timeStamp, Integer flags) throws IOException {
        this.reset();
        Attachment a = AttachmentColumnInfoImpl.newEncodedAttachment(this, url, name, type, encodedData, timeStamp, flags);
        this.getAttachmentInfo().addValue(a);
        return a;
    }

    @Override
    public Attachment updateAttachment(Attachment attachment) throws IOException {
        this.reset();
        this.getAttachmentInfo().updateValue(attachment);
        return attachment;
    }

    @Override
    public Attachment deleteAttachment(Attachment attachment) throws IOException {
        this.reset();
        this.getAttachmentInfo().deleteValue(attachment);
        return attachment;
    }

    @Override
    public SingleValue addMultiValue(Object value) throws IOException {
        this.reset();
        SingleValue v = MultiValueColumnInfoImpl.newSingleValue(this, value);
        this.getMultiValueInfo().addValue(v);
        return v;
    }

    @Override
    public SingleValue updateMultiValue(SingleValue value) throws IOException {
        this.reset();
        this.getMultiValueInfo().updateValue(value);
        return value;
    }

    @Override
    public SingleValue deleteMultiValue(SingleValue value) throws IOException {
        this.reset();
        this.getMultiValueInfo().deleteValue(value);
        return value;
    }

    @Override
    public UnsupportedValue addUnsupportedValue(Map<String, ?> values) throws IOException {
        this.reset();
        UnsupportedValue v = UnsupportedColumnInfoImpl.newValue(this, values);
        this.getUnsupportedInfo().addValue(v);
        return v;
    }

    @Override
    public UnsupportedValue updateUnsupportedValue(UnsupportedValue value) throws IOException {
        this.reset();
        this.getUnsupportedInfo().updateValue(value);
        return value;
    }

    @Override
    public UnsupportedValue deleteUnsupportedValue(UnsupportedValue value) throws IOException {
        this.reset();
        this.getUnsupportedInfo().deleteValue(value);
        return value;
    }

    @Override
    public void deleteAllValues() throws IOException {
        this.reset();
        this.getComplexInfo().deleteAllValues(this);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.mcolumn == ((ComplexValueForeignKeyImpl)o).mcolumn;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.mcolumn);
    }

    private Object now() {
        Database db = this.getColumn().getDatabase();
        if (db.getDateTimeType() == DateTimeType.DATE) {
            return new Date();
        }
        return LocalDateTime.now(db.getZoneId());
    }
}

