/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import shaded.io.github.spannm.jackcess.impl.PageChannel;

public abstract class TempBufferHolder {
    private static final Reference<ByteBuffer> EMPTY_BUFFER_REF = new SoftReference<Object>(null);
    private final boolean _autoRewind;
    private final ByteOrder _order;
    private int _modCount;

    protected TempBufferHolder(boolean autoRewind, ByteOrder order) {
        this._autoRewind = autoRewind;
        this._order = order;
    }

    public int getModCount() {
        return this._modCount;
    }

    public static TempBufferHolder newHolder(Type type, boolean autoRewind) {
        return TempBufferHolder.newHolder(type, autoRewind, PageChannel.DEFAULT_BYTE_ORDER);
    }

    public static TempBufferHolder newHolder(Type type, boolean autoRewind, ByteOrder order) {
        switch (type.ordinal()) {
            case 0: {
                return new HardTempBufferHolder(autoRewind, order);
            }
            case 1: {
                return new SoftTempBufferHolder(autoRewind, order);
            }
            case 2: {
                return new NoneTempBufferHolder(autoRewind, order);
            }
        }
        throw new IllegalStateException("Unknown type " + String.valueOf((Object)type));
    }

    public final ByteBuffer getPageBuffer(PageChannel pageChannel) {
        return this.getBuffer(pageChannel, pageChannel.getFormat().PAGE_SIZE);
    }

    public final ByteBuffer getBuffer(PageChannel pageChannel, int size) {
        ByteBuffer buffer = this.getExistingBuffer();
        if (buffer == null || buffer.capacity() < size) {
            buffer = PageChannel.createBuffer(size, this._order);
            ++this._modCount;
            this.setNewBuffer(buffer);
        } else {
            buffer.limit(size);
        }
        if (this._autoRewind) {
            buffer.rewind();
        }
        return buffer;
    }

    public abstract ByteBuffer getExistingBuffer();

    public abstract void clear();

    protected abstract void setNewBuffer(ByteBuffer var1);

    public static enum Type {
        HARD,
        SOFT,
        NONE;

    }

    private static final class HardTempBufferHolder
    extends TempBufferHolder {
        private ByteBuffer _buffer;

        private HardTempBufferHolder(boolean autoRewind, ByteOrder order) {
            super(autoRewind, order);
        }

        @Override
        public ByteBuffer getExistingBuffer() {
            return this._buffer;
        }

        @Override
        protected void setNewBuffer(ByteBuffer newBuffer) {
            this._buffer = newBuffer;
        }

        @Override
        public void clear() {
            this._buffer = null;
        }
    }

    private static final class SoftTempBufferHolder
    extends TempBufferHolder {
        private Reference<ByteBuffer> _buffer = EMPTY_BUFFER_REF;

        private SoftTempBufferHolder(boolean autoRewind, ByteOrder order) {
            super(autoRewind, order);
        }

        @Override
        public ByteBuffer getExistingBuffer() {
            return this._buffer.get();
        }

        @Override
        protected void setNewBuffer(ByteBuffer newBuffer) {
            this._buffer.clear();
            this._buffer = new SoftReference<ByteBuffer>(newBuffer);
        }

        @Override
        public void clear() {
            this._buffer.clear();
        }
    }

    private static final class NoneTempBufferHolder
    extends TempBufferHolder {
        private NoneTempBufferHolder(boolean autoRewind, ByteOrder order) {
            super(autoRewind, order);
        }

        @Override
        public ByteBuffer getExistingBuffer() {
            return null;
        }

        @Override
        protected void setNewBuffer(ByteBuffer newBuffer) {
        }

        @Override
        public void clear() {
        }
    }
}

