/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import shaded.io.github.spannm.jackcess.BatchUpdateException;
import shaded.io.github.spannm.jackcess.Column;
import shaded.io.github.spannm.jackcess.ColumnBuilder;
import shaded.io.github.spannm.jackcess.ConstraintViolationException;
import shaded.io.github.spannm.jackcess.CursorBuilder;
import shaded.io.github.spannm.jackcess.Index;
import shaded.io.github.spannm.jackcess.IndexBuilder;
import shaded.io.github.spannm.jackcess.InvalidValueException;
import shaded.io.github.spannm.jackcess.JackcessException;
import shaded.io.github.spannm.jackcess.PropertyMap;
import shaded.io.github.spannm.jackcess.Row;
import shaded.io.github.spannm.jackcess.RowId;
import shaded.io.github.spannm.jackcess.Table;
import shaded.io.github.spannm.jackcess.expr.Identifier;
import shaded.io.github.spannm.jackcess.impl.ByteUtil;
import shaded.io.github.spannm.jackcess.impl.ColumnImpl;
import shaded.io.github.spannm.jackcess.impl.CursorImpl;
import shaded.io.github.spannm.jackcess.impl.DBMutator;
import shaded.io.github.spannm.jackcess.impl.DatabaseImpl;
import shaded.io.github.spannm.jackcess.impl.FKEnforcer;
import shaded.io.github.spannm.jackcess.impl.IndexData;
import shaded.io.github.spannm.jackcess.impl.IndexImpl;
import shaded.io.github.spannm.jackcess.impl.JetFormat;
import shaded.io.github.spannm.jackcess.impl.NullMask;
import shaded.io.github.spannm.jackcess.impl.PageChannel;
import shaded.io.github.spannm.jackcess.impl.PropertyMaps;
import shaded.io.github.spannm.jackcess.impl.RowIdImpl;
import shaded.io.github.spannm.jackcess.impl.RowImpl;
import shaded.io.github.spannm.jackcess.impl.RowValidatorEvalContext;
import shaded.io.github.spannm.jackcess.impl.TableCreator;
import shaded.io.github.spannm.jackcess.impl.TableMutator;
import shaded.io.github.spannm.jackcess.impl.TableUpdater;
import shaded.io.github.spannm.jackcess.impl.TempBufferHolder;
import shaded.io.github.spannm.jackcess.impl.TempPageHolder;
import shaded.io.github.spannm.jackcess.impl.TopoSorter;
import shaded.io.github.spannm.jackcess.impl.UsageMap;
import shaded.io.github.spannm.jackcess.util.ErrorHandler;
import shaded.io.github.spannm.jackcess.util.ExportUtil;
import shaded.io.github.spannm.jackcess.util.ToStringBuilder;

public class TableImpl
implements Table,
PropertyMaps.Owner {
    private static final System.Logger LOGGER = System.getLogger(TableImpl.class.getName());
    private static final short OFFSET_MASK = 8191;
    private static final short DELETED_ROW_MASK = Short.MIN_VALUE;
    private static final short OVERFLOW_ROW_MASK = 16384;
    static final int MAGIC_TABLE_NUMBER = 1625;
    private static final int MAX_BYTE = 256;
    public static final byte TYPE_SYSTEM = 83;
    public static final byte TYPE_USER = 78;
    private static final Comparator<ColumnImpl> VAR_LEN_COLUMN_COMPARATOR = Comparator.comparingInt(ColumnImpl::getVarLenTableIndex);
    private static final Comparator<ColumnImpl> DISPLAY_ORDER_COMPARATOR = Comparator.comparingInt(ColumnImpl::getDisplayIndex);
    private final DatabaseImpl _database;
    private final int _flags;
    private final byte _tableType;
    private int _indexCount;
    private int _logicalIndexCount;
    private final int _tableDefPageNumber;
    private short _maxColumnCount;
    private short _maxVarColumnCount;
    private final List<ColumnImpl> _columns = new ArrayList<ColumnImpl>();
    private final List<ColumnImpl> _varColumns = new ArrayList<ColumnImpl>();
    private final List<ColumnImpl> _autoNumColumns = new ArrayList<ColumnImpl>(1);
    private final CalcColEvaluator _calcColEval = new CalcColEvaluator();
    private final List<IndexImpl> _indexes = new ArrayList<IndexImpl>();
    private final List<IndexData> _indexDatas = new ArrayList<IndexData>();
    private final Set<ColumnImpl> _indexColumns = new LinkedHashSet<ColumnImpl>();
    private final String _name;
    private final UsageMap _ownedPages;
    private final UsageMap _freeSpacePages;
    private int _rowCount;
    private int _lastLongAutoNumber;
    private int _lastComplexTypeAutoNumber;
    private int _modCount;
    private final TempPageHolder _addRowBufferH = TempPageHolder.newHolder(TempBufferHolder.Type.SOFT);
    private final TempPageHolder _tableDefBufferH = TempPageHolder.newHolder(TempBufferHolder.Type.SOFT);
    private final TempBufferHolder _writeRowBufferH = TempBufferHolder.newHolder(TempBufferHolder.Type.SOFT, true);
    private final TempPageHolder _longValueBufferH = TempPageHolder.newHolder(TempBufferHolder.Type.SOFT);
    private ErrorHandler _tableErrorHandler;
    private PropertyMap _props;
    private PropertyMaps _propertyMaps;
    private Boolean _allowAutoNumInsert;
    private final FKEnforcer _fkEnforcer;
    private RowValidatorEvalContext _rowValidator;
    private CursorImpl _defaultCursor;

    protected TableImpl(boolean testing, List<ColumnImpl> columns) {
        if (!testing) {
            throw new IllegalArgumentException();
        }
        this._database = null;
        this._tableDefPageNumber = -1;
        this._name = null;
        this._columns.addAll(columns);
        for (ColumnImpl col : this._columns) {
            if (!col.getType().isVariableLength()) continue;
            this._varColumns.add(col);
        }
        this._maxColumnCount = (short)this._columns.size();
        this._maxVarColumnCount = (short)this._varColumns.size();
        this.initAutoNumberColumns();
        this._fkEnforcer = null;
        this._flags = 0;
        this._tableType = (byte)78;
        this._indexCount = 0;
        this._logicalIndexCount = 0;
        this._ownedPages = null;
        this._freeSpacePages = null;
    }

    protected TableImpl(DatabaseImpl database, ByteBuffer tableBuffer, int pageNumber, String name, int flags) throws IOException {
        this._database = database;
        this._tableDefPageNumber = pageNumber;
        this._name = name;
        this._flags = flags;
        tableBuffer = this.loadCompleteTableDefinitionBuffer(tableBuffer, null);
        this._rowCount = tableBuffer.getInt(this.getFormat().OFFSET_NUM_ROWS);
        this._lastLongAutoNumber = tableBuffer.getInt(this.getFormat().OFFSET_NEXT_AUTO_NUMBER);
        if (this.getFormat().OFFSET_NEXT_COMPLEX_AUTO_NUMBER >= 0) {
            this._lastComplexTypeAutoNumber = tableBuffer.getInt(this.getFormat().OFFSET_NEXT_COMPLEX_AUTO_NUMBER);
        }
        this._tableType = tableBuffer.get(this.getFormat().OFFSET_TABLE_TYPE);
        this._maxColumnCount = tableBuffer.getShort(this.getFormat().OFFSET_MAX_COLS);
        this._maxVarColumnCount = tableBuffer.getShort(this.getFormat().OFFSET_NUM_VAR_COLS);
        short columnCount = tableBuffer.getShort(this.getFormat().OFFSET_NUM_COLS);
        this._logicalIndexCount = tableBuffer.getInt(this.getFormat().OFFSET_NUM_INDEX_SLOTS);
        this._indexCount = tableBuffer.getInt(this.getFormat().OFFSET_NUM_INDEXES);
        tableBuffer.position(this.getFormat().OFFSET_OWNED_PAGES);
        this._ownedPages = UsageMap.read(this.getDatabase(), tableBuffer);
        tableBuffer.position(this.getFormat().OFFSET_FREE_SPACE_PAGES);
        this._freeSpacePages = UsageMap.read(this.getDatabase(), tableBuffer);
        for (int i = 0; i < this._indexCount; ++i) {
            this._indexDatas.add(IndexData.create(this, tableBuffer, i, this.getFormat()));
        }
        this.readColumnDefinitions(tableBuffer, columnCount);
        this.readIndexDefinitions(tableBuffer);
        while (tableBuffer.remaining() >= 2 && this.readColumnUsageMaps(tableBuffer)) {
        }
        if (this.getDatabase().getColumnOrder() != Table.ColumnOrder.DATA) {
            this._columns.sort(DISPLAY_ORDER_COMPARATOR);
        }
        for (ColumnImpl col : this._columns) {
            col.postTableLoadInit();
        }
        this._fkEnforcer = new FKEnforcer(this);
        if (!this.isSystem()) {
            for (ColumnImpl col : this._columns) {
                col.initColumnValidator();
            }
            this.reloadRowValidator();
        }
    }

    private void reloadRowValidator() throws IOException {
        this._rowValidator = null;
        if (!this.getDatabase().isEvaluateExpressions()) {
            return;
        }
        PropertyMap props = this.getProperties();
        String exprStr = PropertyMaps.getTrimmedStringProperty(props, "ValidationRule");
        if (exprStr != null) {
            String helpStr = PropertyMaps.getTrimmedStringProperty(props, "ValidationText");
            this._rowValidator = new RowValidatorEvalContext(this).withExpr(exprStr, helpStr);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isHidden() {
        return (this._flags & 8) != 0;
    }

    @Override
    public boolean isSystem() {
        return this._tableType != 78;
    }

    public int getMaxColumnCount() {
        return this._maxColumnCount;
    }

    @Override
    public int getColumnCount() {
        return this._columns.size();
    }

    @Override
    public DatabaseImpl getDatabase() {
        return this._database;
    }

    public JetFormat getFormat() {
        return this.getDatabase().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getDatabase().getPageChannel();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._tableErrorHandler != null ? this._tableErrorHandler : this.getDatabase().getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler newErrorHandler) {
        this._tableErrorHandler = newErrorHandler;
    }

    public int getTableDefPageNumber() {
        return this._tableDefPageNumber;
    }

    @Override
    public boolean isAllowAutoNumberInsert() {
        return this._allowAutoNumInsert != null ? this._allowAutoNumInsert.booleanValue() : this.getDatabase().isAllowAutoNumberInsert();
    }

    @Override
    public void setAllowAutoNumberInsert(Boolean allowAutoNumInsert) {
        this._allowAutoNumInsert = allowAutoNumInsert;
    }

    public RowState createRowState() {
        return new RowState(TempBufferHolder.Type.HARD);
    }

    public UsageMap.PageCursor getOwnedPagesCursor() {
        return this._ownedPages.cursor();
    }

    public int getApproximateOwnedPageCount() {
        int count = this._ownedPages.getPageCount() + 1;
        for (ColumnImpl col : this._columns) {
            count += col.getOwnedPageCount();
        }
        for (IndexData indexData : this._indexDatas) {
            count += indexData.getOwnedPageCount();
        }
        return count;
    }

    protected TempPageHolder getLongValueBuffer() {
        return this._longValueBufferH;
    }

    public List<ColumnImpl> getColumns() {
        return Collections.unmodifiableList(this._columns);
    }

    @Override
    public ColumnImpl getColumn(String name) {
        for (ColumnImpl column : this._columns) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return column;
        }
        throw new IllegalArgumentException(this.withErrorContext("Column with name " + name + " does not exist in this table"));
    }

    public boolean hasColumn(String name) {
        for (ColumnImpl column : this._columns) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PropertyMap getProperties() throws IOException {
        if (this._props == null) {
            this._props = this.getPropertyMaps().getDefault();
        }
        return this._props;
    }

    @Override
    public LocalDateTime getCreatedDate() throws IOException {
        return this.getDatabase().getCreateDateForObject(this._tableDefPageNumber);
    }

    @Override
    public LocalDateTime getUpdatedDate() throws IOException {
        return this.getDatabase().getUpdateDateForObject(this._tableDefPageNumber);
    }

    public PropertyMaps getPropertyMaps() throws IOException {
        if (this._propertyMaps == null) {
            this._propertyMaps = this.getDatabase().getPropertiesForObject(this._tableDefPageNumber, this);
        }
        return this._propertyMaps;
    }

    @Override
    public void propertiesUpdated() throws IOException {
        for (ColumnImpl col : this._columns) {
            col.propertiesUpdated();
        }
        this.reloadRowValidator();
        this._calcColEval.reSort();
    }

    public List<IndexImpl> getIndexes() {
        return Collections.unmodifiableList(this._indexes);
    }

    @Override
    public IndexImpl getIndex(String name) {
        for (IndexImpl index : this._indexes) {
            if (!index.getName().equalsIgnoreCase(name)) continue;
            return index;
        }
        throw new IllegalArgumentException(this.withErrorContext("Index with name " + name + " does not exist on this table"));
    }

    @Override
    public IndexImpl getPrimaryKeyIndex() {
        for (IndexImpl index : this._indexes) {
            if (!index.isPrimaryKey()) continue;
            return index;
        }
        throw new IllegalArgumentException(this.withErrorContext("No primary key index found"));
    }

    @Override
    public IndexImpl getForeignKeyIndex(Table otherTable) {
        for (IndexImpl index : this._indexes) {
            if (!index.isForeignKey() || index.getReference() == null || index.getReference().getOtherTablePageNumber() != ((TableImpl)otherTable).getTableDefPageNumber()) continue;
            return index;
        }
        throw new IllegalArgumentException(this.withErrorContext("No foreign key reference to " + otherTable.getName() + " found"));
    }

    public List<IndexData> getIndexDatas() {
        return Collections.unmodifiableList(this._indexDatas);
    }

    public int getLogicalIndexCount() {
        return this._logicalIndexCount;
    }

    int getIndexCount() {
        return this._indexCount;
    }

    public IndexImpl findIndexForColumns(Collection<String> searchColumns, IndexFeature feature) {
        IndexImpl partialIndex = null;
        for (IndexImpl index : this._indexes) {
            List<IndexData.ColumnDescriptor> indexColumns = index.getColumns();
            if (indexColumns.size() < searchColumns.size()) continue;
            boolean exactMatch = indexColumns.size() == searchColumns.size();
            Iterator iIter = indexColumns.iterator();
            boolean searchMatches = true;
            for (String sColName : searchColumns) {
                String iColName;
                if (sColName.equals(iColName = ((Index.Column)iIter.next()).getName()) || sColName != null && sColName.equalsIgnoreCase(iColName)) continue;
                searchMatches = false;
                break;
            }
            if (!searchMatches) continue;
            if (exactMatch && (feature != IndexFeature.EXACT_UNIQUE_ONLY || index.isUnique())) {
                return index;
            }
            if (exactMatch || feature != IndexFeature.ANY_MATCH || partialIndex != null && indexColumns.size() >= partialIndex.getColumnCount()) continue;
            partialIndex = index;
        }
        return partialIndex;
    }

    List<ColumnImpl> getAutoNumberColumns() {
        return this._autoNumColumns;
    }

    @Override
    public CursorImpl getDefaultCursor() {
        if (this._defaultCursor == null) {
            this._defaultCursor = CursorImpl.createCursor(this);
        }
        return this._defaultCursor;
    }

    @Override
    public CursorBuilder newCursor() {
        return new CursorBuilder(this);
    }

    @Override
    public void reset() {
        this.getDefaultCursor().reset();
    }

    @Override
    public Row deleteRow(Row row) throws IOException {
        this.deleteRow(row.getId());
        return row;
    }

    public RowId deleteRow(RowId rowId) throws IOException {
        this.deleteRow(this.getDefaultCursor().getRowState(), (RowIdImpl)rowId);
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(RowState rowState, RowIdImpl rowId) throws IOException {
        this.requireValidRowId(rowId);
        this.getPageChannel().startWrite();
        try {
            ByteBuffer rowBuffer = TableImpl.positionAtRowHeader(rowState, rowId);
            if (rowState.isDeleted()) {
                return;
            }
            this.requireNonDeletedRow(rowState, rowId);
            int pageNumber = rowState.getHeaderRowId().getPageNumber();
            int rowNumber = rowState.getHeaderRowId().getRowNumber();
            Object[] rowValues = null;
            if (!this._indexDatas.isEmpty()) {
                rowBuffer = TableImpl.positionAtRowData(rowState, rowId);
                for (ColumnImpl idxCol : this._indexColumns) {
                    TableImpl.getRowColumn(this.getFormat(), rowBuffer, idxCol, rowState, null);
                }
                rowValues = rowState.getRowCacheValues();
                this._fkEnforcer.deleteRow(rowValues);
                rowBuffer = TableImpl.positionAtRowHeader(rowState, rowId);
            }
            int rowIndex = TableImpl.getRowStartOffset(rowNumber, this.getFormat());
            rowBuffer.putShort(rowIndex, (short)(rowBuffer.getShort(rowIndex) | Short.MIN_VALUE | 0x4000));
            this.writeDataPage(rowBuffer, pageNumber);
            for (IndexData indexData : this._indexDatas) {
                indexData.deleteRow(rowValues, rowId);
            }
            this.updateTableDefinition(-1);
        }
        finally {
            this.getPageChannel().finishWrite();
        }
    }

    @Override
    public Row getNextRow() throws IOException {
        return this.getDefaultCursor().getNextRow();
    }

    public Object getRowValue(RowState rowState, RowIdImpl rowId, ColumnImpl column) throws IOException {
        if (this != column.getTable()) {
            throw new IllegalArgumentException(this.withErrorContext("Given column " + String.valueOf(column) + " is not from this table"));
        }
        this.requireValidRowId(rowId);
        ByteBuffer rowBuffer = TableImpl.positionAtRowData(rowState, rowId);
        this.requireNonDeletedRow(rowState, rowId);
        return TableImpl.getRowColumn(this.getFormat(), rowBuffer, column, rowState, null);
    }

    public RowImpl getRow(RowState rowState, RowIdImpl rowId, Collection<String> columnNames) throws IOException {
        this.requireValidRowId(rowId);
        ByteBuffer rowBuffer = TableImpl.positionAtRowData(rowState, rowId);
        this.requireNonDeletedRow(rowState, rowId);
        return TableImpl.getRow(this.getFormat(), rowState, rowBuffer, this._columns, columnNames);
    }

    private static RowImpl getRow(JetFormat format, RowState rowState, ByteBuffer rowBuffer, Collection<ColumnImpl> columns, Collection<String> columnNames) throws IOException {
        RowImpl rtn = new RowImpl(rowState.getHeaderRowId(), columns.size());
        for (ColumnImpl column : columns) {
            if (columnNames != null && !columnNames.contains(column.getName())) continue;
            column.setRowValue(rtn, TableImpl.getRowColumn(format, rowBuffer, column, rowState, null));
        }
        return rtn;
    }

    private static Object getRowColumn(JetFormat format, ByteBuffer rowBuffer, ColumnImpl column, RowState rowState, Map<ColumnImpl, byte[]> rawVarValues) throws IOException {
        byte[] columnData = null;
        try {
            NullMask nullMask = rowState.getNullMask(rowBuffer);
            boolean isNull = nullMask.isNull(column);
            if (column.storeInNullMask()) {
                return rowState.withRowCacheValue(column.getColumnIndex(), column.readFromNullMask(isNull));
            }
            if (isNull) {
                return null;
            }
            Object cachedValue = rowState.withRowCacheValue(column.getColumnIndex());
            if (cachedValue != null) {
                return cachedValue;
            }
            rowBuffer.reset();
            int rowStart = rowBuffer.position();
            int colDataPos = 0;
            int colDataLen = 0;
            if (!column.isVariableLength()) {
                int dataStart = rowStart + format.OFFSET_COLUMN_FIXED_DATA_ROW_OFFSET;
                colDataPos = dataStart + column.getFixedDataOffset();
                colDataLen = column.getFixedDataSize();
            } else {
                short varDataEnd;
                short varDataStart;
                if (format.SIZE_ROW_VAR_COL_OFFSET == 2) {
                    int varColumnOffsetPos = rowBuffer.limit() - nullMask.byteSize() - 4 - column.getVarLenTableIndex() * 2;
                    varDataStart = rowBuffer.getShort(varColumnOffsetPos);
                    varDataEnd = rowBuffer.getShort(varColumnOffsetPos - 2);
                } else {
                    short[] varColumnOffsets = TableImpl.readJumpTableVarColOffsets(rowState, rowBuffer, rowStart, nullMask);
                    varDataStart = varColumnOffsets[column.getVarLenTableIndex()];
                    varDataEnd = varColumnOffsets[column.getVarLenTableIndex() + 1];
                }
                colDataPos = rowStart + varDataStart;
                colDataLen = varDataEnd - varDataStart;
            }
            rowBuffer.position(colDataPos);
            columnData = ByteUtil.getBytes(rowBuffer, colDataLen);
            if (rawVarValues != null && column.isVariableLength()) {
                rawVarValues.put(column, columnData);
            }
            return rowState.withRowCacheValue(column.getColumnIndex(), column.read(columnData));
        }
        catch (Exception _ex) {
            rowState.withRowCacheValue(column.getColumnIndex(), ColumnImpl.rawDataWrapper(columnData));
            return rowState.handleRowError(column, columnData, _ex);
        }
    }

    private static short[] readJumpTableVarColOffsets(RowState rowState, ByteBuffer rowBuffer, int rowStart, NullMask nullMask) {
        short[] varColOffsets = rowState.getVarColOffsets();
        if (varColOffsets != null) {
            return varColOffsets;
        }
        int nullMaskSize = nullMask.byteSize();
        int rowEnd = rowStart + rowBuffer.remaining() - 1;
        int numVarCols = ByteUtil.getUnsignedByte(rowBuffer, rowEnd - nullMaskSize);
        varColOffsets = new short[numVarCols + 1];
        int rowLen = rowEnd - rowStart + 1;
        int numJumps = (rowLen - 1) / 256;
        int colOffset = rowEnd - nullMaskSize - numJumps - 1;
        if ((colOffset - rowStart - numVarCols) / 256 < numJumps) {
            --numJumps;
        }
        int jumpsUsed = 0;
        for (int i = 0; i < numVarCols + 1; ++i) {
            while (jumpsUsed < numJumps && i == ByteUtil.getUnsignedByte(rowBuffer, rowEnd - nullMaskSize - jumpsUsed - 1)) {
                ++jumpsUsed;
            }
            varColOffsets[i] = (short)(ByteUtil.getUnsignedByte(rowBuffer, colOffset - i) + jumpsUsed * 256);
        }
        rowState.setVarColOffsets(varColOffsets);
        return varColOffsets;
    }

    private NullMask getRowNullMask(ByteBuffer rowBuffer) {
        rowBuffer.reset();
        int columnCount = ByteUtil.getUnsignedVarInt(rowBuffer, this.getFormat().SIZE_ROW_COLUMN_COUNT);
        NullMask nullMask = new NullMask(columnCount);
        rowBuffer.position(rowBuffer.limit() - nullMask.byteSize());
        nullMask.read(rowBuffer);
        return nullMask;
    }

    public static ByteBuffer positionAtRowHeader(RowState rowState, RowIdImpl rowId) throws IOException {
        ByteBuffer rowBuffer = rowState.withHeaderRow(rowId);
        if (rowState.isAtHeaderRow()) {
            return rowBuffer;
        }
        if (!rowState.isValid()) {
            rowState.setStatus(RowStateStatus.AT_HEADER);
            return null;
        }
        short rowStart = rowBuffer.getShort(TableImpl.getRowStartOffset(rowId.getRowNumber(), rowState.getTable().getFormat()));
        RowStatus rowStatus = RowStatus.NORMAL;
        if (TableImpl.isDeletedRow(rowStart)) {
            rowStatus = RowStatus.DELETED;
        } else if (TableImpl.isOverflowRow(rowStart)) {
            rowStatus = RowStatus.OVERFLOW;
        }
        rowState.setRowStatus(rowStatus);
        rowState.setStatus(RowStateStatus.AT_HEADER);
        return rowBuffer;
    }

    public static ByteBuffer positionAtRowData(RowState rowState, RowIdImpl rowId) throws IOException {
        short rowEnd;
        short rowStart;
        TableImpl.positionAtRowHeader(rowState, rowId);
        if (!rowState.isValid() || rowState.isDeleted()) {
            rowState.setStatus(RowStateStatus.AT_FINAL);
            return null;
        }
        ByteBuffer rowBuffer = rowState.getFinalPage();
        int rowNum = rowState.getFinalRowId().getRowNumber();
        JetFormat format = rowState.getTable().getFormat();
        if (rowState.isAtFinalRow()) {
            return PageChannel.narrowBuffer(rowBuffer, TableImpl.findRowStart(rowBuffer, rowNum, format), TableImpl.findRowEnd(rowBuffer, rowNum, format));
        }
        while (true) {
            rowStart = rowBuffer.getShort(TableImpl.getRowStartOffset(rowNum, format));
            rowEnd = TableImpl.findRowEnd(rowBuffer, rowNum, format);
            boolean overflowRow = TableImpl.isOverflowRow(rowStart);
            rowStart = (short)(rowStart & 0x1FFF);
            if (!overflowRow) break;
            if (rowEnd - rowStart < 4) {
                throw new IOException(rowState.getTable().withErrorContext("invalid overflow row info"));
            }
            int overflowRowNum = ByteUtil.getUnsignedByte(rowBuffer, rowStart);
            int overflowPageNum = ByteUtil.get3ByteInt(rowBuffer, rowStart + 1);
            rowBuffer = rowState.withOverflowRow(new RowIdImpl(overflowPageNum, overflowRowNum));
            rowNum = overflowRowNum;
        }
        rowState.setStatus(RowStateStatus.AT_FINAL);
        return PageChannel.narrowBuffer(rowBuffer, rowStart, rowEnd);
    }

    @Override
    public Iterator<Row> iterator() {
        return this.getDefaultCursor().iterator();
    }

    protected static void writeTableDefinition(TableCreator creator) throws IOException {
        TableImpl.createUsageMapDefinitionBuffer(creator);
        JetFormat format = creator.getFormat();
        int idxDataLen = creator.getIndexCount() * (format.SIZE_INDEX_DEFINITION + format.SIZE_INDEX_COLUMN_BLOCK) + creator.getLogicalIndexCount() * format.SIZE_INDEX_INFO_BLOCK;
        int colUmapLen = creator.getLongValueColumns().size() * 10;
        int totalTableDefSize = format.SIZE_TDEF_HEADER + format.SIZE_COLUMN_DEF_BLOCK * creator.getColumns().size() + idxDataLen + colUmapLen + format.SIZE_TDEF_TRAILER;
        for (ColumnBuilder col : creator.getColumns()) {
            totalTableDefSize += DBMutator.calculateNameLength(col.getName());
        }
        for (IndexBuilder idx : creator.getIndexes()) {
            totalTableDefSize += DBMutator.calculateNameLength(idx.getName());
        }
        ByteBuffer buffer = PageChannel.createBuffer(Math.max(totalTableDefSize, format.PAGE_SIZE));
        TableImpl.writeTableDefinitionHeader(creator, buffer, totalTableDefSize);
        if (creator.hasIndexes()) {
            IndexData.writeRowCountDefinitions(creator, buffer);
        }
        ColumnImpl.writeDefinitions(creator, buffer);
        if (creator.hasIndexes()) {
            IndexData.writeDefinitions(creator, buffer);
            IndexImpl.writeDefinitions(creator, buffer);
        }
        ColumnImpl.writeColUsageMapDefinitions(creator, buffer);
        buffer.put((byte)-1);
        buffer.put((byte)-1);
        buffer.flip();
        TableImpl.writeTableDefinitionBuffer(buffer, creator.getTdefPageNumber(), creator, List.of());
    }

    private static void writeTableDefinitionBuffer(ByteBuffer buffer, int tdefPageNumber, TableMutator mutator, List<Integer> reservedPages) throws IOException {
        buffer.rewind();
        int totalTableDefSize = buffer.remaining();
        JetFormat format = mutator.getFormat();
        PageChannel pageChannel = mutator.getPageChannel();
        if (totalTableDefSize <= format.PAGE_SIZE) {
            buffer.putShort(format.OFFSET_FREE_SPACE, (short)Math.max(format.PAGE_SIZE - totalTableDefSize - 8, 0));
            buffer.clear();
            pageChannel.writePage(buffer, tdefPageNumber);
        } else {
            ByteBuffer partialTdef = pageChannel.createPageBuffer();
            buffer.rewind();
            int nextTdefPageNumber = -1;
            while (buffer.hasRemaining()) {
                partialTdef.clear();
                if (nextTdefPageNumber == -1) {
                    nextTdefPageNumber = tdefPageNumber;
                } else {
                    TableImpl.writeTablePageHeader(partialTdef);
                }
                int curTdefPageNumber = nextTdefPageNumber;
                int writeLen = Math.min(partialTdef.remaining(), buffer.remaining());
                partialTdef.put(buffer.array(), buffer.position(), writeLen);
                ByteUtil.forward(buffer, writeLen);
                if (buffer.hasRemaining()) {
                    nextTdefPageNumber = reservedPages.isEmpty() ? pageChannel.allocateNewPage() : reservedPages.remove(0).intValue();
                    partialTdef.putInt(format.OFFSET_NEXT_TABLE_DEF_PAGE, nextTdefPageNumber);
                }
                partialTdef.putShort(format.OFFSET_FREE_SPACE, (short)Math.max(partialTdef.remaining() - 8, 0));
                pageChannel.writePage(partialTdef, curTdefPageNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ColumnImpl mutateAddColumn(TableUpdater mutator) throws IOException {
        Map<String, PropertyMap.Property> colProps;
        ColumnBuilder column = mutator.getColumn();
        JetFormat format = mutator.getFormat();
        boolean isVarCol = column.isVariableLength();
        boolean isLongVal = column.getType().isLongValue();
        if (isLongVal) {
            mutator.addTdefLen(10);
        }
        mutator.addTdefLen(format.SIZE_COLUMN_DEF_BLOCK);
        int nameByteLen = DBMutator.calculateNameLength(column.getName());
        mutator.addTdefLen(nameByteLen);
        ByteBuffer tableBuffer = this.loadCompleteTableDefinitionBufferForUpdate(mutator);
        ColumnImpl newCol = null;
        int umapPos = -1;
        boolean success = false;
        try {
            ByteUtil.forward(tableBuffer, 29);
            tableBuffer.putShort((short)(this._maxColumnCount + 1));
            short varColCount = (short)(this._varColumns.size() + (isVarCol ? 1 : 0));
            tableBuffer.putShort(varColCount);
            tableBuffer.putShort((short)(this._columns.size() + 1));
            tableBuffer.position(format.SIZE_TDEF_HEADER + this._indexCount * format.SIZE_INDEX_DEFINITION + this._columns.size() * format.SIZE_COLUMN_DEF_BLOCK);
            int varOffset = 0;
            for (ColumnImpl columnImpl : this._varColumns) {
                if (!columnImpl.isVariableLength() || columnImpl.getVarLenTableIndex() < varOffset) continue;
                varOffset = columnImpl.getVarLenTableIndex() + 1;
            }
            int fixedOffset = 0;
            if (!column.isVariableLength() && !column.storeInNullMask()) {
                for (ColumnImpl col : this._columns) {
                    if (col.isVariableLength() || col.getFixedDataOffset() < fixedOffset) continue;
                    fixedOffset = col.getFixedDataOffset() + col.getFixedDataSize();
                }
            }
            mutator.setColumnOffsets(fixedOffset, varOffset, varOffset);
            int n = tableBuffer.position();
            ByteUtil.insertEmptyData(tableBuffer, format.SIZE_COLUMN_DEF_BLOCK);
            ColumnImpl.writeDefinition(mutator, column, tableBuffer);
            TableImpl.skipNames(tableBuffer, this._columns.size());
            ByteUtil.insertEmptyData(tableBuffer, nameByteLen);
            TableImpl.writeName(tableBuffer, column.getName(), mutator.getCharset());
            if (isLongVal) {
                Map.Entry<Integer, Integer> umapInfo = this.addUsageMaps(2, null);
                TableMutator.ColumnState colState = mutator.getColumnState(column);
                colState.setUmapPageNumber(umapInfo.getKey());
                byte rowNum = umapInfo.getValue().byteValue();
                colState.setUmapOwnedRowNumber(rowNum);
                colState.setUmapFreeRowNumber((byte)(rowNum + 1));
                ByteUtil.forward(tableBuffer, this._indexCount * format.SIZE_INDEX_COLUMN_BLOCK);
                ByteUtil.forward(tableBuffer, this._logicalIndexCount * format.SIZE_INDEX_INFO_BLOCK);
                TableImpl.skipNames(tableBuffer, this._logicalIndexCount);
                while (tableBuffer.remaining() >= 2) {
                    if (tableBuffer.getShort() == -1) {
                        ByteUtil.forward(tableBuffer, -2);
                        break;
                    }
                    ByteUtil.forward(tableBuffer, 8);
                }
                umapPos = tableBuffer.position();
                ByteUtil.insertEmptyData(tableBuffer, 10);
                ColumnImpl.writeColUsageMapDefinition(mutator, column, tableBuffer);
            }
            this.validateTableDefUpdate(mutator, tableBuffer);
            newCol = ColumnImpl.create(this, tableBuffer, n, column.getName(), this._columns.size());
            newCol.setColumnIndex(this._columns.size());
            TableImpl.writeTableDefinitionBuffer(tableBuffer, this._tableDefPageNumber, mutator, mutator.getNextPages());
            success = true;
        }
        finally {
            if (!success) {
                this._tableDefBufferH.invalidate();
            }
        }
        this._columns.add(newCol);
        this._maxColumnCount = (short)(this._maxColumnCount + 1);
        if (newCol.isVariableLength()) {
            this._varColumns.add(newCol);
            this._maxVarColumnCount = (short)(this._maxVarColumnCount + 1);
        }
        if (newCol.isAutoNumber()) {
            this._autoNumColumns.add(newCol);
        }
        if (newCol.isCalculated()) {
            this._calcColEval.add(newCol);
        }
        if (umapPos >= 0) {
            tableBuffer.position(umapPos);
            this.readColumnUsageMaps(tableBuffer);
        }
        newCol.postTableLoadInit();
        if (!this.isSystem()) {
            newCol.initColumnValidator();
        }
        if ((colProps = column.getProperties()) != null) {
            newCol.getProperties().putAll(colProps.values());
            this.getProperties().save();
        }
        this.completeTableMutation(tableBuffer);
        return newCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexData mutateAddIndexData(TableUpdater mutator) throws IOException {
        IndexBuilder index = mutator.getIndex();
        JetFormat format = mutator.getFormat();
        mutator.addTdefLen(format.SIZE_INDEX_DEFINITION + format.SIZE_INDEX_COLUMN_BLOCK);
        ByteBuffer tableBuffer = this.loadCompleteTableDefinitionBufferForUpdate(mutator);
        IndexData newIdxData = null;
        boolean success = false;
        try {
            ByteUtil.forward(tableBuffer, 39);
            tableBuffer.putInt(this._indexCount + 1);
            tableBuffer.position(format.SIZE_TDEF_HEADER + this._indexCount * format.SIZE_INDEX_DEFINITION);
            ByteUtil.insertEmptyData(tableBuffer, format.SIZE_INDEX_DEFINITION);
            IndexData.writeRowCountDefinitions(mutator, tableBuffer, 1);
            ByteUtil.forward(tableBuffer, this._columns.size() * format.SIZE_COLUMN_DEF_BLOCK);
            TableImpl.skipNames(tableBuffer, this._columns.size());
            ByteUtil.forward(tableBuffer, this._indexCount * format.SIZE_INDEX_COLUMN_BLOCK);
            TableMutator.IndexDataState idxDataState = mutator.getIndexDataState(index);
            int rootPageNumber = this.getPageChannel().allocateNewPage();
            Map.Entry<Integer, Integer> umapInfo = this.addUsageMaps(1, rootPageNumber);
            idxDataState.setRootPageNumber(rootPageNumber);
            idxDataState.setUmapPageNumber(umapInfo.getKey());
            idxDataState.setUmapRowNumber(umapInfo.getValue().byteValue());
            int idxDataDefPos = tableBuffer.position();
            ByteUtil.insertEmptyData(tableBuffer, format.SIZE_INDEX_COLUMN_BLOCK);
            IndexData.writeDefinition(mutator, tableBuffer, idxDataState, null);
            this.validateTableDefUpdate(mutator, tableBuffer);
            tableBuffer.position(0);
            newIdxData = IndexData.create(this, tableBuffer, idxDataState.getIndexDataNumber(), format);
            tableBuffer.position(idxDataDefPos);
            newIdxData.read(tableBuffer, this._columns);
            TableImpl.writeTableDefinitionBuffer(tableBuffer, this._tableDefPageNumber, mutator, mutator.getNextPages());
            success = true;
        }
        finally {
            if (!success) {
                this._tableDefBufferH.invalidate();
            }
        }
        for (IndexData.ColumnDescriptor iCol : newIdxData.getColumns()) {
            this._indexColumns.add(iCol.getColumn());
        }
        ++this._indexCount;
        this._indexDatas.add(newIdxData);
        this.completeTableMutation(tableBuffer);
        this.populateIndexData(newIdxData);
        return newIdxData;
    }

    private void populateIndexData(IndexData idxData) throws IOException {
        ArrayList<ColumnImpl> idxCols = new ArrayList<ColumnImpl>();
        for (IndexData.ColumnDescriptor col : idxData.getColumns()) {
            idxCols.add(col.getColumn());
        }
        Object[] rowVals = new Object[this._columns.size()];
        for (Row row : this.getDefaultCursor().newIterable().addColumns(idxCols)) {
            for (Column column : idxCols) {
                column.setRowValue(rowVals, column.getRowValue(row));
            }
            IndexData.commitAll(idxData.prepareAddRow(rowVals, (RowIdImpl)row.getId(), (IndexData.PendingChange)null));
        }
        this.updateTableDefinition(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexImpl mutateAddIndex(TableUpdater mutator) throws IOException {
        IndexBuilder index = mutator.getIndex();
        JetFormat format = mutator.getFormat();
        mutator.addTdefLen(format.SIZE_INDEX_INFO_BLOCK);
        int nameByteLen = DBMutator.calculateNameLength(index.getName());
        mutator.addTdefLen(nameByteLen);
        ByteBuffer tableBuffer = this.loadCompleteTableDefinitionBufferForUpdate(mutator);
        IndexImpl newIdx = null;
        boolean success = false;
        try {
            ByteUtil.forward(tableBuffer, 35);
            tableBuffer.putInt(this._logicalIndexCount + 1);
            tableBuffer.position(format.SIZE_TDEF_HEADER + this._indexCount * format.SIZE_INDEX_DEFINITION);
            ByteUtil.forward(tableBuffer, this._columns.size() * format.SIZE_COLUMN_DEF_BLOCK);
            TableImpl.skipNames(tableBuffer, this._columns.size());
            ByteUtil.forward(tableBuffer, this._indexCount * format.SIZE_INDEX_COLUMN_BLOCK);
            ByteUtil.forward(tableBuffer, this._logicalIndexCount * format.SIZE_INDEX_INFO_BLOCK);
            int idxDefPos = tableBuffer.position();
            ByteUtil.insertEmptyData(tableBuffer, format.SIZE_INDEX_INFO_BLOCK);
            IndexImpl.writeDefinition(mutator, index, tableBuffer);
            TableImpl.skipNames(tableBuffer, this._logicalIndexCount);
            ByteUtil.insertEmptyData(tableBuffer, nameByteLen);
            TableImpl.writeName(tableBuffer, index.getName(), mutator.getCharset());
            this.validateTableDefUpdate(mutator, tableBuffer);
            tableBuffer.position(idxDefPos);
            newIdx = new IndexImpl(tableBuffer, this._indexDatas, format);
            newIdx.setName(index.getName());
            TableImpl.writeTableDefinitionBuffer(tableBuffer, this._tableDefPageNumber, mutator, mutator.getNextPages());
            success = true;
        }
        finally {
            if (!success) {
                this._tableDefBufferH.invalidate();
            }
        }
        ++this._logicalIndexCount;
        this._indexes.add(newIdx);
        this.completeTableMutation(tableBuffer);
        return newIdx;
    }

    private void validateTableDefUpdate(TableUpdater mutator, ByteBuffer tableBuffer) {
        if (!mutator.validateUpdatedTdef(tableBuffer)) {
            throw new IllegalStateException(this.withErrorContext("Failed updating table definition (unexpected length)"));
        }
    }

    private void completeTableMutation(ByteBuffer tableBuffer) {
        this._tableDefBufferH.possiblyInvalidate(this._tableDefPageNumber, tableBuffer);
        this._fkEnforcer.reset();
        ++this._modCount;
    }

    private static void skipNames(ByteBuffer tableBuffer, int count) {
        for (int i = 0; i < count; ++i) {
            ByteUtil.forward(tableBuffer, tableBuffer.getShort());
        }
    }

    private ByteBuffer loadCompleteTableDefinitionBufferForUpdate(TableUpdater mutator) throws IOException {
        ByteBuffer tableBuffer = this._tableDefBufferH.withPage(this.getPageChannel(), this._tableDefPageNumber);
        tableBuffer = this.loadCompleteTableDefinitionBuffer(tableBuffer, mutator.getNextPages());
        int addedLen = mutator.getAddedTdefLen();
        int origTdefLen = tableBuffer.getInt(8);
        mutator.setOrigTdefLen(origTdefLen);
        int newTdefLen = origTdefLen + addedLen;
        while (newTdefLen > tableBuffer.capacity()) {
            tableBuffer = this.expandTableBuffer(tableBuffer);
            tableBuffer.flip();
        }
        tableBuffer.limit(origTdefLen);
        tableBuffer.position(8);
        tableBuffer.putInt(newTdefLen);
        return tableBuffer;
    }

    private Map.Entry<Integer, Integer> addUsageMaps(int numMaps, Integer firstUsedPage) throws IOException {
        JetFormat format = this.getFormat();
        PageChannel pageChannel = this.getPageChannel();
        int umapRowLength = format.OFFSET_USAGE_MAP_START + format.USAGE_MAP_TABLE_BYTE_LENGTH;
        int totalUmapSpaceUsage = TableImpl.getRowSpaceUsage(umapRowLength, format) * numMaps;
        int umapPageNumber = -1;
        int firstRowNum = -1;
        int freeSpace = 0;
        TreeSet<Integer> knownPages = new TreeSet<Integer>(Collections.reverseOrder());
        this.collectUsageMapPages(knownPages);
        ByteBuffer umapBuf = pageChannel.createPageBuffer();
        for (Integer pageNum : knownPages) {
            pageChannel.readPage(umapBuf, pageNum);
            freeSpace = umapBuf.getShort(format.OFFSET_FREE_SPACE);
            if (freeSpace < totalUmapSpaceUsage) continue;
            umapPageNumber = pageNum;
            firstRowNum = TableImpl.getRowsOnDataPage(umapBuf, format);
            break;
        }
        if (umapPageNumber == -1) {
            umapPageNumber = pageChannel.allocateNewPage();
            freeSpace = format.DATA_PAGE_INITIAL_FREE_SPACE;
            firstRowNum = 0;
            umapBuf = TableImpl.createUsageMapDefPage(pageChannel, freeSpace);
        }
        int rowStart = TableImpl.findRowEnd(umapBuf, firstRowNum, format) - umapRowLength;
        int umapRowNum = firstRowNum;
        for (int i = 0; i < numMaps; ++i) {
            umapBuf.putShort(TableImpl.getRowStartOffset(umapRowNum, format), (short)rowStart);
            umapBuf.put(rowStart, (byte)0);
            int dataOffset = rowStart + 1;
            if (firstUsedPage != null) {
                umapBuf.putInt(dataOffset, firstUsedPage);
                umapBuf.put(dataOffset += 4, (byte)1);
                ++dataOffset;
            }
            ByteUtil.clearRange(umapBuf, dataOffset, rowStart + umapRowLength);
            rowStart -= umapRowLength;
            ++umapRowNum;
        }
        umapBuf.putShort(format.OFFSET_FREE_SPACE, (short)(freeSpace -= totalUmapSpaceUsage));
        umapBuf.putShort(format.OFFSET_NUM_ROWS_ON_DATA_PAGE, (short)umapRowNum);
        pageChannel.writePage(umapBuf, umapPageNumber);
        return new AbstractMap.SimpleImmutableEntry<Integer, Integer>(umapPageNumber, firstRowNum);
    }

    void collectUsageMapPages(Collection<Integer> pages) {
        pages.add(this._ownedPages.getTablePageNumber());
        pages.add(this._freeSpacePages.getTablePageNumber());
        for (IndexData idx : this._indexDatas) {
            idx.collectUsageMapPages(pages);
        }
        for (ColumnImpl col : this._columns) {
            col.collectUsageMapPages(pages);
        }
    }

    private static void writeTableDefinitionHeader(TableCreator creator, ByteBuffer buffer, int totalTableDefSize) {
        List<ColumnBuilder> columns = creator.getColumns();
        TableImpl.writeTablePageHeader(buffer);
        buffer.putInt(totalTableDefSize);
        buffer.putInt(1625);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put((byte)1);
        for (int i = 0; i < 15; ++i) {
            buffer.put((byte)0);
        }
        buffer.put((byte)78);
        buffer.putShort((short)columns.size());
        buffer.putShort(ColumnImpl.countVariableLength(columns));
        buffer.putShort((short)columns.size());
        buffer.putInt(creator.getLogicalIndexCount());
        buffer.putInt(creator.getIndexCount());
        buffer.put((byte)0);
        ByteUtil.put3ByteInt(buffer, creator.getUmapPageNumber());
        buffer.put((byte)1);
        ByteUtil.put3ByteInt(buffer, creator.getUmapPageNumber());
    }

    private static void writeTablePageHeader(ByteBuffer buffer) {
        buffer.put((byte)2);
        buffer.put((byte)1);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.putInt(0);
    }

    static void writeName(ByteBuffer buffer, String name, Charset charset) {
        ByteBuffer encName = ColumnImpl.encodeUncompressedText(name, charset);
        buffer.putShort((short)encName.remaining());
        buffer.put(encName);
    }

    private static void createUsageMapDefinitionBuffer(TableCreator creator) throws IOException {
        List<ColumnBuilder> lvalCols = creator.getLongValueColumns();
        int indexUmapEnd = 2 + creator.getIndexCount();
        int umapNum = indexUmapEnd + lvalCols.size() * 2;
        JetFormat format = creator.getFormat();
        int umapRowLength = format.OFFSET_USAGE_MAP_START + format.USAGE_MAP_TABLE_BYTE_LENGTH;
        int umapSpaceUsage = TableImpl.getRowSpaceUsage(umapRowLength, format);
        PageChannel pageChannel = creator.getPageChannel();
        int umapPageNumber = -1;
        ByteBuffer umapBuf = null;
        int freeSpace = 0;
        int rowStart = 0;
        int umapRowNum = 0;
        for (int i = 0; i < umapNum; ++i) {
            if (umapBuf == null) {
                umapPageNumber = umapPageNumber == -1 ? creator.getUmapPageNumber() : creator.reservePageNumber();
                freeSpace = format.DATA_PAGE_INITIAL_FREE_SPACE;
                umapBuf = TableImpl.createUsageMapDefPage(pageChannel, freeSpace);
                rowStart = TableImpl.findRowEnd(umapBuf, 0, format) - umapRowLength;
                umapRowNum = 0;
            }
            umapBuf.putShort(TableImpl.getRowStartOffset(umapRowNum, format), (short)rowStart);
            if (i == 0) {
                umapBuf.put(rowStart, (byte)1);
            } else if (i == 1) {
                umapBuf.put(rowStart, (byte)0);
            } else if (i < indexUmapEnd) {
                int indexIdx = i - 2;
                TableMutator.IndexDataState idxDataState = creator.getIndexDataStates().get(indexIdx);
                int rootPageNumber = pageChannel.allocateNewPage();
                idxDataState.setRootPageNumber(rootPageNumber);
                idxDataState.setUmapRowNumber((byte)umapRowNum);
                idxDataState.setUmapPageNumber(umapPageNumber);
                umapBuf.put(rowStart, (byte)0);
                umapBuf.putInt(rowStart + 1, rootPageNumber);
                umapBuf.put(rowStart + 5, (byte)1);
            } else {
                int lvalColIdx = i - indexUmapEnd;
                int umapType = lvalColIdx % 2;
                ColumnBuilder lvalCol = lvalCols.get(lvalColIdx /= 2);
                TableMutator.ColumnState colState = creator.getColumnState(lvalCol);
                umapBuf.put(rowStart, (byte)0);
                if (umapType == 1 && umapPageNumber != colState.getUmapPageNumber()) {
                    --i;
                    umapType = 0;
                }
                if (umapType == 0) {
                    colState.setUmapOwnedRowNumber((byte)umapRowNum);
                    colState.setUmapPageNumber(umapPageNumber);
                } else {
                    colState.setUmapFreeRowNumber((byte)umapRowNum);
                }
            }
            rowStart -= umapRowLength;
            ++umapRowNum;
            if ((freeSpace -= umapSpaceUsage) > umapSpaceUsage && i != umapNum - 1) continue;
            umapBuf.putShort(format.OFFSET_FREE_SPACE, (short)freeSpace);
            umapBuf.putShort(format.OFFSET_NUM_ROWS_ON_DATA_PAGE, (short)umapRowNum);
            pageChannel.writePage(umapBuf, umapPageNumber);
            umapBuf = null;
        }
    }

    private static ByteBuffer createUsageMapDefPage(PageChannel pageChannel, int freeSpace) {
        ByteBuffer umapBuf = pageChannel.createPageBuffer();
        umapBuf.put((byte)1);
        umapBuf.put((byte)1);
        umapBuf.putShort((short)freeSpace);
        umapBuf.putInt(0);
        umapBuf.putInt(0);
        umapBuf.putShort((short)0);
        return umapBuf;
    }

    private ByteBuffer loadCompleteTableDefinitionBuffer(ByteBuffer tableBuffer, List<Integer> pages) throws IOException {
        int nextPage = tableBuffer.getInt(this.getFormat().OFFSET_NEXT_TABLE_DEF_PAGE);
        ByteBuffer nextPageBuffer = null;
        while (nextPage != 0) {
            if (pages != null) {
                pages.add(nextPage);
            }
            if (nextPageBuffer == null) {
                nextPageBuffer = this.getPageChannel().createPageBuffer();
            }
            this.getPageChannel().readPage(nextPageBuffer, nextPage);
            nextPage = nextPageBuffer.getInt(this.getFormat().OFFSET_NEXT_TABLE_DEF_PAGE);
            tableBuffer = this.expandTableBuffer(tableBuffer);
            tableBuffer.put(nextPageBuffer.array(), 8, this.getFormat().PAGE_SIZE - 8);
            tableBuffer.flip();
        }
        return tableBuffer;
    }

    private ByteBuffer expandTableBuffer(ByteBuffer tableBuffer) {
        ByteBuffer newBuffer = PageChannel.createBuffer(tableBuffer.capacity() + this.getFormat().PAGE_SIZE - 8);
        newBuffer.put(tableBuffer);
        return newBuffer;
    }

    private void readColumnDefinitions(ByteBuffer tableBuffer, short columnCount) throws IOException {
        int colOffset = this.getFormat().OFFSET_INDEX_DEF_BLOCK + this._indexCount * this.getFormat().SIZE_INDEX_DEFINITION;
        tableBuffer.position(colOffset + columnCount * this.getFormat().SIZE_COLUMN_HEADER);
        ArrayList<String> colNames = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            colNames.add(this.readName(tableBuffer));
        }
        int dispIndex = 0;
        for (int i = 0; i < columnCount; ++i) {
            ColumnImpl column = ColumnImpl.create(this, tableBuffer, colOffset + i * this.getFormat().SIZE_COLUMN_HEADER, (String)colNames.get(i), dispIndex++);
            this._columns.add(column);
            if (!column.isVariableLength()) continue;
            this._varColumns.add(column);
        }
        Collections.sort(this._columns);
        this.initAutoNumberColumns();
        this.initCalculatedColumns();
        int colIdx = 0;
        for (ColumnImpl col : this._columns) {
            col.setColumnIndex(colIdx++);
        }
        this._varColumns.sort(VAR_LEN_COLUMN_COMPARATOR);
    }

    private void readIndexDefinitions(ByteBuffer tableBuffer) throws IOException {
        int i;
        for (i = 0; i < this._indexCount; ++i) {
            IndexData idxData = this._indexDatas.get(i);
            idxData.read(tableBuffer, this._columns);
            for (IndexData.ColumnDescriptor iCol : idxData.getColumns()) {
                this._indexColumns.add(iCol.getColumn());
            }
        }
        for (i = 0; i < this._logicalIndexCount; ++i) {
            this._indexes.add(new IndexImpl(tableBuffer, this._indexDatas, this.getFormat()));
        }
        for (i = 0; i < this._logicalIndexCount; ++i) {
            this._indexes.get(i).setName(this.readName(tableBuffer));
        }
        Collections.sort(this._indexes);
    }

    private boolean readColumnUsageMaps(ByteBuffer tableBuffer) throws IOException {
        short umapColNum = tableBuffer.getShort();
        if (umapColNum == -1) {
            return false;
        }
        int pos = tableBuffer.position();
        UsageMap colOwnedPages = null;
        UsageMap colFreeSpacePages = null;
        try {
            colOwnedPages = UsageMap.read(this.getDatabase(), tableBuffer);
            colFreeSpacePages = UsageMap.read(this.getDatabase(), tableBuffer);
        }
        catch (IllegalStateException _ex) {
            colOwnedPages = null;
            colFreeSpacePages = null;
            tableBuffer.position(pos + 8);
            LOGGER.log(System.Logger.Level.WARNING, this.withErrorContext("Invalid column " + umapColNum + " usage map definition: " + String.valueOf(_ex)));
        }
        for (ColumnImpl col : this._columns) {
            if (col.getColumnNumber() != umapColNum) continue;
            col.setUsageMaps(colOwnedPages, colFreeSpacePages);
            break;
        }
        return true;
    }

    private void writeDataPage(ByteBuffer pageBuffer, int pageNumber) throws IOException {
        this.getPageChannel().writePage(pageBuffer, pageNumber);
        this._addRowBufferH.possiblyInvalidate(pageNumber, pageBuffer);
        ++this._modCount;
    }

    private String readName(ByteBuffer buffer) {
        int nameLength = this.readNameLength(buffer);
        byte[] nameBytes = ByteUtil.getBytes(buffer, nameLength);
        return ColumnImpl.decodeUncompressedText(nameBytes, this.getDatabase().getCharset());
    }

    private int readNameLength(ByteBuffer buffer) {
        return ByteUtil.getUnsignedVarInt(buffer, this.getFormat().SIZE_NAME_LENGTH);
    }

    @Override
    public Object[] asRow(Map<String, ?> rowMap) {
        return this.asRow(rowMap, null, false);
    }

    public Object[] asRowWithRowId(Map<String, ?> rowMap) {
        return this.asRow(rowMap, null, true);
    }

    @Override
    public Object[] asUpdateRow(Map<String, ?> rowMap) {
        return this.asRow(rowMap, Column.KEEP_VALUE, false);
    }

    public RowId getRowId(Object[] row) {
        return (RowId)row[this._columns.size()];
    }

    private Object[] asRow(Map<String, ?> rowMap, Object defaultValue, boolean returnRowId) {
        int len = this._columns.size();
        if (returnRowId) {
            ++len;
        }
        Object[] row = new Object[len];
        if (defaultValue != null) {
            Arrays.fill(row, defaultValue);
        }
        if (returnRowId) {
            row[len - 1] = ColumnImpl.RETURN_ROW_ID;
        }
        if (rowMap == null) {
            return row;
        }
        for (ColumnImpl col : this._columns) {
            if (!rowMap.containsKey(col.getName())) continue;
            col.setRowValue(row, col.getRowValue(rowMap));
        }
        return row;
    }

    @Override
    public Object[] addRow(Object ... row) throws IOException {
        return this.addRows(Collections.singletonList(row), false).get(0);
    }

    @Override
    public <M extends Map<String, Object>> M addRowFromMap(M row) throws IOException {
        Object[] rowValues = this.asRow(row);
        this.addRow(rowValues);
        TableImpl.returnRowValues(row, rowValues, this._columns);
        return row;
    }

    @Override
    public List<? extends Object[]> addRows(List<? extends Object[]> rows) throws IOException {
        return this.addRows(rows, true);
    }

    @Override
    public <M extends Map<String, Object>> List<M> addRowsFromMaps(List<M> rows) throws IOException {
        ArrayList<Object[]> rowValuesList = new ArrayList<Object[]>(rows.size());
        for (Map row : rows) {
            rowValuesList.add(this.asRow(row));
        }
        this.addRows(rowValuesList);
        for (int i = 0; i < rowValuesList.size(); ++i) {
            Map row;
            row = (Map)rows.get(i);
            Object[] rowValues = (Object[])rowValuesList.get(i);
            TableImpl.returnRowValues(row, rowValues, this._columns);
        }
        return rows;
    }

    private static void returnRowValues(Map<String, Object> row, Object[] rowValues, List<ColumnImpl> cols) {
        for (ColumnImpl col : cols) {
            col.setRowValue(row, col.getRowValue(rowValues));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<? extends Object[]> addRows(List<? extends Object[]> rows, boolean isBatchWrite) throws IOException {
        if (rows.isEmpty()) {
            return rows;
        }
        this.getPageChannel().startWrite();
        try {
            ByteBuffer dataPage = null;
            int pageNumber = -1;
            int updateCount = 0;
            int autoNumAssignCount = 0;
            WriteRowState writeRowState = !this._autoNumColumns.isEmpty() ? new WriteRowState() : null;
            try {
                ArrayList<? extends Object[]> dupeRows = null;
                int numCols = this._columns.size();
                for (int i = 0; i < rows.size(); ++i) {
                    ByteBuffer rowData;
                    int rowSize;
                    Object[] row = rows.get(i);
                    if (row.length < numCols || row.getClass() != Object[].class) {
                        row = TableImpl.dupeRow(row, numCols);
                        if (dupeRows == null) {
                            dupeRows = new ArrayList<Object[]>(rows);
                            rows = dupeRows;
                        }
                        dupeRows.set(i, row);
                    }
                    for (ColumnImpl column : this._columns) {
                        if (column.isAutoNumber()) continue;
                        Object val = column.getRowValue(row);
                        if (val == null) {
                            val = column.generateDefaultValue();
                        }
                        column.setRowValue(row, column.validate(val));
                    }
                    this.handleAutoNumbersForAdd(row, writeRowState);
                    ++autoNumAssignCount;
                    this._calcColEval.calculate(row);
                    if (this._rowValidator != null) {
                        this._rowValidator.validate(row);
                    }
                    if ((rowSize = (rowData = this.createRow(row, this._writeRowBufferH.getPageBuffer(this.getPageChannel()))).remaining()) > this.getFormat().MAX_ROW_SIZE) {
                        throw new InvalidValueException(this.withErrorContext("Row size " + rowSize + " is too large"));
                    }
                    dataPage = this.findFreeRowSpace(rowSize, dataPage, pageNumber);
                    pageNumber = this._addRowBufferH.getPageNumber();
                    int rowNum = TableImpl.getRowsOnDataPage(dataPage, this.getFormat());
                    RowIdImpl rowId = new RowIdImpl(pageNumber, rowNum);
                    if (!this._indexDatas.isEmpty()) {
                        IndexData.PendingChange idxChange = null;
                        try {
                            this._fkEnforcer.addRow(row);
                            for (IndexData indexData : this._indexDatas) {
                                idxChange = indexData.prepareAddRow(row, rowId, idxChange);
                            }
                            IndexData.commitAll(idxChange);
                        }
                        catch (ConstraintViolationException _ex) {
                            IndexData.rollbackAll(idxChange);
                            throw _ex;
                        }
                    }
                    TableImpl.addDataPageRow(dataPage, rowSize, this.getFormat(), 0);
                    dataPage.put(rowData);
                    if (row.length > numCols && row[numCols] == ColumnImpl.RETURN_ROW_ID) {
                        row[numCols] = rowId;
                    }
                    ++updateCount;
                }
                this.writeDataPage(dataPage, pageNumber);
                this.updateTableDefinition(rows.size());
            }
            catch (Exception _ex2) {
                boolean isWriteFailure = TableImpl.isWriteFailure(_ex2);
                if (!isWriteFailure && autoNumAssignCount > updateCount) {
                    this.restoreAutoNumbersFromAdd(rows.get(autoNumAssignCount - 1));
                }
                if (!isBatchWrite) {
                    if (_ex2 instanceof IOException) {
                        throw (IOException)_ex2;
                    }
                    throw (RuntimeException)_ex2;
                }
                if (isWriteFailure) {
                    updateCount = 0;
                } else if (updateCount > 0) {
                    try {
                        this.writeDataPage(dataPage, pageNumber);
                        this.updateTableDefinition(updateCount);
                    }
                    catch (Exception _ex) {
                        LOGGER.log(System.Logger.Level.WARNING, this.withErrorContext("Secondary row failure which preceded the write failure"), (Throwable)_ex2);
                        updateCount = 0;
                        _ex2 = _ex;
                    }
                }
                throw new BatchUpdateException(updateCount, this.withErrorContext("Failed adding rows"), _ex2);
            }
        }
        finally {
            this.getPageChannel().finishWrite();
        }
        return rows;
    }

    private static boolean isWriteFailure(Throwable t) {
        while (t != null) {
            if (t instanceof IOException && !(t instanceof JackcessException)) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    @Override
    public Row updateRow(Row row) throws IOException {
        return this.updateRowFromMap(this.getDefaultCursor().getRowState(), (RowIdImpl)row.getId(), row);
    }

    public Object[] updateRow(RowId rowId, Object ... row) throws IOException {
        return this.updateRow(this.getDefaultCursor().getRowState(), (RowIdImpl)rowId, row);
    }

    public void updateValue(Column column, RowId rowId, Object value) throws IOException {
        Object[] row = new Object[this._columns.size()];
        Arrays.fill(row, Column.KEEP_VALUE);
        column.setRowValue(row, value);
        this.updateRow(rowId, row);
    }

    public <M extends Map<String, Object>> M updateRowFromMap(RowState rowState, RowIdImpl rowId, M row) throws IOException {
        Object[] rowValues = this.updateRow(rowState, rowId, this.asUpdateRow(row));
        TableImpl.returnRowValues(row, rowValues, this._columns);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] updateRow(RowState rowState, RowIdImpl rowId, Object ... row) throws IOException {
        this.requireValidRowId(rowId);
        this.getPageChannel().startWrite();
        try {
            ByteBuffer newRowData;
            ByteBuffer rowBuffer = TableImpl.positionAtRowData(rowState, rowId);
            int oldRowSize = rowBuffer.remaining();
            this.requireNonDeletedRow(rowState, rowId);
            if (row.length < this._columns.size() || row.getClass() != Object[].class) {
                row = TableImpl.dupeRow(row, this._columns.size());
            }
            HashMap<ColumnImpl, byte[]> keepRawVarValues = !this._varColumns.isEmpty() ? new HashMap<ColumnImpl, byte[]>() : null;
            for (ColumnImpl column : this._columns) {
                if (column.isAutoNumber()) continue;
                Object rowValue = column.getRowValue(row);
                if (rowValue == Column.KEEP_VALUE) {
                    rowValue = TableImpl.getRowColumn(this.getFormat(), rowBuffer, column, rowState, keepRawVarValues);
                } else {
                    Object oldValue = Column.KEEP_VALUE;
                    oldValue = this._indexColumns.contains(column) ? TableImpl.getRowColumn(this.getFormat(), rowBuffer, column, rowState, null) : rowState.withRowCacheValue(column.getColumnIndex());
                    if (oldValue != rowValue) {
                        rowValue = column.validate(rowValue);
                    }
                }
                column.setRowValue(row, rowValue);
            }
            this.handleAutoNumbersForUpdate(row, rowBuffer, rowState);
            this._calcColEval.calculate(row);
            if (this._rowValidator != null) {
                this._rowValidator.validate(row);
            }
            if ((newRowData = this.createRow(row, this._writeRowBufferH.getPageBuffer(this.getPageChannel()), oldRowSize, keepRawVarValues)).limit() > this.getFormat().MAX_ROW_SIZE) {
                throw new InvalidValueException(this.withErrorContext("Row size " + newRowData.limit() + " is too large"));
            }
            if (!this._indexDatas.isEmpty()) {
                IndexData.PendingChange idxChange = null;
                try {
                    Object[] oldRowValues = rowState.getRowCacheValues();
                    this._fkEnforcer.updateRow(oldRowValues, row);
                    for (IndexData indexData : this._indexDatas) {
                        idxChange = indexData.prepareUpdateRow(oldRowValues, rowId, row, idxChange);
                    }
                    IndexData.commitAll(idxChange);
                }
                catch (ConstraintViolationException _ex) {
                    IndexData.rollbackAll(idxChange);
                    throw _ex;
                }
            }
            rowBuffer.reset();
            int rowSize = newRowData.remaining();
            ByteBuffer dataPage = null;
            int pageNumber = -1;
            if (oldRowSize >= rowSize) {
                rowBuffer.put(newRowData);
                dataPage = rowState.getFinalPage();
                pageNumber = rowState.getFinalRowId().getPageNumber();
            } else {
                dataPage = this.findFreeRowSpace(rowSize, null, -1);
                pageNumber = this._addRowBufferH.getPageNumber();
                RowIdImpl headerRowId = rowState.getHeaderRowId();
                ByteBuffer headerPage = rowState.getHeaderPage();
                if (pageNumber == headerRowId.getPageNumber()) {
                    dataPage = headerPage;
                }
                int rowNum = TableImpl.addDataPageRow(dataPage, rowSize, this.getFormat(), Short.MIN_VALUE);
                dataPage.put(newRowData);
                rowBuffer = PageChannel.narrowBuffer(headerPage, TableImpl.findRowStart(headerPage, headerRowId.getRowNumber(), this.getFormat()), TableImpl.findRowEnd(headerPage, headerRowId.getRowNumber(), this.getFormat()));
                rowBuffer.put((byte)rowNum);
                ByteUtil.put3ByteInt(rowBuffer, pageNumber);
                ByteUtil.clearRemaining(rowBuffer);
                int headerRowIndex = TableImpl.getRowStartOffset(headerRowId.getRowNumber(), this.getFormat());
                headerPage.putShort(headerRowIndex, (short)(headerPage.getShort(headerRowIndex) | 0x4000));
                if (pageNumber != headerRowId.getPageNumber()) {
                    this.writeDataPage(headerPage, headerRowId.getPageNumber());
                }
            }
            this.writeDataPage(dataPage, pageNumber);
            this.updateTableDefinition(0);
        }
        finally {
            this.getPageChannel().finishWrite();
        }
        return row;
    }

    private ByteBuffer findFreeRowSpace(int rowSize, ByteBuffer dataPage, int pageNumber) throws IOException {
        boolean modifiedPage = true;
        if (dataPage == null) {
            dataPage = TableImpl.findFreeRowSpace(this._ownedPages, this._freeSpacePages, this._addRowBufferH);
            if (dataPage == null) {
                return this.newDataPage();
            }
            pageNumber = this._addRowBufferH.getPageNumber();
            modifiedPage = false;
        }
        if (!TableImpl.rowFitsOnDataPage(rowSize, dataPage, this.getFormat())) {
            if (modifiedPage) {
                this.writeDataPage(dataPage, pageNumber);
            }
            this._freeSpacePages.removePageNumber(pageNumber);
            dataPage = this.newDataPage();
        }
        return dataPage;
    }

    static ByteBuffer findFreeRowSpace(UsageMap ownedPages, UsageMap freeSpacePages, TempPageHolder rowBufferH) throws IOException {
        int tmpPageNumber;
        UsageMap.PageCursor revPageCursor = ownedPages.cursor();
        revPageCursor.afterLast();
        while ((tmpPageNumber = revPageCursor.getPreviousPage()) >= 0) {
            ByteBuffer dataPage;
            if (!freeSpacePages.containsPageNumber(tmpPageNumber) || (dataPage = rowBufferH.withPage(ownedPages.getPageChannel(), tmpPageNumber)).get() != 1) continue;
            return dataPage;
        }
        return null;
    }

    private void updateTableDefinition(int rowCountInc) throws IOException {
        ByteBuffer tdefPage = this._tableDefBufferH.withPage(this.getPageChannel(), this._tableDefPageNumber);
        this._rowCount += rowCountInc;
        tdefPage.putInt(this.getFormat().OFFSET_NUM_ROWS, this._rowCount);
        tdefPage.putInt(this.getFormat().OFFSET_NEXT_AUTO_NUMBER, this._lastLongAutoNumber);
        int ctypeOff = this.getFormat().OFFSET_NEXT_COMPLEX_AUTO_NUMBER;
        if (ctypeOff >= 0) {
            tdefPage.putInt(ctypeOff, this._lastComplexTypeAutoNumber);
        }
        for (IndexData indexData : this._indexDatas) {
            tdefPage.putInt(indexData.getUniqueEntryCountOffset(), indexData.getUniqueEntryCount());
            indexData.update();
        }
        this.getPageChannel().writePage(tdefPage, this._tableDefPageNumber);
    }

    private ByteBuffer newDataPage() throws IOException {
        ByteBuffer dataPage = this._addRowBufferH.withNewPage(this.getPageChannel());
        dataPage.put((byte)1);
        dataPage.put((byte)1);
        dataPage.putShort((short)this.getFormat().DATA_PAGE_INITIAL_FREE_SPACE);
        dataPage.putInt(this._tableDefPageNumber);
        dataPage.putInt(0);
        dataPage.putShort((short)0);
        int pageNumber = this._addRowBufferH.getPageNumber();
        this.getPageChannel().writePage(dataPage, pageNumber);
        this._ownedPages.addPageNumber(pageNumber);
        this._freeSpacePages.addPageNumber(pageNumber);
        return dataPage;
    }

    protected ByteBuffer createRow(Object[] rowArray, ByteBuffer buffer) throws IOException {
        return this.createRow(rowArray, buffer, 0, Map.of());
    }

    private ByteBuffer createRow(Object[] rowArray, ByteBuffer buffer, int minRowSize, Map<ColumnImpl, byte[]> rawVarValues) throws IOException {
        int fixedDataStart;
        buffer.putShort(this._maxColumnCount);
        NullMask nullMask = new NullMask(this._maxColumnCount);
        int fixedDataEnd = fixedDataStart = buffer.position();
        for (ColumnImpl col : this._columns) {
            if (col.isVariableLength()) continue;
            Iterator<ColumnImpl> rowValue = col.getRowValue(rowArray);
            if (col.storeInNullMask()) {
                if (col.writeToNullMask(rowValue)) {
                    nullMask.markNotNull(col);
                }
                rowValue = null;
            }
            if (rowValue != null) {
                nullMask.markNotNull(col);
                buffer.position(fixedDataStart + col.getFixedDataOffset());
                buffer.put(col.write(rowValue, 0));
            }
            buffer.position(fixedDataStart + col.getFixedDataOffset() + col.getLength());
            if (buffer.position() <= fixedDataEnd) continue;
            fixedDataEnd = buffer.position();
        }
        buffer.position(fixedDataEnd);
        if (this._maxVarColumnCount > 0) {
            int maxRowSize = this.getFormat().MAX_ROW_SIZE;
            maxRowSize -= buffer.position();
            int trailerSize = nullMask.byteSize() + 4 + this._maxVarColumnCount * 2;
            maxRowSize -= trailerSize;
            for (ColumnImpl varCol : this._varColumns) {
                if (!varCol.getType().isLongValue() || varCol.getRowValue(rowArray) == null) continue;
                maxRowSize -= this.getFormat().SIZE_LONG_VALUE_DEF;
            }
            short[] varColumnOffsets = new short[this._maxVarColumnCount];
            int varColumnOffsetsIndex = 0;
            for (ColumnImpl varCol : this._varColumns) {
                short offset = (short)buffer.position();
                Object rowValue = varCol.getRowValue(rowArray);
                if (rowValue != null) {
                    nullMask.markNotNull(varCol);
                    byte[] rawValue = null;
                    ByteBuffer varDataBuf = null;
                    rawValue = rawVarValues.get(varCol);
                    varDataBuf = rawValue != null && rawValue.length <= maxRowSize ? ByteBuffer.wrap(rawValue) : varCol.write(rowValue, maxRowSize);
                    maxRowSize -= varDataBuf.remaining();
                    if (varCol.getType().isLongValue()) {
                        maxRowSize += this.getFormat().SIZE_LONG_VALUE_DEF;
                    }
                    try {
                        buffer.put(varDataBuf);
                    }
                    catch (BufferOverflowException _ex) {
                        throw new InvalidValueException(this.withErrorContext("Row size " + buffer.limit() + " is too large"));
                    }
                }
                while (varColumnOffsetsIndex <= varCol.getVarLenTableIndex()) {
                    varColumnOffsets[varColumnOffsetsIndex++] = offset;
                }
            }
            while (varColumnOffsetsIndex < varColumnOffsets.length) {
                varColumnOffsets[varColumnOffsetsIndex++] = (short)buffer.position();
            }
            int eod = buffer.position();
            TableImpl.padRowBuffer(buffer, minRowSize, trailerSize);
            buffer.putShort((short)eod);
            for (int i = this._maxVarColumnCount - 1; i >= 0; --i) {
                buffer.putShort(varColumnOffsets[i]);
            }
            buffer.putShort(this._maxVarColumnCount);
        } else {
            TableImpl.padRowBuffer(buffer, minRowSize, nullMask.byteSize());
        }
        nullMask.write(buffer);
        buffer.flip();
        return buffer;
    }

    private void handleAutoNumbersForAdd(Object[] row, WriteRowState writeRowState) throws IOException {
        if (this._autoNumColumns.isEmpty()) {
            return;
        }
        boolean enableInsert = this.isAllowAutoNumberInsert();
        writeRowState.resetAutoNumber();
        for (ColumnImpl col : this._autoNumColumns) {
            Object inRowValue = TableImpl.getInputAutoNumberRowValue(enableInsert, col, row);
            ColumnImpl.AutoNumberGenerator autoNumGen = col.getAutoNumberGenerator();
            Object rowValue = inRowValue == null ? autoNumGen.getNext(writeRowState) : autoNumGen.handleInsert(writeRowState, inRowValue);
            col.setRowValue(row, rowValue);
        }
    }

    private void handleAutoNumbersForUpdate(Object[] row, ByteBuffer rowBuffer, RowState rowState) throws IOException {
        if (this._autoNumColumns.isEmpty()) {
            return;
        }
        boolean enableInsert = this.isAllowAutoNumberInsert();
        rowState.resetAutoNumber();
        for (ColumnImpl col : this._autoNumColumns) {
            Object inRowValue = TableImpl.getInputAutoNumberRowValue(enableInsert, col, row);
            Object rowValue = inRowValue == null ? TableImpl.getRowColumn(this.getFormat(), rowBuffer, col, rowState, null) : col.getAutoNumberGenerator().handleInsert(rowState, inRowValue);
            col.setRowValue(row, rowValue);
        }
    }

    private static Object getInputAutoNumberRowValue(boolean enableInsert, ColumnImpl col, Object[] row) {
        if (!enableInsert) {
            return null;
        }
        Object inRowValue = col.getRowValue(row);
        if (inRowValue == Column.KEEP_VALUE || inRowValue == Column.AUTO_NUMBER) {
            inRowValue = null;
        }
        return inRowValue;
    }

    private void restoreAutoNumbersFromAdd(Object[] row) {
        if (this._autoNumColumns.isEmpty()) {
            return;
        }
        for (ColumnImpl col : this._autoNumColumns) {
            col.getAutoNumberGenerator().restoreLast(col.getRowValue(row));
        }
    }

    private static void padRowBuffer(ByteBuffer buffer, int minRowSize, int trailerSize) {
        int pos = buffer.position();
        if (pos + trailerSize < minRowSize) {
            int padSize = minRowSize - (pos + trailerSize);
            ByteUtil.clearRange(buffer, pos, pos + padSize);
            ByteUtil.forward(buffer, padSize);
        }
    }

    @Override
    public int getRowCount() {
        return this._rowCount;
    }

    int getNextLongAutoNumber() {
        return ++this._lastLongAutoNumber;
    }

    int getLastLongAutoNumber() {
        return this._lastLongAutoNumber;
    }

    void adjustLongAutoNumber(int inLongAutoNumber) {
        if (inLongAutoNumber > this._lastLongAutoNumber) {
            this._lastLongAutoNumber = inLongAutoNumber;
        }
    }

    void restoreLastLongAutoNumber(int lastLongAutoNumber) {
        this._lastLongAutoNumber = lastLongAutoNumber - 1;
    }

    int getNextComplexTypeAutoNumber() {
        return ++this._lastComplexTypeAutoNumber;
    }

    int getLastComplexTypeAutoNumber() {
        return this._lastComplexTypeAutoNumber;
    }

    void adjustComplexTypeAutoNumber(int inComplexTypeAutoNumber) {
        if (inComplexTypeAutoNumber > this._lastComplexTypeAutoNumber) {
            this._lastComplexTypeAutoNumber = inComplexTypeAutoNumber;
        }
    }

    void restoreLastComplexTypeAutoNumber(int lastComplexTypeAutoNumber) {
        this._lastComplexTypeAutoNumber = lastComplexTypeAutoNumber - 1;
    }

    public String toString() {
        return ToStringBuilder.builder(this).append("type", this._tableType + (!this.isSystem() ? " (USER)" : " (SYSTEM)")).append("name", this._name).append("rowCount", this._rowCount).append("columnCount", this._columns.size()).append("indexCount(data)", this._indexCount).append("logicalIndexCount", this._logicalIndexCount).appendIgnoreNull("validator", this._rowValidator).append("columns", this._columns).append("indexes", this._indexes).append("ownedPages", this._ownedPages).toString();
    }

    public String display() throws IOException {
        return this.display(Long.MAX_VALUE);
    }

    public String display(long limit) throws IOException {
        this.reset();
        StringWriter rtn = new StringWriter();
        new ExportUtil.Builder(this.getDefaultCursor()).withDelimiter("\t").withHeader(true).exportWriter(new BufferedWriter(rtn));
        return rtn.toString();
    }

    public static int addDataPageRow(ByteBuffer dataPage, int rowSize, JetFormat format, int rowFlags) {
        int rowSpaceUsage = TableImpl.getRowSpaceUsage(rowSize, format);
        short freeSpaceInPage = dataPage.getShort(format.OFFSET_FREE_SPACE);
        dataPage.putShort(format.OFFSET_FREE_SPACE, (short)(freeSpaceInPage - rowSpaceUsage));
        short rowCount = dataPage.getShort(format.OFFSET_NUM_ROWS_ON_DATA_PAGE);
        dataPage.putShort(format.OFFSET_NUM_ROWS_ON_DATA_PAGE, (short)(rowCount + 1));
        short rowLocation = TableImpl.findRowEnd(dataPage, rowCount, format);
        rowLocation = (short)(rowLocation - rowSize);
        dataPage.putShort(TableImpl.getRowStartOffset(rowCount, format), (short)(rowLocation | rowFlags));
        dataPage.position(rowLocation);
        return rowCount;
    }

    static int getRowsOnDataPage(ByteBuffer rowBuffer, JetFormat format) {
        int rowsOnPage = 0;
        if (rowBuffer != null && rowBuffer.get(0) == 1) {
            rowsOnPage = rowBuffer.getShort(format.OFFSET_NUM_ROWS_ON_DATA_PAGE);
        }
        return rowsOnPage;
    }

    private void requireValidRowId(RowIdImpl rowId) {
        if (!rowId.isValid()) {
            throw new IllegalArgumentException(this.withErrorContext("Given rowId is invalid: " + String.valueOf(rowId)));
        }
    }

    private void requireNonDeletedRow(RowState rowState, RowIdImpl rowId) {
        if (!rowState.isValid()) {
            throw new IllegalArgumentException(this.withErrorContext("Given rowId is invalid for this table: " + String.valueOf(rowId)));
        }
        if (rowState.isDeleted()) {
            throw new IllegalStateException(this.withErrorContext("Row is deleted: " + String.valueOf(rowId)));
        }
    }

    public static boolean isDeletedRow(short rowStart) {
        return (rowStart & Short.MIN_VALUE) != 0;
    }

    public static boolean isOverflowRow(short rowStart) {
        return (rowStart & 0x4000) != 0;
    }

    public static short cleanRowStart(short rowStart) {
        return (short)(rowStart & 0x1FFF);
    }

    public static short findRowStart(ByteBuffer buffer, int rowNum, JetFormat format) {
        return TableImpl.cleanRowStart(buffer.getShort(TableImpl.getRowStartOffset(rowNum, format)));
    }

    public static int getRowStartOffset(int rowNum, JetFormat format) {
        return format.OFFSET_ROW_START + format.SIZE_ROW_LOCATION * rowNum;
    }

    public static short findRowEnd(ByteBuffer buffer, int rowNum, JetFormat format) {
        return (short)(rowNum == 0 ? format.PAGE_SIZE : (int)TableImpl.cleanRowStart(buffer.getShort(TableImpl.getRowEndOffset(rowNum, format))));
    }

    public static int getRowEndOffset(int rowNum, JetFormat format) {
        return format.OFFSET_ROW_START + format.SIZE_ROW_LOCATION * (rowNum - 1);
    }

    public static int getRowSpaceUsage(int rowSize, JetFormat format) {
        return rowSize + format.SIZE_ROW_LOCATION;
    }

    private void initAutoNumberColumns() {
        for (ColumnImpl c : this._columns) {
            if (!c.isAutoNumber()) continue;
            this._autoNumColumns.add(c);
        }
    }

    private void initCalculatedColumns() {
        for (ColumnImpl c : this._columns) {
            if (!c.isCalculated()) continue;
            this._calcColEval.add(c);
        }
    }

    boolean isThisTable(Identifier identifier) {
        String collectionName = identifier.getCollectionName();
        return collectionName == null || collectionName.equalsIgnoreCase(this.getName());
    }

    public static boolean rowFitsOnDataPage(int rowLength, ByteBuffer dataPage, JetFormat format) {
        int rowSpaceUsage = TableImpl.getRowSpaceUsage(rowLength, format);
        short freeSpaceInPage = dataPage.getShort(format.OFFSET_FREE_SPACE);
        int rowsOnPage = TableImpl.getRowsOnDataPage(dataPage, format);
        return rowSpaceUsage <= freeSpaceInPage && rowsOnPage < format.MAX_NUM_ROWS_ON_DATA_PAGE;
    }

    static Object[] dupeRow(Object[] row, int newRowLength) {
        Object[] copy = new Object[newRowLength];
        System.arraycopy(row, 0, copy, 0, Math.min(row.length, newRowLength));
        return copy;
    }

    String withErrorContext(String msg) {
        return msg + " (Db=" + this.getDatabase().getName() + "; Table=" + this.getName() + ")";
    }

    private class CalcColEvaluator {
        private final List<ColumnImpl> _calcColumns = new ArrayList<ColumnImpl>(1);
        private boolean _sorted;

        private CalcColEvaluator() {
        }

        public void add(ColumnImpl col) {
            if (!TableImpl.this.getDatabase().isEvaluateExpressions()) {
                return;
            }
            this._calcColumns.add(col);
            this._sorted = false;
        }

        public void reSort() {
            this._sorted = false;
        }

        public void calculate(Object[] row) throws IOException {
            if (!this._sorted) {
                this.sortColumnsByDeps();
                this._sorted = true;
            }
            for (ColumnImpl col : this._calcColumns) {
                Object rowValue = col.getCalculationContext().eval(row);
                col.setRowValue(row, rowValue);
            }
        }

        private void sortColumnsByDeps() {
            new TopoSorter<ColumnImpl>(this._calcColumns, true){

                @Override
                protected void fillDescendents(ColumnImpl from, List<ColumnImpl> descendents) {
                    LinkedHashSet<Identifier> identifiers = new LinkedHashSet<Identifier>();
                    from.getCalculationContext().collectIdentifiers(identifiers);
                    for (Identifier identifier : identifiers) {
                        if (!TableImpl.this.isThisTable(identifier)) continue;
                        String colName = identifier.getObjectName();
                        for (ColumnImpl calcCol : CalcColEvaluator.this._calcColumns) {
                            if (!calcCol.getName().equalsIgnoreCase(colName)) continue;
                            descendents.add(calcCol);
                        }
                    }
                }
            }.sort();
        }
    }

    public final class RowState
    extends WriteRowState
    implements ErrorHandler.Location {
        private final TempPageHolder _headerRowBufferH;
        private RowIdImpl _headerRowId = RowIdImpl.FIRST_ROW_ID;
        private int _rowsOnHeaderPage;
        private RowStateStatus _status = RowStateStatus.INIT;
        private RowStatus _rowStatus = RowStatus.INIT;
        private final TempPageHolder _overflowRowBufferH = TempPageHolder.newHolder(TempBufferHolder.Type.SOFT);
        private ByteBuffer _finalRowBuffer;
        private RowIdImpl _finalRowId = null;
        private boolean _haveRowValues;
        private Object[] _rowValues;
        private NullMask _nullMask;
        private int _lastModCount;
        private ErrorHandler _errorHandler;
        private short[] _varColOffsets;

        private RowState(TempBufferHolder.Type headerType) {
            this._headerRowBufferH = TempPageHolder.newHolder(headerType);
            this._rowValues = new Object[TableImpl.this.getColumnCount()];
            this._lastModCount = TableImpl.this._modCount;
        }

        @Override
        public TableImpl getTable() {
            return TableImpl.this;
        }

        public ErrorHandler getErrorHandler() {
            return this._errorHandler != null ? this._errorHandler : this.getTable().getErrorHandler();
        }

        public void setErrorHandler(ErrorHandler newErrorHandler) {
            this._errorHandler = newErrorHandler;
        }

        public void reset() {
            this.resetAutoNumber();
            this._finalRowId = null;
            this._finalRowBuffer = null;
            this._rowsOnHeaderPage = 0;
            this._status = RowStateStatus.INIT;
            this._rowStatus = RowStatus.INIT;
            this._varColOffsets = null;
            this._nullMask = null;
            if (this._haveRowValues) {
                Arrays.fill(this._rowValues, null);
                this._haveRowValues = false;
            }
        }

        public boolean isUpToDate() {
            return TableImpl.this._modCount == this._lastModCount;
        }

        private void checkForModification() {
            if (!this.isUpToDate()) {
                this.reset();
                this._headerRowBufferH.invalidate();
                this._overflowRowBufferH.invalidate();
                int colCount = TableImpl.this.getColumnCount();
                if (colCount != this._rowValues.length) {
                    this._rowValues = new Object[colCount];
                }
                this._lastModCount = TableImpl.this._modCount;
            }
        }

        private ByteBuffer getFinalPage() throws IOException {
            if (this._finalRowBuffer == null) {
                this._finalRowBuffer = this.getHeaderPage();
            }
            return this._finalRowBuffer;
        }

        public RowIdImpl getFinalRowId() {
            if (this._finalRowId == null) {
                this._finalRowId = this.getHeaderRowId();
            }
            return this._finalRowId;
        }

        private void setRowStatus(RowStatus rowStatus) {
            this._rowStatus = rowStatus;
        }

        public boolean isValid() {
            return this._rowStatus.ordinal() >= RowStatus.VALID.ordinal();
        }

        public boolean isDeleted() {
            return this._rowStatus == RowStatus.DELETED;
        }

        public boolean isOverflow() {
            return this._rowStatus == RowStatus.OVERFLOW;
        }

        public boolean isHeaderPageNumberValid() {
            return this._rowStatus.ordinal() > RowStatus.INVALID_PAGE.ordinal();
        }

        public boolean isHeaderRowNumberValid() {
            return this._rowStatus.ordinal() > RowStatus.INVALID_ROW.ordinal();
        }

        private void setStatus(RowStateStatus status) {
            this._status = status;
        }

        public boolean isAtHeaderRow() {
            return this._status.ordinal() >= RowStateStatus.AT_HEADER.ordinal();
        }

        public boolean isAtFinalRow() {
            return this._status.ordinal() >= RowStateStatus.AT_FINAL.ordinal();
        }

        private Object withRowCacheValue(int idx, Object value) {
            this._haveRowValues = true;
            this._rowValues[idx] = value;
            return value;
        }

        private Object withRowCacheValue(int idx) {
            Object value = this._rowValues[idx];
            return ColumnImpl.isImmutableValue(value) ? value : null;
        }

        public Object[] getRowCacheValues() {
            return TableImpl.dupeRow(this._rowValues, this._rowValues.length);
        }

        public NullMask getNullMask(ByteBuffer rowBuffer) {
            if (this._nullMask == null) {
                this._nullMask = TableImpl.this.getRowNullMask(rowBuffer);
            }
            return this._nullMask;
        }

        private short[] getVarColOffsets() {
            return this._varColOffsets;
        }

        private void setVarColOffsets(short[] varColOffsets) {
            this._varColOffsets = varColOffsets;
        }

        public RowIdImpl getHeaderRowId() {
            return this._headerRowId;
        }

        public int getRowsOnHeaderPage() {
            return this._rowsOnHeaderPage;
        }

        private ByteBuffer getHeaderPage() throws IOException {
            this.checkForModification();
            return this._headerRowBufferH.getPage(TableImpl.this.getPageChannel());
        }

        private ByteBuffer withHeaderRow(RowIdImpl rowId) throws IOException {
            this.checkForModification();
            if (this.isAtHeaderRow() && this.getHeaderRowId().equals(rowId)) {
                return this.isValid() ? this.getHeaderPage() : null;
            }
            this.reset();
            this._headerRowId = rowId;
            this._finalRowId = rowId;
            int pageNumber = rowId.getPageNumber();
            int rowNumber = rowId.getRowNumber();
            if (pageNumber < 0 || !TableImpl.this._ownedPages.containsPageNumber(pageNumber)) {
                this.setRowStatus(RowStatus.INVALID_PAGE);
                return null;
            }
            this._finalRowBuffer = this._headerRowBufferH.withPage(TableImpl.this.getPageChannel(), pageNumber);
            this._rowsOnHeaderPage = TableImpl.getRowsOnDataPage(this._finalRowBuffer, TableImpl.this.getFormat());
            if (rowNumber < 0 || rowNumber >= this._rowsOnHeaderPage) {
                this.setRowStatus(RowStatus.INVALID_ROW);
                return null;
            }
            this.setRowStatus(RowStatus.VALID);
            return this._finalRowBuffer;
        }

        private ByteBuffer withOverflowRow(RowIdImpl rowId) throws IOException {
            if (!this.isUpToDate()) {
                throw new IllegalStateException(this.getTable().withErrorContext("Table modified while searching?"));
            }
            if (this._rowStatus != RowStatus.OVERFLOW) {
                throw new IllegalStateException(this.getTable().withErrorContext("Row is not an overflow row?"));
            }
            this._finalRowId = rowId;
            this._finalRowBuffer = this._overflowRowBufferH.withPage(TableImpl.this.getPageChannel(), rowId.getPageNumber());
            return this._finalRowBuffer;
        }

        private Object handleRowError(ColumnImpl column, byte[] columnData, Exception error) throws IOException {
            return this.getErrorHandler().handleRowError(column, columnData, this, error);
        }

        @Override
        public String toString() {
            return ToStringBuilder.valueBuilder(this).append("headerRowId", this._headerRowId).append("finalRowId", this._finalRowId).toString();
        }
    }

    public static enum IndexFeature {
        EXACT_MATCH,
        EXACT_UNIQUE_ONLY,
        ANY_MATCH;

    }

    private static enum RowStateStatus {
        INIT,
        AT_HEADER,
        AT_FINAL;

    }

    private static enum RowStatus {
        INIT,
        INVALID_PAGE,
        INVALID_ROW,
        VALID,
        DELETED,
        NORMAL,
        OVERFLOW;

    }

    protected static class WriteRowState {
        private int _complexAutoNumber = 0;

        protected WriteRowState() {
        }

        public int getComplexAutoNumber() {
            return this._complexAutoNumber;
        }

        public void setComplexAutoNumber(int complexAutoNumber) {
            this._complexAutoNumber = complexAutoNumber;
        }

        public void resetAutoNumber() {
            this._complexAutoNumber = 0;
        }
    }
}

