/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.io.github.spannm.jackcess.DataType;
import shaded.io.github.spannm.jackcess.PropertyMap;
import shaded.io.github.spannm.jackcess.impl.ByteArrayBuilder;
import shaded.io.github.spannm.jackcess.impl.ByteUtil;
import shaded.io.github.spannm.jackcess.impl.ColumnImpl;
import shaded.io.github.spannm.jackcess.impl.DatabaseImpl;
import shaded.io.github.spannm.jackcess.impl.JetFormat;
import shaded.io.github.spannm.jackcess.impl.PageChannel;
import shaded.io.github.spannm.jackcess.impl.PropertyMapImpl;
import shaded.io.github.spannm.jackcess.impl.RowIdImpl;
import shaded.io.github.spannm.jackcess.util.StringUtil;
import shaded.io.github.spannm.jackcess.util.ToStringBuilder;

public class PropertyMaps
implements Iterable<PropertyMapImpl> {
    public static final String DEFAULT_NAME = "";
    private static final short PROPERTY_NAME_LIST = 128;
    private static final short DEFAULT_PROPERTY_VALUE_LIST = 0;
    private static final short COLUMN_PROPERTY_VALUE_LIST = 1;
    private final Map<String, PropertyMapImpl> _maps = new LinkedHashMap<String, PropertyMapImpl>();
    private final int _objectId;
    private final RowIdImpl _rowId;
    private final Handler _handler;
    private final Owner _owner;

    public PropertyMaps(int objectId, RowIdImpl rowId, Handler handler, Owner owner) {
        this._objectId = objectId;
        this._rowId = rowId;
        this._handler = handler;
        this._owner = owner;
    }

    public int getObjectId() {
        return this._objectId;
    }

    public int getSize() {
        return this._maps.size();
    }

    public boolean isEmpty() {
        return this._maps.isEmpty();
    }

    public PropertyMapImpl getDefault() {
        return this.get(DEFAULT_NAME, (short)0);
    }

    public PropertyMapImpl get(String name) {
        return this.get(name, (short)1);
    }

    private PropertyMapImpl get(String name, short type) {
        String lookupName = DatabaseImpl.toLookupName(name);
        PropertyMapImpl map = this._maps.get(lookupName);
        if (map == null) {
            map = new PropertyMapImpl(name, type, this);
            this._maps.put(lookupName, map);
        }
        return map;
    }

    @Override
    public Iterator<PropertyMapImpl> iterator() {
        return this._maps.values().iterator();
    }

    public byte[] write() throws IOException {
        return this._handler.write(this);
    }

    public void save() throws IOException {
        this._handler.save(this);
        if (this._owner != null) {
            this._owner.propertiesUpdated();
        }
    }

    public String toString() {
        return ToStringBuilder.builder(this).append(null, this._maps.values()).toString();
    }

    public static String getTrimmedStringProperty(PropertyMap props, String propName) {
        return StringUtil.trimToNull((String)props.getValue(propName));
    }

    static final class Handler {
        private final DatabaseImpl _database;
        private final ColumnImpl _propCol;
        private final Map<DataType, PropColumn> _columns = new HashMap<DataType, PropColumn>();

        Handler(DatabaseImpl database) {
            this._database = database;
            this._propCol = this._database.getSystemCatalog().getColumn("LvProp");
        }

        public PropertyMaps read(byte[] propBytes, int objectId, RowIdImpl rowId, Owner owner) throws IOException {
            PropertyMaps maps = new PropertyMaps(objectId, rowId, this, owner);
            if (propBytes == null || propBytes.length == 0) {
                return maps;
            }
            ByteBuffer bb = PageChannel.wrap(propBytes);
            boolean knownType = false;
            for (byte[] tmpType : JetFormat.PROPERTY_MAP_TYPES) {
                if (!ByteUtil.matchesRange(bb, bb.position(), tmpType)) continue;
                ByteUtil.forward(bb, tmpType.length);
                knownType = true;
                break;
            }
            if (!knownType) {
                throw new IOException("Unknown property map type " + ByteUtil.toHexString(bb, 4));
            }
            List<String> propNames = null;
            while (bb.hasRemaining()) {
                int len = bb.getInt();
                short type = bb.getShort();
                int endPos = bb.position() + len - 6;
                ByteBuffer bbBlock = PageChannel.narrowBuffer(bb, bb.position(), endPos);
                if (type == 128) {
                    propNames = this.readPropertyNames(bbBlock);
                } else {
                    this.readPropertyValues(bbBlock, propNames, type, maps);
                }
                bb.position(endPos);
            }
            return maps;
        }

        public byte[] write(PropertyMaps maps) throws IOException {
            if (maps == null) {
                return null;
            }
            ByteArrayBuilder bab = new ByteArrayBuilder();
            bab.put(this._database.getFormat().PROPERTY_MAP_TYPE);
            LinkedHashSet<String> propNames = new LinkedHashSet<String>();
            for (PropertyMapImpl propMap : maps) {
                for (PropertyMap.Property prop : propMap) {
                    propNames.add(prop.getName());
                }
            }
            if (propNames.isEmpty()) {
                return null;
            }
            this.writeBlock(null, propNames, (short)128, bab);
            for (PropertyMapImpl propMap : maps) {
                if (propMap.isEmpty()) continue;
                this.writeBlock(propMap, propNames, propMap.getType(), bab);
            }
            return bab.toArray();
        }

        public void save(PropertyMaps maps) throws IOException {
            RowIdImpl rowId = maps._rowId;
            if (rowId == null) {
                throw new IllegalStateException("PropertyMaps cannot be saved without a row id");
            }
            byte[] mapsBytes = this.write(maps);
            this._propCol.getTable().updateValue(this._propCol, rowId, mapsBytes);
        }

        private void writeBlock(PropertyMapImpl propMap, Set<String> propNames, short blockType, ByteArrayBuilder bab) throws IOException {
            int blockStartPos = bab.position();
            bab.reserveInt().putShort(blockType);
            if (blockType == 128) {
                this.writePropertyNames(propNames, bab);
            } else {
                this.writePropertyValues(propMap, propNames, bab);
            }
            int len = bab.position() - blockStartPos;
            bab.putInt(blockStartPos, len);
        }

        private List<String> readPropertyNames(ByteBuffer bbBlock) {
            ArrayList<String> names = new ArrayList<String>();
            while (bbBlock.hasRemaining()) {
                names.add(this.readPropName(bbBlock));
            }
            return names;
        }

        private void writePropertyNames(Set<String> propNames, ByteArrayBuilder bab) {
            for (String propName : propNames) {
                this.writePropName(propName, bab);
            }
        }

        private PropertyMapImpl readPropertyValues(ByteBuffer bbBlock, List<String> propNames, short blockType, PropertyMaps maps) throws IOException {
            String mapName = PropertyMaps.DEFAULT_NAME;
            if (bbBlock.hasRemaining()) {
                int nameBlockLen = bbBlock.getInt();
                int endPos = bbBlock.position() + nameBlockLen - 4;
                if (nameBlockLen > 6) {
                    mapName = this.readPropName(bbBlock);
                }
                bbBlock.position(endPos);
            }
            PropertyMapImpl map = maps.get(mapName, blockType);
            while (bbBlock.hasRemaining()) {
                short valLen = bbBlock.getShort();
                int endPos = bbBlock.position() + valLen - 2;
                boolean isDdl = bbBlock.get() != 0;
                DataType dataType = DataType.fromByte(bbBlock.get());
                short nameIdx = bbBlock.getShort();
                short dataSize = bbBlock.getShort();
                String propName = propNames.get(nameIdx);
                PropColumn col = this.getColumn(dataType, propName, dataSize, null);
                byte[] data = ByteUtil.getBytes(bbBlock, dataSize);
                Object value = col.read(data);
                map.put(propName, dataType, value, isDdl);
                bbBlock.position(endPos);
            }
            return map;
        }

        private void writePropertyValues(PropertyMapImpl propMap, Set<String> propNames, ByteArrayBuilder bab) throws IOException {
            String mapName = propMap.getName();
            int blockStartPos = bab.position();
            bab.reserveInt();
            this.writePropName(mapName, bab);
            int len = bab.position() - blockStartPos;
            bab.putInt(blockStartPos, len);
            int nameIdx = 0;
            for (String propName : propNames) {
                Object value;
                PropertyMapImpl.PropertyImpl prop = (PropertyMapImpl.PropertyImpl)propMap.get(propName);
                if (prop != null && (value = prop.getValue()) != null) {
                    int valStartPos = bab.position();
                    bab.reserveShort();
                    byte ddlFlag = (byte)(prop.isDdl() ? 1 : 0);
                    bab.put(ddlFlag);
                    bab.put(prop.getType().getValue());
                    bab.putShort((short)nameIdx);
                    PropColumn col = this.getColumn(prop.getType(), propName, -1, value);
                    ByteBuffer data = col.write(value, this._database.getFormat().MAX_ROW_SIZE);
                    bab.putShort((short)data.remaining());
                    bab.put(data);
                    len = bab.position() - valStartPos;
                    bab.putShort(valStartPos, (short)len);
                }
                ++nameIdx;
            }
        }

        private String readPropName(ByteBuffer buffer) {
            short nameLength = buffer.getShort();
            byte[] nameBytes = ByteUtil.getBytes(buffer, nameLength);
            return ColumnImpl.decodeUncompressedText(nameBytes, this._database.getCharset());
        }

        private void writePropName(String propName, ByteArrayBuilder bab) {
            ByteBuffer textBuf = ColumnImpl.encodeUncompressedText(propName, this._database.getCharset());
            bab.putShort((short)textBuf.remaining());
            bab.put(textBuf);
        }

        private PropColumn getColumn(DataType dataType, String propName, int dataSize, Object value) throws IOException {
            PropColumn col;
            if (Handler.isPseudoGuidColumn(dataType, propName, dataSize, value)) {
                dataType = DataType.GUID;
            }
            if ((col = this._columns.get((Object)dataType)) == null) {
                DataType colType = dataType;
                if (dataType == DataType.MEMO) {
                    colType = DataType.TEXT;
                } else if (dataType == DataType.OLE) {
                    colType = DataType.BINARY;
                }
                col = colType == DataType.BOOLEAN ? new BooleanPropColumn() : new PropColumn(colType);
                this._columns.put(dataType, col);
            }
            return col;
        }

        private static boolean isPseudoGuidColumn(DataType dataType, String propName, int dataSize, Object value) throws IOException {
            return dataType == DataType.BINARY && (dataSize == DataType.GUID.getFixedSize() || dataSize == -1 && ColumnImpl.isGUIDValue(value)) && "GUID".equalsIgnoreCase(propName);
        }

        private class PropColumn
        extends ColumnImpl {
            private PropColumn(DataType type) {
                super(null, null, type, 0, 0, 0);
            }

            @Override
            public DatabaseImpl getDatabase() {
                return Handler.this._database;
            }
        }

        private final class BooleanPropColumn
        extends PropColumn {
            private BooleanPropColumn() {
                super(DataType.BOOLEAN);
            }

            @Override
            public Object read(byte[] data) {
                return data[0] != 0 ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public ByteBuffer write(Object obj, int remainingRowLength) {
                ByteBuffer buffer = PageChannel.createBuffer(1);
                buffer.put(((Number)BooleanPropColumn.booleanToInteger(obj)).byteValue());
                buffer.flip();
                return buffer;
            }
        }
    }

    static interface Owner {
        public void propertiesUpdated() throws IOException;
    }
}

