/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.Normalizer;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import shaded.io.github.spannm.jackcess.DataType;
import shaded.io.github.spannm.jackcess.JackcessRuntimeException;
import shaded.io.github.spannm.jackcess.impl.ByteUtil;
import shaded.io.github.spannm.jackcess.impl.ColumnImpl;
import shaded.io.github.spannm.jackcess.impl.PageChannel;
import shaded.io.github.spannm.jackcess.util.OleBlob;
import shaded.io.github.spannm.jackcess.util.ToStringBuilder;

public class OleUtil {
    private static final int PACKAGE_SIGNATURE = 7189;
    private static final Charset OLE_CHARSET = StandardCharsets.US_ASCII;
    private static final Charset OLE_UTF_CHARSET = StandardCharsets.UTF_16LE;
    private static final byte[] COMPOUND_STORAGE_SIGNATURE = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final String SIMPLE_PACKAGE_TYPE = "Package";
    private static final int PACKAGE_OBJECT_TYPE = 2;
    private static final int OLE_VERSION = 1281;
    private static final int OLE_FORMAT = 2;
    private static final int PACKAGE_STREAM_SIGNATURE = 2;
    private static final int PS_EMBEDDED_FILE = 196608;
    private static final int PS_LINKED_FILE = 65536;
    private static final Set<OleBlob.ContentType> WRITEABLE_TYPES = EnumSet.of(OleBlob.ContentType.LINK, OleBlob.ContentType.SIMPLE_PACKAGE, OleBlob.ContentType.OTHER);
    private static final byte[] NO_DATA = new byte[0];
    private static final int LINK_HEADER = 1;
    private static final byte[] PACKAGE_FOOTER = new byte[]{1, 5, 0, 0, 0, 0, 0, 0, 1, -83, 5, -2};
    private static final Pattern UNICODE_ACCENT_PATTERN = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");
    private static final CompoundPackageFactory COMPOUND_FACTORY;

    private OleUtil() {
    }

    public static OleBlob parseBlob(byte[] bytes) {
        return new OleBlobImpl(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OleBlob createBlob(OleBlob.Builder oleBuilder) throws IOException {
        try {
            if (!WRITEABLE_TYPES.contains((Object)oleBuilder.getType())) {
                throw new IllegalArgumentException("Cannot currently create ole values of type " + String.valueOf((Object)oleBuilder.getType()));
            }
            long contentLen = oleBuilder.getContentLength();
            byte[] contentBytes = oleBuilder.getBytes();
            InputStream contentStream = oleBuilder.getStream();
            byte[] packageStreamHeader = NO_DATA;
            byte[] packageStreamFooter = NO_DATA;
            switch (oleBuilder.getType()) {
                case LINK: {
                    packageStreamHeader = OleUtil.writePackageStreamHeader(oleBuilder);
                    contentBytes = OleUtil.getZeroTermStrBytes(oleBuilder.getFilePath());
                    contentLen = contentBytes.length;
                    break;
                }
                case SIMPLE_PACKAGE: {
                    packageStreamHeader = OleUtil.writePackageStreamHeader(oleBuilder);
                    packageStreamFooter = OleUtil.writePackageStreamFooter(oleBuilder);
                    break;
                }
                case OTHER: {
                    break;
                }
                default: {
                    throw new JackcessRuntimeException("Unexpected type " + String.valueOf((Object)oleBuilder.getType()));
                }
            }
            long payloadLen = (long)(packageStreamHeader.length + packageStreamFooter.length) + contentLen;
            byte[] packageHeader = OleUtil.writePackageHeader(oleBuilder, payloadLen);
            long totalOleLen = (long)(packageHeader.length + PACKAGE_FOOTER.length) + payloadLen;
            if (totalOleLen > (long)DataType.OLE.getMaxSize()) {
                throw new IllegalArgumentException("Content size of " + totalOleLen + " is too large for ole column");
            }
            byte[] oleBytes = new byte[(int)totalOleLen];
            ByteBuffer bb = PageChannel.wrap(oleBytes);
            bb.put(packageHeader);
            bb.put(packageStreamHeader);
            if (contentLen > 0L) {
                if (contentBytes != null) {
                    bb.put(contentBytes);
                } else {
                    byte[] buf = new byte[8192];
                    int numBytes = 0;
                    while ((numBytes = contentStream.read(buf)) >= 0) {
                        bb.put(buf, 0, numBytes);
                    }
                }
            }
            bb.put(packageStreamFooter);
            bb.put(PACKAGE_FOOTER);
            OleBlob oleBlob = OleUtil.parseBlob(oleBytes);
            return oleBlob;
        }
        finally {
            ByteUtil.closeQuietly(oleBuilder.getStream());
        }
    }

    private static byte[] writePackageHeader(OleBlob.Builder oleBuilder, long contentLen) {
        byte[] prettyNameBytes = OleUtil.getZeroTermStrBytes(oleBuilder.getPrettyName());
        String className = oleBuilder.getClassName();
        String typeName = oleBuilder.getTypeName();
        if (className == null) {
            className = typeName;
        } else if (typeName == null) {
            typeName = className;
        }
        byte[] classNameBytes = OleUtil.getZeroTermStrBytes(className);
        byte[] typeNameBytes = OleUtil.getZeroTermStrBytes(typeName);
        int packageHeaderLen = 20 + prettyNameBytes.length + classNameBytes.length;
        int oleHeaderLen = 24 + typeNameBytes.length;
        byte[] headerBytes = new byte[packageHeaderLen + oleHeaderLen];
        ByteBuffer bb = PageChannel.wrap(headerBytes);
        bb.putShort((short)7189);
        bb.putShort((short)packageHeaderLen);
        bb.putInt(2);
        bb.putShort((short)prettyNameBytes.length);
        bb.putShort((short)classNameBytes.length);
        int prettyNameOff = bb.position() + 8;
        bb.putShort((short)prettyNameOff);
        bb.putShort((short)(prettyNameOff + prettyNameBytes.length));
        bb.putInt(-1);
        bb.put(prettyNameBytes);
        bb.put(classNameBytes);
        bb.putInt(1281);
        bb.putInt(2);
        bb.putInt(typeNameBytes.length);
        bb.put(typeNameBytes);
        bb.putLong(0L);
        bb.putInt((int)contentLen);
        return headerBytes;
    }

    private static byte[] writePackageStreamHeader(OleBlob.Builder oleBuilder) {
        byte[] fileNameBytes = OleUtil.getZeroTermStrBytes(oleBuilder.getFileName());
        byte[] filePathBytes = OleUtil.getZeroTermStrBytes(oleBuilder.getFilePath());
        int headerLen = 6 + fileNameBytes.length + filePathBytes.length;
        headerLen = oleBuilder.getType() == OleBlob.ContentType.SIMPLE_PACKAGE ? (headerLen += 8 + filePathBytes.length) : (headerLen += 2);
        byte[] headerBytes = new byte[headerLen];
        ByteBuffer bb = PageChannel.wrap(headerBytes);
        bb.putShort((short)2);
        bb.put(fileNameBytes);
        bb.put(filePathBytes);
        if (oleBuilder.getType() == OleBlob.ContentType.SIMPLE_PACKAGE) {
            bb.putInt(196608);
            bb.putInt(filePathBytes.length);
            bb.put(filePathBytes, 0, filePathBytes.length);
            bb.putInt((int)oleBuilder.getContentLength());
        } else {
            bb.putInt(65536);
            bb.putShort((short)1);
        }
        return headerBytes;
    }

    private static byte[] writePackageStreamFooter(OleBlob.Builder oleBuilder) {
        byte[] fileNameBytes = oleBuilder.getFileName().getBytes(OLE_UTF_CHARSET);
        byte[] filePathBytes = oleBuilder.getFilePath().getBytes(OLE_UTF_CHARSET);
        int footerLen = 12 + filePathBytes.length * 2 + fileNameBytes.length;
        byte[] footerBytes = new byte[footerLen];
        ByteBuffer bb = PageChannel.wrap(footerBytes);
        bb.putInt(filePathBytes.length / 2);
        bb.put(filePathBytes);
        bb.putInt(fileNameBytes.length / 2);
        bb.put(fileNameBytes);
        bb.putInt(filePathBytes.length / 2);
        bb.put(filePathBytes);
        return footerBytes;
    }

    private static ContentImpl parseContent(OleBlobImpl blob) throws IOException {
        ByteBuffer bb = PageChannel.wrap(blob.getBytes());
        if (bb.remaining() < 2 || bb.getShort() != 7189) {
            return new UnknownContentImpl(blob);
        }
        short headerSize = bb.getShort();
        bb.getInt();
        short prettyNameLen = bb.getShort();
        short classNameLen = bb.getShort();
        short prettyNameOff = bb.getShort();
        short classNameOff = bb.getShort();
        bb.getInt();
        String prettyName = OleUtil.readStr(bb, prettyNameOff, prettyNameLen);
        String className = OleUtil.readStr(bb, classNameOff, classNameLen);
        bb.position(headerSize);
        int oleVer = bb.getInt();
        bb.getInt();
        if (oleVer != 1281) {
            return new UnknownContentImpl(blob);
        }
        int typeNameLen = bb.getInt();
        String typeName = OleUtil.readStr(bb, bb.position(), typeNameLen);
        bb.getLong();
        int dataBlockLen = bb.getInt();
        int dataBlockPos = bb.position();
        if (SIMPLE_PACKAGE_TYPE.equalsIgnoreCase(typeName)) {
            return OleUtil.createSimplePackageContent(blob, prettyName, className, typeName, bb, dataBlockLen);
        }
        if (COMPOUND_FACTORY != null && bb.remaining() >= COMPOUND_STORAGE_SIGNATURE.length && ByteUtil.matchesRange(bb, bb.position(), COMPOUND_STORAGE_SIGNATURE)) {
            return COMPOUND_FACTORY.createCompoundPackageContent(blob, prettyName, className, typeName, bb, dataBlockLen);
        }
        return new OtherContentImpl(blob, prettyName, className, typeName, dataBlockPos, dataBlockLen);
    }

    private static ContentImpl createSimplePackageContent(OleBlobImpl blob, String prettyName, String className, String typeName, ByteBuffer blobBb, int dataBlockLen) {
        int dataBlockPos = blobBb.position();
        ByteBuffer bb = PageChannel.narrowBuffer(blobBb, dataBlockPos, dataBlockPos + dataBlockLen);
        short packageSig = bb.getShort();
        if (packageSig != 2) {
            return new OtherContentImpl(blob, prettyName, className, typeName, dataBlockPos, dataBlockLen);
        }
        String fileName = OleUtil.readZeroTermStr(bb);
        String filePath = OleUtil.readZeroTermStr(bb);
        int packageType = bb.getInt();
        if (packageType == 196608) {
            int rem;
            int localFilePathLen = bb.getInt();
            String localFilePath = OleUtil.readStr(bb, bb.position(), localFilePathLen);
            int dataLen = bb.getInt();
            int dataPos = bb.position();
            bb.position(dataLen + dataPos);
            int strNum = 0;
            while ((rem = bb.remaining()) >= 4) {
                int strLen = bb.getInt();
                String remStr = OleUtil.readStr(bb, bb.position(), strLen * 2, OLE_UTF_CHARSET);
                switch (strNum) {
                    case 0: {
                        localFilePath = remStr;
                        break;
                    }
                    case 1: {
                        fileName = remStr;
                        break;
                    }
                    case 2: {
                        filePath = remStr;
                        break;
                    }
                }
                ++strNum;
            }
            return new SimplePackageContentImpl(blob, prettyName, className, typeName, dataPos, dataLen, fileName, filePath, localFilePath);
        }
        if (packageType == 65536) {
            bb.getShort();
            String linkStr = OleUtil.readZeroTermStr(bb);
            return new LinkContentImpl(blob, prettyName, className, typeName, fileName, linkStr, filePath);
        }
        return new OtherContentImpl(blob, prettyName, className, typeName, dataBlockPos, dataBlockLen);
    }

    private static String readStr(ByteBuffer bb, int off, int len) {
        return OleUtil.readStr(bb, off, len, OLE_CHARSET);
    }

    private static String readZeroTermStr(ByteBuffer bb) {
        byte b;
        int off = bb.position();
        while (bb.hasRemaining() && (b = bb.get()) != 0) {
        }
        int len = bb.position() - off;
        return OleUtil.readStr(bb, off, len);
    }

    private static String readStr(ByteBuffer bb, int off, int len, Charset charset) {
        String str = new String(bb.array(), off, len, charset);
        bb.position(off + len);
        if (str.charAt(str.length() - 1) == '\u0000') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static byte[] getZeroTermStrBytes(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFD);
        str = UNICODE_ACCENT_PATTERN.matcher(str).replaceAll("");
        str = Normalizer.normalize(str, Normalizer.Form.NFC);
        return (str + "\u0000").getBytes(OLE_CHARSET);
    }

    static {
        CompoundPackageFactory compoundFactory = null;
        try {
            compoundFactory = (CompoundPackageFactory)Class.forName("shaded.io.github.spannm.jackcess.impl.CompoundOleUtil").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        COMPOUND_FACTORY = compoundFactory;
    }

    static final class OleBlobImpl
    implements OleBlob,
    ColumnImpl.InMemoryBlob {
        private byte[] _bytes;
        private ContentImpl _content;

        private OleBlobImpl(byte[] bytes) {
            this._bytes = bytes;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this._bytes);
        }

        @Override
        public OleBlob.Content getContent() throws IOException {
            if (this._content == null) {
                this._content = OleUtil.parseContent(this);
            }
            return this._content;
        }

        @Override
        public InputStream getBinaryStream() {
            return new ByteArrayInputStream(this._bytes);
        }

        @Override
        public InputStream getBinaryStream(long pos, long len) {
            return new ByteArrayInputStream(this._bytes, OleBlobImpl.fromJdbcOffset(pos), (int)len);
        }

        @Override
        public long length() {
            return this._bytes.length;
        }

        @Override
        public byte[] getBytes() throws IOException {
            if (this._bytes == null) {
                throw new IOException("blob is closed");
            }
            return this._bytes;
        }

        @Override
        public byte[] getBytes(long pos, int len) {
            return ByteUtil.copyOf(this._bytes, OleBlobImpl.fromJdbcOffset(pos), len);
        }

        @Override
        public long position(byte[] pattern, long start) {
            int pos = ByteUtil.findRange(PageChannel.wrap(this._bytes), OleBlobImpl.fromJdbcOffset(start), pattern);
            return pos >= 0 ? (long)OleBlobImpl.toJdbcOffset(pos) : (long)pos;
        }

        @Override
        public long position(Blob pattern, long start) throws SQLException {
            return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
        }

        @Override
        public OutputStream setBinaryStream(long position) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public void truncate(long len) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public int setBytes(long pos, byte[] bytes) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int lesn) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public void free() {
            this.close();
        }

        @Override
        public void close() {
            this._bytes = null;
            ByteUtil.closeQuietly(this._content);
            this._content = null;
        }

        private static int toJdbcOffset(int off) {
            return off + 1;
        }

        private static int fromJdbcOffset(long off) {
            return (int)off - 1;
        }

        public String toString() {
            ToStringBuilder sb = ToStringBuilder.builder(this);
            if (this._content != null) {
                sb.append("content", this._content);
            } else {
                sb.append("bytes", this._bytes).append("content", "(uninitialized)");
            }
            return sb.toString();
        }
    }

    private static final class UnknownContentImpl
    extends ContentImpl {
        private UnknownContentImpl(OleBlobImpl blob) {
            super(blob);
        }

        @Override
        public OleBlob.ContentType getType() {
            return OleBlob.ContentType.UNKNOWN;
        }

        public String toString() {
            return this.toString(ToStringBuilder.builder(this)).append("content", this._blob._bytes).toString();
        }
    }

    static abstract class ContentImpl
    implements OleBlob.Content,
    Closeable {
        protected final OleBlobImpl _blob;

        protected ContentImpl(OleBlobImpl blob) {
            this._blob = blob;
        }

        @Override
        public OleBlobImpl getBlob() {
            return this._blob;
        }

        protected byte[] getBytes() throws IOException {
            return this.getBlob().getBytes();
        }

        @Override
        public void close() {
        }

        protected ToStringBuilder toString(ToStringBuilder sb) {
            sb.append("type", (Object)this.getType());
            return sb;
        }
    }

    static interface CompoundPackageFactory {
        public ContentImpl createCompoundPackageContent(OleBlobImpl var1, String var2, String var3, String var4, ByteBuffer var5, int var6);
    }

    private static final class OtherContentImpl
    extends EmbeddedPackageContentImpl
    implements OleBlob.OtherContent {
        private OtherContentImpl(OleBlobImpl blob, String prettyName, String className, String typeName, int position, int length) {
            super(blob, prettyName, className, typeName, position, length);
        }

        @Override
        public OleBlob.ContentType getType() {
            return OleBlob.ContentType.OTHER;
        }

        public String toString() {
            return this.toString(ToStringBuilder.builder(this)).toString();
        }
    }

    private static final class SimplePackageContentImpl
    extends EmbeddedPackageContentImpl
    implements OleBlob.SimplePackageContent {
        private final String _fileName;
        private final String _filePath;
        private final String _localFilePath;

        private SimplePackageContentImpl(OleBlobImpl blob, String prettyName, String className, String typeName, int position, int length, String fileName, String filePath, String localFilePath) {
            super(blob, prettyName, className, typeName, position, length);
            this._fileName = fileName;
            this._filePath = filePath;
            this._localFilePath = localFilePath;
        }

        @Override
        public OleBlob.ContentType getType() {
            return OleBlob.ContentType.SIMPLE_PACKAGE;
        }

        @Override
        public String getFileName() {
            return this._fileName;
        }

        @Override
        public String getFilePath() {
            return this._filePath;
        }

        @Override
        public String getLocalFilePath() {
            return this._localFilePath;
        }

        public String toString() {
            return this.toString(ToStringBuilder.builder(this)).append("fileName", this._fileName).append("filePath", this._filePath).append("localFilePath", this._localFilePath).toString();
        }
    }

    private static final class LinkContentImpl
    extends EmbeddedPackageContentImpl
    implements OleBlob.LinkContent {
        private final String _fileName;
        private final String _linkPath;
        private final String _filePath;

        private LinkContentImpl(OleBlobImpl blob, String prettyName, String className, String typeName, String fileName, String linkPath, String filePath) {
            super(blob, prettyName, className, typeName, -1, -1);
            this._fileName = fileName;
            this._linkPath = linkPath;
            this._filePath = filePath;
        }

        @Override
        public OleBlob.ContentType getType() {
            return OleBlob.ContentType.LINK;
        }

        @Override
        public String getFileName() {
            return this._fileName;
        }

        @Override
        public String getLinkPath() {
            return this._linkPath;
        }

        @Override
        public String getFilePath() {
            return this._filePath;
        }

        @Override
        public InputStream getLinkStream() throws IOException {
            return new FileInputStream(this.getLinkPath());
        }

        public String toString() {
            return this.toString(ToStringBuilder.builder(this)).append("fileName", this._fileName).append("linkPath", this._linkPath).append("filePath", this._filePath).toString();
        }
    }

    static abstract class EmbeddedPackageContentImpl
    extends EmbeddedContentImpl
    implements OleBlob.PackageContent {
        private final String _prettyName;
        private final String _className;
        private final String _typeName;

        protected EmbeddedPackageContentImpl(OleBlobImpl blob, String prettyName, String className, String typeName, int position, int length) {
            super(blob, position, length);
            this._prettyName = prettyName;
            this._className = className;
            this._typeName = typeName;
        }

        @Override
        public String getPrettyName() {
            return this._prettyName;
        }

        @Override
        public String getClassName() {
            return this._className;
        }

        @Override
        public String getTypeName() {
            return this._typeName;
        }

        @Override
        protected ToStringBuilder toString(ToStringBuilder sb) {
            sb.append("prettyName", this._prettyName).append("className", this._className).append("typeName", this._typeName);
            super.toString(sb);
            return sb;
        }
    }

    static abstract class EmbeddedContentImpl
    extends ContentImpl
    implements OleBlob.EmbeddedContent {
        private final int _position;
        private final int _length;

        protected EmbeddedContentImpl(OleBlobImpl blob, int position, int length) {
            super(blob);
            this._position = position;
            this._length = length;
        }

        @Override
        public long length() {
            return this._length;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes(), this._position, this._length);
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.getBytes(), this._position, this._length);
        }

        @Override
        protected ToStringBuilder toString(ToStringBuilder sb) {
            super.toString(sb);
            if (this._position >= 0) {
                sb.append("content", ByteBuffer.wrap(this._blob._bytes, this._position, this._length));
            }
            return sb;
        }
    }
}

