/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import shaded.io.github.spannm.jackcess.Column;
import shaded.io.github.spannm.jackcess.Cursor;
import shaded.io.github.spannm.jackcess.JackcessRuntimeException;
import shaded.io.github.spannm.jackcess.Row;
import shaded.io.github.spannm.jackcess.RowId;
import shaded.io.github.spannm.jackcess.impl.ColumnImpl;
import shaded.io.github.spannm.jackcess.impl.IndexImpl;
import shaded.io.github.spannm.jackcess.impl.JetFormat;
import shaded.io.github.spannm.jackcess.impl.PageChannel;
import shaded.io.github.spannm.jackcess.impl.RowIdImpl;
import shaded.io.github.spannm.jackcess.impl.TableImpl;
import shaded.io.github.spannm.jackcess.impl.TableScanCursor;
import shaded.io.github.spannm.jackcess.util.ColumnMatcher;
import shaded.io.github.spannm.jackcess.util.ErrorHandler;
import shaded.io.github.spannm.jackcess.util.IterableBuilder;
import shaded.io.github.spannm.jackcess.util.SimpleColumnMatcher;

public abstract class CursorImpl
implements Cursor {
    private static final System.Logger LOGGER = System.getLogger(CursorImpl.class.getName());
    public static final boolean MOVE_FORWARD = true;
    public static final boolean MOVE_REVERSE = false;
    private final IdImpl mid;
    private final TableImpl mtable;
    private final TableImpl.RowState mrowState;
    private final PositionImpl mfirstPos;
    private final PositionImpl mlastPos;
    protected PositionImpl mprevPos;
    protected PositionImpl mcurPos;
    protected ColumnMatcher mcolumnMatcher = SimpleColumnMatcher.INSTANCE;

    protected CursorImpl(IdImpl id, TableImpl table, PositionImpl firstPos, PositionImpl lastPos) {
        this.mid = id;
        this.mtable = table;
        this.mrowState = this.mtable.createRowState();
        this.mfirstPos = firstPos;
        this.mlastPos = lastPos;
        this.mcurPos = firstPos;
        this.mprevPos = firstPos;
    }

    public static CursorImpl createCursor(TableImpl table) {
        return new TableScanCursor(table);
    }

    public TableImpl.RowState getRowState() {
        return this.mrowState;
    }

    @Override
    public IdImpl getId() {
        return this.mid;
    }

    @Override
    public TableImpl getTable() {
        return this.mtable;
    }

    public JetFormat getFormat() {
        return this.getTable().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getTable().getPageChannel();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.mrowState.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler newErrorHandler) {
        this.mrowState.setErrorHandler(newErrorHandler);
    }

    @Override
    public ColumnMatcher getColumnMatcher() {
        return this.mcolumnMatcher;
    }

    @Override
    public void setColumnMatcher(ColumnMatcher columnMatcher) {
        if (columnMatcher == null) {
            columnMatcher = this.getDefaultColumnMatcher();
        }
        this.mcolumnMatcher = columnMatcher;
    }

    protected ColumnMatcher getDefaultColumnMatcher() {
        return SimpleColumnMatcher.INSTANCE;
    }

    @Override
    public SavepointImpl getSavepoint() {
        return new SavepointImpl(this.mid, this.mcurPos, this.mprevPos);
    }

    @Override
    public void restoreSavepoint(Cursor.Savepoint savepoint) throws IOException {
        this.restoreSavepoint((SavepointImpl)savepoint);
    }

    public void restoreSavepoint(SavepointImpl savepoint) throws IOException {
        if (!this.mid.equals(savepoint.getCursorId())) {
            throw new IllegalArgumentException("Savepoint " + String.valueOf(savepoint) + " is not valid for this cursor with id " + String.valueOf(this.mid));
        }
        this.restorePosition(savepoint.getCurrentPosition(), savepoint.getPreviousPosition());
    }

    protected PositionImpl getFirstPosition() {
        return this.mfirstPos;
    }

    protected PositionImpl getLastPosition() {
        return this.mlastPos;
    }

    @Override
    public void reset() {
        this.beforeFirst();
    }

    @Override
    public void beforeFirst() {
        this.reset(true);
    }

    @Override
    public void afterLast() {
        this.reset(false);
    }

    @Override
    public boolean isBeforeFirst() throws IOException {
        return this.isAtBeginning(true);
    }

    @Override
    public boolean isAfterLast() throws IOException {
        return this.isAtBeginning(false);
    }

    protected boolean isAtBeginning(boolean moveForward) throws IOException {
        return this.getDirHandler(moveForward).getBeginningPosition().equals(this.mcurPos) && !this.recheckPosition(!moveForward);
    }

    @Override
    public boolean isCurrentRowDeleted() throws IOException {
        TableImpl.positionAtRowData(this.mrowState, this.mcurPos.getRowId());
        return this.mrowState.isDeleted();
    }

    protected void reset(boolean moveForward) {
        this.mprevPos = this.mcurPos = this.getDirHandler(moveForward).getBeginningPosition();
        this.mrowState.reset();
    }

    @Override
    public Iterator<Row> iterator() {
        return new RowIterator(null, true, true);
    }

    @Override
    public IterableBuilder newIterable() {
        return new IterableBuilder(this);
    }

    public Iterator<Row> iterator(IterableBuilder iterBuilder) {
        switch (iterBuilder.getType()) {
            case SIMPLE: {
                return new RowIterator(iterBuilder.getColumnNames(), iterBuilder.isReset(), iterBuilder.isForward());
            }
            case COLUMN_MATCH: {
                Map.Entry entry = (Map.Entry)iterBuilder.getMatchPattern();
                return new ColumnMatchIterator(iterBuilder.getColumnNames(), (ColumnImpl)entry.getKey(), entry.getValue(), iterBuilder.isReset(), iterBuilder.isForward(), iterBuilder.getColumnMatcher());
            }
            case ROW_MATCH: {
                Map map = (Map)iterBuilder.getMatchPattern();
                return new RowMatchIterator(iterBuilder.getColumnNames(), map, iterBuilder.isReset(), iterBuilder.isForward(), iterBuilder.getColumnMatcher());
            }
        }
        throw new JackcessRuntimeException("Unknown match type " + String.valueOf((Object)iterBuilder.getType()));
    }

    @Override
    public void deleteCurrentRow() throws IOException {
        this.mtable.deleteRow(this.mrowState, this.mcurPos.getRowId());
    }

    @Override
    public Object[] updateCurrentRow(Object ... row) throws IOException {
        return this.mtable.updateRow(this.mrowState, this.mcurPos.getRowId(), row);
    }

    @Override
    public <M extends Map<String, Object>> M updateCurrentRowFromMap(M row) throws IOException {
        return this.mtable.updateRowFromMap(this.mrowState, this.mcurPos.getRowId(), row);
    }

    @Override
    public Row getNextRow() throws IOException {
        return this.getNextRow(null);
    }

    @Override
    public Row getNextRow(Collection<String> columnNames) throws IOException {
        return this.getAnotherRow(columnNames, true);
    }

    @Override
    public Row getPreviousRow() throws IOException {
        return this.getPreviousRow(null);
    }

    @Override
    public Row getPreviousRow(Collection<String> columnNames) throws IOException {
        return this.getAnotherRow(columnNames, false);
    }

    private Row getAnotherRow(Collection<String> columnNames, boolean moveForward) throws IOException {
        if (this.moveToAnotherRow(moveForward)) {
            return this.getCurrentRow(columnNames);
        }
        return null;
    }

    @Override
    public boolean moveToNextRow() throws IOException {
        return this.moveToAnotherRow(true);
    }

    @Override
    public boolean moveToPreviousRow() throws IOException {
        return this.moveToAnotherRow(false);
    }

    protected boolean moveToAnotherRow(boolean moveForward) throws IOException {
        if (this.mcurPos.equals(this.getDirHandler(moveForward).getEndPosition())) {
            return this.recheckPosition(moveForward);
        }
        return this.moveToAnotherRowImpl(moveForward);
    }

    protected void restorePosition(PositionImpl curPos) throws IOException {
        this.restorePosition(curPos, this.mcurPos);
    }

    protected final void restorePosition(PositionImpl curPos, PositionImpl prevPos) throws IOException {
        if (!curPos.equals(this.mcurPos) || !prevPos.equals(this.mprevPos)) {
            this.restorePositionImpl(curPos, prevPos);
        }
    }

    protected void restorePositionImpl(PositionImpl curPos, PositionImpl prevPos) throws IOException {
        this.mprevPos = this.mcurPos;
        this.mcurPos = curPos;
        this.mrowState.reset();
    }

    private boolean recheckPosition(boolean moveForward) throws IOException {
        if (this.isUpToDate()) {
            return false;
        }
        this.restorePosition(this.mprevPos);
        return this.moveToAnotherRowImpl(moveForward);
    }

    private boolean moveToAnotherRowImpl(boolean moveForward) throws IOException {
        this.mrowState.reset();
        this.mprevPos = this.mcurPos;
        this.mcurPos = this.findAnotherPosition(this.mrowState, this.mcurPos, moveForward);
        TableImpl.positionAtRowHeader(this.mrowState, this.mcurPos.getRowId());
        return !this.mcurPos.equals(this.getDirHandler(moveForward).getEndPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findRow(RowId rowId) throws IOException {
        RowIdImpl rowIdImpl = (RowIdImpl)rowId;
        PositionImpl curPos = this.mcurPos;
        PositionImpl prevPos = this.mprevPos;
        boolean found = false;
        try {
            this.reset(true);
            if (TableImpl.positionAtRowHeader(this.mrowState, rowIdImpl) == null) {
                boolean bl = false;
                return bl;
            }
            this.restorePosition(this.getRowPosition(rowIdImpl));
            if (!this.isCurrentRowValid()) {
                boolean bl = false;
                return bl;
            }
            found = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException _ex) {
                    LOGGER.log(System.Logger.Level.ERROR, "Failed restoring position", (Throwable)_ex);
                }
            }
        }
    }

    @Override
    public boolean findFirstRow(Column columnPattern, Object valuePattern) throws IOException {
        return this.findFirstRow((ColumnImpl)columnPattern, valuePattern);
    }

    public boolean findFirstRow(ColumnImpl columnPattern, Object valuePattern) throws IOException {
        return this.findAnotherRow(columnPattern, valuePattern, true, true, this.mcolumnMatcher, this.prepareSearchInfo(columnPattern, valuePattern));
    }

    @Override
    public boolean findNextRow(Column columnPattern, Object valuePattern) throws IOException {
        return this.findNextRow((ColumnImpl)columnPattern, valuePattern);
    }

    public boolean findNextRow(ColumnImpl columnPattern, Object valuePattern) throws IOException {
        return this.findAnotherRow(columnPattern, valuePattern, false, true, this.mcolumnMatcher, this.prepareSearchInfo(columnPattern, valuePattern));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean findAnotherRow(ColumnImpl columnPattern, Object valuePattern, boolean reset, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        PositionImpl curPos = this.mcurPos;
        PositionImpl prevPos = this.mprevPos;
        boolean found = false;
        try {
            if (reset) {
                this.reset(moveForward);
            }
            boolean bl = found = this.findAnotherRowImpl(columnPattern, valuePattern, moveForward, columnMatcher, searchInfo);
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException _ex) {
                    LOGGER.log(System.Logger.Level.ERROR, "Failed restoring position", (Throwable)_ex);
                }
            }
        }
    }

    @Override
    public boolean findFirstRow(Map<String, ?> rowPattern) throws IOException {
        return this.findAnotherRow(rowPattern, true, true, this.mcolumnMatcher, this.prepareSearchInfo(rowPattern));
    }

    @Override
    public boolean findNextRow(Map<String, ?> rowPattern) throws IOException {
        return this.findAnotherRow(rowPattern, false, true, this.mcolumnMatcher, this.prepareSearchInfo(rowPattern));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean findAnotherRow(Map<String, ?> rowPattern, boolean reset, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        PositionImpl curPos = this.mcurPos;
        PositionImpl prevPos = this.mprevPos;
        boolean found = false;
        try {
            if (reset) {
                this.reset(moveForward);
            }
            boolean bl = found = this.findAnotherRowImpl(rowPattern, moveForward, columnMatcher, searchInfo);
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException _ex) {
                    LOGGER.log(System.Logger.Level.ERROR, "Failed restoring position", (Throwable)_ex);
                }
            }
        }
    }

    @Override
    public boolean currentRowMatches(Column columnPattern, Object valuePattern) throws IOException {
        return this.currentRowMatches((ColumnImpl)columnPattern, valuePattern);
    }

    public boolean currentRowMatches(ColumnImpl columnPattern, Object valuePattern) throws IOException {
        return this.currentRowMatchesImpl(columnPattern, valuePattern, this.mcolumnMatcher);
    }

    protected boolean currentRowMatchesImpl(ColumnImpl columnPattern, Object valuePattern, ColumnMatcher columnMatcher) throws IOException {
        return this.currentRowMatchesPattern(columnPattern.getName(), valuePattern, columnMatcher, this.getCurrentRowValue(columnPattern));
    }

    @Override
    public boolean currentRowMatches(Map<String, ?> rowPattern) throws IOException {
        return this.currentRowMatchesImpl(rowPattern, this.mcolumnMatcher);
    }

    protected boolean currentRowMatchesImpl(Map<String, ?> rowPattern, ColumnMatcher columnMatcher) throws IOException {
        Row row = this.getCurrentRow(rowPattern.keySet());
        if (rowPattern.size() != row.size()) {
            return false;
        }
        for (Map.Entry e : row.entrySet()) {
            String columnName = (String)e.getKey();
            if (this.currentRowMatchesPattern(columnName, rowPattern.get(columnName), columnMatcher, e.getValue())) continue;
            return false;
        }
        return true;
    }

    protected final boolean currentRowMatchesPattern(String columnPattern, Object valuePattern, ColumnMatcher columnMatcher, Object rowValue) {
        if (valuePattern instanceof Predicate) {
            return ((Predicate)valuePattern).test(rowValue);
        }
        return columnMatcher.matches(this.getTable(), columnPattern, valuePattern, rowValue);
    }

    protected boolean findAnotherRowImpl(ColumnImpl columnPattern, Object valuePattern, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        while (this.moveToAnotherRow(moveForward)) {
            if (this.currentRowMatchesImpl(columnPattern, valuePattern, columnMatcher)) {
                return true;
            }
            if (this.keepSearching(columnMatcher, searchInfo)) continue;
            break;
        }
        return false;
    }

    protected boolean findAnotherRowImpl(Map<String, ?> rowPattern, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        while (this.moveToAnotherRow(moveForward)) {
            if (this.currentRowMatchesImpl(rowPattern, columnMatcher)) {
                return true;
            }
            if (this.keepSearching(columnMatcher, searchInfo)) continue;
            break;
        }
        return false;
    }

    protected Object prepareSearchInfo(ColumnImpl columnPattern, Object valuePattern) {
        return null;
    }

    protected Object prepareSearchInfo(Map<String, ?> rowPattern) {
        return null;
    }

    protected boolean keepSearching(ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        return true;
    }

    @Override
    public int moveNextRows(int numRows) throws IOException {
        return this.moveSomeRows(numRows, true);
    }

    @Override
    public int movePreviousRows(int numRows) throws IOException {
        return this.moveSomeRows(numRows, false);
    }

    private int moveSomeRows(int numRows, boolean moveForward) throws IOException {
        int numMovedRows;
        for (numMovedRows = 0; numMovedRows < numRows && this.moveToAnotherRow(moveForward); ++numMovedRows) {
        }
        return numMovedRows;
    }

    @Override
    public Row getCurrentRow() throws IOException {
        return this.getCurrentRow(null);
    }

    @Override
    public Row getCurrentRow(Collection<String> columnNames) throws IOException {
        return this.mtable.getRow(this.mrowState, this.mcurPos.getRowId(), columnNames);
    }

    @Override
    public Object getCurrentRowValue(Column column) throws IOException {
        return this.getCurrentRowValue((ColumnImpl)column);
    }

    public Object getCurrentRowValue(ColumnImpl column) throws IOException {
        return this.mtable.getRowValue(this.mrowState, this.mcurPos.getRowId(), column);
    }

    @Override
    public void setCurrentRowValue(Column column, Object value) throws IOException {
        this.setCurrentRowValue((ColumnImpl)column, value);
    }

    public void setCurrentRowValue(ColumnImpl column, Object value) throws IOException {
        Object[] row = new Object[this.mtable.getColumnCount()];
        Arrays.fill(row, Column.KEEP_VALUE);
        column.setRowValue(row, value);
        this.mtable.updateRow(this.mrowState, this.mcurPos.getRowId(), row);
    }

    protected boolean isUpToDate() {
        return this.mrowState.isUpToDate();
    }

    protected boolean isCurrentRowValid() throws IOException {
        return this.mcurPos.getRowId().isValid() && !this.isCurrentRowDeleted() && !this.isBeforeFirst() && !this.isAfterLast();
    }

    public String toString() {
        return String.format("%s[id=%s, table=%s, prevPos=%s, curPos=%s]", this.getClass().getSimpleName(), this.mid, this.mtable, this.mprevPos, this.mcurPos);
    }

    protected abstract PositionImpl getRowPosition(RowIdImpl var1) throws IOException;

    protected abstract PositionImpl findAnotherPosition(TableImpl.RowState var1, PositionImpl var2, boolean var3) throws IOException;

    protected abstract DirHandler getDirHandler(boolean var1);

    protected static final class IdImpl
    implements Cursor.Id {
        private final int _tablePageNumber;
        private final int _indexNumber;

        protected IdImpl(TableImpl table, IndexImpl index) {
            this._tablePageNumber = table.getTableDefPageNumber();
            this._indexNumber = index != null ? index.getIndexNumber() : -1;
        }

        public int hashCode() {
            return this._tablePageNumber;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this._tablePageNumber == ((IdImpl)o)._tablePageNumber && this._indexNumber == ((IdImpl)o)._indexNumber;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this._tablePageNumber + ":" + this._indexNumber;
        }
    }

    protected static abstract class PositionImpl
    implements Cursor.Position {
        protected PositionImpl() {
        }

        public final int hashCode() {
            return this.getRowId().hashCode();
        }

        public final boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.equalsImpl(o);
        }

        @Override
        public abstract RowIdImpl getRowId();

        protected abstract boolean equalsImpl(Object var1);
    }

    protected static final class SavepointImpl
    implements Cursor.Savepoint {
        private final IdImpl _cursorId;
        private final PositionImpl _curPos;
        private final PositionImpl _prevPos;

        private SavepointImpl(IdImpl cursorId, PositionImpl curPos, PositionImpl prevPos) {
            this._cursorId = cursorId;
            this._curPos = curPos;
            this._prevPos = prevPos;
        }

        @Override
        public IdImpl getCursorId() {
            return this._cursorId;
        }

        @Override
        public PositionImpl getCurrentPosition() {
            return this._curPos;
        }

        private PositionImpl getPreviousPosition() {
            return this._prevPos;
        }

        public String toString() {
            return String.format("%s[cursorId=%s, curPos=%s, prevPos=%s]", this.getClass().getSimpleName(), this._cursorId, this._curPos, this._prevPos);
        }
    }

    protected static abstract class DirHandler {
        protected DirHandler() {
        }

        public abstract PositionImpl getBeginningPosition();

        public abstract PositionImpl getEndPosition();
    }

    private final class RowIterator
    extends BaseIterator {
        private RowIterator(Collection<String> columnNames, boolean reset, boolean moveForward) {
            super(columnNames, reset, moveForward, null);
        }

        @Override
        protected boolean findNext() throws IOException {
            return CursorImpl.this.moveToAnotherRow(this._moveForward);
        }
    }

    private final class ColumnMatchIterator
    extends BaseIterator {
        private final ColumnImpl _columnPattern;
        private final Object _valuePattern;
        private final Object _searchInfo;

        private ColumnMatchIterator(Collection<String> columnNames, ColumnImpl columnPattern, Object valuePattern, boolean reset, boolean moveForward, ColumnMatcher columnMatcher) {
            super(columnNames, reset, moveForward, columnMatcher);
            this._columnPattern = columnPattern;
            this._valuePattern = valuePattern;
            this._searchInfo = CursorImpl.this.prepareSearchInfo(columnPattern, valuePattern);
        }

        @Override
        protected boolean findNext() throws IOException {
            return CursorImpl.this.findAnotherRow(this._columnPattern, this._valuePattern, false, this._moveForward, this._colMatcher, this._searchInfo);
        }
    }

    private final class RowMatchIterator
    extends BaseIterator {
        private final Map<String, ?> _rowPattern;
        private final Object _searchInfo;

        private RowMatchIterator(Collection<String> columnNames, Map<String, ?> rowPattern, boolean reset, boolean moveForward, ColumnMatcher columnMatcher) {
            super(columnNames, reset, moveForward, columnMatcher);
            this._rowPattern = rowPattern;
            this._searchInfo = CursorImpl.this.prepareSearchInfo(rowPattern);
        }

        @Override
        protected boolean findNext() throws IOException {
            return CursorImpl.this.findAnotherRow(this._rowPattern, false, this._moveForward, this._colMatcher, this._searchInfo);
        }
    }

    protected abstract class BaseIterator
    implements Iterator<Row> {
        protected final Collection<String> _columnNames;
        protected final boolean _moveForward;
        protected final ColumnMatcher _colMatcher;
        protected Boolean _hasNext;
        protected boolean _validRow;

        protected BaseIterator(Collection<String> columnNames, boolean reset, boolean moveForward, ColumnMatcher columnMatcher) {
            this._columnNames = columnNames;
            this._moveForward = moveForward;
            this._colMatcher = columnMatcher != null ? columnMatcher : CursorImpl.this.mcolumnMatcher;
            try {
                if (reset) {
                    CursorImpl.this.reset(this._moveForward);
                } else if (CursorImpl.this.isCurrentRowValid()) {
                    this._validRow = true;
                    this._hasNext = true;
                }
            }
            catch (IOException _ex) {
                throw new UncheckedIOException(_ex);
            }
        }

        @Override
        public boolean hasNext() {
            if (this._hasNext == null) {
                try {
                    this._hasNext = this.findNext();
                    this._validRow = this._hasNext;
                }
                catch (IOException _ex) {
                    throw new UncheckedIOException(_ex);
                }
            }
            return this._hasNext;
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Row rtn = CursorImpl.this.getCurrentRow(this._columnNames);
                this._hasNext = null;
                return rtn;
            }
            catch (IOException _ex) {
                throw new UncheckedIOException(_ex);
            }
        }

        @Override
        public void remove() {
            if (this._validRow) {
                try {
                    CursorImpl.this.deleteCurrentRow();
                    this._validRow = false;
                }
                catch (IOException _ex) {
                    throw new UncheckedIOException(_ex);
                }
            } else {
                throw new IllegalStateException("Not at valid row");
            }
        }

        protected abstract boolean findNext() throws IOException;
    }
}

