/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.expr;

import java.text.DateFormatSymbols;
import java.util.Locale;
import shaded.io.github.spannm.jackcess.JackcessRuntimeException;
import shaded.io.github.spannm.jackcess.expr.Value;

public class TemporalConfig {
    public static final String US_DATE_FORMAT = "M/d[/uuuu]";
    public static final String US_TIME_FORMAT_12_FORMAT = "h:mm:ss a";
    public static final String US_TIME_FORMAT_24_FORMAT = "H:mm:ss";
    public static final String US_LONG_DATE_FORMAT = "EEEE, MMMM dd, uuuu";
    public static final String MEDIUM_DATE_FORMAT = "dd-MMM-uu";
    public static final String MEDIUM_TIME_FORMAT = "hh:mm a";
    public static final String SHORT_TIME_FORMAT = "HH:mm";
    public static final TemporalConfig US_TEMPORAL_CONFIG = new TemporalConfig("M/d[/uuuu]", "EEEE, MMMM dd, uuuu", "h:mm:ss a", "H:mm:ss", '/', ':', Locale.US);
    private final Locale mlocale;
    private final String mdateFormat;
    private final String mlongDateFormat;
    private final String mtimeFormat12;
    private final String mtimeFormat24;
    private final char mdateSeparator;
    private final char mtimeSeparator;
    private final String mdateTimeFormat12;
    private final String mdateTimeFormat24;
    private final String[] mamPmStrings;

    public TemporalConfig(String _dateFormat, String _longDateFormat, String _timeFormat12, String _timeFormat24, char _dateSeparator, char _timeSeparator, Locale _locale) {
        this.mlocale = _locale;
        this.mdateFormat = _dateFormat;
        this.mlongDateFormat = _longDateFormat;
        this.mtimeFormat12 = _timeFormat12;
        this.mtimeFormat24 = _timeFormat24;
        this.mdateSeparator = _dateSeparator;
        this.mtimeSeparator = _timeSeparator;
        this.mdateTimeFormat12 = TemporalConfig.toDateTimeFormat(this.mdateFormat, this.mtimeFormat12);
        this.mdateTimeFormat24 = TemporalConfig.toDateTimeFormat(this.mdateFormat, this.mtimeFormat24);
        this.mamPmStrings = DateFormatSymbols.getInstance(_locale).getAmPmStrings();
    }

    public Locale getLocale() {
        return this.mlocale;
    }

    public String getDateFormat() {
        return this.mdateFormat;
    }

    public String getTimeFormat12() {
        return this.mtimeFormat12;
    }

    public String getTimeFormat24() {
        return this.mtimeFormat24;
    }

    public String getDateTimeFormat12() {
        return this.mdateTimeFormat12;
    }

    public String getDateTimeFormat24() {
        return this.mdateTimeFormat24;
    }

    public String getDefaultDateFormat() {
        return this.getDateFormat();
    }

    public String getDefaultTimeFormat() {
        return this.getTimeFormat12();
    }

    public String getDefaultDateTimeFormat() {
        return this.getDateTimeFormat12();
    }

    public char getDateSeparator() {
        return this.mdateSeparator;
    }

    public char getTimeSeparator() {
        return this.mtimeSeparator;
    }

    public String getDateTimeFormat(Type type) {
        switch (type.ordinal()) {
            case 0: 
            case 10: {
                return this.getDefaultDateFormat();
            }
            case 1: {
                return this.getDefaultTimeFormat();
            }
            case 2: 
            case 7: {
                return this.getDefaultDateTimeFormat();
            }
            case 3: 
            case 11: {
                return this.getTimeFormat12();
            }
            case 4: {
                return this.getTimeFormat24();
            }
            case 5: {
                return this.getDateTimeFormat12();
            }
            case 6: {
                return this.getDateTimeFormat24();
            }
            case 8: {
                return this.getLongDateFormat();
            }
            case 9: {
                return this.getMediumDateFormat();
            }
            case 12: {
                return this.getMediumTimeFormat();
            }
            case 13: {
                return this.getShortTimeFormat();
            }
        }
        throw new IllegalArgumentException("unknown date/time type " + String.valueOf((Object)type));
    }

    public String[] getAmPmStrings() {
        return this.mamPmStrings;
    }

    private static String toDateTimeFormat(String dateFormat, String timeFormat) {
        return dateFormat + " " + timeFormat;
    }

    protected String getLongDateFormat() {
        return this.mlongDateFormat;
    }

    protected String getMediumDateFormat() {
        return MEDIUM_DATE_FORMAT;
    }

    protected String getMediumTimeFormat() {
        return MEDIUM_TIME_FORMAT;
    }

    protected String getShortTimeFormat() {
        return SHORT_TIME_FORMAT;
    }

    public static enum Type {
        DATE,
        TIME,
        DATE_TIME,
        TIME_12,
        TIME_24,
        DATE_TIME_12,
        DATE_TIME_24,
        GENERAL_DATE,
        LONG_DATE,
        MEDIUM_DATE,
        SHORT_DATE,
        LONG_TIME,
        MEDIUM_TIME,
        SHORT_TIME;


        public Type getDefaultType() {
            switch (this.ordinal()) {
                case 0: 
                case 8: 
                case 9: 
                case 10: {
                    return DATE;
                }
                case 1: 
                case 3: 
                case 4: 
                case 11: 
                case 12: 
                case 13: {
                    return TIME;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    return DATE_TIME;
                }
            }
            throw new JackcessRuntimeException("Invalid type " + String.valueOf((Object)this));
        }

        public Value.Type getValueType() {
            switch (this.ordinal()) {
                case 0: 
                case 8: 
                case 9: 
                case 10: {
                    return Value.Type.DATE;
                }
                case 1: 
                case 3: 
                case 4: 
                case 11: 
                case 12: 
                case 13: {
                    return Value.Type.TIME;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    return Value.Type.DATE_TIME;
                }
            }
            throw new JackcessRuntimeException("Invalid type " + String.valueOf((Object)this));
        }

        public boolean includesTime() {
            return !this.isDateOnly();
        }

        public boolean includesDate() {
            return !this.isTimeOnly();
        }

        public boolean isDateOnly() {
            switch (this.ordinal()) {
                case 0: 
                case 8: 
                case 9: 
                case 10: {
                    return true;
                }
            }
            return false;
        }

        public boolean isTimeOnly() {
            switch (this.ordinal()) {
                case 1: 
                case 3: 
                case 4: 
                case 11: 
                case 12: 
                case 13: {
                    return true;
                }
            }
            return false;
        }
    }
}

