/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import net.ucanaccess.commands.CompositeCommand;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.ICursorCommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.jdbc.Context;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.NormalizedSQL;
import net.ucanaccess.jdbc.Session;
import net.ucanaccess.jdbc.UcanaccessBlob;
import net.ucanaccess.jdbc.UcanaccessCallableStatement;
import net.ucanaccess.jdbc.UcanaccessDatabaseMetadata;
import net.ucanaccess.jdbc.UcanaccessDriver;
import net.ucanaccess.jdbc.UcanaccessPreparedStatement;
import net.ucanaccess.jdbc.UcanaccessSavepoint;
import net.ucanaccess.jdbc.UcanaccessStatement;
import shaded.io.github.spannm.jackcess.Database;

public class UcanaccessConnection
implements Connection {
    static final String BATCH_ID = "BATCH_ID";
    private static final ThreadLocal<Context> CTX = new ThreadLocal();
    private final System.Logger logger = System.getLogger(this.getClass().getName());
    private boolean feedbackState;
    private final LinkedList<ICommand> commands = new LinkedList();
    private Connection hsqlDBConnection;
    private final Map<Savepoint, String> savepointsMap = new HashMap<Savepoint, String>();
    private DBReference ref;
    private boolean checkModified = false;
    private boolean autoCommit = true;
    private Properties clientInfo;
    private Session session;
    private SQLWarning warnings;
    private String url;
    private UcanaccessStatement currentStatement;
    private Object lastGeneratedKey;
    private String refId;

    public static synchronized UcanaccessConnection getCtxConnection() {
        return Optional.ofNullable(CTX.get()).map(Context::getCurrentConnection).orElse(null);
    }

    public static synchronized boolean hasContext() {
        return CTX.get() != null;
    }

    public static synchronized String getCtxExcId() {
        return Optional.ofNullable(CTX.get()).map(Context::getCurrentExecId).orElse(null);
    }

    public static synchronized void setCtxConnection(UcanaccessConnection conn) {
        CTX.set(new Context(conn));
    }

    public static synchronized void setCtxExecId(String id) {
        Optional.ofNullable(CTX.get()).ifPresent(ctx -> ctx.setCurrentExecId(id));
    }

    public UcanaccessConnection(DBReference _ref, Properties _clientInfo, Session _session) throws UcanaccessSQLException {
        try {
            this.ref = _ref;
            this.refId = _ref.getId();
            _ref.incrementActiveConnection();
            this.session = _session;
            this.hsqlDBConnection = _ref.getHSQLDBConnection(_session);
            this.clientInfo = _clientInfo;
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    Object getLastGeneratedKey() {
        return this.lastGeneratedKey;
    }

    String preprocess(String sql) {
        if (SQLConverter.hasIdentity(sql)) {
            return SQLConverter.preprocess(sql, this.lastGeneratedKey);
        }
        return sql;
    }

    void setCurrentStatement(UcanaccessStatement _currentStatement) {
        this.currentStatement = _currentStatement;
    }

    public void setGeneratedKey(Object key) {
        this.lastGeneratedKey = key;
        if (this.currentStatement != null) {
            this.currentStatement.setGeneratedKey(key);
        }
    }

    public void addFunctions(Class<?> clazz) throws SQLException {
        LoadJet lfa = new LoadJet(this.ref.getHSQLDBConnection(this.session), this.ref.getDbIO());
        lfa.addFunctions(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadDbIO() throws IOException {
        Class<UcanaccessConnection> clazz = UcanaccessConnection.class;
        synchronized (UcanaccessConnection.class) {
            this.ref.reloadDbIO();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized boolean add(ICommand c4io) {
        if (c4io.getType().equals((Object)ICommand.CommandType.UPDATE) || c4io.getType().equals((Object)ICommand.CommandType.DELETE)) {
            ICommand last = !this.commands.isEmpty() ? this.commands.getLast() : null;
            ICursorCommand c4ioc = (ICursorCommand)c4io;
            if (last != null && !last.getExecId().equals(BATCH_ID) && last.getExecId().equals(c4io.getExecId()) && last.getTableName().equals(c4io.getTableName())) {
                return ((CompositeCommand)last).add(c4ioc);
            }
            CompositeCommand cc4io = new CompositeCommand();
            cc4io.add(c4ioc);
            c4io = cc4io;
        }
        return this.commands.add(c4io);
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.hsqlDBConnection.close();
            this.ref.decrementActiveConnection(this.session);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        Class<UcanaccessConnection> clazz = UcanaccessConnection.class;
        synchronized (UcanaccessConnection.class) {
            try {
                if (this.isReadOnly() && !this.commands.isEmpty()) {
                    this.rollback();
                    if (this.ref.isReadOnlyFileFormat()) {
                        throw new UcanaccessSQLException("Access 97 is supported in read-only");
                    }
                    throw new UcanaccessSQLException("File marked as read only. Notice that only one process (one VM) at a time can access in writing mode");
                }
                this.flushIO();
                this.hsqlDBConnection.commit();
                if (!this.commands.isEmpty()) {
                    this.ref.updateLastModified();
                }
            }
            catch (SQLException _ex) {
                throw new UcanaccessSQLException(_ex);
            }
            finally {
                this.finalizeEnlistedResources();
                this.checkModified = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            this.checkConnection();
            return this.hsqlDBConnection.createArrayOf(typeName, elements);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.checkConnection();
            return new UcanaccessBlob(UcanaccessBlob.createBlob(this), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    public Blob createBlob(File fl) throws SQLException {
        try {
            this.checkConnection();
            return new UcanaccessBlob(UcanaccessBlob.createBlob(fl, this), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    private void checkConnection() throws UcanaccessSQLException {
        if (this.autoCommit || this.isCheckModified()) {
            this.checkLastModified();
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Clob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("NClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXML");
    }

    @Override
    public UcanaccessStatement createStatement() throws SQLException {
        this.checkConnection();
        return new UcanaccessStatement(this.hsqlDBConnection.createStatement(), this);
    }

    @Override
    public UcanaccessStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        return new UcanaccessStatement(this.hsqlDBConnection.createStatement(resultSetType, resultSetConcurrency), this);
    }

    @Override
    public UcanaccessStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnection();
        return new UcanaccessStatement(this.hsqlDBConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            this.checkConnection();
            return this.hsqlDBConnection.createStruct(typeName, attributes);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    private void flushIO() throws SQLException {
        ArrayList<IFeedbackAction> ibal = new ArrayList<IFeedbackAction>();
        LinkedList<ICommand> executed = new LinkedList<ICommand>();
        try {
            for (ICommand command : this.commands) {
                for (IFeedbackAction iFeedbackAction : ibal) {
                    iFeedbackAction.doAction(command);
                }
                IFeedbackAction ib = command.persist();
                executed.add(command);
                if (ib == null) continue;
                if (command instanceof CompositeCommand) {
                    ib.doAction(command);
                    continue;
                }
                ibal.add(ib);
            }
            this.afterFlushIoHook();
        }
        catch (Throwable _ex) {
            this.logger.log(System.Logger.Level.WARNING, _ex.toString());
            this.hsqlDBConnection.rollback();
            ibal.clear();
            Iterator it = executed.descendingIterator();
            while (it.hasNext()) {
                ICommand command = (ICommand)it.next();
                for (IFeedbackAction iFeedbackAction : ibal) {
                    iFeedbackAction.doAction(command);
                }
                IFeedbackAction iFeedbackAction = command.rollback();
                if (iFeedbackAction == null) continue;
                ibal.add(iFeedbackAction);
            }
            this.ref.updateLastModified();
            try {
                this.ref.getDbIO().flush();
                this.unloadDB();
            }
            catch (IOException _ex2) {
                this.logger.log(System.Logger.Level.WARNING, _ex2.toString());
            }
            throw _ex instanceof UcanaccessSQLException ? (UcanaccessSQLException)_ex : new UcanaccessSQLException(_ex);
        }
        try {
            this.ref.getDbIO().flush();
        }
        catch (IOException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    void afterFlushIoHook() {
    }

    private void finalizeEnlistedResources() {
        this.commands.clear();
        this.savepointsMap.clear();
        UcanaccessConnection.setCtxConnection(null);
        UcanaccessConnection.setCtxExecId(null);
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.hsqlDBConnection.getCatalog();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public Properties getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String _name) {
        return this.clientInfo.getProperty(_name);
    }

    public Database getDbIO() {
        return this.ref.getDbIO();
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.hsqlDBConnection.getHoldability();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    public Connection getHSQLDBConnection() {
        return this.hsqlDBConnection;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return new UcanaccessDatabaseMetadata(this.hsqlDBConnection.getMetaData(), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.hsqlDBConnection.getTransactionIsolation();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.hsqlDBConnection.getTypeMap();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public void setWarnings(SQLWarning _warnings) {
        this.warnings = _warnings;
    }

    public void addWarnings(SQLWarning _warnings) {
        if (this.warnings == null) {
            this.setWarnings(_warnings);
        } else {
            this.warnings.setNextWarning(_warnings);
        }
    }

    public boolean isFeedbackState() {
        return this.feedbackState;
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.hsqlDBConnection.isClosed();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.ref.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return this.hsqlDBConnection.isValid(timeout);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        try {
            return this.hsqlDBConnection.isWrapperFor(arg0);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public String nativeSQL(String sql) {
        return SQLConverter.convertSQL(sql).getSql();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessCallableStatement(nsql, this.hsqlDBConnection.prepareCall(sql), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessCallableStatement(nsql, this.hsqlDBConnection.prepareCall(sql, resultSetType, resultSetConcurrency), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessCallableStatement(nsql, this.hsqlDBConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    private NormalizedSQL prepare(String sql) throws SQLException {
        this.checkConnection();
        return SQLConverter.convertSQL(sql, this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                this.logStatementWarning(sql);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql())), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    void logStatementWarning(String _sql) {
        Object sql = _sql;
        if (_sql.length() > 100) {
            sql = _sql.substring(0, 100) + "...";
        }
        this.logger.log(System.Logger.Level.WARNING, "Please use a simple statement (not a PreparedStatement) to execute DDL (e.g. CREATE TABLE): {0}", sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                this.logStatementWarning(sql);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), autoGeneratedKeys), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                this.logStatementWarning(sql);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), resultSetType, resultSetConcurrency), this);
        }
        catch (SQLException _ex) {
            if (resultSetType == 1005 && resultSetConcurrency == 1008) {
                return this.prepareStatement(sql, 1003, 1007);
            }
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                this.logStatementWarning(sql);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), resultSetType, resultSetConcurrency, resultSetHoldability), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                this.logStatementWarning(sql);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), columnIndexes), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            if (SQLConverter.checkDDL(sql)) {
                this.logStatementWarning(sql);
                return new UcanaccessPreparedStatement(sql, this);
            }
            NormalizedSQL nsql = this.prepare(sql);
            return new UcanaccessPreparedStatement(nsql, this.hsqlDBConnection.prepareStatement(this.preprocess(nsql.getSql()), columnNames), this);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.hsqlDBConnection.releaseSavepoint(((UcanaccessSavepoint)savepoint).getWrapped());
            this.savepointsMap.remove(savepoint);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.hsqlDBConnection.rollback();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
        finally {
            this.finalizeEnlistedResources();
            this.checkModified = true;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.hsqlDBConnection.rollback(((UcanaccessSavepoint)savepoint).getWrapped());
            String lastId = this.savepointsMap.get(savepoint);
            boolean remove = false;
            Iterator it = this.commands.iterator();
            while (it.hasNext()) {
                ICommand c4io = (ICommand)it.next();
                if (remove && !c4io.getExecId().equals(lastId)) {
                    it.remove();
                }
                remove = remove || c4io.getExecId().equals(lastId);
            }
            this.checkModified = true;
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setAutoCommit(boolean _autoCommit) throws SQLException {
        if (!_autoCommit) {
            this.checkLastModified();
        } else {
            this.checkModified = false;
        }
        this.autoCommit = _autoCommit;
    }

    public void setFeedbackState(boolean _feedbackState) {
        this.feedbackState = _feedbackState;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCatalog");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.hsqlDBConnection.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.hsqlDBConnection.setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.hsqlDBConnection.setHoldability(holdability);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.hsqlDBConnection.setReadOnly(readOnly);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            UcanaccessSavepoint sp = new UcanaccessSavepoint(this.hsqlDBConnection.setSavepoint());
            if (!this.commands.isEmpty()) {
                this.savepointsMap.put(sp, this.commands.getLast().getExecId());
            }
            return sp;
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            UcanaccessSavepoint sp = new UcanaccessSavepoint(this.hsqlDBConnection.setSavepoint(name));
            if (!this.commands.isEmpty()) {
                this.savepointsMap.put(sp, this.commands.getLast().getExecId());
            }
            return sp;
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.hsqlDBConnection.setTransactionIsolation(level);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.hsqlDBConnection.setTypeMap(map);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        try {
            return this.hsqlDBConnection.unwrap(arg0);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    public String toString() {
        return super.toString() + "[" + String.valueOf(this.ref.getDbFile()) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkLastModified() throws UcanaccessSQLException {
        try {
            this.checkModified = false;
            if (!this.refId.equals(this.ref.getId())) {
                this.hsqlDBConnection = this.ref.getHSQLDBConnection(this.session);
            }
            Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
            synchronized (UcanaccessDriver.class) {
                this.hsqlDBConnection = this.ref.checkLastModified(this.hsqlDBConnection, this.session);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.refId = this.ref.getId();
            }
        }
        catch (Exception _ex) {
            throw UcanaccessSQLException.wrap(_ex);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String _url) {
        this.url = _url;
    }

    public boolean isShowSchema() {
        return this.ref.isShowSchema();
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public String getSchema() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadDB() throws UcanaccessSQLException {
        try {
            Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
            synchronized (UcanaccessDriver.class) {
                this.ref.shutdown(this.session);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception _ex) {
            throw new UcanaccessSQLException(_ex);
        }
        {
            return;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.hsqlDBConnection.abort(executor);
        }
        catch (Exception _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) {
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    public boolean isCheckModified() {
        return this.checkModified;
    }
}

