/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.IJackcessOpenerInterface;
import net.ucanaccess.jdbc.UcanaccessDriver;
import shaded.io.github.spannm.jackcess.Database;

public final class DBReferenceSingleton {
    private static DBReferenceSingleton singleton;
    private final Map<String, DBReference> dbRegistry = Collections.synchronizedMap(new HashMap());

    private DBReferenceSingleton() {
    }

    public static synchronized DBReferenceSingleton getInstance() {
        if (singleton == null) {
            singleton = new DBReferenceSingleton();
        }
        return singleton;
    }

    public DBReference getReference(File ref) {
        return this.dbRegistry.get(ref.getAbsolutePath());
    }

    public boolean loaded(File fl) {
        return this.dbRegistry.containsKey(fl.getAbsolutePath());
    }

    public DBReference loadReference(File fl, Database.FileFormat ff, IJackcessOpenerInterface jko, String pwd, Charset charset) throws IOException {
        return new DBReference(fl, ff, jko, pwd, charset);
    }

    public DBReference put(String _path, DBReference _dbr) {
        return this.dbRegistry.put(_path, _dbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBReference remove(String _path) {
        Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
        synchronized (UcanaccessDriver.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.dbRegistry.remove(_path);
        }
    }
}

