/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.exception;

import java.sql.SQLException;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.ucanaccess.util.VersionInfo;

public class UcanaccessSQLException
extends SQLException {
    static final String MSG_PREFIX = "UCAExc:";
    private static final long serialVersionUID = -1432048647665807662L;
    private static final String UCANACCESS_GENERIC_ERROR_STR = String.valueOf(15000);

    public UcanaccessSQLException() {
    }

    public UcanaccessSQLException(String _reason, String _sqlState, int _vendorCode, Throwable _cause) {
        super(_reason, _sqlState, _vendorCode, _cause);
    }

    public UcanaccessSQLException(String _reason) {
        this(_reason, UCANACCESS_GENERIC_ERROR_STR, 15000, null);
    }

    public UcanaccessSQLException(String _reason, Object ... _args) {
        this(String.format(_reason, _args), UCANACCESS_GENERIC_ERROR_STR, 15000, null);
    }

    public UcanaccessSQLException(String _reason, String _sqlState, int _vendorCode) {
        super(_reason, _sqlState, _vendorCode, null);
    }

    public UcanaccessSQLException(String _reason, String _sqlState, Throwable _cause) {
        super(_reason, _sqlState, 15000, _cause);
    }

    public UcanaccessSQLException(String _reason, Throwable _cause) {
        super(_reason, UCANACCESS_GENERIC_ERROR_STR, 15000, _cause);
    }

    public UcanaccessSQLException(String _reason, String _sqlState) {
        super(_reason, _sqlState, 15000, null);
    }

    public UcanaccessSQLException(Throwable _cause) {
        super(UcanaccessSQLException.explainCause(_cause), _cause instanceof SQLException ? ((SQLException)_cause).getSQLState() : UCANACCESS_GENERIC_ERROR_STR, _cause instanceof SQLException ? ((SQLException)_cause).getErrorCode() : 15000, _cause);
    }

    public static String explainCause(Throwable _cause) {
        SQLException se;
        if (_cause instanceof SQLException && (se = (SQLException)_cause).getErrorCode() == -5562) {
            return _cause.getMessage() + " This exception may happen if you add integers representing units of time directly to datetime values using the arithmetic plus operator but without specifying the unit of date." + System.lineSeparator() + "In this specific case you have to use, for example, <dateColumn> + 1 DAY.";
        }
        return _cause.getMessage();
    }

    String addVersionInfo(String _message) {
        if (_message != null && _message.startsWith(MSG_PREFIX)) {
            return _message;
        }
        String ver = VersionInfo.find(this.getClass()).getVersion();
        return ("UCAExc:::" + Optional.ofNullable(ver).orElse("x.y.z") + " " + (_message == null || _message.isBlank() ? "(n/a)" : _message)).trim();
    }

    @Override
    public String getLocalizedMessage() {
        return this.addVersionInfo(super.getLocalizedMessage());
    }

    @Override
    public String getMessage() {
        return this.addVersionInfo(super.getMessage());
    }

    public static final <T extends Throwable> UcanaccessSQLException wrap(T _t) {
        return UcanaccessSQLException.wrap(null, _t);
    }

    public static final <T extends Throwable> UcanaccessSQLException wrap(String _reason, T _t) {
        String reason;
        String string = reason = _reason == null || _reason.isBlank() ? null : _reason.trim();
        if (_t instanceof UcanaccessSQLException) {
            UcanaccessSQLException ex = (UcanaccessSQLException)_t;
            if (reason == null) {
                return ex;
            }
            return new UcanaccessSQLException(reason + ": " + ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), ex.getCause());
        }
        if (_t instanceof SQLException) {
            SQLException ex = (SQLException)_t;
            return new UcanaccessSQLException((String)(reason == null ? ex.getMessage() : reason + ": " + ex.getMessage()), ex.getSQLState(), ex.getErrorCode(), ex.getCause());
        }
        return new UcanaccessSQLException((String)(reason == null ? _t.getMessage() : reason + ": " + _t.getMessage()), _t);
    }

    public static final <T extends UcanaccessSQLException> void throwIf(BooleanSupplier _condition, Supplier<T> _exceptionSupplier) throws T {
        if (_condition.getAsBoolean()) {
            throw (UcanaccessSQLException)_exceptionSupplier.get();
        }
    }
}

