/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.ucanaccess.type.AccessVersion;
import net.ucanaccess.type.ColumnOrder;
import net.ucanaccess.type.ObjectType;
import net.ucanaccess.util.Try;

public class Metadata {
    private static final System.Logger LOGGER = System.getLogger(Metadata.class.getName());
    private static final String SCHEMA = "CREATE SCHEMA UCA_METADATA AUTHORIZATION DBA";
    private static final String TABLES = "CREATE TABLE UCA_METADATA.TABLES(TABLE_ID INTEGER IDENTITY, TABLE_NAME LONGVARCHAR, ESCAPED_TABLE_NAME LONGVARCHAR, TYPE VARCHAR(5), UNIQUE(TABLE_NAME))";
    private static final String COLUMNS = "CREATE MEMORY TABLE UCA_METADATA.COLUMNS(COLUMN_ID INTEGER IDENTITY, COLUMN_NAME LONGVARCHAR, ESCAPED_COLUMN_NAME LONGVARCHAR, ORIGINAL_TYPE VARCHAR(20), COLUMN_DEF LONGVARCHAR, IS_GENERATEDCOLUMN VARCHAR(3), TABLE_ID INTEGER, UNIQUE(TABLE_ID, COLUMN_NAME) )";
    private static final String PROP = "CREATE MEMORY TABLE UCA_METADATA.PROP(NAME LONGVARCHAR PRIMARY KEY, MAX_LEN INTEGER, DEFAULT_VALUE VARCHAR(500), DESCRIPTION LONGVARCHAR)";
    private static final String COLUMNS_VIEW = "CREATE VIEW UCA_METADATA.COLUMNS_VIEW AS SELECT t.TABLE_NAME, c.COLUMN_NAME,t.ESCAPED_TABLE_NAME, c.ESCAPED_COLUMN_NAME, c.COLUMN_DEF, c.IS_GENERATEDCOLUMN, CASE WHEN(c.ORIGINAL_TYPE IN ('COUNTER' ,'GUID')) THEN 'YES' ELSE 'NO' END as IS_AUTOINCREMENT, c.ORIGINAL_TYPE FROM UCA_METADATA.COLUMNS c INNER JOIN UCA_METADATA.TABLES t ON (t.TABLE_ID = c.TABLE_ID)";
    private static final String FK = "ALTER TABLE UCA_METADATA.COLUMNS ADD CONSTRAINT UCA_METADATA_FK FOREIGN KEY (TABLE_ID) REFERENCES UCA_METADATA.TABLES (TABLE_ID) ON DELETE CASCADE";
    private static final String TABLE_RECORD = "INSERT INTO UCA_METADATA.TABLES( TABLE_NAME,ESCAPED_TABLE_NAME, TYPE) VALUES(?,?,?)";
    private static final String COLUMN_RECORD = "INSERT INTO UCA_METADATA.COLUMNS(COLUMN_NAME,ESCAPED_COLUMN_NAME,ORIGINAL_TYPE, IS_GENERATEDCOLUMN,TABLE_ID) VALUES(?,?,?,'NO',?)";
    private static final String SELECT_COLUMN = "SELECT DISTINCT c.COLUMN_NAME,c.ORIGINAL_TYPE IN('COUNTER', 'GUID') as IS_AUTOINCREMENT, c.ORIGINAL_TYPE='MONEY' as IS_CURRENCY FROM UCA_METADATA.COLUMNS  c INNER JOIN UCA_METADATA.TABLES t ON (t.TABLE_ID = c.TABLE_ID ) WHERE t.ESCAPED_TABLE_NAME=nvl(?,t.ESCAPED_TABLE_NAME) AND c.ESCAPED_COLUMN_NAME=? ";
    private static final String SELECT_COLUMN_ESCAPED = "SELECT c.ESCAPED_COLUMN_NAME FROM UCA_METADATA.COLUMNS c INNER JOIN UCA_METADATA.TABLES t ON (t.TABLE_ID = c.TABLE_ID) WHERE t.TABLE_NAME=nvl(?,t.TABLE_NAME) AND c.COLUMN_NAME=?";
    private static final String SELECT_TABLE_ESCAPED = "SELECT ESCAPED_TABLE_NAME FROM UCA_METADATA.TABLES WHERE TABLE_NAME = ?";
    private static final String SELECT_TABLE_METADATA = "SELECT TABLE_ID, TABLE_NAME FROM UCA_METADATA.TABLES WHERE ESCAPED_TABLE_NAME = ?";
    private static final String DROP_TABLE = "DELETE FROM UCA_METADATA.TABLES WHERE TABLE_NAME = ?";
    private static final String UPDATE_COLUMN_DEF = "UPDATE UCA_METADATA.COLUMNS c SET c.COLUMN_DEF=? WHERE COLUMN_NAME=?  AND EXISTS(SELECT * FROM UCA_METADATA.TABLES t WHERE t.TABLE_NAME=? AND t.TABLE_ID=c.TABLE_ID)";
    private static final String UPDATE_IS_GENERATEDCOLUMN = "UPDATE UCA_METADATA.COLUMNS c SET c.IS_GENERATEDCOLUMN='YES' WHERE COLUMN_NAME=?  AND EXISTS(SELECT * FROM UCA_METADATA.TABLES t WHERE t.TABLE_NAME=? AND t.TABLE_ID=c.TABLE_ID)";
    private static final String SELECT_COLUMNS = "SELECT DISTINCT c.COLUMN_NAME,c.ORIGINAL_TYPE IN('COUNTER', 'GUID') as IS_AUTOINCREMENT, c.ORIGINAL_TYPE='MONEY' as IS_CURRENCY FROM UCA_METADATA.COLUMNS  c INNER JOIN UCA_METADATA.TABLES t ON (t.TABLE_ID = c.TABLE_ID ) WHERE t.ESCAPED_TABLE_NAME = nvl(?, t.ESCAPED_TABLE_NAME)";
    private static final String RENAME = "UPDATE UCA_METADATA.TABLES SET TABLE_NAME=?, ESCAPED_TABLE_NAME=? WHERE TABLE_NAME=?";
    private final Connection conn;

    public Metadata(Connection _conn) {
        this.conn = _conn;
    }

    public void createMetadata() throws SQLException {
        try (Statement st = this.conn.createStatement();){
            st.execute(SCHEMA);
            st.execute(PROP);
            st.execute(TABLES);
            st.execute(COLUMNS);
            st.execute(FK);
            st.execute(COLUMNS_VIEW);
            this.loadProp();
        }
    }

    public void loadProp() throws SQLException {
        try (PreparedStatement ps = this.conn.prepareStatement("INSERT INTO UCA_METADATA.PROP(NAME, MAX_LEN, DEFAULT_VALUE, DESCRIPTION) VALUES(?, ?, ?, ?)");){
            for (Property prop : Property.values()) {
                ps.setObject(1, prop.name());
                ps.setObject(2, prop.getMaxLen());
                ps.setObject(3, Optional.ofNullable(prop.getDefaultValue()).map(Object::toString).orElse(null));
                ps.setObject(4, prop.getDescription());
                ps.execute();
            }
        }
    }

    public Integer newTable(String _name, String _escaped, ObjectType _type) throws SQLException {
        Integer n;
        block8: {
            PreparedStatement ps = this.conn.prepareStatement(TABLE_RECORD, 1);
            try {
                ps.setString(1, _name);
                ps.setString(2, _escaped);
                ps.setString(3, _type.name());
                ps.executeUpdate();
                ResultSet rs = ps.getGeneratedKeys();
                rs.next();
                n = rs.getInt(1);
                if (ps == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException _ex) {
                    return this.getTableId(_escaped);
                }
            }
            ps.close();
        }
        return n;
    }

    public void newColumn(String _name, String _escaped, String _originalType, Integer _idTable) {
        if (_idTable < 0) {
            return;
        }
        try (PreparedStatement ps = this.conn.prepareStatement(COLUMN_RECORD);){
            ps.setString(1, _name);
            ps.setString(2, _escaped);
            ps.setString(3, _originalType);
            ps.setInt(4, _idTable);
            ps.executeUpdate();
        }
        catch (SQLException _ignored) {
            LOGGER.log(System.Logger.Level.DEBUG, "Ignoring {0}", _ignored.toString());
        }
    }

    public List<String> getColumnNames(String _tableName) throws SQLException {
        return Try.withResources(() -> this.conn.prepareStatement(SELECT_COLUMNS), ps -> {
            ps.setString(1, "SYSTEM_SUBQUERY".equals(_tableName) ? null : _tableName);
            ResultSet rs = ps.executeQuery();
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString("COLUMN_NAME"));
            }
            return !"SYSTEM_SUBQUERY".equals(_tableName) ? result : null;
        }).orThrow(ex -> ex);
    }

    public String getColumnName(String _escapedTableName, String _escapedColumnName) throws SQLException {
        return Try.withResources(() -> this.conn.prepareStatement(SELECT_COLUMN), ps -> {
            ps.setString(1, "SYSTEM_SUBQUERY".equals(_escapedTableName) ? null : _escapedTableName);
            ps.setString(2, _escapedColumnName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String res = rs.getString("COLUMN_NAME");
                if (!"SYSTEM_SUBQUERY".equals(_escapedTableName) || !rs.next()) {
                    return res;
                }
            }
            return null;
        }).orThrow(ex -> ex);
    }

    public String getEscapedColumnName(String _tableName, String _columnName) throws SQLException {
        return Try.withResources(() -> this.conn.prepareStatement(SELECT_COLUMN_ESCAPED), ps -> {
            ps.setString(1, "SYSTEM_SUBQUERY".equals(_tableName) ? null : _tableName);
            ps.setString(2, _columnName);
            ResultSet rs = ps.executeQuery();
            return rs.next() ? rs.getString("ESCAPED_COLUMN_NAME") : null;
        }).orThrow(ex -> ex);
    }

    public String getEscapedTableName(String _tableName) throws SQLException {
        return Try.withResources(() -> this.conn.prepareStatement(SELECT_TABLE_ESCAPED), ps -> {
            ps.setString(1, _tableName);
            ResultSet rs = ps.executeQuery();
            return rs.next() ? rs.getString("ESCAPED_TABLE_NAME") : null;
        }).orThrow(ex -> ex);
    }

    public boolean isAutoIncrement(String _tableName, String _columnName) throws SQLException {
        return Try.withResources(() -> this.conn.prepareStatement(SELECT_COLUMN), ps -> {
            ps.setString(1, "SYSTEM_SUBQUERY".equals(_tableName) ? null : _tableName);
            ps.setString(2, _columnName);
            ResultSet rs = ps.executeQuery();
            return rs.next() && rs.getBoolean("IS_AUTOINCREMENT");
        }).orThrow(ex -> ex);
    }

    public boolean isCurrency(String _tableName, String _columnName) throws SQLException {
        return Try.withResources(() -> this.conn.prepareStatement(SELECT_COLUMN), ps -> {
            ps.setString(1, "SYSTEM_SUBQUERY".equals(_tableName) ? null : _tableName);
            ps.setString(2, _columnName);
            ResultSet rs = ps.executeQuery();
            return rs.next() && rs.getBoolean("IS_CURRENCY");
        }).orThrow(ex -> ex);
    }

    public Integer getTableId(String _escapedName) throws SQLException {
        return Try.withResources(() -> this.conn.prepareStatement(SELECT_TABLE_METADATA), ps -> {
            ps.setString(1, _escapedName);
            ResultSet rs = ps.executeQuery();
            return rs.next() ? rs.getInt("TABLE_ID") : -1;
        }).orThrow(ex -> ex);
    }

    public String getTableName(String _escapedName) throws SQLException {
        return Try.withResources(() -> this.conn.prepareStatement(SELECT_TABLE_METADATA), ps -> {
            ps.setString(1, _escapedName);
            ResultSet rs = ps.executeQuery();
            return rs.next() ? rs.getString("TABLE_NAME") : null;
        }).orThrow(ex -> ex);
    }

    public void dropTable(String _tableName) throws SQLException {
        Try.withResources(() -> this.conn.prepareStatement(DROP_TABLE), ps -> {
            ps.setString(1, _tableName);
            ps.execute();
        }).orThrow(ex -> ex);
    }

    public void columnDef(String _tableName, String _columnName, String _def) throws SQLException {
        Try.withResources(() -> this.conn.prepareStatement(UPDATE_COLUMN_DEF), ps -> {
            ps.setString(1, _def);
            ps.setString(2, _columnName);
            ps.setString(3, _tableName);
            ps.execute();
        }).orThrow(ex -> ex);
    }

    public void calculatedField(String _tableName, String _columnName) throws SQLException {
        Try.withResources(() -> this.conn.prepareStatement(UPDATE_IS_GENERATEDCOLUMN), ps -> {
            ps.setString(1, _columnName);
            ps.setString(2, _tableName);
            ps.execute();
        }).orThrow(ex -> ex);
    }

    public void rename(String _oldTableName, String _newTableName, String _newEscapedTableName) throws SQLException {
        Try.withResources(() -> this.conn.prepareStatement(RENAME), ps -> {
            ps.setString(1, _newTableName);
            ps.setString(2, _newEscapedTableName);
            ps.setString(3, _oldTableName);
            ps.executeUpdate();
        }).orThrow(ex -> ex);
    }

    public static enum Property {
        user(String.class, null, 500, new Object[0]),
        password(String.class, null, 500, new Object[0]),
        columnOrder(ColumnOrder.class, ColumnOrder.DATA, 10, new Object[0]),
        concatNulls(Boolean.class, false, 10, new Object[0]),
        encrypt(Boolean.class, false, 10, new Object[0]),
        ignoreCase(Boolean.class, true, 10, new Object[0]),
        immediatelyReleaseResources(Boolean.class, false, 10, new Object[0]),
        inactivityTimeout(Integer.class, 2, 10, new Object[0]),
        jackcessOpener(String.class, null, 500, new Object[0]),
        keepMirror(String.class, null, 500, new Object[0]),
        lobScale(Integer.class, 2, 2, 1, 2, 4, 8, 16, 32),
        lockMdb(Boolean.class, false, 10, new Object[0]),
        memory(Boolean.class, true, 10, new Object[0]),
        mirrorFolder(String.class, null, 500, new Object[0]),
        newDatabaseVersion(AccessVersion.class, null, 8, new Object[0]),
        openExclusive(Boolean.class, false, 500, new Object[0]),
        preventReloading(Boolean.class, false, 10, new Object[0]),
        reMap(String.class, null, 500, new Object[0]),
        readOnlyMirror(Boolean.class, false, 10, new Object[0]),
        showSchema(Boolean.class, false, 10, new Object[0]),
        singleConnection(Boolean.class, false, 10, new Object[0]),
        skipIndexes(Boolean.class, false, 10, new Object[0]),
        supportsAccessLike(Boolean.class, false, 10, new Object[0]),
        charset(String.class, null, 20, new Object[0]),
        sysSchema(Boolean.class, false, 10, new Object[0]);

        private final Class<?> type;
        private final int maxLen;
        private final Object defaultValue;
        private final List<Object> validValues;
        private final String description;

        private <T> Property(Class<T> _type, T _defaultValue, int _maxLen, Object ... _validValues) {
            this.type = _type;
            this.maxLen = _maxLen;
            this.defaultValue = _defaultValue;
            this.validValues = Arrays.asList(_validValues);
            this.description = "see documentation";
        }

        public Class<?> getType() {
            return this.type;
        }

        public int getMaxLen() {
            return this.maxLen;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isValidValue(Object _val) {
            if (_val == null) {
                return false;
            }
            if (this.type.isEnum()) {
                for (Object en : this.type.getEnumConstants()) {
                    if (en != _val && !en.toString().equalsIgnoreCase(_val.toString())) continue;
                    return true;
                }
                return false;
            }
            if (this.validValues.isEmpty()) {
                if (this.type == Boolean.class) {
                    return "true".equalsIgnoreCase(_val.toString()) || "false".equalsIgnoreCase(_val.toString());
                }
                if (this.type == Integer.class) {
                    return Try.catching(() -> Integer.parseInt(_val.toString())).map(i -> true).orElse(false);
                }
                return true;
            }
            if (_val instanceof CharSequence) {
                return this.validValues.contains(_val.toString().toUpperCase());
            }
            return this.validValues.contains(_val);
        }

        public static Property parse(Object _val) {
            if (_val == null) {
                return null;
            }
            String val = _val.toString().strip().toLowerCase();
            for (Property prop : Property.values()) {
                if (!val.equalsIgnoreCase(prop.name())) continue;
                return prop;
            }
            return null;
        }
    }
}

