/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.server;

import shaded.org.hsqldb.lib.FileUtil;
import shaded.org.hsqldb.persist.HsqlProperties;
import shaded.org.hsqldb.resources.ResourceBundleHandler;
import shaded.org.hsqldb.server.Server;
import shaded.org.hsqldb.server.ServerConfiguration;
import shaded.org.hsqldb.server.ServerProperties;

public class WebServer
extends Server {
    static int webBundleHandle = ResourceBundleHandler.getBundleHandle("webserver-pages", null);

    public WebServer() {
        super(0);
    }

    public static void main(String[] stringArray) {
        ServerProperties serverProperties;
        HsqlProperties hsqlProperties = null;
        hsqlProperties = HsqlProperties.argArrayToProps(stringArray, "server");
        String[] stringArray2 = hsqlProperties.getErrorKeys();
        if (stringArray2.length != 0) {
            System.out.println("no value for argument:" + stringArray2[0]);
            WebServer.printHelp("webserver.help");
            return;
        }
        String string = hsqlProperties.getProperty("server.props");
        String string2 = "";
        if (string == null) {
            string = "webserver";
            string2 = ".properties";
        }
        ServerProperties serverProperties2 = (serverProperties = ServerConfiguration.getPropertiesFromFile(0, string = FileUtil.getFileUtil().canonicalOrAbsolutePath(string), string2)) == null ? new ServerProperties(0) : serverProperties;
        serverProperties2.addProperties(hsqlProperties);
        ServerConfiguration.translateDefaultDatabaseProperty(serverProperties2);
        ServerConfiguration.translateDefaultNoSystemExitProperty(serverProperties2);
        ServerConfiguration.translateAddressProperty(serverProperties2);
        WebServer webServer = new WebServer();
        try {
            webServer.setProperties(serverProperties2);
        }
        catch (Exception exception) {
            webServer.printError("Failed to set properties");
            webServer.printStackTrace(exception);
            return;
        }
        webServer.print("Startup sequence initiated from main() method");
        if (serverProperties != null) {
            webServer.print("Loaded properties from [" + string + ".properties]");
        } else {
            webServer.print("Could not load properties from file");
            webServer.print("Using cli/default properties only");
        }
        webServer.start();
    }

    @Override
    public String getDefaultWebPage() {
        return this.serverProperties.getProperty("server.default_page");
    }

    @Override
    public String getHelpString() {
        return ResourceBundleHandler.getString(serverBundleHandle, "webserver.help");
    }

    @Override
    public String getProductName() {
        return "HSQLDB web server";
    }

    @Override
    public String getProtocol() {
        return this.isTls() ? "HTTPS" : "HTTP";
    }

    @Override
    public String getWebRoot() {
        return this.serverProperties.getProperty("server.root");
    }
}

