/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb;

import shaded.org.hsqldb.Expression;
import shaded.org.hsqldb.Session;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.types.Type;

public class ExpressionValue
extends Expression {
    ExpressionValue(Object object, Type type) {
        super(1);
        this.dataType = type;
        this.valueData = object;
    }

    @Override
    public byte getNullability() {
        return this.valueData == null ? (byte)1 : 0;
    }

    @Override
    public String getSQL() {
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuilder.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData)).append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuilder.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionValue");
    }

    @Override
    public Object getValue(Session session, Type type) {
        if (this.dataType == type || this.valueData == null) {
            return this.valueData;
        }
        return type.convertToType(session, this.valueData, this.dataType);
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }
}

