/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.github.spannm.jackcess.impl.expr;

import shaded.io.github.spannm.jackcess.expr.EvalContext;
import shaded.io.github.spannm.jackcess.expr.Function;
import shaded.io.github.spannm.jackcess.expr.Value;
import shaded.io.github.spannm.jackcess.impl.expr.DefaultFunctions;
import shaded.io.github.spannm.jackcess.impl.expr.FunctionSupport;
import shaded.io.github.spannm.jackcess.impl.expr.ValueSupport;

public class DefaultFinancialFunctions {
    private static final int PMT_END_MNTH = 0;
    private static final int PMT_BEG_MNTH = 1;
    private static final int MAX_RATE_ITERATIONS = 20;
    private static final double RATE_PRECISION = 1.0E-7;
    public static final Function NPER = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("NPer", 3, 5){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double rate = params[0].getAsDouble(ctx);
            double pmt = params[1].getAsDouble(ctx);
            double pv = params[2].getAsDouble(ctx);
            double fv = DefaultFinancialFunctions.getFV(ctx, params, 3);
            int pmtType = DefaultFinancialFunctions.getPaymentType(ctx, params, 4);
            double result = DefaultFinancialFunctions.calculateLoanPaymentPeriods(rate, pmt, pv, fv, pmtType);
            return ValueSupport.toValue(result);
        }
    });
    public static final Function FV = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("FV", 3, 5){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double rate = params[0].getAsDouble(ctx);
            double nper = params[1].getAsDouble(ctx);
            double pmt = params[2].getAsDouble(ctx);
            double pv = FunctionSupport.getOptionalDoubleParam(ctx, params, 3, 0.0);
            int pmtType = DefaultFinancialFunctions.getPaymentType(ctx, params, 4);
            double result = DefaultFinancialFunctions.calculateFutureValue(rate, nper, pmt, pv, pmtType);
            return ValueSupport.toValue(result);
        }
    });
    public static final Function PV = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("PV", 3, 5){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double rate = params[0].getAsDouble(ctx);
            double nper = params[1].getAsDouble(ctx);
            double pmt = params[2].getAsDouble(ctx);
            double fv = DefaultFinancialFunctions.getFV(ctx, params, 3);
            int pmtType = DefaultFinancialFunctions.getPaymentType(ctx, params, 4);
            double result = DefaultFinancialFunctions.calculatePresentValue(rate, nper, pmt, fv, pmtType);
            return ValueSupport.toValue(result);
        }
    });
    public static final Function PMT = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("Pmt", 3, 5){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double rate = params[0].getAsDouble(ctx);
            double nper = params[1].getAsDouble(ctx);
            double pv = params[2].getAsDouble(ctx);
            double fv = DefaultFinancialFunctions.getFV(ctx, params, 3);
            int pmtType = DefaultFinancialFunctions.getPaymentType(ctx, params, 4);
            double result = DefaultFinancialFunctions.calculateLoanPayment(rate, nper, pv, fv, pmtType);
            return ValueSupport.toValue(result);
        }
    });
    public static final Function IPMT = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("IPmt", 4, 6){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double rate = params[0].getAsDouble(ctx);
            double per = params[1].getAsDouble(ctx);
            double nper = params[2].getAsDouble(ctx);
            double pv = params[3].getAsDouble(ctx);
            double fv = DefaultFinancialFunctions.getFV(ctx, params, 4);
            int pmtType = DefaultFinancialFunctions.getPaymentType(ctx, params, 5);
            double result = DefaultFinancialFunctions.calculateInterestPayment(rate, per, nper, pv, fv, pmtType);
            return ValueSupport.toValue(result);
        }
    });
    public static final Function PPMT = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("PPmt", 4, 6){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double rate = params[0].getAsDouble(ctx);
            double per = params[1].getAsDouble(ctx);
            double nper = params[2].getAsDouble(ctx);
            double pv = params[3].getAsDouble(ctx);
            double fv = DefaultFinancialFunctions.getFV(ctx, params, 4);
            int pmtType = DefaultFinancialFunctions.getPaymentType(ctx, params, 5);
            double result = DefaultFinancialFunctions.calculatePrincipalPayment(rate, per, nper, pv, fv, pmtType);
            return ValueSupport.toValue(result);
        }
    });
    public static final Function DDB = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("DDB", 4, 5){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double cost = params[0].getAsDouble(ctx);
            double salvage = params[1].getAsDouble(ctx);
            double life = params[2].getAsDouble(ctx);
            double period = params[3].getAsDouble(ctx);
            double factor = FunctionSupport.getOptionalDoubleParam(ctx, params, 4, 2.0);
            double result = DefaultFinancialFunctions.calculateDoubleDecliningBalance(cost, salvage, life, period, factor);
            return ValueSupport.toValue(result);
        }
    });
    public static final Function SLN = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("SLN", 3, 3){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double cost = params[0].getAsDouble(ctx);
            double salvage = params[1].getAsDouble(ctx);
            double life = params[2].getAsDouble(ctx);
            double result = DefaultFinancialFunctions.calculateStraightLineDepreciation(cost, salvage, life);
            return ValueSupport.toValue(result);
        }
    });
    public static final Function SYD = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("SYD", 4, 4){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double cost = params[0].getAsDouble(ctx);
            double salvage = params[1].getAsDouble(ctx);
            double life = params[2].getAsDouble(ctx);
            double period = params[3].getAsDouble(ctx);
            double result = DefaultFinancialFunctions.calculateSumOfYearsDepreciation(cost, salvage, life, period);
            return ValueSupport.toValue(result);
        }
    });
    public static final Function RATE = DefaultFunctions.registerFunc(new FunctionSupport.FuncVar("Rate", 3, 6){

        @Override
        protected Value evalVar(EvalContext ctx, Value[] params) {
            double nper = params[0].getAsDouble(ctx);
            double pmt = params[1].getAsDouble(ctx);
            double pv = params[2].getAsDouble(ctx);
            double fv = DefaultFinancialFunctions.getFV(ctx, params, 3);
            int pmtType = DefaultFinancialFunctions.getPaymentType(ctx, params, 4);
            double guess = FunctionSupport.getOptionalDoubleParam(ctx, params, 5, 0.1);
            double result = DefaultFinancialFunctions.calculateRate(nper, pmt, pv, fv, pmtType, guess);
            return ValueSupport.toValue(result);
        }
    });

    DefaultFinancialFunctions() {
    }

    private static double calculateFutureValue(double rate, double nper, double pmt, double pv, int pmtType) {
        if (rate == 0.0) {
            return -1.0 * (pv + nper * pmt);
        }
        double r1 = pmtType == 1 ? rate + 1.0 : 1.0;
        double p1 = Math.pow(rate + 1.0, nper);
        return (1.0 - p1) * r1 * pmt / rate - pv * p1;
    }

    private static double calculatePresentValue(double rate, double nper, double pmt, double fv, int pmtType) {
        if (rate == 0.0) {
            return -1.0 * (nper * pmt + fv);
        }
        double r1 = pmtType == 1 ? rate + 1.0 : 1.0;
        double p1 = Math.pow(rate + 1.0, nper);
        return ((1.0 - p1) / rate * r1 * pmt - fv) / p1;
    }

    private static double calculateLoanPayment(double rate, double nper, double pv, double fv, int pmtType) {
        if (rate == 0.0) {
            return -1.0 * (fv + pv) / nper;
        }
        double r1 = pmtType == 1 ? rate + 1.0 : 1.0;
        double p1 = Math.pow(rate + 1.0, nper);
        return (fv + pv * p1) * rate / (r1 * (1.0 - p1));
    }

    private static double calculateInterestPayment(double rate, double per, double nper, double pv, double fv, int pmtType) {
        if (per == 1.0 && pmtType == 1) {
            return 0.0;
        }
        double pmt = DefaultFinancialFunctions.calculateLoanPayment(rate, nper, pv, fv, pmtType);
        double result = DefaultFinancialFunctions.calculateFutureValue(rate, per - 1.0, pmt, pv, pmtType) * rate;
        if (pmtType == 1) {
            result /= 1.0 + rate;
        }
        return result;
    }

    private static double calculatePrincipalPayment(double rate, double per, double nper, double pv, double fv, int pmtType) {
        double pmt = DefaultFinancialFunctions.calculateLoanPayment(rate, nper, pv, fv, pmtType);
        double ipmt = DefaultFinancialFunctions.calculateInterestPayment(rate, per, nper, pv, fv, pmtType);
        return pmt - ipmt;
    }

    public static double calculateDoubleDecliningBalance(double cost, double salvage, double life, double period, double factor) {
        if (cost < 0.0 || life == 2.0 && period > 1.0) {
            return 0.0;
        }
        if (life < 2.0 || life == 2.0 && period <= 1.0) {
            return cost - salvage;
        }
        double v1 = factor * cost / life;
        if (period <= 1.0) {
            return Math.min(v1, cost - salvage);
        }
        double v2 = (life - factor) / life;
        double v3 = Math.max(salvage - cost * Math.pow(v2, period), 0.0);
        double result = v1 * Math.pow(v2, period - 1.0) - v3;
        return Math.max(result, 0.0);
    }

    private static double calculateStraightLineDepreciation(double cost, double salvage, double life) {
        return (cost - salvage) / life;
    }

    private static double calculateSumOfYearsDepreciation(double cost, double salvage, double life, double period) {
        return (cost - salvage) * (life - period + 1.0) * 2.0 / (life * (life + 1.0));
    }

    private static double calculateLoanPaymentPeriods(double rate, double pmt, double pv, double fv, int pmtType) {
        double v2;
        double v1;
        if (rate == 0.0) {
            return -1.0 * (fv + pv) / pmt;
        }
        double cr = (pmtType == 1 ? 1.0 + rate : 1.0) * pmt / rate;
        if (cr - fv < 0.0) {
            v1 = Math.log(fv - cr);
            v2 = Math.log(-pv - cr);
        } else {
            v1 = Math.log(cr - fv);
            v2 = Math.log(pv + cr);
        }
        return (v1 - v2) / Math.log(1.0 + rate);
    }

    public static double calculateRate(double nper, double pmt, double pv, double fv, int pmtType, double guess) {
        double y = 0.0;
        double f = 0.0;
        double rate = guess;
        if (Math.abs(rate) < 1.0E-7) {
            y = pv * (1.0 + nper * rate) + pmt * (1.0 + rate * (double)pmtType) * nper + fv;
        } else {
            f = Math.exp(nper * Math.log(1.0 + rate));
            y = pv * f + pmt * (1.0 / rate + (double)pmtType) * (f - 1.0) + fv;
        }
        double y0 = pv + pmt * nper + fv;
        double y1 = pv * f + pmt * (1.0 / rate + (double)pmtType) * (f - 1.0) + fv;
        double x0 = 0.0;
        double x1 = rate;
        for (int i = 0; Math.abs(y0 - y1) > 1.0E-7 && i < 20; ++i) {
            rate = (y1 * x0 - y0 * x1) / (y1 - y0);
            x0 = x1;
            x1 = rate;
            if (Math.abs(rate) < 1.0E-7) {
                y = pv * (1.0 + nper * rate) + pmt * (1.0 + rate * (double)pmtType) * nper + fv;
            } else {
                f = Math.exp(nper * Math.log(1.0 + rate));
                y = pv * f + pmt * (1.0 / rate + (double)pmtType) * (f - 1.0) + fv;
            }
            y0 = y1;
            y1 = y;
        }
        return rate;
    }

    private static double getFV(EvalContext ctx, Value[] params, int idx) {
        return FunctionSupport.getOptionalDoubleParam(ctx, params, idx, 0.0);
    }

    private static int getPaymentType(EvalContext ctx, Value[] params, int idx) {
        int pmtType = 0;
        if (params.length > idx) {
            pmtType = params[idx].getAsLongInt(ctx) != 0 ? 1 : 0;
        }
        return pmtType;
    }
}

