/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.exception.AuthenticationException;
import net.ucanaccess.exception.UcanaccessRuntimeException;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.DBReferenceSingleton;
import net.ucanaccess.jdbc.DefaultJackcessOpener;
import net.ucanaccess.jdbc.IJackcessOpenerInterface;
import net.ucanaccess.jdbc.Session;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.type.ColumnOrder;
import net.ucanaccess.util.Try;
import net.ucanaccess.util.VersionInfo;
import shaded.io.github.spannm.jackcess.Database;

public final class UcanaccessDriver
implements Driver {
    public static final String URL_PREFIX = "jdbc:ucanaccess://";
    private static final System.Logger LOGGER = System.getLogger(UcanaccessDriver.class.getName());

    @Override
    public boolean acceptsURL(String _url) {
        return _url != null && _url.startsWith(URL_PREFIX) && _url.length() > URL_PREFIX.length();
    }

    @Override
    public Connection connect(String _url, Properties _props) throws SQLException {
        if (!this.acceptsURL(_url)) {
            return null;
        }
        LinkedHashMap unknownProps = new LinkedHashMap();
        Map<Metadata.Property, String> props = UcanaccessDriver.readProperties(_props, _url, (k, v) -> {
            unknownProps.put(k, v);
            LOGGER.log(System.Logger.Level.WARNING, "Unknown driver property {0} with value {1}", k, v);
        });
        int idxSemicolon = _url.indexOf(59);
        String fileDbPath = idxSemicolon > 0 ? _url.substring(URL_PREFIX.length(), idxSemicolon) : _url.substring(URL_PREFIX.length());
        File fileDb = new File(fileDbPath);
        DBReferenceSingleton as = DBReferenceSingleton.getInstance();
        Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
        synchronized (UcanaccessDriver.class) {
            try {
                String pwd;
                DBReference dbRef;
                boolean useCustomOpener;
                Session session = new Session();
                boolean alreadyLoaded = as.loaded(fileDb);
                Database.FileFormat ff = null;
                if (props.containsKey((Object)Metadata.Property.newDatabaseVersion) && !fileDb.exists()) {
                    ff = Database.FileFormat.parse(props.get((Object)Metadata.Property.newDatabaseVersion));
                }
                DefaultJackcessOpener jko = (useCustomOpener = props.containsKey((Object)Metadata.Property.jackcessOpener)) ? this.newJackcessOpenerInstance(props.get((Object)Metadata.Property.jackcessOpener)) : new DefaultJackcessOpener();
                DBReference dBReference = dbRef = alreadyLoaded ? as.getReference(fileDb) : as.loadReference(fileDb, ff, jko, props.get((Object)Metadata.Property.password));
                if (!alreadyLoaded) {
                    if ((useCustomOpener || props.containsKey((Object)Metadata.Property.encrypt) && Boolean.parseBoolean(props.get((Object)Metadata.Property.encrypt))) && (props.containsKey((Object)Metadata.Property.memory) && !Boolean.parseBoolean(props.get((Object)Metadata.Property.memory)) || props.containsKey((Object)Metadata.Property.keepMirror))) {
                        dbRef.setEncryptHSQLDB(true);
                    }
                    if (props.containsKey((Object)Metadata.Property.memory)) {
                        dbRef.setInMemory(Boolean.parseBoolean(props.get((Object)Metadata.Property.memory)));
                    }
                    if (props.containsKey((Object)Metadata.Property.lobScale)) {
                        Integer vl = this.validateLobScale(props.get((Object)Metadata.Property.lobScale));
                        dbRef.setLobScale(vl);
                    }
                    if (props.containsKey((Object)Metadata.Property.keepMirror)) {
                        dbRef.setInMemory(false);
                        if (dbRef.isEncryptHSQLDB()) {
                            LOGGER.log(System.Logger.Level.WARNING, "{0} parameter cannot be combined with parameters {1} or {2}, {3} skipped", new Object[]{Metadata.Property.keepMirror, Metadata.Property.jackcessOpener, Metadata.Property.encrypt, Metadata.Property.keepMirror});
                        } else {
                            File dbMirror = new File(props.get((Object)Metadata.Property.keepMirror) + fileDb.getName().toUpperCase().hashCode());
                            dbRef.setToKeepHsql(dbMirror);
                            if (props.containsKey((Object)Metadata.Property.readOnlyMirror)) {
                                dbRef.setMirrorReadOnly(Boolean.parseBoolean(props.get((Object)Metadata.Property.readOnlyMirror)));
                            }
                        }
                    }
                    if (props.containsKey((Object)Metadata.Property.showSchema)) {
                        dbRef.setShowSchema(Boolean.parseBoolean(props.get((Object)Metadata.Property.showSchema)));
                    }
                    if (props.containsKey((Object)Metadata.Property.inactivityTimeout)) {
                        int millis = 60000 * Integer.parseInt(props.get((Object)Metadata.Property.inactivityTimeout));
                        dbRef.setInactivityTimeout(millis);
                    }
                    if (props.containsKey((Object)Metadata.Property.singleConnection)) {
                        dbRef.setImmediatelyReleaseResources(Boolean.parseBoolean(props.get((Object)Metadata.Property.singleConnection)));
                    }
                    if (props.containsKey((Object)Metadata.Property.immediatelyReleaseResources)) {
                        dbRef.setImmediatelyReleaseResources(Boolean.parseBoolean(props.get((Object)Metadata.Property.immediatelyReleaseResources)));
                    }
                    if (props.containsKey((Object)Metadata.Property.lockMdb)) {
                        dbRef.setOpenExclusive(Boolean.parseBoolean(props.get((Object)Metadata.Property.lockMdb)));
                    }
                    if (props.containsKey((Object)Metadata.Property.openExclusive)) {
                        dbRef.setOpenExclusive(Boolean.parseBoolean(props.get((Object)Metadata.Property.openExclusive)));
                    }
                    if (props.containsKey((Object)Metadata.Property.concatNulls)) {
                        dbRef.setConcatNulls(Boolean.parseBoolean(props.get((Object)Metadata.Property.concatNulls)));
                    }
                    if (props.containsKey((Object)Metadata.Property.preventReloading)) {
                        dbRef.setPreventReloading(Boolean.parseBoolean(props.get((Object)Metadata.Property.preventReloading)));
                    }
                    if (props.containsKey((Object)Metadata.Property.reMap)) {
                        Map map = Arrays.stream(props.get((Object)Metadata.Property.reMap).split("&")).map(s -> s.split("\\|")).filter(arr -> ((String[])arr).length == 2).collect(Collectors.toMap(k1 -> k1[0], v1 -> v1[1], (v1, v2) -> v1, LinkedHashMap::new));
                        dbRef.setExternalResourcesMapping(map);
                    }
                    if (props.containsKey((Object)Metadata.Property.supportsAccessLike)) {
                        SQLConverter.setSupportsAccessLike(Boolean.parseBoolean(props.get((Object)Metadata.Property.supportsAccessLike)));
                    }
                    if (props.containsKey((Object)Metadata.Property.columnOrder) && ColumnOrder.DISPLAY == ColumnOrder.parse(props.get((Object)Metadata.Property.columnOrder))) {
                        dbRef.setColumnOrderDisplay();
                    }
                    if (props.containsKey((Object)Metadata.Property.mirrorFolder) && dbRef.getToKeepHsql() == null) {
                        dbRef.setInMemory(false);
                        String fd = props.get((Object)Metadata.Property.mirrorFolder);
                        if ("java.io.tmpdir".equals(fd)) {
                            fd = System.getProperty("java.io.tmpdir");
                        }
                        dbRef.setMirrorFolder(new File(fd));
                    }
                    if (props.containsKey((Object)Metadata.Property.ignoreCase)) {
                        dbRef.setIgnoreCase(Boolean.parseBoolean(props.get((Object)Metadata.Property.ignoreCase)));
                    }
                    dbRef.getDbIO().setErrorHandler((cl, bt, location, ex) -> {
                        if (cl.getType().isTextual()) {
                            LOGGER.log(System.Logger.Level.WARNING, "Invalid textual value in table {0}, column {1}: it might look like {2}", cl.getTable().getName(), cl.getName(), new String(bt));
                        }
                        throw new IOException(ex);
                    });
                }
                if ((pwd = dbRef.getDbIO().getDatabasePassword()) != null && !props.containsKey((Object)Metadata.Property.jackcessOpener)) {
                    if (!pwd.equals(props.get((Object)Metadata.Property.password))) {
                        throw new AuthenticationException();
                    }
                } else if (props.containsKey((Object)Metadata.Property.jackcessOpener)) {
                    String mpwd = props.get((Object)Metadata.Property.password);
                    session.setPassword(mpwd);
                }
                Optional.ofNullable(props.get((Object)Metadata.Property.user)).ifPresent(session::setUser);
                SQLWarning sqlw = null;
                if (!alreadyLoaded) {
                    boolean val;
                    boolean toBeLoaded = !dbRef.loadedFromKeptMirror(session);
                    Connection conn = dbRef.getHSQLDBConnection(session);
                    Try.withResources(conn::createStatement, st -> st.executeQuery("SET TIME ZONE 'UTC'")).orThrow();
                    LoadJet la = new LoadJet(conn, dbRef.getDbIO());
                    if (props.containsKey((Object)Metadata.Property.sysSchema)) {
                        val = Boolean.parseBoolean(props.get((Object)Metadata.Property.sysSchema));
                        dbRef.setSysSchema(val);
                        la.setSysSchema(val);
                    }
                    if (props.containsKey((Object)Metadata.Property.skipIndexes)) {
                        val = Boolean.parseBoolean(props.get((Object)Metadata.Property.skipIndexes));
                        dbRef.setSkipIndexes(val);
                        la.setSkipIndexes(val);
                    }
                    if (toBeLoaded) {
                        la.loadDB();
                    } else {
                        la.resetFunctionsDefault();
                    }
                    as.put(fileDb.getAbsolutePath(), dbRef);
                    sqlw = la.getLoadingWarnings();
                }
                Properties newProps = new Properties();
                props.forEach((key, value) -> newProps.put(key.name(), value));
                newProps.putAll((Map<?, ?>)unknownProps);
                UcanaccessConnection uc = new UcanaccessConnection(as.getReference(fileDb), newProps, session);
                uc.addWarnings(sqlw);
                uc.setUrl(_url);
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return uc;
            }
            catch (Exception _ex) {
                throw new UcanaccessSQLException(_ex);
            }
        }
    }

    private Integer validateLobScale(String _property) {
        try {
            int i = Integer.parseInt(_property);
            if (i == 1 || i == 2 || i == 4 || i == 8 || i == 16 || i == 32) {
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.log(System.Logger.Level.WARNING, "Lobscale value must equal at least one of the following values: 1,2,4,8,16,32, skipping it");
        return null;
    }

    @Override
    public int getMajorVersion() {
        return VersionInfo.find(this.getClass()).getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return VersionInfo.find(this.getClass()).getMinorVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties arg1) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private IJackcessOpenerInterface newJackcessOpenerInstance(String className) throws UcanaccessSQLException {
        Object instance = Try.catching(() -> Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).orThrow(ex -> new UcanaccessSQLException("Failed to instantiate " + className, (Throwable)ex));
        if (instance instanceof IJackcessOpenerInterface) {
            return (IJackcessOpenerInterface)instance;
        }
        throw new UcanaccessSQLException("Jackess Opener class must implement " + IJackcessOpenerInterface.class.getName());
    }

    static Map<Metadata.Property, String> readProperties(Properties _input, String _url, BiConsumer<String, String> _unknownConsumer) {
        Objects.requireNonNull(_input, "Properties required");
        Objects.requireNonNull(_url, "URL required");
        EnumMap<Metadata.Property, String> props = new EnumMap<Metadata.Property, String>(Metadata.Property.class);
        for (String key : _input.stringPropertyNames()) {
            Metadata.Property prop = Metadata.Property.parse(key);
            String val = _input.getProperty(key);
            if (prop == null) {
                _unknownConsumer.accept(key, val);
                continue;
            }
            props.put(prop, val);
        }
        Arrays.stream(_url.split(";")).skip(1L).map(s -> s.split("=")).forEach(arr -> {
            String val;
            Metadata.Property prop = Metadata.Property.parse(arr[0]);
            String string = val = ((String[])arr).length > 1 ? arr[1].strip() : null;
            if (prop == null) {
                _unknownConsumer.accept(arr[0], val);
            } else {
                props.put(prop, val);
            }
        });
        return props;
    }

    static {
        try {
            DriverManager.registerDriver(new UcanaccessDriver());
            Class.forName("shaded.org.hsqldb.jdbc.JDBCDriver");
            System.setProperty("hsqldb.method_class_names", "net.ucanaccess.converters.*");
        }
        catch (ClassNotFoundException _ex) {
            LOGGER.log(System.Logger.Level.WARNING, "Unable to find hsqldb driver (version 2.x.x. or later) on your classpath");
            throw new UcanaccessRuntimeException(_ex.getMessage());
        }
        catch (SQLException _ex) {
            throw new UcanaccessRuntimeException(_ex.getMessage());
        }
    }
}

