/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.rights;

import shaded.org.hsqldb.HsqlNameManager;
import shaded.org.hsqldb.error.Error;
import shaded.org.hsqldb.lib.StringConverter;
import shaded.org.hsqldb.rights.Grantee;
import shaded.org.hsqldb.rights.GranteeManager;

public class User
extends Grantee {
    private String password;
    public boolean isLocalOnly;
    public boolean isExternalOnly;
    private HsqlNameManager.HsqlName initialSchema = null;

    User(HsqlNameManager.HsqlName hsqlName, GranteeManager granteeManager) {
        super(hsqlName, granteeManager);
        if (granteeManager != null) {
            this.updateAllRights();
        }
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("CREATE").append(' ').append("USER").append(' ').append(this.granteeName.statementName).append(' ').append("PASSWORD").append(' ').append("DIGEST").append(' ').append('\'').append(this.password).append('\'');
        return stringBuilder.toString();
    }

    public String getPasswordDigest() {
        return this.password;
    }

    public void setPassword(String string, boolean bl) {
        if (!bl) {
            string = this.granteeManager.digest(string);
        }
        this.password = string;
    }

    public void checkPassword(String string) {
        String string2 = this.granteeManager.digest(string);
        if (!string2.equals(this.password)) {
            throw Error.error(4000, this.granteeName.statementName);
        }
    }

    public HsqlNameManager.HsqlName getInitialSchema() {
        return this.initialSchema;
    }

    public HsqlNameManager.HsqlName getInitialOrDefaultSchema() {
        if (this.initialSchema != null) {
            return this.initialSchema;
        }
        HsqlNameManager.HsqlName hsqlName = this.granteeManager.database.schemaManager.findSchemaHsqlName(this.getName().getNameString());
        if (hsqlName == null) {
            return this.granteeManager.database.schemaManager.getDefaultSchemaHsqlName();
        }
        return hsqlName;
    }

    public void setInitialSchema(HsqlNameManager.HsqlName hsqlName) {
        this.initialSchema = hsqlName;
    }

    public String getInitialSchemaSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("ALTER").append(' ').append("USER").append(' ').append(this.getName().getStatementName()).append(' ').append("SET").append(' ').append("INITIAL").append(' ').append("SCHEMA").append(' ').append(this.initialSchema.getStatementName());
        return stringBuilder.toString();
    }

    public String getLocalUserSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("ALTER").append(' ').append("USER").append(' ').append(this.getName().getStatementName()).append(' ').append("SET").append(' ').append("LOCAL").append(' ').append("TRUE");
        return stringBuilder.toString();
    }

    public String getSetUserPasswordDigestSQL(String string, boolean bl) {
        if (!bl) {
            string = this.granteeManager.digest(string);
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("ALTER").append(' ').append("USER").append(' ').append(this.getName().getStatementName()).append(' ').append("SET").append(' ').append("PASSWORD").append(' ').append("DIGEST").append(' ').append('\'').append(string).append('\'');
        return stringBuilder.toString();
    }

    public static String getSetCurrentPasswordDigestSQL(GranteeManager granteeManager, String string, boolean bl) {
        if (!bl) {
            string = granteeManager.digest(string);
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("SET").append(' ').append("PASSWORD").append(' ').append("DIGEST").append(' ').append('\'').append(string).append('\'');
        return stringBuilder.toString();
    }

    public String getConnectUserSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("SET").append(' ').append("SESSION").append(' ').append("AUTHORIZATION").append(' ').append(StringConverter.toQuotedString(this.getName().getNameString(), '\'', true));
        return stringBuilder.toString();
    }
}

