/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hsqldb.map;

import java.util.Arrays;

public class HashIndex {
    int[] hashTable;
    int[] linkTable;
    int newNodePointer;
    int elementCount;
    int reclaimedNodePointer = -1;
    boolean fixedSize;
    boolean modified;

    public HashIndex(int n, int n2, boolean bl) {
        if (n2 < n) {
            n2 = n;
        }
        this.reset(n, n2);
        this.fixedSize = bl;
    }

    public void reset(int n, int n2) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n2];
        this.hashTable = nArray;
        this.linkTable = nArray2;
        Arrays.fill(this.hashTable, -1);
        this.resetTables();
    }

    public void resetTables() {
        this.newNodePointer = 0;
        this.elementCount = 0;
        this.reclaimedNodePointer = -1;
        this.modified = false;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public int getLimitPointer() {
        return this.newNodePointer;
    }

    public void clear() {
        Arrays.fill(this.linkTable, 0, this.newNodePointer, 0);
        Arrays.fill(this.hashTable, -1);
        this.resetTables();
    }

    public int getHashIndex(int n) {
        return (n & Integer.MAX_VALUE) % this.hashTable.length;
    }

    public int getLookup(int n) {
        if (this.elementCount == 0) {
            return -1;
        }
        int n2 = (n & Integer.MAX_VALUE) % this.hashTable.length;
        return this.hashTable[n2];
    }

    public int getNewNodePointer() {
        return this.newNodePointer;
    }

    public int getNextLookup(int n) {
        return this.linkTable[n];
    }

    public int linkNode(int n, int n2) {
        int n3;
        int n4 = this.reclaimedNodePointer;
        if (n4 == -1) {
            n4 = this.newNodePointer++;
        } else {
            this.reclaimedNodePointer = this.linkTable[n4];
        }
        if (n2 == -1) {
            n3 = this.hashTable[n];
            this.hashTable[n] = n4;
        } else {
            n3 = this.linkTable[n2];
            this.linkTable[n2] = n4;
        }
        this.linkTable[n4] = n3;
        ++this.elementCount;
        this.modified = true;
        return n4;
    }

    public void unlinkNode(int n, int n2, int n3) {
        if (n2 == -1) {
            this.hashTable[n] = this.linkTable[n3];
        } else {
            this.linkTable[n2] = this.linkTable[n3];
        }
        this.linkTable[n3] = this.reclaimedNodePointer;
        this.reclaimedNodePointer = n3;
        --this.elementCount;
        if (this.elementCount == 0) {
            Arrays.fill(this.linkTable, 0, this.newNodePointer, 0);
            this.resetTables();
        }
    }

    public boolean removeEmptyNode(int n) {
        boolean bl = false;
        int n2 = -1;
        int n3 = this.reclaimedNodePointer;
        while (n3 >= 0) {
            if (n3 == n) {
                if (n2 == -1) {
                    this.reclaimedNodePointer = this.linkTable[n];
                } else {
                    this.linkTable[n2] = this.linkTable[n];
                }
                bl = true;
                break;
            }
            n2 = n3;
            n3 = this.linkTable[n3];
        }
        if (!bl) {
            return false;
        }
        for (n3 = 0; n3 < this.newNodePointer; ++n3) {
            if (this.linkTable[n3] <= n) continue;
            int n4 = n3;
            this.linkTable[n4] = this.linkTable[n4] - 1;
        }
        System.arraycopy(this.linkTable, n + 1, this.linkTable, n, this.newNodePointer - n - 1);
        this.linkTable[this.newNodePointer - 1] = 0;
        --this.newNodePointer;
        for (n3 = 0; n3 < this.hashTable.length; ++n3) {
            if (this.hashTable[n3] <= n) continue;
            int n5 = n3;
            this.hashTable[n5] = this.hashTable[n5] - 1;
        }
        return true;
    }

    public boolean insertEmptyNode(int n) {
        int n2;
        for (n2 = 0; n2 < this.newNodePointer; ++n2) {
            if (this.linkTable[n2] < n) continue;
            int n3 = n2;
            this.linkTable[n3] = this.linkTable[n3] + 1;
        }
        for (n2 = 0; n2 < this.hashTable.length; ++n2) {
            if (this.hashTable[n2] < n) continue;
            int n4 = n2;
            this.hashTable[n4] = this.hashTable[n4] + 1;
        }
        System.arraycopy(this.linkTable, n, this.linkTable, n + 1, this.newNodePointer - n);
        ++this.newNodePointer;
        if (this.reclaimedNodePointer >= n) {
            // empty if block
        }
        this.linkTable[n] = ++this.reclaimedNodePointer;
        this.reclaimedNodePointer = n;
        return true;
    }

    public HashIndex clone() {
        HashIndex hashIndex = null;
        try {
            hashIndex = (HashIndex)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashIndex.hashTable = (int[])this.hashTable.clone();
        hashIndex.linkTable = (int[])this.linkTable.clone();
        return hashIndex;
    }
}

